/*-----------------------------------------------------------------------------
/ Standalone I/O support for X-1000
/
/ 18-Apr-88  Craig J. Kim
/ Added support for SCSI type EDT - open(), parser()
/----------------------------------------------------------------------------*/

#include <types.h>
#include <sysmacros.h>
#include <param.h>
#include <ino.h>
#include "sainode.h"
#include <fs/s5filsys.h>
#include <fs/s5dir.h>
#include "saio.h"
#include "icb.h"
#include "icbcmd.h"
#include "vreg.h"
#include "cpu.h"
#include "sysconf.h"
#include "dk.h"
#include "misc.h"
#include "globlvars.h"

#define NOTHING 0
#define DISK	1
#define TAPE	2
#define RDISK	3

static ino_t dlook();
struct slot_info *dev_slot[4] = 0;
struct slot_info *dm_slot,*tm_slot;
unsigned short num_bds = 0;
char *parser();
char *get_type();
int ldrive, drive, cntrler, type;
char *devptr[] = { "","rp","mt","rv",0};
char *devstr;
unsigned short old_type = 0;

int MAP_BASE = 0;
unsigned char twenty_fiveM = 0;
unsigned char dtc_array[4];  		/*this array was added so that the 
					boot program will pass the correct 
					value for root, pipe and swap devices
					to the kernel.  The kernel expects
					all smd drives to pass a zero for the
					root major device, scsi drives will
					use the numbers 1 thru 4 depending on
					the scsi controller that the root
					device is on.
					*/
unsigned char scsicount;


static
openi(n,io)
register struct iob *io;
{
	register struct dinode *dp;

	io->i_offset = 0;

/*	io->i_bn = (daddr_t)((n+15)/INOPB) + io->i_boff; */
	io->i_bn = (daddr_t)(itod(n)) + io->i_boff;

	io->i_cc = BUFFSIZE;
	io->i_ma = io->i_buf;
	devread(io);

/*	dp = (io->i_buf);	*/
/*	dp = &dp[(n-1)%INOPB];	*/
	dp = (struct dinode *)(io->i_buf);
	dp = &dp[itoo(n)];

	io->i_ino.i_number = n;
	io->i_ino.i_mode = dp->di_mode;
	io->i_ino.i_size = dp->di_size;
/*
	l3tol((char *)io->i_ino.i_un.i_addr,(char *)dp->di_addr,NADDR);
*/
	l3tol((char *)io->i_ino.i_addr,(char *)dp->di_addr,NADDR);
}


static
find(path, file)
register char *path;
struct iob *file;
{
	register char *q;
	char c;
	int n;

	if (path==NULL || *path=='\0') {
		printf("null path\n");
		return(0);
	}

	openi((ino_t) 2, file);
	while (*path) {
		while (*path == '/')
			path++;
		q = path;
		while(*q != '/' && *q != '\0')
			q++;
		c = *q;
		*q = '\0';

		if ((n=dlook(path, file))!=0) {
			if (c=='\0')
				break;
			openi(n, file);
			*q = c;
			path = q;
			continue;
		} else {
			printf("%s not found\n",path);
			return(0);
		}
	}
	return(n);
}


static daddr_t
sbmap(io, bn)
register struct iob *io;
daddr_t bn;
{
	register i;
	register struct inode *ip;
	int j, sh;
	daddr_t nb, *bap;

	ip = &io->i_ino;;
	if(bn < 0) {
		printf("bn negative\n");
		return((daddr_t)0);
	}

	/*
	 * blocks 0..NADDR-4 are direct blocks
	 */
	if(bn < NADDR-3) {
		i = bn;
		/*nb = ip->i_un.i_addr[i]; */

		nb = ip->i_addr[i];
		return(nb);
	}

	/*
	 * addresses NADDR-3, NADDR-2, and NADDR-1
	 * have single, double, triple indirect blocks.
	 * the first step is to determine
	 * how many levels of indirection.
	 */
	sh = 0;
	nb = 1;
	bn -= NADDR-3;
	for(j=3; j>0; j--) {
		sh += NSHIFT;
		nb <<= NSHIFT;
		if(bn < nb)
			break;
		bn -= nb;
	}
	if(j == 0) {
		printf("bn ovf %D\n",bn);
		return((daddr_t)0);
	}

	/*
	 * fetch the address from the inode
	 */
	/*nb = ip->i_un.i_addr[NADDR-j];*/
	nb = ip->i_addr[NADDR-j];
	if(nb == 0) {
		printf("bn void %D\n",bn);
		return((daddr_t)0);
	}

	/*
	 * fetch through the indirect blocks
	 */
	for(; j<=3; j++) {
		if (blknos[j] != nb) {
			io->i_bn = nb + io->i_boff;
			io->i_ma = b[j];
			io->i_cc = BUFFSIZE;
			devread(io);
			blknos[j] = nb;
		}
		/*
		bap = b[j];
		*/
		bap = (daddr_t *)b[j];
		sh -= NSHIFT;
		i = (bn>>sh) & NMASK;
		nb = bap[i];
		if(nb == 0) {
			printf("bn void %D\n",bn);
			return((daddr_t)0);
		}
	}

	return(nb);
}

static ino_t
dlook(s, io)
char *s;
register struct iob *io;
{
	register struct direct *dp;
	register struct inode *ip;
	daddr_t bn;
	int n,dc;

	if (s==NULL || *s=='\0')
		return(0);
	ip = &io->i_ino;
	if ((ip->i_mode&IFMT)!=IFDIR) {
		printf("not a directory\n");
		return(0);
	}

	n = ip->i_size/sizeof(struct direct);

	if (n==0) {
		printf("zero length directory\n");
		return(0);
	}

	dc = BUFFSIZE;
	bn = (daddr_t)0;
	while(n--) {
		if (++dc >= BUFFSIZE/sizeof(struct direct)) {
			io->i_bn = sbmap(io, bn++) + io->i_boff;
			io->i_ma = io->i_buf;
			io->i_cc = BUFFSIZE;
			devread(io);
			dp = (struct direct *)io->i_buf;
			dc = 0;
		}

		if (match(s, dp->d_name))
			return(dp->d_ino);
		dp++;
	}
	return(0);
}

static
match(s1,s2)
register char *s1,*s2;
{
	register cc;

	cc = DIRSIZ;
	while (cc--) {
		if (*s1 != *s2)
			return(0);
		if (*s1++ && *s2++)
			continue; else
			return(1);
	}
	return(1);
}

lseek(fdesc, addr, ptr)
int	fdesc;
off_t	addr;
int	ptr;
{
	register struct iob *io;

	if (ptr != 0) {
		printf("Seek not from beginning of file\n");
		return(-1);
	}
	fdesc -= 3;
	if (fdesc < 0 || fdesc >= NFILES || ((io = &iob[fdesc])->i_flgs&F_ALLOC) == 0)
		return(-1);
	io->i_offset = addr;
	io->i_bn = addr/BUFFSIZE + io->i_boff;
	io->i_cc = 0;
	return(0);
}

getc(fdesc)
int	fdesc;
{
	register struct iob *io;
	register char *p;
	register  c;
	int off;


	if (fdesc >= 0 && fdesc <= 2)
		return(getchar());
	fdesc -= 3;
	if (fdesc < 0 || fdesc >= NFILES || ((io = &iob[fdesc])->i_flgs&F_ALLOC) == 0)
		return(-1);
	p = io->i_ma;
	if (io->i_cc <= 0) {
		io->i_bn = io->i_offset/(off_t)BUFFSIZE;
		if (io->i_flgs&F_FILE)
			io->i_bn = sbmap(io, io->i_bn) + io->i_boff;
		else
			io->i_bn += io->i_boff;
		io->i_ma = io->i_buf;
		io->i_cc = BUFFSIZE;
		devread(io);
		if (io->i_flgs&F_FILE) {
			off = io->i_offset % (off_t)BUFFSIZE;
			if (io->i_offset+(BUFFSIZE-off) >= io->i_ino.i_size)
				io->i_cc = io->i_ino.i_size - io->i_offset + off;
			io->i_cc -= off;
			if (io->i_cc <= 0)
				return(-1);
		} else
			off = 0;
		p = &io->i_buf[off];
	}
	io->i_cc--;
	io->i_offset++;
/*
	c = (unsigned)*p++;
*/
	c = *p++ & 0377;
	io->i_ma = p;
	return(c);
}
getchar() {
	char ch;

	ch = xgetch();
	if (ch == 0x7f)
		exit(0x7f);
	return(ch);
}

getw(fdesc)
int	fdesc;
{
	register w,i;
	register char *cp;
	short val;

	for (i = 0, val = 0, cp = (char *)&val; i < sizeof(val); i++) {
		w = getc(fdesc);
		if (w < 0) {
			if (i == 0) return(-1);	/* ran out of character */
			else return(val & 0x0ffff);/* ran out but only 1 char */
		}
		*cp++ = w;
	}
	return( val & 0x0ffff);
}

long
getl(fdesc)
int	fdesc;
{
	register w,i;
	register char *cp;
	long val;

	val =0; cp = (char *)&val;

	for (i = 0; i < sizeof(val); i++) {
		w = getc(fdesc);
		if (w < 0) {
			if (i == 0) return(-1);	/* ran out of character */
			else return(val);	/* ran out but only 1 char */
		}
		*cp++ = w;
	}
	return(val);
}

read(fdesc, buf, count)
int	fdesc;
char	*buf;
int	count;
{
	register i;
	register struct iob *file;

	if (fdesc >= 0 && fdesc <= 2) {
		i = count;
		do {
			*buf = getchar();
		} while (--i && *buf++ != '\n');
		return(count - i);
	}
	fdesc -= 3;
	if (fdesc < 0 || fdesc >= NFILES || ((file = &iob[fdesc])->i_flgs&F_ALLOC) == 0)
		return(-1);
	if ((file->i_flgs&F_READ) == 0)
		return(-1);
	if ((file->i_flgs&F_FILE) == 0) {
		file->i_cc = count;
		file->i_ma = buf;
		i = devread(file);
		file->i_bn += count/BSIZE;
		return(i);
	}
	else {
		if (file->i_offset+count > file->i_ino.i_size)
			count = file->i_ino.i_size - file->i_offset;
		if ((i = count) <= 0)
			return(0);
		file->i_bn = file->i_offset/(off_t)BUFFSIZE;
		file->i_bn = sbmap(file, file->i_bn) + file->i_boff;
/*
		do {
			*buf++ = getc(fdesc+3);
		} while (--i);
		return(count);
*/
		file->i_cc = count;
		file->i_ma = buf;
		i = devread(file);
		file->i_offset += i;
		file->i_cc = 0;
		return(i);
	}
}

write(fdesc, buf, count)
int	fdesc;
char	*buf;
int	count;
{
	register i;
	register struct iob *file;

	if (fdesc >= 0 && fdesc <= 2) {
		i = count;
		while (i--)
			putchar(*buf++);
		return(count);
	}
	fdesc -= 3;
	if (fdesc < 0 || fdesc >= NFILES || ((file = &iob[fdesc])->i_flgs&F_ALLOC) == 0)
		return(-1);
	if ((file->i_flgs&F_WRITE) == 0)
		return(-1);
	file->i_cc = count;
	file->i_ma = buf;
	i = devwrite(file);
	file->i_bn += count/BSIZE;
	return(i);
}

/*----------------------------------------------------------- open() ----------
/ changes made to support SCSI disks:
/
/   iob.i_unit
/      old format: xxxxxxxx xxxxxxxx xxxxxxxx xx xx xxxx
/                  |------- not used -------| ^^ ^^ ^^^^
/                                             |  |   |
/                                             |  |   `------ logical drive
/                                             |  `---------- physical drive
/                                             `------------- controller
/
/      new format: xxxxxxxx xxxxxxxx xxxx xx xx xxxx xxxx
/                  |----- not used --------| ^^ ^^^^ ^^^^
/                                            |   |    |
/                                            |   |    `----- logical drive
/                                            |   `---------- physical drive
/                                            `-------------- controller
/
/  NOTE:  The above formats apply only to logical disk slices.  They do not
/         apply to reserved area (i.e. raw disk) or tape devices.  For these
/         devices, lowest nibble is used for physical drive number and upper
/         for controller.
/----------------------------------------------------------------------------*/
open(str, how)
char *str;
int	how;
{
	char *cp;
	char *np;
	int i,j;
	register struct iob *file;
	register struct devsw *dp;
	register struct slot_info *slotptr;
	int	fdesc;
	static first = 1;

	if (first) {
		for (i = 0; i < NFILES; i++)
			iob[i].i_flgs = 0;

		slotptr = SYSCONF->slotinfo;
		tm_slot = dm_slot = SYSCONF->bslotptr;

		for (i = 0; i < 4; i++)
			dev_slot[i] = 0;
		for(i = 0, j = 0,scsicount=1; i < NUMSLOTS; i++, slotptr++) {
			if (slotptr->flags & OCCUPIED) {
				register int bdtype;

				bdtype = slotptr->slotaddr->bdtypreg & BDTYPMSK;
				if (((bdtype == HSDTBDTYP) 
						|| (bdtype == EDTBDTYP) 
						|| (bdtype == SCSIBDTYP)) 
						&& !(slotptr->flags & BOARDDOWN)) {
					dev_slot[j] = slotptr;
					if(bdtype == SCSIBDTYP){
	    				    dtc_array[j++] = scsicount;
	    				    scsicount++;
					}
					else
	    				    dtc_array[j++] = 0;
					num_bds++;
#ifdef SCSI_DEBUG
					printf("board %d at %x\n", i, (int) slotptr);	
#endif
				}
			}
		}

		first = 0;
	}

	for (fdesc = 0; fdesc < NFILES; fdesc++)
		if (iob[fdesc].i_flgs == 0)
			goto gotfile;
	_stop("No more file slots");
gotfile:
	
	(file = &iob[fdesc])->i_flgs |= F_ALLOC;

	if ( (str = get_type(str)) == (char *)-1) {
		(file = &iob[fdesc])->i_flgs = 0;
		return(-1);
	}
		

	if(old_type){
		for (cp = str; *cp && *cp != '('; cp++)
			;
		if (*cp != '(') {
			printf("Bad device\n");
			file->i_flgs = 0;
			return(-1);
		}
		*cp++ = '\0';
	}
	for (dp = devsw; dp->dv_name; dp++) {
		if (match(str, dp->dv_name))
			goto gotdev;
	}
	printf("Unknown device\n");
	file->i_flgs = 0;
	return(-1);
gotdev:
	if(old_type){
		*(cp-1) = '(';
		file->i_ino.i_dev = dp - devsw;
		if(*(cp+1) == ',')
			file->i_unit = *cp++ - '0';
		else{
			if(*(cp+2) == ','){
				*(cp+2) = '\0';
				file->i_unit = atoi(cp);
				*(cp+2) = ',';
				cp += 2;
			}
			else{
				printf("Bad unit specifier\n");
				file->i_flgs = 0;
				return(-1);
			}
		}
	
	}
	else{
		file->i_ino.i_dev = dp - devsw;
		
/*-------------------------- old format -------------------------------------
		file->i_unit = (type == DISK) ? ((cntrler << 6) | (drive <<4) 
			| ldrive) : ((cntrler<<4) | drive);
---------------------------------------------------------------------------*/

		file->i_unit = (type == DISK)		/* cjk 880603 */
				? ((cntrler << 8) | (drive << 4) | ldrive)
				: ((cntrler << 4) | drive);
	}

	if (file->i_unit < 0 || file->i_unit > 0x3ff || (cntrler > num_bds)) {
		printf("Bad unit specifier\n");
		file->i_flgs = 0;
		return(-1);
	}
	if(old_type){
		if (*cp++ != ',') {
badoff:
			printf("Missing offset specification\n");
			file->i_flgs = 0;
			return(-1);
		}
		np = cp;
		for (;;) {
			if (*np == ')')
				break;
			if (*np++)
				continue;
			goto badoff;
		}
		*np = '\0';
		file->i_boff = offset(cp);
		file->i_bn = file->i_boff;
		*np = ')';
		cp = np;
		if (*++cp == '\0') {
			file->i_flgs |= how+1;
			file->i_cc = 0;
			file->i_offset = 0;
			if(devopen(file) < 0) {
				file->i_flgs = 0;
				return(-1);
			}
			return(fdesc+3);
		}
		else if(devopen(file) < 0) {
			file->i_flgs = 0;
			return(-1);
		}
	}
	else{
		file->i_boff = 0;
		file->i_bn = file->i_boff;
		file->i_cc = 0;
		file->i_offset = 0;
		if((cp = devstr) == (char *)0 || *cp == '\0'){
			file->i_flgs |= how+1;
			if(devopen(file) < 0) {
				file->i_flgs = 0;
				return(-1);
			}
			return(fdesc+3);
		}
		else if(devopen(file) < 0){
			file->i_flgs = 0;
			return(-1);
		}
	}
	if ((i = find(cp, file)) == 0) {
		file->i_flgs = 0;
		return(-1);
	}
	if (how != 0) {
		printf("Can't write files yet.. Sorry\n");
		file->i_flgs = 0;
		return(-1);
	}
	openi(i, file);
	file->i_offset = 0;
	file->i_cc = 0;
	file->i_flgs |= F_FILE | (how+1);
	return(fdesc+3);
}

close(fdesc)
int	fdesc;
{
	struct iob *file;

	fdesc -= 3;
	if (fdesc < 0 || fdesc >= NFILES || ((file = &iob[fdesc])->i_flgs&F_ALLOC) == 0)
		return(-1);
	if ((file->i_flgs&F_FILE) == 0)
		devclose(file);
	file->i_flgs = 0;
	return(0);
}

ioctl(fdesc, cmd, addr)
int	fdesc;
int	cmd;
char	*addr;
{
	struct iob *file;

	fdesc -= 3;
	if (fdesc < 0 || fdesc >= NFILES || ((file = &iob[fdesc])->i_flgs&F_ALLOC) == 0)
		return(-1);
	return(devioctl(file, cmd, addr));
}

exit(retval)
{

	printf("\n(%x) ",retval);
	_stop("returned by exit");
}

_stop(s)
char	*s;
{
	printf("%s\n", s);
/* ????????????????? */
/* return to standalone BOOT */
	_rtt();
}

offset (s)
	
register char *s;
{
	int a;
	int base = 10;
	int d;

	if ( *s == '+') s++;
	if ( *s == 'x'|| *s == 'X') {
		s++;
		base = 16;
	} else if (*s=='0' && (s[1]=='x'||s[1]=='X') ) {
		s +=2;
		base = 16;
	} else if (*s == '0')
		base = 8;
 
	for (a=0; *s; s++)  {
		d = *s;
		if (d>='0' && d<='9')
			a = a*base + d - '0';
		else if (d>='a' && d<='f' && base == 16)
			a = a*base +d+10-'a';
		else if (d>='A' && d<='F' && base == 16)
			a = a*base+d+10-'A';
		else
			break;
	}
	return (a);
}

/*------------------------------------------------------ get_type() ----------
/ determine the type of drive specification and let function parser() figure
/ out the rest.  if 'old_type' is zero, the drive spec is in c#d#s# format;
/ otherwise, (r,v) format
/---------------------------------------------------------------------------*/
char *get_type(str)
char *str;
{

	int num;
	char *ptr;


	if((ptr = parser(str)) != (char *)-1){
		if(ptr != (char *)0){
			if(type == NOTHING){
				old_type++;
				return(ptr);
			}
/*
			else if(type == DISK)
				printf("controller %x drive %x ldrive %x string %s type %s\n",cntrler,drive,ldrive,ptr,devptr[type]);
			else
				printf("controller %x drive %x  string %s type %s\n",cntrler,drive,ptr,devptr[type]);
*/
			devstr = ptr;
			old_type = 0;
			return(devptr[type]);
		}
		else{
/*
			if(type == DISK)
				printf("controller %x drive %x ldrive %x type %s\n",cntrler,drive,ldrive,devptr[type]);
			else
				printf("controller %x drive %x type %s\n",cntrler,drive,devptr[type]);
*/
			devstr = (char *)0;
			old_type = 0;
			return(devptr[type]);
		}
	}
}

/*--------------------------------------------------------- parser() ----------
/ parse out the drive spec and determine format: c#d#s# or (r,v).  If c#d#s#,
/ set 'cntrler', 'drive', and 'ldrive'; otherwise, return type=NOTHING
/----------------------------------------------------------------------------*/
char *parser(cbuf)
char *cbuf;
{

	char *cptr;
	cptr = cbuf;

	if(*cptr == 'c') {
	    	if(((*++cptr) - 0x30) < 9){
			if((*cptr - 0x30) > 3){
				printf("invalid controller number %c\n",*cptr);
				return((char *)-1);
			}
		cntrler = (*cptr++) - 0x30;
	    	}
	    	else {
			cptr--;
			return(cptr);
		}
	}
	else{
		type = NOTHING;
		return(cptr);
	}

	
	if(*cptr != 'd'){
		printf("invalid drive number %c\n",*cptr);
		return((char *)-1);
	}
	if ((dev_slot[cntrler]->slotaddr->bdtypreg & BDTYPMSK) == SCSIBDTYP) {
		register int scsidrvnum = 0;

		while (isdigit(*++cptr))
			scsidrvnum = scsidrvnum * 10 + (*cptr - '0');
		if (scsidrvnum > 13) {
			printf("Invalid SCSI drive number %d\n", scsidrvnum);
			return((char *) -1);
		}
		drive = scsidrvnum;
	}
	else {
		if((*++cptr) - 0x30 > 3){
			printf("invalid drive number %c\n",*cptr);
			return((char *)-1);
		}
		drive = (*cptr++) - 0x30;
	}

	if (*cptr == '\0') {
		type = TAPE;
		return((char *)0);
	}
	if(*cptr == 's') {
		*cptr++;
	 	if( (ldrive = atoi(cptr)) || *cptr == '0' ){
			if( ldrive > 0x0f){
				printf("Invalid logical drive %d\n",ldrive);
				return((char *)-1);
			}
			type = DISK;
			if(*++cptr){
			    if(*cptr == ' ' || ( *cptr >= '0' && *cptr <= '9') )
				++cptr;
			    return(cptr);
			}
			else
				return((char *)0);
		}
		else{
			printf("Invalid tape command - %s\n", *cptr);
			return((char *)-1);
		}
	}
	else if((*cptr == 'r') && (*(cptr+1) == '\0')){
		type = RDISK;
		return((char *)0);
	}
	else{
		type = TAPE;
		return(cptr);
	}
}

/*
 * dqprint -	pretty print a devq struct
 *
 */


int	debugrq;

rqprint(rqptr)
struct devq	*rqptr;
{

	printf("q_devtype %s         devnum %X\n",
	  rqptr->q_devtype == 1 ? "DISK" : rqptr->q_devtype == 2 ? 
	  "TAPE": "ERROR", rqptr->q_devnum);

	printf("q_cmd %X         q_count %X\n", rqptr->q_cmd, rqptr->q_count);

	printf("q_mem %X         q_key\n", rqptr->q_mem, rqptr->q_key);

	switch (rqptr->q_cmd) {

	case LREAD:
	case LWRITE:
	case PLREAD:
	case PLWRITE:

		printf("q_devun.block %X\n", rqptr->q_devun.block);
		break;

	case PREADPS:
	case PWRITPS:
		printf("q_devun.pdisk.cyl %X\n", rqptr->q_devun.pdisk.cyl);
		printf("q_devun.pdisk.head %X\n", rqptr->q_devun.pdisk.head);
		printf("q_devun.pdisk.sector %X\n",rqptr->q_devun.pdisk.sector);
		break;
	}

	printf("\n-> ");
	getchar();
}

SMAP(adr) {
	register struct slot_info *slotptr;
	register i;

	if(!(MAP_BASE)){
		slotptr = SYSCONF->slotinfo;
		for(i=0; i<NUMSLOTS; i++, slotptr++) {
			if(slotptr->flags & OCCUPIED &&
				((slotptr->slotaddr->bdtypreg & BDTYPMSK) == MCPUBDTYP) && !(slotptr->flags & BOARDDOWN)) {
				MAP_BASE = 0x480e00;
				break;

			}
		}
		if(!(MAP_BASE)) MAP_BASE = 0x480000;
		
	}


	return ( ((MAP_BASE + ((int)adr >> 10)) & 0xfffffc) );
}


cpu_type()
{
	register struct slot_info *slotptr;
	register i;
	unsigned short *map_ptr;
	unsigned short temp;

	slotptr = SYSCONF->slotinfo;
	GVP = (struct globlvars *)(0x400800);
	twenty_fiveM = 0;
	for(i=0; i<NUMSLOTS; i++, slotptr++) {
		if(slotptr->flags & OCCUPIED && !(slotptr->flags & BOARDDOWN)) {
			if(((slotptr->slotaddr->bdtypreg & BDTYPMSK) == MCPU32BDTP)){
	/*we have to read the upper nibble of the map ram to determine whether
	this is a 25MHz cpu or a 12.5MHz cpu */
			    map_ptr = (unsigned short *)0x480000;
			    temp = *map_ptr;
			    *map_ptr = 0x5fff;
			    if(*map_ptr != 0x5fff){
				GVP = (struct globlvars *)(0x400800);
			    }
			    else{
				twenty_fiveM++;
				GVP = (struct globlvars *)(0x420400);
			    }
			    *map_ptr = temp;
			
			}
		}

	}
}
