
/*******************************************************************
 *
 *   P T M   motorola 6840
 *   programmable timer module
 *
 *******************************************************************/

struct ptm_reg {
	unsigned char filler;
	unsigned char reg;
};

struct ptm {
	struct ptm_reg ctl13;			/* control register 1 & 3 */
	struct ptm_reg c2s;				/* control register 2 and status */
	struct ptm_cnt {
		struct ptm_reg cmsb;		/* count MSB */
		struct ptm_reg clsb;		/* count LSB */
	} ptmc[3];
};

/******************************************************************************
 *
 *   C O N T R O L   R E G I S T E R S
 *
 ******************************************************************************/
#define P_TOPR     0x00  /* timers operate (control reg 1) */
#define P_WCR3     0x00  /* write control reg 3 (control reg 2) */
#define P_CNPR     0x00  /* clock not prescaled (control reg 3) */
#define P_TPRES    0x01  /* timers held preset (control reg 1) */
#define P_WCR1     0x01  /* write control reg 1 (control reg 2) */
#define P_CD8      0x01  /* clock divided by 8 (control reg 3) */
#define P_ECLK     0x02  /* timer uses enable clock */
#define P_D8BT     0x04  /* dual 8 bit counting mode */
#define P_CONT     0x00  /* continuous counting mode */
#define P_IEN      0x40  /* interrupt enabled */
#define P_OEN      0x80  /* output enabled */

/******************************************************************************
 *
 *   S T A T U S   R E G I S T E R
 *
 ******************************************************************************/
#define P_T1INT    0x01  /* timer 1 interrupt */
#define P_T2INT    0x02  /* timer 2 interrupt */
#define P_T3INT    0x04  /* timer 3 interrupt */
#define P_CTINT    0x80  /* composite timer interrupt */
