/******************************************************************************
 *
 * this structure represents all of the global variables used in the CPU
 * prom environment.
 * they have been put into a structure and assigned a constant address so
 * they may be shared with other diagnostics.
 *
 ******************************************************************************/
#include "setjmp.h"

struct globlvars {
	int Interrupt;
	jmp_buf EnvironBuf;
	struct icb *MasterSlot;
	unsigned char BTReg, IntReg;
	struct slot_info *HeadPtr, *SlotPtr, *IntSlot;
	unsigned short MemErrStatus, DmcStatus, SoftIReg;
	unsigned char BusFault, SoftLed, SSlot, SoftMapEnaPort, IOflag;
	char InputQ[CQSIZ], *Head, *Tail, Buf0[CBUFSIZ], Buf1[CBUFSIZ];
	unsigned FaultyAddress, MemSoftErr, ErrorCount, IntCounter;
	unsigned Seconds, TotRam;
	unsigned char HndlBerr, HndlInt, EdacTest, AbortFlag, InDiag;
	unsigned char ByteAble, SlvICmd, ConFlag;
	unsigned char NewSoftLed,emuflag,DMC4Flag,HndlFline,FPUThere;
	unsigned short *zeromemslot;
	unsigned incchtst;  /* indicates doing the diagnostic cache test */
	unsigned *hsptr [4];
	unsigned char edacerr;
	unsigned char DiagFlag, LastCon, Verbose, Loop;
	unsigned char intags;	/* TRUE when doing the cpu32 diagnostic */
				/* tags as RAM test  */
	unsigned int SpurCount;
};

struct globlvars * GVP;

/* defines for above ConFlag and DiagFlag*/
#define BAUDMSK	0x0f
#define BUFALL	0x10
#define BAUDSET	0x20
#define XOFF	0x40

/* defines for above InDiag field */
#define DIAGS 0x01 /* we are in the diagnostics */
#define POCTST 0x02 /* power on confidence test */

#define VERBOSE GVP->Verbose
#define LOOP    GVP->Loop
