/* **************************************** */
/* data structure return by HSDT controller */
/* **************************************** */

/* *********************************************** */
/* command = MEDDEFECT (request media defect list) */

/* ***********************************************
struct medf_list {
	unsigned short	cyl;
	unsigned char	head;
	unsigned char	dummy;
	struct defpos {
		unsigned short	pos;	position of defect is in
					bytes after Index +- 1 byte 
		unsigned short	len;	 length of defect is in 
					bits +- 1 bit 
	} defpos[4];
};

*********************************************** */

/* ****************************************** */
/* command = BADBLK (request bad blocks list) */
/* ****************************************** */
struct bad_list {
	unsigned short	cyl;
	unsigned char 	head;
	unsigned char	sector;
};


/* ************************************************* */
/* command = ALTSEC (request alternate sectors list) */
/* ************************************************* */
struct  alt_list {
	unsigned short cyl;	/* bad c,h,s or -1 */
	unsigned char head;
	unsigned char sector;
	unsigned short altcyl;
	unsigned char althead;
	unsigned char altsector;
};

