
#define PRINT1		( printflag ==1 )
#define PRINT2		( printflag ==2 )
#define PRINT3		( printflag ==3 )
#define PRINT4		( printflag ==4 )
#define PRINT5		( printflag ==5 )
#define PRINT6		( printflag ==6 )	/* for debugging tool only */

#define enter_short_cr \
{\
	asm("or.w	&0x0700,%sr");\
}
#define exit_short_cr \
{\
	asm("and.w	&0xf8ff,%sr");\
}
#define exit_short_cr2 \
{\
	asm("and.w	&0xfaff,%sr");\
}
#define exit_short_cr3 \
{\
	asm("and.w	&0xfbff,%sr");\
}

#define exit_short_cr4 \
{\
	asm("and.w	&0xfcff,%sr");\
}

#define exit_short_cr5 \
{\
	asm("and.w	&0xfdff,%sr");\
}

#define enter_short_cr5 \
{\
	asm("or.w	&0x0500,%sr");\
}


/* retry for disk io */
#define RETRY		4
#define CRC_RETRY       8

/* page size in main memory */
#define PAGESIZE	0x1000

/*number of bytes allocated to the dtbarray for chained transfers*/
#define DTB_ARRAY_SIZE  300

#define BANK 1    		/*the memory bank used for dma transfers*/
#define BANK_SIZE 0x10000	/* the size of one bank of memory*/


/* max bytes allowed for disk i/o into non-contiguous memory */
#define MAX_RAW_COUNT	(MAXPGNUM * 4 * 0x400)

/* the maximum number of bytes that the scsi chip will allow in a single
    transfer is 0xffff and, therefore, we allow the next lower even sector
    multiple for out maximum single transfer
*/

#define MAXIMUM_SINGLE_TRANSFER 0xfc00

/* number of free que on hsdt board */
#define NQNUM	48

/* acknowledge data byte to master cpu for completing the request */
#define ICB_ACK		0x0


#define DTBBUF  0x10000
#define ALTBUF  0x10020
#define DTBARRAY 0x10040


#define DTBNOWAIT	0
#define DTBWAIT		1

/* from diskio routine */
#define	SKERR 		1
#define RWERR		2
#define TIMEOUT		3
#define ALTERR		4

/* value in DEVICE */
#define DISK	1
#define TAPE	2		/* arch tape or 9 track */
#define TAPE9	0x82		/* must be 9 track */
#define PF_WAIT 0x1d		/*power fail wait for disk completion*/
#define CONSOLE 4
#define ICB	8
#define FINISHED -2		/* tape request has been completed*/
#define DONE 88

/* values in FLAG of devq structure */

#define NO_RETRY  0x1		/*disable retries on disk r/w */
#define NOALT	  0x2		/* no need to reprg c,h,s when
					we hit an alternate sector */ 
#define NO_WAIT     0x4		/*don't wait for completion of rewind/tension/
				erase on tape */
#define READY_TO_DISCONNECT 0x8 /*drive has disconnected but the dma has not yet
				completed */
#define OPEN_DISK   0x10	/*reading in system sectors */
#define WAIT	    0x10	/* wait for i/o to complete*/
#define DMA_COMPLETE 0x20	/* the dma has completed for a disk transfer */
#define BUS_RECOVERY 0x40	/* recovering from a bus reset */
#define NO_DISCONNECT 0x80	/* do not allow disconnection for this request*/
#define FREE_REQ    0x100	/*this is one of the free requests; do not put
				it back on the response queue */
#define TAPE_CMPLT  0x200	/* a tape write request was completed while this
				request was on the dtbque */
#define MAIN_TO_DK  0x400	/*data transfer from main memory to the disk*/
#define DK_TO_MAIN  0x800	/* data transfer from disk to main memory */
#define LOC_TO_DK   0x1000	/* data transfer from local memory to the disk*/
#define LOC_TO_TAPE 0x1000
#define DK_TO_LOC   0x2000	/* data transfer from disk to local memory */
#define TAPE_TO_LOC 0x2000
#define LOC_TO_MAIN 0x4000	/* data transfer from local to main memory */
#define MAIN_TO_LOC 0x8000	/* data transfer from main to local memory */
#define FUNCTION_MASK  0xfc00	/* mask to determine whether to do a disk read/
				   write, a read/write id or a dtb transfer */


#define MAX_PDRIVE	14		/* maximum number of disk drives*/
#define MAX_TDRIVE	1		/* max tape drive */
#define BLKSIZE		0x400
#define BLKSIZBIT	10		/* shift >> 10(same as div by 0x400) */

#define MAXCYL		0x400		/* hardware max cyl */

#define MMUTABLE_IN      2		/* mmutable loaded for raw io request*/


#define FMTFLAGS	0
#define DEFM_LEN	24	/* media defect list for each track */

#define SEC0		0	/* system sector */
#define MEDSEC		6	/* media defect sector */
#define BOOTSEC		8	/* boot information sector */
#define BADSCSEC	0x10	/* bad sectors found by disk test */

#define BOOTLEN		0x400	/* length in sectors of boot sw */


#define TOTLOG		224		/* 14 x 16 total log drive */
#define MAXDEV		8		/* max device num on hsdt board */
					/* tape, disk, mirror, console, boot */

#define BIT(x) (1<<x)
#define UNBIT(x) ~(1<<x)
#define U_L_BIT(x) ((1<<x) | (1<<(x+8)))
#define UPPERBIT(x) (1<<(x+8))
#define UPPERBIT_MASK 0xff00


#define MTPR(port, val) *port = val	/* move to processor register */
#define MFPR(port) *port		/* move from processor register */

#define NUM_CMDS 20		/* the number of commands that can be queued
				at one time */

/* the following are the definitions of the scsi bus phases */
#define DATA_OUT	0
#define DATA_IN		1
#define COMMAND		2
#define STATUS		3
#define MESSAGE_OUT	6
#define MESSAGE_IN	7

#define BUS_PHASE	7

#define SYNC		1
#define ASYNC		2
#define ASYNC_SYNC	3

#define DMA_DONE 	0x80
#define SCSI_DONE 	0x40
#define FIRST_QUE	0x20
#define SECOND_QUE	0x10
#define TRANSFER_DONE 	0xc0
#define NO_ONE_ON_THE_BUS 0xff
