/* check changes to bootinfo, getphptr, and ckopdrive */





#include "scsi_ccpu.h"
#include "scsi_dtc.h"
#include "disksect.h"
#include "scsi.h"
#include "disk_struct.h"
#include "scsidata.h"
#include "vreg.h"
#include "icbcmd.h"
#include "scsiextrn.h"
#include "data_struct.h"
#include "scsi_error.h"


/*
	pick up icb command
 */

icbparse()
{	register unsigned short icbcmd,first;
	register struct icbcmdhdr *p;
	struct devq dkreq; register struct devq *dev;
	register struct dkinf *dkptr;
	struct devq *last_ptr;
	unsigned short oldpri;

	oldpri = spl6();			/* disable interrupts */
	interrupt &= ~ICB_INT;		/* allow more icb interrupts later */
	splx(oldpri);


	icbcmd = (icbdata) & ICBI_MASK;	/* get interrupt word */
	icbdata = 0;


	switch ( icbcmd ) {
		case IDWNLD:		/* go into download mode */
			break;
		case IVRUPDT:		/* updated vreg */
			upvreg(); 
			break;
		case IMEMCMD:		/* process memory resident cmd */
			p = bddesc.bd_imcptr;
			if ( p->command == IBTINFO ) {
				p->status = ICMPLT;
				if ( p->information >= MAX_PDRIVE ) {
					p->information = 0;
					intr_cpu (IMEMCMD);
					break;
				}

				/* insure sector 0 is read first */
				dev = &dkreq;
				/* clear the  dev rq */
				initdevq (dev);
				dev->q_devtype = DISK;
				dev->q_devnum = p->information;
			
				/* get pointer to physical drive data */
/*
				dkptr = (struct dkinf *)getphptr(dev);
				if ( check_for_open (dev, dkptr) ) {
					p->information = 0;
				}
				else {
					bootinf(dev, dkptr,p);
				}
*/
			}
			else {
				p->status = IILLEG;
				p->information = 0;
			}
			intr_cpu (IMEMCMD);
			break;
		case ICBSTOP_TAPE:
			while(tapeque.t_active);
			tapeque.t_active = 1;
			dev = ipque.i_p_first;
			first = 1;
			if(dev->q_devtype & TAPE){
				ipque.i_p_active = 0;
				last_ptr = dev;
			}
			while(dev){
				if(dev->q_devtype & TAPE){
					dev->rc1 = TP_ABORT;
					send_back(dev,0);
					last_ptr->q_next = dev->q_next;
				}
				else {
					if(first){
						first = 0;
						ipque.i_p_first = dev;
					}
					last_ptr = dev;
				}
				dev = dev->q_next;
			}
			break;
		case ICBSTOP_IO:
			stop();
			break;
		default:
			intr_cpu (icbcmd);
			break;
	}

	/* LIGHT(ledoff); */
	return;
}


upvreg()
{
	/* check icb interrupt level num */
	irqlevl = bddesc.bd_icbint <<13;

	/* check dtb id & external dtb device */
	if ( (bddesc.bd_xdtbid & XDTYPMSK) != XDTYPDMA )
		printf ("baddtb(%x)\n", bddesc.bd_xdtbid);
	else
		*DTB_IDR=(bddesc.bd_dtbid << 4) | (bddesc.bd_xdtbid & XDIDMSK);

	intr_cpu ( IVRUPDT );
}


bootinf(dev,dkptr,p)
register struct icbcmdhdr *p;
register struct devq *dev;
register struct dkinf *dkptr;
{
	register char *bptr;
	register struct free_mem *fm_ptr;

	fm_ptr = ipque.freemem_first;
	dev->local_mem = fm_ptr;
	ipque.freemem_first = fm_ptr->fm_next;
	bptr = (char *)fm_ptr->fm;

/*
	if ( rsydata (dev, dkptr, BOOTSEC ) ) 
		p->information = 0;
	else
		p->information = *((int *)bptr);
*/

	ipque.freemem_last->fm_next = fm_ptr;
	ipque.freemem_last = fm_ptr;
	fm_ptr->fm_next = (struct free_mem *)0;
	return;
}

/* send byte value to main cpu thru ICB interrupt register */
intr_cpu( intbyte )
unsigned char intbyte;
{
	register unsigned wordv;
	/* wait until DTC interrupt main cpu bit not set */
	wordv = 0x1000;
	while ( ICB_OBUSY ) {
		if ( --wordv == 0 ) {
			printf (".");
			wordv = 0x1000;
		}
	}

	*ICB_IR =(short )(irqlevl | intbyte);
	return;
}

