
/* The following error codes are found in the sense key(byte 2) of the
   sense data returned following a request sense command
*/

#define RECOVERED_ERROR		1
#define NOT_READY		2
#define MEDIUM_ERROR		3
#define HARDWARE_ERROR		4
#define ILLEGAL_REQUEST		5
#define UNIT_ATTENTION		6
#define ABORTED_COMMAND		0xb
#define VOLUME_OVERFLOW		0xd
#define MISCOMPARE		0xe
#define INCORRECT_LEN_INDIC	0x20
#define END_OF_MEDIA		0x40
#define FILEMARK		0x80

#define SENSE_KEY		2	/*byte address of the sense key */
#define ERROR_CODE		12      /*byte address of the error code*/

struct request_sense{
	unsigned char rs_err_class;	/*bit 7 validity, bits 4-6 error class*/
	unsigned char rs_segment;
	unsigned char rs_key;		/*error bits defined above */
	unsigned int rs_info_byte;	/*if validity bit is one, this is the 
					number of the bad block */
	unsigned char rs_sense_len;
	unsigned int rs_copy_srch;
	unsigned char rs_err_code;
	unsigned char rs_reserved;
	unsigned char rs_fru_code;
	unsigned char rs_bit_ptr;
	unsigned short rs_field_ptr;
};
