/* SETUPFILE:
 * Try to open the object file (filename)
 * Check its magic number, header size, (qualify its STANDALONEness)
 * then read in the header
 */
#include "extern.h"
setupfile(){
	/* open the file */
	if((fp=fopen(filename,"r+"))==NULL)
		fprintf(stderr,"%s: Cannot open %s for Modification\n",
		utilname,filename),exit(1);
	/* get to the beginning */	
	if(fseek(fp,0L,0L))
		fprintf(stderr,"%s: Cannot seek to beginning of %s\n",
		utilname,filename),closefile('n');
	/* read the filehdr */
	if(1 != fread(&filehdr, sizeof(filehdr), 1, fp))
		fprintf(stderr,"%s: Cannot read fileheader of %s\n",
		utilname,filename),closefile('n');
	/* if we are adding a header, we need to check for different    *
	 * magic numbers						*/
	/* is the magic number right */
	if(headerflag) 
	{
		if(filehdr.f_magic == M68ASAMAGIC)
			fprintf(stderr,"%s: %s is already of standalone type\n",
			utilname,filename),closefile('n');
	       	if(filehdr.f_magic != MC68MAGIC 
		   && filehdr.f_magic != M68AWRMAGIC
		   && filehdr.f_magic != M68AROMAGIC 
		   && filehdr.f_magic != A68020MAGIC
		   && filehdr.f_magic != X68020MAGIC)
		   /*&& filehdr.f_magic != NEWMAGIC)*/
			fprintf(stderr,"%s: Bad magic number [ %#.4x ] on file %s\n",
			utilname,filehdr.f_magic,filename),closefile('n');
	}
	else
	{
		if(filehdr.f_magic != M68ASAMAGIC)
			fprintf(stderr,"%s: Bad magic number [ %#.4x ] on file %s\n",
			utilname,filehdr.f_magic,filename),closefile('n');
	}
	/* is the size of optional header right */
	if(headerflag)
	{
		if(filehdr.f_opthdr == sizeof(aouthdr))
			fprintf(stderr,"%s: %s already has a standalone header\n",
			utilname,filename),closefile('n');
	}
	else
	{
		if(filehdr.f_opthdr != sizeof(aouthdr))
			fprintf(stderr,"%s: Wrong size header [ %#.4x ] on file %s\n",
			utilname,filehdr.f_opthdr,filename),closefile('n');
	}
	/* seek to & read the optional header */
	if(1 != fread(&aouthdr, filehdr.f_opthdr, 1, fp))
		fprintf(stderr,"%s: Cannot read optional header on %s\n",
		utilname,filename),closefile('n');
}
