

/* ADDSA:
 * Once you have a valid file that needs a standalone header, add the 
 * default header.
 *
 *	sw0 - kelly - changed the hardcoded tmp file name to use tmpnam()
 */
#include "extern.h"
char *malloc();
char *tmpnam();
addsa()
{
	int i, ct, extra;
	char * p = aouthdr.boothdr.boot_name;
	char *tmpnam();

	/* set up new aouthdr with boothdr */
	aouthdr.boothdr.bd_type = BD_TYPE;
	aouthdr.boothdr.bd_ifcard = BD_IFCARD;
	aouthdr.boothdr.bd_iocard = BD_IOCARD;
	aouthdr.boothdr.bd_opt = BD_OPT;
	aouthdr.boothdr.user_opt = USER_OPT;
	aouthdr.boothdr.boot_type = BOOT_TYPE;
	strcpy(p, filename);
	if(versionflag)
		aouthdr.boothdr.boothdr_version = uresult;	
	else
		aouthdr.boothdr.boothdr_version = VERSION;
	aouthdr.boothdr.boothdrdummy[0] = DUMMY0;
	aouthdr.boothdr.boothdrdummy[1] = DUMMY1;
	aouthdr.boothdr.boothdrdummy[2] = DUMMY2;
	aouthdr.boothdr.boothdrdummy[3] = DUMMY3;
	aouthdr.boothdr.boothdrdummy[4] = DUMMY4;

	/* get size of the new boothdr */
	extra=sizeof(aouthdr.boothdr);

	/* get a tmp file name - sw0 */
	tempfile=malloc(L_tmpnam);
	tmpnam(tempfile);

	/* open tmp file */
	if((tp=fopen(tempfile,"w")) == NULL)
		fprintf(stderr,"%s: Cannot create %s\n",
		utilname,tempfile),exit(1);
	
	/* change the magic number */
	filehdr.f_magic = SAMAGIC;

	/* adjust the file ptr to symtab in the filehdr */
	if(filehdr.f_symptr != 0)
		filehdr.f_symptr=filehdr.f_symptr + extra;

	/* update the sizeof opthdr  */
	if(filehdr.f_opthdr != 0)
		filehdr.f_opthdr = filehdr.f_opthdr + extra;

	/* put the filehdr into the tmp file */
	if(1 != fwrite( &filehdr, sizeof(filehdr), 1, tp))
	{
		fprintf(stderr,"%s: Cannot write filehdr to %s\n", 
	 	utilname,tempfile);
		closefile('n');	
	}
	/* put the new aouthdr into the tmp file */
	if(1 != fwrite(&aouthdr, sizeof(aouthdr), 1, tp))
	{
		fprintf(stderr,"%s: Cannot write aouthdr to %s\n", 
	 	utilname,tempfile);
		closefile('n');	
	}
	for( i=1; i<=filehdr.f_nscns; i++)
	{
		if(1 != fread(&scnhdr, sizeof(scnhdr), 1, fp))
		{
			fprintf(stderr,"%s: Cannot read section header to %s\n",
	 		utilname,tempfile);
			closefile('n');	
		}
		/* adjust the ptr to raw data for section */
		if(scnhdr.s_scnptr != 0)
			scnhdr.s_scnptr = scnhdr.s_scnptr + extra;

		/* if there is relocation information you should exit */
		if(scnhdr.s_nreloc != 0)
		{
			fprintf(stderr,"%s: Relocation information present in %s\n", 
	 		utilname,filename);
			closefile('n');	
		}
		
		/* if there is a line number section, adjust the pointer */
		if(scnhdr.s_nlnno != 0)
			scnhdr.s_lnnoptr = scnhdr.s_lnnoptr + extra;
			
		/* write the section header to the tmp file */
		if(1 != fwrite(&scnhdr, sizeof(scnhdr), 1, tp))
		{
			fprintf(stderr,"%s: Cannot write scnhdr to %s\n", 
	 		utilname,tempfile);
			closefile('n');	
		}
	}

	/* write the rest of the file to the tmp file */
	tptr=malloc(BUFSIZE);
	while((ct=(fread(tptr, 1, BUFSIZE, fp))) != 0 )
		if(1 != fwrite(tptr, ct, 1, tp))
		{
			fprintf(stderr,"%s: Cannot write to %s\n", 
	 		utilname,tempfile);
			closefile('n');	
		}
	
	/* close the files and rename them */
	free(tptr);
	fclose(fp);
	fclose(tp);
	if(unlink(filename) != 0)
	{
			fprintf(stderr,"%s: Cannot unlink %s\n", 
	 		utilname,filename);
			exit(1);
	}
	execl("/bin/mv", "mv", tempfile, filename, 0);
	if(chmod(filename, 777) != 0)
	{
			fprintf(stderr,"%s: Cannot chmod of %s\n", 
	 		utilname,filename);
			exit(1);
	}
}	
