#include "hsdtccpu.h"
#include "hsdtdisksect.h"
#include "hsdt.h"
#include "hsdtdtc.h"
#include "hsdtdata.h"
#include "vreg.h"
#include "hsdtextrn.h"
#include "hsdtvern.h"
#include "hsdtdevstr.h"
#include "data_struct.h"
#include "hsdtptm.h"

#define CTRL_D	4

extern ldlssp(), pdlssp(), pdls();
int restcon();

/* *************************************** */
extern rwdisk(), disksize(), readid();
extern display();
/* *************************************** */

char *skipsp(); char *skiparg();
struct cmd  {
	char cmdchar; int (*func)();
} cmdtbl[] = {
	'U', restcon,
	'D', display,
/* *********************************************** */
/* if we run out of text space, the following command */
/* can be deleted */

	'E', readid,
	'R', rwdisk,
	'W', rwdisk,

/* *********************************************** */
	0, 0,
};


main() {
	char buffer[32];
	register char *bptr;
	register struct cmd *p;
	register struct interim_processing_que *ip;
	register struct seek_per_disk *sptr;
	unsigned char *xhead; 
	struct dkinf *dkptr;
	struct ld *pl;
	register unsigned char temp;
	register int rc, i;

	/* init HSDT hardware */
	printf ("\nHSDT %x.%x%x\n#", VERNUM, RELEASE,RELEASE1);

	inithsdt();
	ip = &ipque;

	for (;;) {

	/* check to see if there are any dtb transfers ready to go */

		if((!dtbque.dtb_active) && (dtbque.d_first) &&
		    !(seekque.seek_active&0xf)){
			dtbque.dtb_active |= (dtbque.d_first->q_devtype);
			dtb_proc(dtbque.d_first);

		}

	/*Now check if there are any requests from the master cpu */

		if ( bddesc.reqfst )
			ckreq();

	/* Anything on the tape queue? */

		if(!tapeque.t_active && tapeque.t_first){
			tapeque.t_active++;
			setup_tape(tapeque.t_first);
		}


	/*The seekque disk_seek_ptr should be pointing to the next available
	  seek request. If there is one, process it and then search all of the
	  drive seek queues in order to update disk_seek_ptr
	*/
		enter_short_cr;
		sptr = seekque.disk_seek_ptr;
		if(sptr){
		    if((!(seekque.seek_active&UPPERBIT(sptr->s_first->q_devnum)))
			&& (!(dtbque.dtb_active&DISK))){
			seekque.seek_active |= UPPERBIT(sptr->s_first->q_devnum);
			seekque.disk_seek_ptr = 0;
		        exit_short_cr;
			start_seek(sptr);
			enter_short_cr;
			for(i=0;i<MAX_PDRIVE;i++){
				sptr = sptr->next_seek_per_disk_ptr;
				if((sptr->s_first )
				    && (!(seekque.seek_active & 
		    	    	    BIT(sptr->s_first->q_devnum)))) {
		    			seekque.disk_seek_ptr = sptr;
		    			break;
				}
			}
			exit_short_cr;
		}

	    }

		exit_short_cr;

		if(ip->i_p_first ){
			if(!(ip->i_p_active)){
				ip->i_p_active++;
				ip->i_p_proc_count = 0;
				ip->i_p_count = 0;
				ip->i_p_block = ip->i_p_first->q_devun.block;

				load_mmu(ip);
			}
			else{

	/* Only process the raw request if the mmutable has been loaded */

				if((ip->i_p_active&MMUTABLE_IN) ||
				    ip->i_p_first->rc1) 
					raw_proc(ip);
			}
		}

		if(status_change){

		/* check for icb interrupt from main cpu or
			monitor command from keyboard */

		    if ( status_change & ICB ) {
			/* get interrupt word */
			if ( icbdata & ICBI_MASK)
				icbparse();
			status_change &= ~ICB;
		    }

		    if(status_change & DISK){
		    	if(!(dtbque.d_first || seekque.disk_seek_ptr)){
				dkopen(0,dkptr);
				status_change &= ~DISK;
		    	}
		    }
				

		    if(status_change & CONSOLE){
		    	if ( consolecmd == 0 ) {
				xhead = head;
				while ( xhead != tail ) {
					temp = *xhead++;
					if ( xhead == &input_q[sizeof input_q] )
						xhead = input_q;
					if ( temp == CTRL_D ) {
						consolecmd = 1;
					}
					head = xhead;
				}
			/* no character in buffer */
		    	}
		    	else if ( head != tail ) { 
			/* monitor command input active */
				bptr = buffer;
				for (i=0; i < sizeof(buffer); i++)
					*bptr++ = ' ';

				rc = 0;
				if ( get(buffer,sizeof(buffer)-1) < 0 )
					rc = 1;

				else if ( buffer[0] != 0 ) {
					bptr = skipsp(buffer);
					rc = 1;

				/* search for valid command */
					for(p= cmdtbl;p->cmdchar;p++) {
						if ( *bptr == p->cmdchar ) {
					     		rc=(*(p->func))(bptr);
					     		break;
						}
					}
				}
				if ( rc )
					printf ("?\n");
				printf ("#");
		    	}
			status_change &= ~CONSOLE;
		    }
		}

	}	/* end of for loop */
}

/*	get a line of output into buffer, up to a carriage return.
	if character stream is greater then buffer size, return -1
	else return num of character in buffer
	also convert all lower case to upper case letters
			--------------------------------
	input:	character buffer pointer, buffer size
*/

get(bufptr, bsize)
char *bufptr; int bsize;
{
	register char *ptr; register int charnum ;
	register char c;

	ptr = bufptr;

	charnum =0;
	while ( (c=getchar()) != '\r' && c !=0 && charnum < bsize 
			&& c != '\n') {
		putchar(c);
		switch (c) {
			case 0x10:
				charnum = 0;
				ptr = bufptr;
				printf ("^\r");
				break;

			case '\b':
				if ( charnum ) {
					--ptr;
					--charnum;
					putchar(' ');
					putchar('\b');
				}
				break;
	
			default:
				if ( (c >='a') && (c <='z') )
					c -= 0x20;
				*ptr++ = c;
				charnum++;
				break;
		}
	}
	if ( charnum >= bsize ) return (-1);


	*ptr = 0;
	putchar ('\r');
	putchar ('\n');
	return (charnum);
}

/*	*******************************		*/
/*	skip over argument upto a space		*/
/*	or zero or \r or \n			*/
/*	*******************************		*/
char *
skiparg(ptr)
register char *ptr;
{	register char c;
	while ( (c= *ptr) != ' ' && c != 0 && c != '\r' &&
		c != '\n' ) ptr++;
	return (ptr);
}

/*	******************	*/
/*	skip over space		*/
/*	******************	*/
char *
skipsp(ptr)
register char *ptr;
{
	while ( *ptr == ' ' )
		ptr++;
	return (ptr);	/* got char not space */
}

/*	********************************************	*/
/*	convert input ascii-char to 4 bits hex value	*/
/*	********************************************	*/

convert(c)
register char c;
{
 	if ( (c >= '0') && (c <= '9') ) {
		c -= '0';
		return (c);
	}
	else if ( (c >= 'a') && (c <= 'f') ) {
		c += 10 - 'a';
		return (c);
	}
	else if ( (c >= 'A') && (c <= 'F') ) {
		c += 10 - 'A';
		return (c);
	}
	else if ( (c == ' ') || (c == '\n') || (c == '\r') || (c == 0) )
		return (-2);
	else
		return (-1);
}


/*	*******************************************************	*/
/*	take the next argument and convert to 32 bits hex value */
/*	pptr = double pointer (contain a pointer to the buffer  */
/*	*******************************************************	*/
getlong(pptr, pvalue)
register char **pptr; register int *pvalue;
{
	register unsigned int hex32;
	register char c, *ptr;
	register temp;

	ptr = skipsp(*pptr);	/* skip over space */
	c = *ptr;		/* point to non-blank char */

	/* **************************** */
	/* check out any char out there */
	/* **************************** */

	temp = convert(c);
	c = temp;

	if ( (temp == -1) || (temp == -2) ) {
		*pptr = ptr;
		return ( -1 );	/* no hex value */
	}

	/* ****************************** */
	/* have not increment pointer yet */
	/* ****************************** */

	hex32 = 0;
	*pvalue = 0;

	while ( 1 ) {
		temp = convert(*ptr++);
		c = temp;
		if ( (temp != -1) && (temp != -2) )
			hex32 = (hex32 << 4) + c;
		else
			break;
	}
/* return  2 values */

	*pptr = --ptr;
	*pvalue = hex32;
	if ( temp == -2 )
		return ( 0 );	/* 8 digits */
	else
		return (-1);	/* illegal character */
}


/*	********************************************	*/
/*	get the next three argument (expect to be long)	*/
/*	and convert them into three 32 bits value	*/
/*	store them at array pointed by argup		*/
/*	********************************************	*/

getarg(bufptr, argup, num)
char *bufptr; register int *argup, num;
{
	char *ptr; unsigned int temp;
	/* ***************** */
	/* skip over command */
	/* ***************** */
	ptr = skiparg (bufptr);

	while ( num--)  {
		if (  getlong(&ptr, &temp) < 0 ) 
			return (-1);
		else
			*argup++ = temp;
	}
	return(0);
}

restcon()
{	consolecmd = 0;
	return (0);
}

dtb_proc(dev)
register struct devq *dev;
{

	register unsigned char *dtb_ptr;
	register unsigned int direction,localcount;
	
	switch(dev->q_flag&FUNCTION_MASK){
		case DK_TO_MAIN:
		case LOC_TO_DK:
		case DK_TO_LOC:
			diskrw(dev);
			break;
		case LOC_TO_MAIN:
		case MAIN_TO_LOC:
			direction=(dev->q_flag & MAIN_TO_LOC) ? RD_DTB : WR_DTB;
			if ( dev->q_mmu ) {
				enter_short_cr;
			/* *************************************** */
			/* transfer data for non-contiguous memory */
			/* program chain dma starting & ending addr */
			/* *************************************** */

			/* number of bytes to program DTB dma */
				localcount = prgdtbchn (dev, direction);
	
				inturpt &= ~(DTB_INT | DTBDMA_INT | CHNDMA_INT | DDC_INT);

			/* program DTB dma with local buffer addr */
				dmaddr(dev->local_mem->fm,localcount-4,DTBDMA );

		/* program DTB/DISK data path mode for local memory <->DTB */
				mslmdkdtb (direction, ~DISK);
				dtbque.d_tick = TICK_1SEC;
				exit_short_cr;
				return;
			}
			dtb_ptr = dtbbuf;
			*(short *)(dtb_ptr+2) = dev->q_count>>2;
			*(int *)(dtb_ptr+4) = (int)(dev->q_mem) >> 2;
			xferdata(dtb_ptr,dev->local_mem,direction,DTBNOWAIT);
			break;

	}
}
