#include "hsdtccpu.h"
#include "hsdtstruct.h"
#include "hsdtdisksect.h"
#include "hsdt.h"
#include "hsdtdevdq.h"
#include "hsdtdevstr.h"
#include "devcmd.h"
#include "hsdtdtc.h"
#include "hsdterror.h"
#include "hsdtextrn.h"
#include "vreg.h"
#include "data_struct.h"


#define DISKIO	1


int dkopen(), diskclose(), dkcmder(), dkcompl();

extern ldlogrw(),	phyrw(),	pdlogrw();
extern diskio();
extern diskopen();
extern nextrvsec(),	phspare();
extern hwspare(),	swapdev();
extern rwsecid(),	unspare();
extern setiming(),	seekio();
extern medeftrk(),	wrsysec0();
extern newstat();

struct dcmd {
	int (*func)(); unsigned char io; unsigned char opr;
} dcmdtbl[] = {
	dkcmder,	0,	0,	/* 0 */
	ldlogrw,	DISKIO,	OPR_READ, /* 1 log dr,log sec(1),spare lookup */
	ldlogrw,	DISKIO,	OPR_WRITE,

	phyrw,		DISKIO,	OPR_READ, /* 3 phydr,c,h,s(multiple),no spare */
	phyrw,		DISKIO, OPR_WRITE,
	pdlogrw,	DISKIO, OPR_READ, /* 5 phydr,log sect(1),spare lookup */
	pdlogrw,	DISKIO, OPR_WRITE,

	phyrw,		DISKIO,	OPR_READ, /* 7 phy dr,c,h,s(mult)spare lookup */
	phyrw,		DISKIO,	OPR_WRITE,

	dkcmder,	0,	0,	/* 9 */
	dkcmder,	0,	0,	/* a */
	dkcmder,	0,	0,	/* b */
	dkcmder,	0,	0,	/* c */

	dkcmder,	0,	0,	/* d */

	dkopen,		0,	0,	/* e (reopen) read sector 0 */
	diskclose,	0,	0,	/* f erase table for phy drive */


	dkcmder,	0,	0,	/* 10 size disk */
	dkcmder,	0,	0,	/* 11 get bad block list */
	nextrvsec,	0,	NO_OP,	/* 12 next available rv sector */
	phspare,	0,	NO_OP,	/* 13 prg alt, set spare table */

	dkcmder,	0,	0,	/* 14 med list */
	dkcmder,	0,	0,	/* 15 total bad blk number */

	hwspare,	0,	NO_OP,	/* 16 prg alt sector to -1 */
	dkcmder,	0,	0,	/* 17 total alt sectors number */

	dkcmder,	0,	0,	/* 18 get alt sectors list */
	swapdev,	0,	NO_OP,	/* 19 swap device */
	
	dkcmder,	0,	0,	 /* 1a,1b: pdr,chs(mult)spare lookup */
	dkcmder,	0,	0,	/* skip track */

	rwsecid,	0,	OPR_WRID,/* 1c format sectors */

	dkcompl,	0,	NO_OP,	/* 1d wait for all diskio completed */

	unspare,	0,	NO_OP,	/* 1e unspare sector */
	setiming,	0,	NO_OP,	/* 1f setup timing parameters */
	wrsysec0,	DISKIO,	OPR_WRITE,/* 20 write system sector 0 */
	seekio,		0,	NO_OP,	/*21 seek to the specified cyl number */
	rwsecid,	0,	OPR_RDID,/* 22 read sector id */
	medeftrk,	0,	OPR_RDID,/* 23 read med def list by track */
	newstat,	0,	NO_OP,   /*24 additional status information*/

};
	
dkparse(dev)
register struct devq *dev;
{
	register unsigned char operation;
	register struct dkinf *dkptr; register struct dcmd *p;
	register struct smdrd *rd;

	/* ***************************************** */
	/* check to see if there was a power failure */
	/* if so, stop all diskio 		     */
	/* ***************************************** */

	/* check for valid disk command */
	if ( dev->q_cmd >= (sizeof dcmdtbl / sizeof(struct dcmd)) ) {
		dev->rc1 = DER_ILLCMD;
		return(1);
	}

	p = &dcmdtbl[dev->q_cmd];

	/* only convert for read/write command */
	operation = p->opr;

	if ( (operation == OPR_READ) || (operation == OPR_WRITE) ) {
		/* can't take care of partial sectors */
		if ( (dev->q_count < BLKSIZE) || (dev->q_count & (BLKSIZE-1))
			|| (dev->q_count == 0) || (((int)dev->q_mem & 0x03) &&
			(!(dev->q_mmu)))) {
			dev->rc1 = DER_CNT;
			return(1);
		}
		if((dev->q_mmu) && (dev->q_count > MAX_RAW_COUNT)){
			dev->rc1 = DER_CNT;
			return(1);
		}
		/* convert total count to sector count, main memory shifted */
		dev->q_mem = (char *)((int)dev->q_mem >> 2);
		dev->scnt = dev->q_count >> BLKSIZBIT;

		/* ***************************************** */
		/* dev->sectleft = sector on next track      */
		/* dev->totsleft = total sector in a request */
		/* for command 1/2 and 5/6                   */
		/*	dev->sectleft will be re-calculated  */
		/* ***************************************** */
		dev->sectleft = dev->scnt;	/* total sector on single trk */
		dev->totsleft = dev->scnt;	/* total sector on request */
		dev->totsdone	= 0;
	}

	/* special case log drive */
	if ( (dev->q_cmd == LREAD) || (dev->q_cmd == LWRITE) ) {
		/* use device to store log drive */
		dev->q_devtype= dev->q_devnum & 0xf;
		dev->q_devnum = dev->q_devnum >> 4;
	}


	if ( (dkptr=(struct dkinf *)getphptr(dev))==(struct dkinf *)-1 ) {
		dev->q_devtype = DISK;
		return(1);
	}


	dev->opr = operation;		/* set operation code */
	dev->q_extdtb = 0;

	if((p->func) (dev,dkptr))
		return(1);

	return(0);

}

dkcmder(dev)
struct devq *dev;
{
	dev->rc1 = DER_ILLCMD;
	return(1);
}

/* read sector 0, 2 in data area again */
dkopen (dev, dkptr)
struct devq *dev; struct dkinf *dkptr;
{
	register struct devq *p;
	register unsigned short i;
	register struct dev_desc *devptr;
	

	/* ******************************************************** */
	/* erase 4 physical drive structures and rebuild them later */
	/* wait until all disk requests are done                       */
	/* ******************************************************** */
	diskclose (dev);

	dkptr = phydr;
	devptr = devdesc;
	if(!(devptr->dd_type & DTDISK)) devptr++;
	p = ipque.i_p_dqfirst;
	ipque.i_p_dqfirst = p->q_next;
	for ( i=0; i<MAX_PDRIVE; i++){
		initdevq (p);
		p->q_devtype = DISK;
		p->q_devnum = i;
		if(diskopen (p, dkptr) == 0)
			devptr->dd_count++ ;
		dkptr++;
	}
	ipque.i_p_dqlast->q_next = p;
	ipque.i_p_dqlast = p;
	p->q_next = (struct devq *)0;

	return(1);
	
}

/* ***********************************************************   */
/* close a drive, we need to erase physical drive table, logical */
/* drive table, skip track list for all drives, and reopen the   */
/* other drive later don't erase timing values if they have      */
/* been sent by the master cpu    			         */
/* ***********************************************************   */
diskclose (dev)
struct devq *dev;
{
	register unsigned short stat, i;
	register struct dev_desc *devptr;
	register struct dkinf *dkptr;
	unsigned char timeval[32];


	dkptr = phydr;
	for (i=0; i<MAX_PDRIVE; i++) {
		stat = dkptr->pd_ststat & (~DK_INIT);

		/* save any timing register */
		bcopy ( dkptr->timing, timeval, sizeof iddata );

		setbuf ( dkptr, sizeof (struct dkinf) >> 2, 0);

		seekque.s_p_d[dev->q_devnum].current_cyl = -1;
		dkptr->pd_ststat = stat;

		/* restore timing register if any */
		if ( dkptr->pd_ststat & DK_TIMIN )
			bcopy (timeval, dkptr->timing, sizeof iddata );

		dkptr++;
	}
	devptr = devdesc;
	if(!(devptr->dd_type & DTDISK)) devptr++;
	devptr->dd_count = 0;

	setbuf ( log, (sizeof (struct ld) >>2) *TOTLOG, 0 );
	skplist_num = 0;
	skplist_ptr = 0;
	setbuf ( sklist, (sizeof (struct badtrck) >> 2) * MAXSKNUM, 0 );
}


/*
	request to wait for all disk io to be completed, then
	send back the response to the master cpu
	This routine actually just sets a counter which is checked by the
	timer routine.  If, at that time, all of the disk activity has
	been completed and there is no more pending this request will
	be processed.
 */
dkcompl (dev)
struct devq *dev;
{

	disk_wait_timer++;
	disk_waiting = dev;

	return(0);
}
