
#include "hsdtccpu.h"
#include "hsdtdisksect.h"
#include "hsdt.h"
#include "hsdtdevdq.h"
#include "hsdtdevstr.h"
#include "hsdtdtc.h"
#include "hsdterror.h"
#include "hsdtdata.h"
#include "vreg.h"
#include "data_struct.h"
#include "hsdtextrn.h"
#include "devcmd.h"


ckreq()
{	register struct devq *dev;
	register struct interim_processing_que *iptr;
	register struct seek_per_disk *sptr;
	register struct tape_que *tptr;

		enter_short_cr;
		locktas();
		if ( (int)bddesc.reqfst == 0 ) {
			/* clear TAS */
			*DTC_CRH = 1;
			exit_short_cr;
			return;
		}
	
		dev = bddesc.reqfst;

		if ( bddesc.reqlst == (struct devq *)dev )
			bddesc.reqlst = 0;
		
		bddesc.reqfst = (struct devq *)dev->q_next;

		/* clear TAS */
		*DTC_CRH = 1;
	
		LIGHT(greenlit);
		exit_short_cr;
	
	
	/* ****************************************** */
		if ( PRINT2 )  {
			printlf();
			prbuf ( dev, (sizeof (struct devq)) >> 1 );
		}
	
		/* only keep 2 bits */
		dev->q_flag &= (NO_RETRY + NOALT);
		*((short *)&dev->rc1) = 0;	/* zero return code */
	
		dev->q_next = 0;
		dev->retry = 0;
	
		/* check for valid device by parsing the request for
		   errors in the elements of the structure */
		if ( dev->q_devtype == DISK ) {
		    if(dkparse(dev)){
			enter_short_cr;
			finreq(dev,1);
			exit_short_cr;
			return;
		    }
		}
		else if(dev->q_devtype & TAPE ){
		    if(taparse(dev)){
			enter_short_cr;
			finreq(dev,1);
			exit_short_cr;
			return;
		    }
		}
		else if (dev->q_devtype == PF_WAIT){
		    	dkcompl(dev);
			return;
		}
	 	else {
			dev->rc1 =  DER_DTYPE;
			enter_short_cr;
			finreq(dev,1);
			exit_short_cr;
			return;
		}
	

		/*If it is not contiguous memory, put it on the interim_
		  processing_queue */

		enter_short_cr;

		if(dev->q_mmu){
			iptr = &ipque;
			if(iptr->i_p_first)
				iptr->i_p_last->q_next = dev;
			else
				iptr->i_p_first = dev;
			iptr->i_p_last = dev;
		}

		/*Otherwise, a disk request should go on the seek queue */

		else if(dev->q_devtype == DISK){
			dev->q_flag |= DK_TO_MAIN;
			sptr = &seekque.s_p_d[dev->q_devnum];
			sptr->sort_count++;
			if(sptr->s_first)
				check_sort(dev,sptr);
			else{
				sptr->s_first = dev;
				sptr->sort_ptr = dev;
				sptr->s_last = dev;
				dev->q_next = (struct devq *)0;
			}
			if((seekque.disk_seek_ptr == (struct seek_per_disk *)0)
				    && (!(seekque.seek_active & 
		    	    	    BIT(dev->q_devnum)))) 
				seekque.disk_seek_ptr = sptr;
		}

		/* and a tape request should go on the tape queue */

		else if(dev->q_devtype & TAPE ){
			tptr = &tapeque;
			if(tptr->t_first)
				tptr->t_last->q_next = dev;
			else
				tptr->t_first = dev;
			tptr->t_last = dev;
		}

	exit_short_cr;
}

/* interrupts are disabled when we enter this routine */

finreq(ndevq,leave_dtb_alone)
register struct devq *ndevq;
unsigned int leave_dtb_alone;
{
	register struct devq *dq;
	register unsigned int *io_count;
	register struct dtb_que *dptr;

	if(!(leave_dtb_alone)){

		dptr = &dtbque;
		if((dptr->d_first = ndevq->q_next) == (struct devq *)0)
			dptr->d_last = (struct devq *)0;
	}

	if(ndevq->q_flag&FREE_REQ){
		if(ipque.i_p_dqfirst)
			ipque.i_p_dqlast->q_next = ndevq;
		else
			ipque.i_p_dqfirst = ndevq;
		ipque.i_p_dqlast = ndevq;

		ndevq->q_next = (struct devq *)0;
		ndevq->q_prev = (struct devq *)0;
		return;
	}
	
	
	ndevq->q_next = (struct devq *)0;
	ndevq->q_prev = (struct devq *)0;



/* If there is not a value in q_mmu, then we have completed a block io
   transfer and now must put in a count in the physical drive structure
   to increment the number of block io transfers and the total time for 
   those requests.
*/
	if(!(ndevq->q_mmu)) {
		io_count = io_counter_array[ndevq->q_devnum] ;
		*io_count += 1;
		*(io_count+1) += (clock_cnt - time_counter_array[ndevq->q_devnum]);
	}

	
	if ( PRINT2 )
		prbuf ( ndevq, (sizeof (struct devq)) >> 1 );
	
	if ( PRINT1 && (*(short *)&ndevq->rc1) )
		printrc(ndevq);

	/* put req on response que */
	locktas();
	if ( bddesc.rsfst == 0 ) {
		bddesc.rsfst = ndevq;
		bddesc.rslst = ndevq;

		/* clear TAS */
		*DTC_CRH = 1;
	/* interrupt the master cpu */
		intr_cpu (ICB_ACK);
	}
	else {
		/* put que at the end */
		dq = bddesc.rslst;
		dq->q_next = ndevq;
		ndevq->q_prev = dq;

		bddesc.rslst = ndevq;

		/* clear TAS */
		*DTC_CRH = 1;
	}

	LIGHT(ledoff);
	return (0);
}
locktas()
{	register first;
	first = 1;
	while ( ICB_TAS ){
		if ( first && PRINT2 )
			con_out ('*');
		first = 0;
	}
}

