 
#include "hsdtccpu.h"
#include "hsdtdtc.h"
#include "hsdtdisksect.h"
#include "hsdt.h"
#include "hsdtdevdq.h"
#include "hsdtdevstr.h"
#include "devcmd.h"
#include "hsdttape.h"
#include "hsdterror.h"
#include "hsdtdata.h"
#include "hsdtptm.h"
#include "hsdtextrn.h"
#include "vreg.h"
#include "hsdtstruct.h"
#include "data_struct.h"

#define TAPENUM		0
unsigned char check_status = 0;
extern int watch;

prgclk()
{
	/* clock will interrupt every 10 ms */
	MTPR ( TM_MSB3, TICKHZ >> 8);
	MTPR ( TM_LSB3, TICKHZ & 0xff);
	MTPR ( TM_C2, PTM_OE | PTM_DUAL8 | PTM_ECLOCK | PTM_REG3);
	MTPR ( TM_C13, PTM_OE | PTM_IE | PTM_ECLOCK);
}

clockint()
{
	register struct tape_que *taptr;
	register struct dkinf *dkptr;
	register struct seek_per_disk *sptr;
	register struct devq *dev;
	struct smdrd *p;
	register char i;

/* keep clock ticking */
	if( (++clock_cnt & 7) != 7 ){
		i = MFPR (TM_S2);
		i = MFPR (TM_MSB3);
		i = MFPR (TM_LSB3);
		return;
	}

	/*  check for a timeout on DTB activity */

	if ( dtbque.dtb_active && ( dtbque.d_tick ) ) {
		if ( --dtbque.d_tick  == 0 ){
			enter_short_cr;
			timeoutdtb();
			exit_short_cr3;
		}
	}

	 /*check to see if there is any disk activity which may timeout */

	sptr = seekque.s_p_d;
	dkptr = phydr;
	++check_status;
	enter_short_cr;
	for ( i=0; i<MAX_PDRIVE; i++,sptr++,dkptr++ ) {
		if ( sptr->s_time ) {
			if(!(seekque.seek_active&BIT(i))) 
				printf("seek not active %x\n",i);
			if ( (--(sptr->s_time)) == 0 ){
				timeoutdisk(sptr,i);
			}
	 	watch = 0;
		}
	/* Otherwise, if no disk activity is going on, check to see which
	   drives may have changed status (either gone not ready but the
	   status table indicates it is ready or now ready and the status
	   table indicates that it is not).*/
	
		else if(check_status >= 12){
		    if(((seekque.seek_active&UPPERBIT_MASK)== 0) &&
			!(seekque.disk_seek_ptr)){
			    if(disk_wait_timer){
			        if(disk_waiting->q_devtype == PF_WAIT)
				    finreq(disk_waiting,1);
			        disk_wait_timer = 0;
			    	return;
			    }
			    p = (struct smdrd *)DK_STSR + i;
			    if(dkptr->pd_ststat&DK_READY){
			        if((p->unitstus & UNIT_RDY) == 0){
				    closephy(i,dkptr);
				    break;
			        }
			    }
			    else{
			    	if(!(status_change&DISK) && !(unitsel(i)))
					status_change |= DISK;
			    }
			}
			else if (((seekque.seek_active&UPPERBIT_MASK)!= 0) &&
			      ((seekque.seek_active&LOWERBIT_MASK)== 0) &&
			      (!(dtbque.dtb_active)))
				if((watch++ > 12)){
				int i;
					    if(PRINT3)
						printf("watch_dog ");
						for(i=0;i<0x10000;i++);
					seekque.seek_active=0;
					watch=0;
					}
	    }
	}
	exit_short_cr3;


	if(check_status >= 12) check_status = 0;
/*
	 check for any tape activity to timeout 
*/

	taptr = &tapeque;

	 /* *************************************************** 
	 make sure the tape is actually moving              
	 when tape is using DTB
	 *************************************************** */

	if ( taptr->t_first != (struct devq *)0 ) {
		if ( taptr->t_tick ) {
			if ( (--taptr->t_tick) == 0 ) {
				enter_short_cr;
				timeoutape(taptr->t_first);
				exit_short_cr3;
			}
		}
	}
#ifdef TRACK9
	else{
	    if(taptr->tape_status_waiting){
	    	for(i=0; i<MAX_TDRIVE;i++){
			if((dev = taptr->tape_wait_que[i])){
			    if(--taptr->waiting_timer[i] == 0) {
			    	if(--dev->retry){
					if(taptr->t_first)
						taptr->t_last->q_next = dev;
					else
						taptr->t_first = dev;
					taptr->t_last = dev;
			    	}
			    	else{
					dev->rc1 = DER_NRDY;
					finreq(dev,1);
			    	}
				taptr->tape_wait_que[i] = (struct devq *)0;
				taptr->tape_status_waiting &= UNBIT(i);
			    }
			}
	    	}
	    }
	}
#endif



	 /* led for idle */
	enter_short_cr;
	if ( ++ledtick >= TICK_1SEC ) {
		ledtick = 0;
		if ( (unsigned short)(dtc_ctl&0x03)!=(unsigned short)greenlit )
			i = greenlit;
		else
			i = ledoff;
		LIGHT (i);
	}
	exit_short_cr3;


	 /*keep clock ticking */
	i = MFPR (TM_S2);
	i = MFPR (TM_MSB3);
	i = MFPR (TM_LSB3);

	return;

}

timeoutape(dev)
register struct devq *dev;
{
	register unsigned short intfcard;

	/* timeout on tape */
	/* check which kind of tape interface card */
	intfcard = *TP_SR & TP_INFC;
#ifdef TRACK9
	if ( intfcard == TP_9TRKIF )
		resetape9();
#endif
#ifdef ARCH
	if ( intfcard != TP_9TRKIF ) {
		resetape();
	}
#endif

	dev->rc1 = TP_HANG;
	dev->q_count = 0;


	/* don't allow tape to inturpt, disable tape dma bit */
	dtc_ctl &= ~TAPEINT_EN;
	*DTC_CRL = dtc_ctl;
	inturpt &= (~TAPEDMA_INT + TAPE_INT);
	dbc_cr &= ~TP_EN;
	*DBC_CR = dbc_cr;

	if ( dev->q_flag & NO_WAIT ) {
		/* send response back to master cpu */
		/*first mark the request finished so that the main
		  request will be sent back to the master later */

		if((dev->q_cmd == TPREAD) || (dev->q_cmd == TPWRITE)){
			ipque.i_p_block = FINISHED;

		/* then take the request off of the tape que */

			*(short *)&ipque.i_p_first->rc1= *(short *)&dev->rc1;
			ipque.i_p_count += dev->q_count;
			clean_up_que(dev,0);
		}
		else{
			if((tapeque.t_first = dev->q_next) == 0)
				tapeque.t_last = 0;
			finreq(dev,1);
		}
		tapeque.t_active = 0;
	}
	else {
		/* for tape operation to be waited for completion */
		/* for fast tape rw */
		inturpt |= TAPE_INT;
	}

}


timeoutdisk(skptr,drive)
register struct seek_per_disk *skptr;
register unsigned int drive;
{
	register struct devq *dev;
	register struct seek_que *sptr;


	/* reset disk drive */
	*DDC_CR = 0;
	*DDC_CR = ENDKDATAC;

	sptr = &seekque;


		/* ******************** */
		/* timeout on disk seek */
		/* ******************** */
	if ( (dev=skptr->s_first) == (struct devq *)0 )
		return;
	skptr->current_cyl = -1;

	++dev->retry;

	/* seek timeout, try rezeroeing, if this has a problem, 
		send the request back to master cpu */
	

	if ( dev->q_flag & WAIT) 
		return;
	if ( (dkrezero (drive, skptr)) || (dev->retry >= RETRY)){
		if(dev->q_flag&RETRY_CRC) /*FIX for head repositioning */
			dev->rc1=DER_CRC;
		else
			dev->rc1 = DER_TIMEOUT;
		if(ipque.i_p_first->q_key == dev->q_key)
		    	*(short *)&(ipque.i_p_first->rc1) = *(short *)&dev->rc1;
		    	if(seekque.seek_active && 
			    (skptr == &seekque.s_p_d[drive]))
			 	/*take all seeks off the seekque */
				clear_que(skptr,dev->q_key); 

		if((skptr->s_first = dev->q_next) == (struct devq *)0) {
			skptr->s_last = (struct devq *)0;
			sptr->disk_seek_ptr = (struct seek_per_disk *)0;
			/* it would have no first */
		}
		else
			if(sptr->disk_seek_ptr == (struct seek_per_disk *)0) 
				sptr->disk_seek_ptr = skptr;
		skptr->sort_ptr = skptr->s_first;
		finreq(dev,1);

	}
	sptr->seek_active &= ~(U_L_BIT(drive));

}

timeoutdtb()
{

	register struct devq *dev,*tmp;
	register struct seek_per_disk *skptr;
	register unsigned short intrptbit;
	register struct dtb_que *dtb;
 	unsigned char ddcstatus,drive;

	ddcstatus = *DDC_SR; /*fix for r/w timeout */

	dtb = &dtbque;
	if((dev = dtb->d_first) == (struct devq *)0)
		return(1);
	drive = dev->q_devnum;
	skptr = &seekque.s_p_d[drive];

	if(dev->q_flag & (LOC_TO_MAIN|MAIN_TO_LOC)){
		inturpt &= ~(DTB_INT + DTBDMA_INT + CHNDMA_INT);
		dbc_cr &= ~(CHN_EN + DTB_EN);
		*DBC_CR = dbc_cr;
		canceldmc();

		if ( ++dev->retry >= 3 ) {
			finreq(dev,0);
			if(ipque.i_p_first->q_key == dev->q_key){
				ipque.i_p_block = FINISHED;
				ipque.i_p_first->rc1 = DER_TIMEOUT;
				if(dev->q_devtype == TAPE)
					clean_up_que(dev,1);
			}
			if(dev->q_devtype == DISK) 
			       seekque.seek_active &= ~(U_L_BIT(drive));
		}
		dtb->dtb_active = 0;
		return;
	}


		/* ****************** */
		/* timeout on disk rw */
		/* ****************** */

		/* need to cancel dmc */
	if ( dev->q_flag & (DK_TO_LOC|LOC_TO_DK) ) {
		intrptbit = DDCDMA_INT; /* disk <-> local memory) */
		dbc_cr &= ~(DDC_EN + DDA_EN);
	}
	else {
		intrptbit = CHNDMA_INT + DTB_INT; /* disk <-> DTB */
		dbc_cr &= ~(CHN_EN + DDA_EN);
	}

	inturpt &= ~( intrptbit + DDADMA_INT + DDC_INT);
	*DBC_CR  = dbc_cr;


	/* turn off  bits in  DDC control register */
	*DDC_CR = 0;
	*DDC_CR = ENDKDATAC;
 
	/* don't allow ddc done interrupt */
	dtc_ctl &= ~DDCINT_EN;
	*DTC_CRL = dtc_ctl;

	++dev->retry;
	present_timing = 0;

	if ( (dev->q_flag & (DK_TO_LOC|LOC_TO_DK) ) == 0 ){
		canceldmc();

	}


	if ( (dev->q_flag & WAIT) == 0 ) {
		if(ddcstatus & DATA_OVR){
			printf(" OVER_RUN ");
			over_run(dev); /* use local memory */
			dtb->dtb_active = 0;
			return;		/* let the proc continue */
		}
		if(ddcstatus & CRC_ERR)
			dev->q_flag |= RETRY_CRC;

		if ( (dkrezero (drive, skptr)) || (dev->retry >=RETRY)){
			if(dev->q_flag&RETRY_CRC)
				dev->rc1 = DER_CRC;
			else if(ddcstatus&HEAD_SEARCH) 
				dev->rc1 = DER_HDSR;	/* header search */
			else
				dev->rc1 = DER_TIMEOUT;
			if(ipque.i_p_first->q_key == dev->q_key)
			  	*(short *)&(ipque.i_p_first->rc1) =
				     *(short *)&dev->rc1;
			dev->q_count = 0;
		    	if(skptr->s_first)
				clean(skptr,dev);
			else if(seekque.disk_seek_ptr==skptr)
				seekque.disk_seek_ptr = 0;
			seekque.seek_active &= ~(U_L_BIT(drive));
			finreq (dev,0);
			dtb->dtb_active = 0;
			return;
		}
		else {
			/****************************************/
			/* take the requests for this disk and  */
			/* cylinder of the dtbque and place on  */
			/* the seekque and start the seek again */
			/****************************************/

		    while(dtb->d_first &&(drive ==  dtb->d_first->q_devnum)) {
			int cylinder;

			cylinder = dtb->d_first->q_devun.pdisk.cyl; 
			if(skptr->s_first){
				skptr->s_last->q_next = dev;
				dev->q_prev = skptr->s_last;
			}
			else{
				skptr->s_first = dev;
				skptr->sort_ptr = dev;
			}
			skptr->s_last = dev;
			if(!(dtb->d_first = dev->q_next)){
		       	    dtb->d_last = (struct devq *)0;
			    seekque.seek_active &= ~(U_L_BIT(drive));
			    if(seekque.disk_seek_ptr == 0) 
			    	seekque.disk_seek_ptr = skptr;
			}
			else{
			    if((dtb->d_first->q_devnum == drive)&&
			      (dev->q_devun.pdisk.cyl == cylinder )) {
			        dev = dev->q_next; /*get the next buffer */
			        /*if(seekque.disk_seek_ptr ==  skptr)
					seekque.disk_seek_ptr = 0;*/
			    }
			    else {
			      seekque.seek_active &= ~(U_L_BIT(drive));
			      if(seekque.disk_seek_ptr == 0) 
					seekque.disk_seek_ptr = skptr;
			    }
			}
			skptr->sort_count++;
		    }
		    dev->q_next = (struct devq *)0; /* null end of seekque */
		}
	}
	else {
		/* for local wait for completion */
		inturpt |= DDC_INT;
		dev->q_count = 0;
		dev->rc1 = DER_TIMEOUT;
		finreq (dev,0);
	}

	dtb->dtb_active = 0;


	
}

extern int que_cnt;

clear_que(skptr,key)
register struct seek_per_disk *skptr;
register  int key;
{
	register struct devq *ptr,*ptr1;

    	ptr = skptr->s_first; /* setup  first pointer */
    	while(ptr) { /* end of que? */
		ptr1=ptr;
		if((ptr=ptr->q_next) != 0) {
			if(ptr->q_key==key) { /*same request? */
 		      		if(ipque.i_p_dqfirst){ /* back on free que */
			    		if(ipque.i_p_dqlast != ptr)/*sanity */
						ipque.i_p_dqlast->q_next = ptr;
				}
				else
					ipque.i_p_dqfirst = ptr;
				ipque.i_p_dqlast = ptr;
				que_cnt++;
				if(ptr->q_next) {
		        		ptr1->q_next = ptr->q_next;
					ptr->q_next = (struct devq *)0;
					ptr->q_prev = (struct devq *)0;
					ptr=ptr1;
				}
				else {
					skptr->s_last=ptr1;
					ptr->q_next = (struct devq *)0;
					ptr->q_prev = (struct devq *)0;
					ptr=0;
					ptr1->q_next = 0;
				}
			}
	 	}
	 	else	
			skptr->s_last=ptr1;
  	}
}


	 /* *************************************************** 
	 The request had an over run of more than one long word 
	 therefore the dtb timed out. Handle in local memory like
	 a regular over run.
	 *************************************************** */

over_run(dev)
register struct devq *dev;
{
    	dev->totsleft = dev->scnt;
    	dev->sectleft = dev->scnt;
    	dev->totsdone = 0;
    	*(short *)&dev->rc1 = 0;
    	dev->retry = 0;
    	dev->q_flag &= ~(DK_TO_MAIN|DK_TO_LOC|LOC_TO_DK|MAIN_TO_LOC);
    	dev->q_flag |= (dev->opr == OPR_READ) ? DK_TO_LOC|OVR_ERROR : 	
		MAIN_TO_LOC|OVR_ERROR;
    	dev->local_mem = NINE_TRACK_MEM; /* use local buffer area */
}
