#include "hsdtdtc.h"
#include "hsdtdisksect.h"
#include "hsdt.h"
#include "hsdtdevstr.h"
#include "hsdtdevdq.h"
#include "hsdttape.h"
#include "hsdterror.h"
#include "hsdtextrn.h"
#include "vreg.h"
#include "data_struct.h"


/*	return:	1 if seek error
		2 if read/write sector error
		0 if no error
 */


check_sort(dev,sptr)
register struct devq *dev;
register struct seek_per_disk *sptr;
{
	register struct devq *ap,*bp;


	/* sort the que */

	if((sptr->sort_count & 0xf) == 0)
		sptr->sort_ptr = sptr->s_last;
	if(!(sptr->sort_ptr)) sptr->sort_ptr = sptr->s_first;
	for (ap = sptr->sort_ptr; bp = ap->q_next;ap=bp){
		int s1, s2;
		if ((s1=ap->q_devun.pdisk.cyl-dev->q_devun.pdisk.cyl)<0)
				s1 = -s1;
		if ((s2=ap->q_devun.pdisk.cyl-bp->q_devun.pdisk.cyl)<0)
				s2 = -s2;
		if ( s1 < s2 ) 
			break;
	}
	ap->q_next = dev;
	dev->q_prev = ap;
	if((dev->q_next = bp) == (struct devq *)0)
		sptr->s_last = dev;
}
			
		


start_seek(sptr)
register struct seek_per_disk *sptr;
{

	register struct devq *dev;
	register struct dtb_que *dptr;
	register unsigned int retbyte;
	register unsigned short oldpri;
	struct devq *last_ptr,*first_ptr;
	register short cylinder;
	register unsigned short count;
#ifdef ASSERT
	struct devq *p;
#endif

	if((dev = sptr->s_first) == (struct devq *)0)
		return(1);



	if ( sptr->current_cyl != dev->q_devun.pdisk.cyl ) {

	/* time stamp the request for system activity */
		time_counter_array[dev->q_devnum] = clock_cnt;

		retbyte =  aseek (dev, sptr);
		/* if aseek routine has problem before starting
			to seek, it will rezero drive, set rc1
		*/
	    if(retbyte) {
		if (( dev->q_flag&OPEN_DISK) == OPEN_DISK) {
			if((sptr->s_first = dev->q_next) == (struct devq *)0)
				sptr->s_last = (struct devq *)0;
			seekque.seek_active &= ~(U_L_BIT(dev->q_devnum));
		}
		else if (++dev->retry>=RETRY) {/* return the error to kernel */
	    		ipque.i_p_first->rc1 = dev->rc1;
			clear_que(sptr,dev->q_key);
			seekque.seek_active &= ~(U_L_BIT(dev->q_devnum));
			if((sptr->s_first = dev->q_next) == (struct devq *)0){
				sptr->s_last = (struct devq *)0;
				seekque.disk_seek_ptr = 0; /*clear que */
			}
			finreq(dev,1);
		}
		else {				/* do it again */
			seekque.seek_active &= ~(U_L_BIT(dev->q_devnum));
			dev->rc1 = 0;
		}
	    }
		return(0);
		
	}


	/* Since we are already on the cylinder that this request
	   needs, just put the request on the dtbque for the disk r/w 
	   and take it off of the seek queue */


	enter_short_cr;
	dptr = &dtbque;
#ifdef ASSERT
	printf("start_seek: ");
	for(p=sptr->s_first;p;p=p->q_next)
		printf("%x(%x %x) ",p->q_devun.block,p->q_next,p->q_prev);
#endif
	first_ptr = dev;
	last_ptr = (struct devq *)0;
	cylinder = dev->q_devun.pdisk.cyl;
	count = 0;
	sptr->current_cyl = cylinder;
	while(dev && (dev->q_devun.pdisk.cyl == cylinder)){
		count++;
		last_ptr = dev;
		if(sptr->sort_ptr == dev)
			sptr->sort_ptr = dev->q_next;
		dev = dev->q_next;
		sptr->s_first = dev;
	}
	
	if(sptr->s_first == (struct devq *)0)
		sptr->s_last = (struct devq *)0;
	if(last_ptr->q_next)
		last_ptr->q_next->q_prev = (struct devq *)0;
	if(dptr->d_first)
		dptr->d_last->q_next = first_ptr;
	else
		dptr->d_first = first_ptr;
	dptr->d_last = last_ptr;
	dptr->d_last->q_next = (struct devq *)0;

#ifdef ASSERT
	printf("start_seek out : ");
	for(p = sptr->s_first;p;p=p->q_next)
		printf("%x(%x %x) ",p->q_devun.block,p->q_next,p->q_prev);
	printf("\n");
#endif
	seekque.seek_active &= UNBIT(first_ptr->q_devnum);
	exit_short_cr;
	return(0);
}

/* 3 to 1 sort */
char optimal[] = {
	0,15,30,1,16,31,2,17,32,3,18,33,4,19,34,5,20,35,6,21,36,7,22,37,
	8,23,38,9,24,39,10,25,40,11,26,41,12,27,42,13,28,43,14,29,44
};



resort(cyl_list_head, cyl_list_tail)
struct devq	**cyl_list_head;
struct devq	**cyl_list_tail;
{
	register struct devq	*ap, *bp, *next;
	register int		inserted;
	register char		ap_sector;
	register struct devq	*tail;	/* tail of list to go on dtb queue */

	struct devq	*final_head;	/* head of list to go on dtb queue */
	struct devq	*head;
	struct devq	*oldtail = (struct devq *)0;	
	struct devq	*dup_head = (struct devq *)0;
	struct devq	*dup_tail = (struct devq *)0;


	(*cyl_list_head)->q_prev = (*cyl_list_tail)->q_next = (struct devq *)0;

	/* set first request onto queue, and initialize pointers */

	head = final_head = tail = *cyl_list_head;
	ap = head->q_next;
	head->q_prev =  head->q_next = (struct devq *)0;
	if ( ap == (struct devq *)0 )	/* we're done */
		return;
	ap->q_prev = (struct devq *)0;

	/* while there are still requests to process */

ap_loop:

	while ( ap ) {

		next = ap->q_next;
		/* loop through current list from head */

		for ( bp = head; bp; bp = bp->q_next ) {

			inserted = 0;

			ap_sector = ap->q_devun.pdisk.sector;

			/* save off duplicates, process at end of list */

			if(ap_sector == bp->q_devun.pdisk.sector){

				if ( dup_head ) {
					dup_tail->q_next = ap;
					dup_tail = ap;
				}
				else		/* initialize */
					dup_head = dup_tail = ap;

				ap->q_next = ap->q_prev = (struct devq *)0;
				inserted = 1;
				break;
			}

			/* insert before current entry */

			if ( optimal[ap_sector] < 
			  optimal[bp->q_devun.pdisk.sector] ) {
				ap->q_next = bp;

				if ( bp->q_prev ) {
					bp->q_prev->q_next = ap;
					ap->q_prev = bp->q_prev;
					if ( head == bp ) {
						head = ap;
					}
					if ( final_head == bp ) {
						final_head = ap;
					}
					bp->q_prev = ap;
				}
				else {
					if ( oldtail )
						head = bp->q_prev = ap;
					else {
						final_head=head=bp->q_prev = ap;
					}
					ap->q_prev = (struct devq *)0;
				}


				inserted = 1;
				break;
			}
		}

		/* put at tail if we fell out of here without inserting */

		if ( inserted == 0 ) {
			ap->q_prev = tail;
			tail->q_next = ap;
			tail = ap;
			ap->q_next = (struct devq *)0;
		}

		ap = next;
	}

	if ( oldtail ) {
		oldtail->q_next = head;
		oldtail = (struct devq *)0;
	}

	if ( dup_head ) {
		oldtail = tail;
		head = tail = ap = dup_head;
		ap = ap->q_next;
		head->q_prev = head->q_next = (struct devq *)0;
		dup_head = dup_tail = (struct devq *)0;
		if ( ap ) {
			ap->q_prev = (struct devq *)0;
			goto ap_loop;
		}
		else {
			oldtail->q_next = head;
			oldtail = (struct devq *)0;
		}
	}

	/* insert onto dtb queue with final_head and tail */

	*cyl_list_head = final_head;
	*cyl_list_tail = tail;
}

setup_seek(sptr)
register struct seek_per_disk *sptr;
{
	register i;


	if((!(seekque.seek_active&UPPERBIT(sptr->s_first->q_devnum)))
	   && (!(dtbque.dtb_active&DISK))){
		if(!sptr->s_first){ /* sanity check for dev 0 */
			seekque.disk_seek_ptr = 0;
			return;
		}
		seekque.seek_active |= UPPERBIT(sptr->s_first->q_devnum);
		seekque.disk_seek_ptr = 0;
        	exit_short_cr;
		if(start_seek(sptr)){
		      enter_short_cr;
		      seekque.seek_active &= ~UPPERBIT(sptr->s_first->q_devnum);
		}
		enter_short_cr;
		for(i=0;i<MAX_PDRIVE;i++){
			sptr = sptr->next_seek_per_disk_ptr;
			if((sptr->s_first )
		    	&& (!(seekque.seek_active & 
    	    	    	BIT(sptr->s_first->q_devnum)))) {
    				seekque.disk_seek_ptr = sptr;
    				break;
			}
		}
	}

}
