#include "hsdtccpu.h"
#include "hsdtdisksect.h"
#include "hsdt.h"
#include "hsdtdevdq.h"
#include "hsdtdevstr.h"
#include "hsdtdtc.h"
#include "hsdtextrn.h"
#include "vreg.h"
#include "data_struct.h"
#include "hsdttape.h"
#include "hsdtdata.h"
#include "hsdtptm.h"
#include "hsdterror.h"


extern que_cnt;	/* free dev structs */
extern struct devq_buf devq_buf[];/* dual dev structs */

#define dual_buf 0xd258			/* dual_port buffer lowest */
#define dual_count 0x30			/* dual_port buffer count */
#define free_buf 0x11b90		/* local buffer lowest */
#define free_count 0x2a			/* local buffer count */

xamin ()
{
	register char *cptr;
	struct devq *dev,*hold;
	struct dkinf *dkptr;
	struct seek_per_disk *sptr;
	struct bd_desc *bd;
	unsigned short i,num;
	struct tp *taptr;

	bd = &bddesc; /*point to board data struct */
	dev = hold = ipque.i_p_dqfirst;
	while((hold=hold->q_next) != 0)
		dev = hold;
	printf("                ****     EDT BOARD STATUS     ****  \n");
	printf("  (0x%x) local devq structs  first free (%x) last free (%x)\n",
		que_cnt,ipque.i_p_dqfirst,dev);
	dev=bd->freefst;
	i=0;
	if((hold=dev)!=0) i++;
	while(hold&&(hold=hold->q_next) != 0){
		i++;
		dev = hold;
	}
      printf("  (0x%x) dual ported structs  first free (%5x) last free (%5x)\n",
	i,bd->freefst,dev); 
	printf("  system: requests first (%x) last (%x) ",
	         bd->reqfst,bd->reqlst);
	printf(": response first (%x) last (%x)\n",bd->rsfst,bd->rslst);
	for(i=0;i<4;i++){
	    dkptr = &phydr[i]  ;
	    if(dkptr->cyldisk)
	        printf("  disk(%x) 0x%x cyls 0x%3x trks 0x%x sects per track\n",
	        i,dkptr->cyldisk,dkptr->headcyl,dkptr->sechead);
	}
	/*bd->bd_imcptr = (struct icbcmdhdr *)drive_pointer_array;
	dtc_ctl = DKINTFEN | PROMOUT | ledoff;
	  *DMA_SELECT = 1; incase I want to write into a buffer */
return(0);
}
	
menu()
{
     printf(" \n");
     printf("                       EDT MENU \n");
     printf("  ?:   displays menu\n");
     printf("\n  D:  (address)(count) displays address to address + count -1");
     printf("\n  D:  (address) displays address(enter new value ??)\n");
     printf("      (or <cr> to toggle address Q returns controll");
     printf("\n\n  T:  resets tape drive");
     printf("\n\n  X:  examins local structures");
     printf("\n\n  P:  counts the dual ported request structures");
     printf("\n\n  F:  counts the local free request structures");
     printf("\n\n  Z:  locates all the  request structures on all the ");
     printf("\n");
return(0);
}


check(dev_low)
int dev_low;
{
register i,j;
register struct devq *dev;
char l,k,m,n,o;

	dev=dtbque.d_first;
	i = 0;
	while ( dev ){
		if(!i++)
			printf("dtb queue:");
		printf(" %x ",dev);
	        devq_buf[((int)dev - dev_low)/0x30].flag++;/*mark busy */
		dev=dev->q_next;
		if(!(i%8)) printf("\n          ");
	}
	if(i) printf("\n");
	for(k=0;k<4;k++){
		j = 0;
		dev=seekque.s_p_d[k].s_first;
		while ( dev){
			if(!j++)
				printf("seek queue disk(%x):",k);
			printf(" %x ",dev);
	        	devq_buf[((int)dev - dev_low)/0x30].flag++;
			dev=dev->q_next;
			if(!(j%8)) printf("\n                   ");
		}
		if(j) printf("\n");
	}
	dev=tapeque.t_first;
	m = 0;
	while ( dev && ((dev_low >=(free_buf))||dev->q_cmd==3)){
		if(!m++)
			printf("tape queue:");
		printf(" %x ",dev);
	        devq_buf[((int)dev - dev_low)/0x30].flag++;/*mark busy */
		dev=dev->q_next;
		if(!(m%8)) printf("\n           ");
	}
	if(m) printf("\n");
	dev=bddesc.reqfst;
	n = 0;
	while ( dev && (dev_low <(free_buf))){
		if(!n++)
			printf("request queue:");
		printf(" %x ",dev);
	        devq_buf[((int)dev - dev_low)/0x30].flag++;/*mark busy */
		dev=dev->q_next;
		if(!(n%9)) printf("\n              ");
	}
	if((n)) printf("\n");
	dev=bddesc.rsfst;
	o = 0;
	while ( dev && (dev_low <(free_buf))){
		if(!o++)
			printf("response queue:");
		printf(" %x ",dev);
	        devq_buf[((int)dev - dev_low)/0x30].flag++;/*mark busy */
		dev=dev->q_next;
		if(!(o%9)) printf("\n              ");
	}

}

/*    ?:  find the shared structures and exanmine the state of the 	*/
/*	 ones not on the queue( not available )				*/
static int this_one=0; 	/* saves array initialization */
static count_only=0;	/* default is full display */
static char k=0;
local()
{
	int i;

	if(!count_only)	k=0;	/* may have had a prev. request */
	if(this_one!=1){
		for(i=0;i< free_count;i++)
			devq_buf[i].devp=(struct devq *)(free_buf+(i*0x30));
		this_one=1;
	}	
	check_que(free_buf,free_count,count_only);
return(0);
}
dual ()
{
	int i;

	if(!count_only)	k=0;	/* may have had a prev. request */
	if(this_one!=2){
		for(i=0;i<dual_count;i++)
			devq_buf[i].devp=(struct devq *)(dual_buf+(i*0x30));
		this_one=2;
	}
	check_que(dual_buf,dual_count,count_only);
return(0);
}

queues()
{
	k=0;				/* may have had a prev. request */
	count_only++;
	check_que(free_buf,free_count,count_only);
	check_que(dual_buf,dual_count,count_only);
	count_only=0;
	k=0;
	
return(0);
}
check_que (dev_low,count,count_only)
register int count;
register int dev_low;
int count_only;
{
	register struct devq *dev,*dev1;
	register i;
	register j=0;

	
	for(i=0;i<count;i++)
		 devq_buf[i].flag=0;
	if(count== dual_count){
		k++;
		printf("*******  DUAL PORTED MEMORY   ");
		dev1=bddesc.freefst;
	}
	else{
		k++;
		printf("*******  LOCAL MEMORY BUFFERS ");
		dev1=ipque.i_p_dqfirst;
	}
	for(dev=dev1,i=0;dev!=0;dev=dev->q_next){
		if(((int)dev < dev_low)|| ((int)dev > ((count*0x30)+dev_low)) ||
			 ((int)dev - dev_low)%0x30){
		    printf("\t**ERROR ILLEGAL BUFFER ON LIST DEV= %x POS= %x\n",		     dev,i);
	/*	    return;  should not happen */
		}
	        devq_buf[((int)dev - dev_low)/0x30].flag++;
		i++;
	}
	if(i==count){
		k++;
		printf(":all (%x) structures on free list  *******\n",count);
		return;
	}
	else
	    if(count_only){
		k++;
		printf(":    (%x) structures on free list    ***** \n",i);
		check(dev_low);
	    }
	    else{
		k++;
		printf(": (%x) structures unaccounted for   ***** \n",count-i);	
	    }

	for(i=0;i<count;i++)
		if(devq_buf[i].flag==0){
			if(count_only&&devq_buf[i].devp && !(j))
				printf("missing:\n");
			if(devq_buf[i].devp){/* sanity check */
				j++; k+=6;
		    		printf(" DEV = %x Key = %x ",devq_buf[i].devp,
			  	 devq_buf[i].devp->q_key);
		    		if(devq_data(devq_buf[i].devp)) 
					printf("DEVQ_DATA RETURNED 1 ");
		    		if((!(j%3) && j)||k>22){
		    		char c;
			    	k=0;
			    	printf("! <cr> to continue: q to quit \n");
			    	if((c=getchar())== 'q')
					return;
		    		}
				else printf("\n");
		        }
		}
}

/*	P or F at monitor will dump the request structure */
/*	P -> examins dual ported request structures	  */
/*	F -> examins local private request structures	  */
/*	Z -> examines not only the available queues, but  */
/*		also the tape, seek, interim processing   */
/*		and dtb queues				  */

devq_data (dev)
struct devq  *dev;
{	register char *cptr;
	register struct devq *devp,*last,*hold;
	register i,j;

	if(dev==0)
		return(1);
	printf("next buffer = %x",dev->q_next);
	if(dev->q_next)
		printf(" nkey = %x",dev->q_next->q_key);
	printf("\n  req dev type = ");
	switch (dev->q_devtype) {

		case 0:
			printf("zero (0)\n");
			break;
		case 1:
   	    		printf("disk(1):");
			printf(" device = %x slice %x cmd = ",
			   dev->q_devnum,dev->q_priority);
			if(dev->q_cmd == 1)
				printf("read");
			else if(dev->q_cmd==2)
				printf("2 write");
			else printf("unknown  cmd (%x)",dev->q_cmd);
			printf(" byte cnt = 0x%x\n",dev->q_count);
			break;
		case  2:
			printf("tape(2): ");
			if(dev->q_cmd == 1)
				printf("1 read");
			else if(dev->q_cmd==2)
				printf("2 write");
			else if(dev->q_cmd==3)
				printf("3 rew");
			else ("printf cmd == %x",dev->q_cmd);
			printf(" byte cnt = 0x%x\n",dev->q_count);
			break;
		defaultf: 
			printf(" reserved area request \n");
	}
	printf("  the bp = 0x%x the mmutable = %x flags = 0x%x \n",
		dev->q_key,dev->q_mmu,dev->q_flag);
	printf("  the error rc1 0x%x rc2 0x%x  retries 0x%x\n",	
			dev->rc1,dev->rc2,dev->retry);
	printf("  sect cnt = 0x%x sect done = 0x%x sect left = 0x%x\n",
		dev->scnt,dev->totsdone,dev->totsleft);
	printf("  the local memory address = 0x%x opr = 0x%x \n",
		dev->local_mem,dev->opr);
	
}
