
#include "hsdtdisksect.h"
#include "hsdt.h"
#include "hsdtdevstr.h"
#include "devcmd.h"
#include "hsdtdevdq.h"
#include "hsdtdtc.h"
#include "hsdttape.h"
#include "hsdterror.h"
#include "hsdtextrn.h"
#include "vreg.h"
#include "data_struct.h"
#include "hsdtccpu.h"
#include "hsdtstruct.h"

extern int que_cnt;
extern unsigned char new_code;
extern unsigned short c_retry[];
extern *pskip();
/* interrupts are disabled
   check for any rw error, put the request back on the response que and
   interrupt the master
   check for any pending tape transfer and start the dtb xfer.
   check for any fast tape that may be waiting for the dtb
   check for any more requests on same drive, if there are any, check 
   to see if they are on the same cyl, and start rw, if they are not on 
   the same cyl, give some other drive a chance
   if another drive has a request on the same cyl, start the rw, if it is 
   not on the same cyl, start the seek
*/
finrw()
{
	register struct devq *dev, *nextdq;
	register struct dkinf *dkptr;
	register char drive; register i;
	register sendqback;
	register seekon; register unsigned short sectdone;
	struct seek_que *sptr;
	register struct seek_per_disk *skptr;

	dev = dtbque.d_first;

	/* check rw error and set error code */
	drive = dev->q_devnum;
	dkptr = drive_pointer_array[drive];

	sectdone = checkrw (dev);

	/* *********************** */
	/* determine how many left */
	/* *********************** */

	dev->totsleft -= sectdone;

	sendqback = 0;

	if ( dev->rc1 == DER_ALT ) {
		/* ****************************** */
		/* hit a sector with an alternate id field */
		/* ****************************** */


		 if ( (dev->q_flag & NOALT) == 0 ) {
			/* ********************************* */
			/* reprogram the c,h,s = sector id field */
			/* ********************************* */
			if ( reprg (dev, dkptr, sectdone) )
				sendqback = 1;		/* can't reprg c,h,s */
		}
		else 
			/* ********************************* */
			/* no need to reprogram, just return */
			/* ********************************* */
			sendqback = 1;
	}
	/* **************** RETRY IN LOCAL MEMORY  ******************** */
	else if  (dev->rc1 == DER_OVR)
		over_run(dev);

	/* ********************* RETRY **************************** */
	else if(dev->rc1 == DER_CRC) {
		dev->q_flag |= RETRY_CRC;

		/* **************************************** */
		/* need to retry on data crc & data overrun */
		/* finer test for CRC offset k.c.	    */
		/* **************************************** */
		if((dev->q_flag & NO_RETRY) || (++dev->retry >= RETRY) ||
		    (!new_code && (c_retry[dev->q_extdtb + 1]&0xf) 
		    && (dev->retry >2)) || dev->q_extdtb>=CRC_RETRY){
			 /* offset heads on new micro code only */
				present_timing = -1;
				sendqback = 1;		/* no retry */
		}

		/* **************************************** */
		/* retry, later will put que back on dkptr  */
		/* restore sectdone back into dev->totsleft */
		/* redo the track again                     */
		/* **************************************** */
		else {
			if(dev->retry == RETRY-1){
				dev->retry = 0;
				dev->q_extdtb++;
			}
 			else {
 				seekque.seek_active |=(UPPERBIT(dev->q_devnum));
 				dev->rc1 = 0;
 				dev->totsleft = dev->scnt;
 				dev->sectleft = dev->scnt;
 				dev->totsdone = 0;
 				return;
 			}
			printf ("RETRY_CRC");
			dev->rc1 = 0;
			dev->totsleft = dev->scnt;
			dev->sectleft = dev->scnt;
			dev->totsdone = 0;
		}
	}

	else if ( dev->rc1 == DER_RDYCHG ) {
		/* **************************** */
		/* reseek on ready change error */
		/* **************************** */
		if ( dev->q_flag & NO_RETRY )
			sendqback = 1;
		else if (dkrezero(dev->q_devnum,&seekque.s_p_d[dev->q_devnum])||
			  dev->retry++>RETRY) 
			/* rezero has a problem */
			sendqback = 1;

		/* **************************************** */
		/* retry, later we will put the que back   */
		/* restore sectdone back into dev->totsleft */
		/* **************************************** */
		else {
			dev->rc1 = 0;
			dev->totsleft = dev->scnt;
			dev->sectleft = dev->scnt;
			dev->totsdone = 0;
		}
	}
	
	/* ******************************************** */
	/* did not hit sector with alt id, did not just */
	/* finish rw alt sector, no hard disk error   */
	/* might get more to do on the next track       */
	/* ******************************************** */
	else 
		sendqback = 1;



	/* either send req back to master cpu, or put back on the que */

	if ( sendqback ) {
		dev->q_count = dev->totsdone << BLKSIZBIT;
		if(dev->q_flag & FREE_REQ){
			if(dev->q_flag & LOC_TO_DK){
			    if(ipque.freemem_first)
				ipque.freemem_last->fm_next=dev->local_mem;
			    else
				ipque.freemem_first = dev->local_mem;
			    ipque.freemem_last = dev->local_mem;
			    dev->local_mem->fm_next = (struct free_mem *)0;
			}
		
			if(*(short *)&dev->rc1){
				clean_up_que(dev,1);
				*(short *)&ipque.i_p_first->rc1 =
				    *(short *)&dev->rc1;
				ipque.i_p_count += dev->q_count;/* actual sect*/
				if(dev->q_flag&RETRY_CRC){
					if((dev->q_extdtb >= 2)&&(new_code))
 					 /* offset was used,(clear it) */
						clear_crc(dev);
					skptr = &(seekque.s_p_d[dev->q_devnum]);
		    			if(skptr->s_first)
						clean(skptr,dev);
					dev->q_flag &= ~RETRY_CRC;
				}
				return;
			}
			else if(dev->q_flag & DK_TO_LOC){
			    dev->q_flag &= ~DK_TO_LOC;
			    dev->q_flag |= LOC_TO_MAIN;
			    return;
			}
			ipque.i_p_count += dev->q_count;
		}
		else{
			if((dev->q_flag&LOC_TO_DK) && !(dev->q_flag&OVR_ERROR)){
			    if(ipque.freemem_first)
				ipque.freemem_last->fm_next=dev->local_mem;
			    else
				ipque.freemem_first = dev->local_mem;
			    ipque.freemem_last = dev->local_mem;

			    dev->local_mem->fm_next = (struct free_mem *)0;
			}
			else if(dev->q_flag & DK_TO_LOC){
			    dev->q_flag &= ~DK_TO_LOC;
			    dev->q_flag |= LOC_TO_MAIN;
			    return;
			}
			else if(dev->q_flag&RETRY_CRC){
				if((dev->q_extdtb >= 2)&&(new_code))
 				 /* offset was used,(clear it) */
					clear_crc(dev);
				dev->q_flag &= ~RETRY_CRC;
			}
		}
		finreq (dev,0);
	}
	else {
		/* this has been taken off of the seek queue so we must
		take it off of the dtbque and put it back on the 
		seek queue. An overrun error will just be attempted again
		from the dtb queue.
		*/
		
		if(!(dev->q_flag & OVR_ERROR)&&(!(dev->q_flag & RETRY_CRC))){
			sptr = &seekque;
			skptr = &(sptr->s_p_d[dev->q_devnum]);
			if((dtbque.d_first = dev->q_next) == (struct devq *)0)
				dtbque.d_last = (struct devq *)0;
			else dtbque.d_first->q_prev = 0;
	
			if(skptr->s_first){
				dev->q_next = skptr->s_first;
				skptr->s_first = dev;
				dev->q_prev = 0;
			}
			else{
				skptr->s_first = dev;
				skptr->sort_ptr = dev;
				dev->q_next = 0;
				skptr->s_last = dev;
			}
			sptr->disk_seek_ptr = skptr;
			skptr->sort_count++;
		}

	}


	return;
}

reprg (dev,dkptr,sectdone)
register struct devq *dev;
register struct dkinf *dkptr;
register unsigned short sectdone;
{
	register struct alt *altptr;
	register struct devq *newdev,*next_newdev;
	register struct seek_per_disk *skptr;
	short extra_work=0; 		/* redo for OVR+ALT */

	altptr = (struct alt *)altbuf;

	/* the alt c,h,s is in altbuf */

	if ( (altptr->cyl >= dkptr->cyldisk) ||
		(altptr->head >= dkptr->headcyl) ||
		(altptr->sector >= dkptr->sechead) ||
		(altptr->cyl == (unsigned short)-1) ) {
		if ( PRINT1 )
			printf ("bad alt ");
		dev->rc1 = DER_BADALT;
		return (1);
	}

		*(short *)&dev->rc1 = 0;
	if(dev->scnt == 1){
		*(int *)&dev->q_devun.pdisk.cyl = *(int *)altbuf; 
		dev->totsleft = 1;
		dev->totsdone = 0;
		dev->sectleft = 1;
		return(0);
	}
	else{
		if((newdev = ipque.i_p_dqfirst) == (struct devq *)0){
			printf("nothing free\n");
			return(1);
		}
		ipque.i_p_dqfirst = newdev->q_next;/* tail */
		que_cnt--;
		bcopy(dev,newdev,sizeof(struct devq)); /* one sect req */
		newdev->q_next = (struct devq *) 0;

		newdev->q_flag|=FREE_REQ; /* Four K req */
    		if((dev->q_flag&DK_TO_LOC||dev->q_flag&MAIN_TO_LOC)&&
		  (sectdone)) {
			if((next_newdev = ipque.i_p_dqfirst) == 0){
				printf("nothing free\n");
				return(1);
			}
			ipque.i_p_dqfirst = next_newdev->q_next;/*tail */
			que_cnt--;
			bcopy(dev,next_newdev,sizeof(struct devq));/* cp req*/
			next_newdev->q_mmu = dev->q_mmu;
			next_newdev->q_flag|=FREE_REQ; /* Four K req */
			next_newdev->q_mem = dev->q_mem;
			next_newdev->q_next = (struct devq *) 0;
			extra_work++;

		}
		dev->q_devun.pdisk.sector += sectdone+1;
		newdev->q_count = BLKSIZE;
	

	/* reprg c,h,s compute main memory address */
		*(int *)&newdev->q_devun.pdisk.cyl = *(int *)altbuf; 
		if ( newdev->q_mmu == 0 ){
			newdev->q_mem += (sectdone << 8);
			dev->q_mem += ((sectdone+1) <<8);
		}
		else{
		/* ********************************************* */
		/* adjust page index and offset in mmu structure */
		/* ********************************************* */
			adjmmu(sectdone,((short *)&newdev->q_mmu+1),((short *)&newdev->q_mem+1));
			adjmmu(sectdone+1,((short *)&dev->q_mmu+1),((short *)&dev->q_mem+1));
		}

		newdev->scnt = 1;
		newdev->totsleft = 1;
		newdev->totsdone = 0;
		newdev->sectleft = 1;
		skptr = &(seekque.s_p_d[dev->q_devnum]);
		if(skptr->s_first)
			skptr->s_last->q_next = newdev;
		else{
			skptr->s_first = newdev;
			skptr->sort_ptr = newdev;
		}
		skptr->s_last = newdev;
		newdev->q_next = (struct devq *)0;
		if((seekque.disk_seek_ptr == (struct seek_per_disk *)0)
		    	&& (!(seekque.seek_active & BIT(dev->q_devnum)))) 
			seekque.disk_seek_ptr = skptr;
		skptr->sort_count++;
	
	}

	if(extra_work) {
		dev->totsdone = 0; /* i_p_count must not  be incremented */
		next_newdev->totsleft = sectdone;
		next_newdev->sectleft = sectdone;
		next_newdev->scnt = sectdone;
		next_newdev->q_count = sectdone<< BLKSIZBIT;
		next_newdev->totsdone = 0;
		skptr->s_last->q_next = next_newdev;
		skptr->s_last = next_newdev;
		skptr->sort_count++;
/*		seekque.seek_active |=(UPPERBIT(dev->q_devnum));*/
	}

	if((dev->scnt -= (sectdone+1)) == 0)
		return(1);
	dev->q_count = dev->scnt << BLKSIZBIT;
	dev->totsleft = dev->scnt;
	dev->sectleft = dev->scnt;
	ipque.i_p_count += dev->totsdone << BLKSIZBIT;
	dev->totsdone = 0;

	return(0);
	
}



/*****************************************/




/* *************************************************** */
/* only increment the track number by 1 if the input   */
/* cyl and head are equal to the skip track list entry */
/* *************************************************** */
addtrk1 (dev, dkptr, ldkptr)
struct devq *dev;
register struct dkinf *dkptr;
struct ld *ldkptr;
{
	register unsigned int num, cyltrk;
	register unsigned int *list, *p;
	register struct badtrck *bt;
	register unsigned short incyl, inhead;

	list = (unsigned int *)ldkptr->skplist;
	num = ldkptr->numskiptrack;

	incyl = dev->q_devun.pdisk.cyl;
	inhead = dev->q_devun.pdisk.head;
	cyltrk = ((incyl << 16) & 0xffff0000) | inhead;

	/* return a pointer to the list whose number is greater than  */
	/* the input number */
	p = (unsigned int *)pskip (cyltrk, list, num);

	/* need to backup one entry to check for equal track number */
	if ( p != list )
		p--;

	if ( (unsigned int)p >= (unsigned int)(&list[num+1]) )
		return(0);

	bt = (struct badtrck *)p;

	/* only increment track number by 1 if they match */
	while ( (incyl == bt->cyl) && (inhead == bt->head) ) {
		if ( ++inhead >= dkptr->headcyl ) {
			inhead = 0;
			if ( ++incyl >= dkptr->cyldisk ) {
				dev->rc1 = DER_SKTRK;
				return (-1);
			}
		}
		bt++;
	}

	dev->q_devun.pdisk.cyl = incyl;	dev->q_devun.pdisk.head = inhead;
	return(0);
}

adjmmu(sectdone,index,offset)
register unsigned short sectdone;
register unsigned short *index,*offset;
{
	register unsigned int offset1;


	offset1 = *offset;

	offset1 += (sectdone << BLKSIZBIT);

	if ( offset1 >= PAGESIZE ) 
		*index += (offset1 >> 12 );

	*offset = offset1 & 0x0fff;

}
/*	clean up seek queue for all request with the same key	*/

clean(skptr,dev)
register struct seek_per_disk *skptr;
register struct devq *dev;
{
	register struct devq *tmp;

	clear_que(skptr,dev->q_key);	
	if(skptr->s_first->q_key==dev->q_key) {
		 /* keep track of the next buffer */
		tmp= skptr->s_first->q_next;
		finreq(skptr->s_first,1);
		if((skptr->s_first = tmp) == (struct devq *)0)
		       skptr->s_last = (struct devq *)0;
	}
}
/* remove offset from drive after CRC error finished */
clear_crc(dev)
register struct devq *dev;
{
	register struct smdwr *wr;
	struct smdrd *rd;
	register i=0;
		wr = (struct smdwr *)DK_BUSW + dev->q_devnum;
		rd = (struct smdrd *)DK_STSR + dev->q_devnum;
		wr->control = 0;
		while(((rd->unitstus & 3) != 3)&&(i++<2000));
}
