#include "hsdtdisksect.h"
#include "hsdt.h"
#include "hsdtdevdq.h"
#include "hsdtdevstr.h"
#include "hsdtdtc.h"
#include "hsdterror.h"
#include "hsdtextrn.h"
#include "hsdtvern.h"
#include "vreg.h"
#include "data_struct.h"


/* input: secnum is logical sector num 
   output:	0 (no error)
		1 (seek error)
		2 (r/w error)
 */


rwsydata(dev, dkptr, secnum)
register struct devq *dev; 
struct dkinf *dkptr;
int secnum;
{

	if ( secnum >= SEC84_HEAD ) {
		dev->q_devun.block = secnum;
		if ( convl2p (dev, dkptr) )
			return(-1);
	}
	else {
		dev->q_devun.pdisk.cyl = 0;
		dev->q_devun.pdisk.head = 0;
		dev->q_devun.pdisk.sector = secnum;	
	}
	dev->scnt = 1;
	dev->q_mem = (char *)dev->local_mem->fm;
	*(short *)&dev->rc1 = 0;

	/* always wait for disk to complete */
	dev->q_flag |= OPEN_DISK;
	
	seekque.s_p_d[dev->q_devnum].current_cyl = -1;
	setup_and_wait(dev);

	if(dev->rc1)
		return(TIMEOUT);
	return (0);
}


/* write to sector and sector+1 */

wsydata(dev, dkptr, sectnum)
struct devq *dev; struct dkinf *dkptr;
int sectnum;
{
	register unsigned short i;
	dev->opr = OPR_WRITE;
	dev->q_flag |= LOC_TO_DK;
	for (i=0; i<2; i++) {
		if ( rwsydata(dev, dkptr, sectnum) )
			return(-1);
		sectnum++;
	}
	return(0);
}

/* read sector, if there is error, will read sector+1 */ 

rsydata(dev, dkptr, sectnum)
struct devq *dev; struct dkinf *dkptr;
int sectnum;
{
	register ret;
	dev->opr = OPR_READ;
	dev->q_flag |= DK_TO_LOC;
	if ( ret = rwsydata(dev, dkptr, sectnum) ) {
		if ( ret = rwsydata(dev, dkptr, sectnum+1) )
			return(ret);
	}
	return(0);
}

