#include "hsdtdtc.h"
#include "hsdtdisksect.h"
#include "hsdt.h"
#include "hsdtdevdq.h"
#include "hsdtdevstr.h"
#include "devcmd.h"
#include "hsdterror.h"
#include "hsdtextrn.h"
#include "vreg.h"
#include "data_struct.h"
#include "hsdtccpu.h"
#include "hsdtstruct.h"


/* the maximum number of sectors which can be handled is 85 per track */
#define WSECID_LEN		12
#define RSECID_LEN		8

/* write any sector in cyl 0, data is in main memory */
wrsysec0(dev, dkptr)
register struct devq *dev; struct dkinf *dkptr;
{
	if ( dev->q_devnum >= MAX_PDRIVE ) {
		dev->rc1 = DER_DRLIMIT;
		return(1);
	}

	if ( ((dkptr->pd_ststat & DK_TIMIN) == 0 ) || dev->q_devun.pdisk.cyl ) {
		dev->rc1 = DER_ISEC;
		return(1);
	}
	return(0);

}

setiming(dev, dkptr)
register struct devq *dev; struct dkinf *dkptr;
{
	register char *bptr;
	register struct dtb_que *dptr;

	dev->local_mem = ipque.freemem_first;
	ipque.freemem_first = ipque.freemem_first->fm_next;

	if ( dev->q_devnum >= MAX_PDRIVE ) {
		dev->rc1 = DER_DRLIMIT;
		return(1);
	}

	if ( (int)dev->q_mem & 0x03 ) {
		dev->rc1 = DER_MEM;
		return(1);
	}

	if ( dev->q_count == 0 ) {
		/* pick up specified timing register in main memory */
		dev->q_flag |= (WAIT|MAIN_TO_LOC);
		dptr = &dtbque;
		dptr->d_first = dptr->d_last = dev;
		dev->q_next = (struct devq *)0;
		dptr->dtb_active |= DISK;
		dptr->d_tick = 0;
		bptr = (char *)dev->local_mem->fm;
		if ( dtbxfer ( bptr, dev->q_mem, TIMLCNT, RD_DTB) ) {
			dev->rc1 = DER_TIMEOUT;
			return(1);
		}
	}
	else {
		dev->rc1 = DER_CNT;
		return(1);
	}

	setimid ( bptr );
	present_timing = 0;

	/* save the timing register in physical drive structure */
	bcopy ( bptr, dkptr->timing, sizeof iddata);

	dkptr->pd_ststat |= DK_TIMIN;
	ipque.freemem_last->fm_next = dev->local_mem;
	ipque.freemem_last = dev->local_mem;
	dev->local_mem->fm_next = (struct free_mem *)0;

	return(1);

}

/* ************************************************** */
/* format any number of sectors on a single track, the */
/* ID data for each sector is in main memory          */ 
/* read ID into main memory                           */
/* ************************************************** */
rwsecid(dev, dkptr)
register struct devq *dev; struct dkinf *dkptr;
{
	register i, length;

	if ( dev->q_devnum >= MAX_PDRIVE ) {
		dev->rc1 = DER_DRLIMIT;
		return(1);
	}

	if ( (int)dev->q_mem & 0x03 ) {
		dev->rc1 = DER_MEM;
		return(1);
	}

	/* insure timing parameters are set, and num of sector */
	/* per track is valid */
	if ( (dkptr->pd_ststat & (DK_TIMIN|DK_INIT) )== 0) {
		dev->rc1 = DER_SYERR;
		return(1);
	}

	dev->scnt = dev->q_count;	/* number of sectors to format */
#ifndef S90
	dev->q_mem = (char *)((int)dev->q_mem >> 2);
#endif

	if ( dev->opr == OPR_WRID ) 
		length = WSECID_LEN;
	else
		length = RSECID_LEN;
	for (i=0; i<2; i++) {
		/* also include the seek and write id from main memory */
		rwid (dev,dkptr,dev->scnt*length,0);
		if((*(short *)&dev->rc1) == 0)
			break;
	}

	/* return the number of sectors processed */
	dev->q_count = dev->totsdone;
	return(1);
}


/* unspare a sector and update Sector 2 spare sector list */
/* can't use this to unspare the first cylinder */

unspare(dev, dkptr)
register struct devq *dev; struct dkinf *dkptr;
{
	register struct sprs *p;
	register struct spare_list *s;
	register secnum, sparenum, ret;
	register unsigned  index, offsetsecnum, i;
	struct alt orgsec; register struct  alt *secptr;
	struct free_mem *free_ptr;

	secptr = &orgsec;

	/* open drive, check input c,hs, and formattype = 0 */
	ckprgalt (dev, dkptr);
	if ( dev->rc1 )
		return(1);

	/* can't unspare sectors in cyl 0 */
	if (  dev->q_devun.pdisk.cyl == 0 ) {
		dev->rc1 = DER_ISEC;
		return(1);
	}

	/* save the input c,h,s */
	*(int *)&secptr->cyl = *(int *)&dev->q_devun.pdisk.cyl;

	/* read spare sector list */
	free_ptr = ipque.freemem_first;
	s = (struct spare_list *)free_ptr->fm;
	ipque.freemem_first = ipque.freemem_first->fm_next;
	dev->local_mem = free_ptr;

	if ( (index = dev->q_count) != (unsigned int)-1 ) {

		offsetsecnum = (index / (unsigned int)SPARELSTSIZ) + 1;
		index = index % (unsigned int)SPARELSTSIZ;

		secnum = SPARESEC;
	
		while ( offsetsecnum--) {
			if ( secnum == 0 ) {
				dev->rc1 = DER_SYERR;
				return(1);
			}

			/* wait for operation to be completed */
			if ( readsysect(dev, dkptr, secnum)  )
				return(1);
			sparenum = secnum;
			secnum = s->nextsec;
		}


		/* check the bad c,h,s pointed by the index match input c,h,s */
		p = &s->sparesect[index];
	
		if ( (*(int *)&p->cyl) != (*(int *)&secptr->cyl) ) {
			dev->rc1 = DER_SYERR;
			return(1);
		}

	}



	/* write ID to that sector, c,h,s */
	*(int *)&dev->q_devun.pdisk.cyl = *(int *)&secptr->cyl;
	dev->scnt = 1;

	/* format sector ID field */
	if ( wridsec (dev, dkptr) ) {
		dev->q_devun.pdisk.cyl = -1;
		return(1);		/* can't write id to sector */
	}

	/* write data to that sector */
	dev->scnt = 1;

/*
	dev->local_mem = ipque.freemem_first;
	ipque.freemem_first = ipque.freemem_first->fm_next;
	dev->q_mem = (char *) dev->local_mem->fm;
	setbuf (dev->q_mem, BLKSIZE/4, FORMDATA );
	dev->q_flag |= DK_TO_LOC;
*/



	/* don't touch spare sector list */
	if ( index == (unsigned int)-1 )
		return(1);

	/* also update spare list sector */
	/* the alternate sector is available again for sparing */
	*(int *)&p->cyl = -1;
	s->usedspare--;

	/* write to sparenum and sparenum+1 */
	if ( wsydata(dev, dkptr, sparenum) ) {
		printf ("d7");
		return(1);
	}
	
	free_ptr->fm_next = dev->local_mem;
	ipque.freemem_last->fm_next = free_ptr;
	ipque.freemem_last = free_ptr;
	dev->local_mem->fm_next = (struct free_mem *)0;

	return(1);
}

/* ********************************* */
/* seek to specified cylinder number */
/* wait for seek to completed */
/* ********************************* */
seekio (dev, dkptr)
register struct devq *dev;
register struct dkinf *dkptr;
{

	/* wait for operation to be completed */
	dev->q_flag |=  WAIT;

	setup_and_wait(dev);

	return(1);
}

/*
	Read the media defect list off a single track into main memory.
	If the list cannot be read, return error code DER_TIMEOUT
 */

medeftrk (dev, dkptr)
register struct devq *dev;
register struct dkinf *dkptr;
{
	register struct seek_per_disk *skptr;
	register i; 
	register unsigned short oldpri;

	skptr = &seekque.s_p_d[dev->q_devnum];

	if ( dev->q_devnum >= MAX_PDRIVE ) {
		dev->rc1 = DER_DRLIMIT;
		return(1);
	}

	/* insure timing parameters are set */
	if ( (dkptr->pd_ststat & DK_TIMIN) == 0) {
		dev->rc1 = DER_SYERR;
		return(1);
	}

#ifndef S90
	dev->q_mem = (char *)((int)dev->q_mem >> 2);
#endif

	for (i=0; i<2; i++) {
		/* also includes the seek and write id from main memory */
		rwid (dev, dkptr, DEFM_LEN,0);
		if((*(short *)&dev->rc1) == 0)
			break;

		/* *************************** */
		/* timeout or error, try again */
		/* *************************** */
		oldpri = spl6();
		dkrezero ( dev->q_devnum, skptr);
		splx(oldpri);
	}
	return(1);
}


/*
	transfer data between main memory and local memory
	insure disk and tape are both not using the DTB interface
 */
dtbxfer ( locmem, mainmem, lwordcnt, direction)
{
	register j;
	register unsigned char *bufptr;


	/* *********** */
	/* DTB is free */
	/* *********** */

	bufptr = dtbbuf;

	/* setup 8 byte parameters in buf:buf[2],buf[3] = long word count
	   buf[4]-buf[7] = main memory address >>2 */

	*(short *)(bufptr+2) = lwordcnt;	/* long word cnt */
#ifndef S90
	*(int *)(bufptr+4) = mainmem >> 2;
#else
	/*load css slot */
	*(bufptr+1) = (char)(((int)mainmem&0xf0000000)>>24);
	/* load main memory address */
	*(int *)(bufptr+4)=(((int)(mainmem)&0xfffffff) << 4);
#endif

	if ( xferdata ( bufptr, locmem, direction, DTBWAIT ) ) {
		return (1);		/* trouble transferring data */
	}
	return (0);
}

newstat(dev,dkptr)
struct devq *dev;
struct dkinf *dkptr;
{

	struct smdrd *rd;

	rd = (struct smdrd *)DK_STSR + dev->q_devnum;
	dev->q_count = rd->accsts & 0x3f;

	return(1);
}
