#include "hsdtdtc.h"
#include "hsdtdisksect.h"
#include "hsdt.h"
#include "hsdtdevdq.h"
#include "hsdtdevstr.h"
#include "devcmd.h"
#include "hsdterror.h"
#include "hsdtextrn.h"
#include "vreg.h"
#include "data_struct.h"


swapdev (dev, dkptr)
register struct devq *dev; register struct dkinf *dkptr;
{
	register struct ld *ldkptr; register unsigned char i;

	/* wait for operation to be completed */

	dev->q_count = -1;
	/* if need to read sector 0, will always wait for it */
	if ( ckopdrive (dev, dkptr) ) 
		return(1);


	ldkptr = dkptr->pd_ptr;		/* point to log table */
	for (i=0;  i<dkptr->pd_ldnum; i++) {
		if ( ldkptr->ld_type == LD_SWAP ) {
			dev->q_count = i;
			dev->q_mem = (char *)ldkptr->ld_size;
			return(1);
		}
		ldkptr++;
	}
	return(1);			/* can't find any swap device */
}


nextrvsec (dev, dkptr)
register struct devq *dev; struct dkinf *dkptr;
{
	register struct sector0 *bptr;
	register blockno;
	register struct free_mem *fm_ptr;


	fm_ptr = ipque.freemem_first;
	bptr = (struct sector0 *) fm_ptr->fm;
	dev->local_mem = fm_ptr;
	ipque.freemem_first = fm_ptr->fm_next;
	if ( readsysect (dev, dkptr, SEC0) ) {
		dev->q_devun.block = -1;
		/* hard disk error, rc1 should be set */
		return(1);
	}

	/* get the next avialable sector , update to next one,
		and write back to sector 0 */

	blockno = bptr->nextsec;
	bptr->nextsec += 2;

	if ( wsydata (dev, dkptr, SEC0) ) {
		dev->q_devun.block = -1;
		/* hard disk error, rc1 should be set */
		return(1);			/* can't write to sect 0 */

	}
	dev->q_devun.block = blockno;
	ipque.freemem_last->fm_next = fm_ptr;
	ipque.freemem_last = fm_ptr;
	fm_ptr->fm_next = (struct free_mem *)0;
	return(1);
}


hwspare(dev, dkptr)
register struct devq *dev; register struct dkinf *dkptr;
{
	struct sprs spbuf; register struct sprs *sprptr;

	/* open drive, check input c,hs, and formattype = 0 */
	ckprgalt (dev, dkptr);
	if ( dev->rc1 )
		return(1);

	sprptr = &spbuf;
	*(int *)&sprptr->cyl = *(int *)&dev->q_devun.pdisk.cyl;


	*(int *)&sprptr->altcyl = -1;

	if ( prgalt (dev, dkptr, sprptr) ) {
		dev->q_devun.pdisk.cyl = -1;
		/* hard disk error, rc1 should be set */
		return(1);
	}
	return(1);

}
ckprgalt(dev, dkptr)
register struct devq *dev;
register struct dkinf *dkptr;
{
	if ( ckopdrive (dev, dkptr) )
		return(1);

	/* insure the input c,h,s is within range (sector 0) */
	if ( ckchs (dev, dkptr) )
		return(1);

	if ( dkptr->formattype ) {
		dev->rc1 = DER_SYERR;
		return(1);
	}
	return(1);
}

phspare(dev, dkptr)
register struct devq *dev; struct dkinf *dkptr;
{
	struct sprs spbuf; register struct sprs *sprptr, *p;
	register struct spare_list *s;
	register index, offsetsecnum, secnum, orgsec;
	struct free_mem *fm_ptr;

	/* open drive, check input c,hs, and formattype = 0 */
	ckprgalt (dev, dkptr);
	if ( dev->rc1 )
		return(1);


	/* get spare information */
	sprptr = &spbuf;
	*(int *)&sprptr->cyl = *(int *)&dev->q_devun.pdisk.cyl;

	*(int *)&sprptr->altcyl = *(int *)&dev->q_mem;

	/* ************************************************* */
	/* able to handle multiple spare sectors (link list) */
	/* ************************************************* */

	index = dev->q_count;
	offsetsecnum = (index / (unsigned short)SPARELSTSIZ) + 1;
	index = index % (unsigned short)SPARELSTSIZ;

	secnum = SPARESEC;
	fm_ptr = ipque.freemem_first;
	s = (struct spare_list *) fm_ptr->fm;
	dev->local_mem = fm_ptr;
	ipque.freemem_first = fm_ptr->fm_next;
	
	while ( offsetsecnum--) {
		if ( secnum == 0 ) {
			dev->rc1 = DER_SYERR;
			return(1);
		}

		/* wait for operation to be completed */
		if ( readsysect(dev, dkptr, secnum)  )
			return(1);
		orgsec = secnum;
		secnum = s->nextsec;
	}


	dev->q_flag &= ~DK_TO_LOC;
	/* check the alt sector pointed by the index match the input */
	p = &s->sparesect[index];

	if ( (*(int *)&p->altcyl) != (*(int *)&sprptr->altcyl)  ) {
		dev->rc1 = DER_SYERR;
		return(1);
	}


	if ( prgalt (dev, dkptr, sprptr) ) {
		dev->q_devun.pdisk.cyl = -1;
		return(1);
	}
	dev->q_flag &= ~(LOC_TO_DK|RWID);
	dev->local_mem = fm_ptr;

	/* also update spare table */
	*(int *)&p->cyl = *(int *)&sprptr->cyl;
	s->usedspare++;

	if ( wsydata(dev, dkptr, orgsec) ) {
		printf ("d6");
		return(1);
	}

	/* restore input num */
	*(int *)&dev->q_devun.pdisk.cyl = *(int *)&sprptr->cyl;
	*(int *)&dev->q_mem = *(int *)&sprptr->altcyl;

	ipque.freemem_last->fm_next = fm_ptr;
	ipque.freemem_last = fm_ptr;
	fm_ptr->fm_next = (struct free_mem *)0;

	return(1);

}

/* return -1 if can't read system sector */
/* return 0 if ok */
/* sectnum is logical sector num */
readsysect (dev, dkptr, sectnum)
register struct devq *dev; struct dkinf *dkptr;
int sectnum;
{
	/* insure sector 0 in read in */
	if ( ckopdrive (dev, dkptr) ) 
		return(1);			/* hard disk error */

	/* wait for operation to be completed */
	dev->q_flag |= WAIT;
	
	rsydata (dev, dkptr, sectnum);

	return(0);
}


