#include "hsdtdisksect.h"
#include "hsdt.h"
#include "hsdtdevdq.h"
#include "hsdtdevstr.h"
#include "hsdtdtc.h"
#include "hsdterror.h"
#include "hsdtextrn.h"
#include "vreg.h"
#include "data_struct.h"


diskopen(dev, dkptr)
struct devq *dev; register struct dkinf *dkptr;
{
	register ret;
	register unsigned int i;
	register struct sector0 *sec0;
	register struct ld *ldkptr;
	register struct logtype *p;
	int temp;
	struct free_mem *dq;
	char timeval[32];


	/* check to see if the physical drive is already open */

	if ( dkptr->pd_ststat & DK_INIT )
		return (0);

	sec0 = (struct sector0 *) ipque.freemem_first->fm;
	dq = ipque.freemem_first;
	dev->local_mem = dq;
	ipque.freemem_first = ipque.freemem_first->fm_next;

	/* pointer to logical table for this physical drive */
	ldkptr = &log[(short)(dev->q_devnum<<4)];

	/* always wait if read system sector */
	dev->q_flag |= OPEN_DISK;

	if ( PRINT1 )
		printf ("rD=%x", dev->q_devnum);

	/* ********************************************************* */
	/* save original timing value from physical structure if any */
	/* ********************************************************* */
	bcopy ( dkptr->timing, timeval, sizeof iddata );

	for (i=0; i<TIM_SET; i++) {

		/* ********************************************************* */
		/* program the hardware and store them in physical structure */
		/* ********************************************************* */
		setimid ( timingval[i] );
		bcopy ( timingval[i], dkptr->timing, sizeof iddata );
		present_timing = 0;
		temp = i;

		if ( (ret = rsydata (dev, dkptr, SEC0)) != TIMEOUT )
			break;

		/* used the wrong timing register, try another one */
		printf("d2"); 
	}
	
	/* restore the original timing register in physical drive structure */
	bcopy ( timeval, dkptr->timing, sizeof iddata );
 
	/* ********************************************* */
	/* the default timing value failed, check to see if */
	/* there is a timing register set by the master cpu */
	/* ********************************************* */
	if ( ret == TIMEOUT ) {
		if ( dkptr->pd_ststat & DK_TIMIN ) {
			setimid (dkptr->timing);
			present_timing = 0;
			ret = rsydata(dev,dkptr,SEC0);
		}
	}

	if ( ret ) {
		printf ("d4(%x)\n", dev->rc1);
		ipque.freemem_last->fm_next = dq;
		ipque.freemem_last = dq;
		dq->fm_next = (struct free_mem *)0;
		return(-1);
	}


	/* at least we are able to read a sector */
	dkptr->pd_ststat |= DK_READY;

	/* check ID name and max number of logical drives allowed */
	if ( (*((int *)&sec0->id[0]) != (int)'INIT') ||
		(sec0->pd_ldmaxnum > LOGDR) ||
		(sec0->pd_ldnum > LOGDR) ) {
		dev->rc1 = DER_UNFORM;
		ipque.freemem_last->fm_next = dq;
		ipque.freemem_last = dq;
		dq->fm_next = (struct free_mem *)0;
		return(-1);
	}

	dkptr->formattype = sec0->id[7];

	*(int *)&dkptr->cyldisk = *(int *)&sec0->cyldisk;
	*(int *)&dkptr->seccyl = *(int *)&sec0->seccyl;

	bcopy ( sec0->gap, dkptr->timing, sizeof  iddata);

	/* reprg timing register */
	setimid ( &dkptr->timing[0] );

	if(dkptr->timing[1] != timingval[i][1]){
		for(i=0;i<TIM_SET;i++){
			if(dkptr->timing[1] == timingval[i][1]){
				temp = i;
				break;
			}
		}
	}

	dkptr->pd_ldmaxnum = sec0->pd_ldmaxnum;
	dkptr->pd_ldnum = sec0->pd_ldnum;

	/* reserved size and skip track list */
	dkptr->rv_strt = sec0->rv_strt;
	dkptr->rv_size = sec0->rv_size;
	dkptr->numskiptrack = 0;
	dkptr->skplist = 0;


	if ( dkptr->pd_ldnum == 0 ) {
		/* no need to read setup logical drive table */
		printf ("d5");
		/* sector 0 read and got timing register from sector 0 */
		dkptr->pd_ststat |= DK_INIT|DK_TIMIN;
		dkptr->pd_ststat |= BIT(temp);
		ipque.freemem_last->fm_next = dq;
		ipque.freemem_last = dq;
		dq->fm_next = (struct free_mem *)0;
		return(0);
	}
	
	/* setup log drive table */
	dkptr->pd_ptr = ldkptr;
	p = &sec0->logdrive[0];

	for (i=0; i< dkptr->pd_ldnum; i++) {
		ldkptr->ld_strt = p->ld_strt;
		ldkptr->ld_size = p->ld_size;
		ldkptr->ld_type = p->ld_type;
		ldkptr->ld_mirror = p->ld_mirror; 
		ldkptr->mirtype = p->mirtype;
		ldkptr->ld_bdsnum = 0;

		ldkptr++;
		p++;
	}

	/* read skip track list */
	if ( fillskiptrk ( dev, dkptr, sec0 ) ) {
		/* ******************************************* */
		/* only erase table for current physical drive */
		/* ******************************************* */
		closephy ( dev->q_devnum, dkptr);
		printf ("d1");
		ipque.freemem_last->fm_next = dq;
		ipque.freemem_last = dq;
		dq->fm_next = (struct free_mem *)0;
		return (-1);
	}

	/* sector 0 read and got timing register from sector 0 */
	dkptr->pd_ststat |= DK_INIT|DK_TIMIN;
	dkptr->pd_ststat |= BIT(temp);
	present_timing = 0;
	ipque.freemem_last->fm_next = dq;
	ipque.freemem_last = dq;
	dq->fm_next = (struct free_mem *)0;
	return(0);
}

fillskiptrk (dev, dkptr, skpsec)
struct devq *dev;
register struct dkinf *dkptr;
struct sktrk_list *skpsec;
{
	register unsigned char i; register unsigned short cursknum;
	register struct ld *ldkptr;
	register struct badtrck *sk;
	register sklist_num; register struct badtrck *sklist_ptr;

	/* first drive to open, init skip trk list pointer */
	if ( skplist_ptr == 0 )
		skplist_ptr = sklist;

	ldkptr = dkptr->pd_ptr;

	/* pointer and count for current HSDT card */
	sklist_ptr = skplist_ptr;
	sklist_num = skplist_num;

	if ( rsydata(dev, dkptr, SKTRKSEC) )
		return(-1);

	/* insure id field is valid */
	if ( skpsec->idfield != SKIPSECID ) {
		dev->rc1 = DER_SYBAD;
		return(-1);
	}

	/* pointer to first list in skip track sector */
	/* skip track number in current sector */
	cursknum = 0;  sk = (struct  badtrck *)skpsec;

	/* *********************************************************** */
	/* total 4 drives can have maximum 0x3f0 (1008)skip track list */
	/* *********************************************************** */

	/* fill skip track table for all logical drives and reserved area */
	/* for (i=0; i<dkptr->pd_ldnum; i++) { */
	for (i=0; i<(dkptr->pd_ldmaxnum+1); i++) {

		/* get skip track for reserved area */
		if ( i == dkptr->pd_ldmaxnum ) {
			dkptr->numskiptrack = 0;
			dkptr->skplist = sklist_ptr;
		}
		else {
			ldkptr->numskiptrack = 0;	/* log drive */
			ldkptr->skplist = sklist_ptr;
		}

		while ( sk->cyl || sk->head ) {

			/* insure that the skip trk list does not run out */
			if ( sklist_num == MAXSKNUM ) {
				dev->rc1 = DER_SKFULL;
				return (-1);
			}

			sklist_ptr->cyl = sk->cyl;
			sklist_ptr->head = sk->head;

			sklist_ptr++;		/* inc skip trk list pointer */
			sklist_num++;		/* inc count */

			if ( i == dkptr->pd_ldmaxnum ) 
				dkptr->numskiptrack++;
			else
				ldkptr->numskiptrack++;

			/* ************************************************** */
			/* if we have run out of data in this sector,read     */
			/* next sector                                        */
			/* ************************************************** */
			sk++; cursknum++;
			if ( cursknum == SKTRKSIZ ) {
				/* ran out of list in current sector for */
				/* current log drive, read next sector for */
				/* more list */
				if(rsydata(dev,dkptr,skpsec->nextsec))
					return(-1);
				if ( skpsec->idfield != SKIPSECID ) {
					dev->rc1 = DER_SYBAD;
					return(-1);
				}
				cursknum = 0;  sk = (struct  badtrck *)skpsec;
			}
		}

		sk++; cursknum++;
		if ( cursknum == SKTRKSIZ ) {
			/* ran out of list in current sector for */
			/* next log drive, read next sector for */
			/* more list */
			if(rsydata(dev,dkptr,skpsec->nextsec))
				return(-1);
			if ( skpsec->idfield != SKIPSECID ) {
				dev->rc1 = DER_SYBAD;
				return(-1);
			}
			cursknum = 0;  sk = (struct  badtrck *)skpsec;
		}

		if ( i == dkptr->pd_ldmaxnum ) { 
			if ( dkptr->numskiptrack == 0 )
				dkptr->skplist = 0;
		}
		else {
			if ( ldkptr->numskiptrack == 0 )
				ldkptr->skplist = 0;
		}

		ldkptr++;
	}


	/* update pointer and count for current HSDT card */
	skplist_ptr = sklist_ptr;
	skplist_num = sklist_num;

	return(0);
}

closephy (drive, dkptr)
register unsigned char drive;
register struct dkinf *dkptr;
{
	register struct ld *ldkptr;
	register struct dev_desc *devptr;

	devptr = devdesc;
	if(!(devptr->dd_type & DTDISK)) devptr++;
	devptr->dd_count--;

	setbuf ( dkptr, sizeof (struct dkinf) >> 2, 0);

	seekque.s_p_d[drive].current_cyl = -1;

	ldkptr = &log[(short)(drive * LOGDR)];
	setbuf ( ldkptr, ((sizeof(struct ld)) * LOGDR) >> 2, 0);
}
