#include "hsdtccpu.h"
#include "hsdtdisksect.h"
#include "hsdt.h"
#include "hsdtdevdq.h"
#include "hsdtdevstr.h"
#include "hsdtdtc.h"
#include "hsdtextrn.h"
#include "vreg.h"
#include "data_struct.h"

#define STARTCYL	1


/*
	seek cylinder in a loop
	KL  <drive number>
	K <drive number > <cyl>
 */

/* *****************************************
seek(bufptr)
char *bufptr;
{
	int argu[3]; register loopcnt;
	register struct devq *dev;
	register struct dkinf *dkptr;
	register unsigned short oldpri;

	dev = &req;
	initdevq (dev);

	if ( *(bufptr+1) == 'L' ) {
		if ( getdrive(bufptr) )
			return(-1);
		dev->q_devun.pdisk.cyl = STARTCYL;
	}
	else {
		if ( getarg(bufptr, argu, 2)<0 )
			return (-1);
 		if ( argu[0] >= MAX_PDRIVE )
			return (-1);

		dev->q_devnum = argu[0];
		dev->q_devun.pdisk.cyl = argu[1];
	}

	loopcnt = 0;

	 get pointer to physical drive data 
	if ( (dkptr=(struct dkinf *)getphptr(dev))==(struct dkinf *)-1 ) {
		printrc (dev);
		return;
	}

	 no read/write
	dev->opr = 0xff;

	 stop if receiving character 'Q' 
	while ( con_in() != 'Q' ) {
		if ( dev->q_devun.pdisk.cyl >= cylsize )
			return (-1);

		if ( PRINT1 )
			printf ("C=%x loop=%x  \r", dev->q_devun.pdisk.cyl, loopcnt);
		oldpri = spl6();
		if ( aseek (dev,bufptr) ) 

			 seek problem, drive already rezero 

			break;
	
		 inturpt will be enabled by aseek
		if ( *(bufptr+1) != 'L' )
			break;		 not loop mode 

		dev->q_devun.pdisk.cyl += 0x10;	 increment cylinder # 

		if ( dev->q_devun.pdisk.cyl >= cylsize ) {
			loopcnt++;
			dev->q_devun.pdisk.cyl = (STARTCYL + loopcnt) & 0x001f;
			blinkled();
		}
	}
	printlf();
	return (0);
}
**************************************** */

/* rezero drive
	B <drive>
 */

/* **************************************

rezerodr (bufptr)
char *bufptr;
{	register struct devq *dev;
	register struct dkinf *dkptr;
	register unsigned short oldpri;

	if ( getdrive(bufptr) )
		return(-1);
	dev = &req;

	 get pointer to physical drive data 

	if ( (dkptr=(struct dkinf *)getphptr(dev))==(struct dkinf *)-1 ) {
		printrc (dev);
		return;
	}

	oldpri = spl6();

	dkrezero (dev->q_devnum,&seekque.s_p_d[dev->q_devnum]);

	splx(oldpri);
	return (0);
}

**************************************** */


/*
 * R/W[L]  <addrress>  <drive>  <cyl>  <head>  <sector>  <sector count>
 */

rwdisk (bufptr)
char *bufptr;
{	register char *cptr;
	register struct devq *dev;
	register struct dkinf *dkptr;
	register unsigned int numsec, num;
	struct seek_per_disk *sptr;
	int loopcnt;

	dev = &req;
	initdevq (dev);
	dev->q_devtype = DISK;

	cptr = bufptr;
	cptr++;

	if ( *bufptr == 'R' )
		dev->opr = OPR_READ;
	else  {

		dev->opr = OPR_WRITE;
	}

	loopcnt = 0;
	if ( inputarg (bufptr, cptr, dev) )
		return (-1);

	/* get pointer to physical drive data */
	if ( (dkptr=(struct dkinf *)getphptr(dev))==(struct dkinf *)-1 ) {
		printrc (dev);
		return;
	}


	/* can't overlap track, insure input C,H,S is valid */
	if ( cklimit (dev) == -1 )
		return (-1);


	sptr = &seekque.s_p_d[dev->q_devnum];
	if ( *cptr != 'L' ) {
		sptr->s_first = dev;
		sptr->s_last = dev;
		
		return(0);
	}


	numsec = dev->scnt;

	while ( con_in() != 'Q' ) {
		num = numsec; dev->q_devun.pdisk.sector = 0;
		while ( num ) {
			if ( num > SEC84_HEAD ) {
				dev->scnt = SEC84_HEAD;
				num -= SEC84_HEAD;
			}
			else {
				dev->scnt = num;
				num = 0;
			}

			printchs (dev, loopcnt);

			/* read or write sector */
			sptr->s_first = dev;
			sptr->s_last = dev;

			dev->q_devun.pdisk.sector += dev->scnt;
		}
		incchs (dev,&loopcnt);
	}
	printlf();
	return (0);
}

/*
 * E <addrress>  <drive>  <cyl>  <head>  <sector>  <sector count>
 */

readid (bufptr)
char *bufptr;
{	register char *cptr;
	register struct devq *dev;
	register struct dkinf *dkptr;
	int loopcnt; register ret;
	register int *ptr; register int i; register temp;

	dev = &req;
	initdevq (dev);
	dev->q_devtype = DISK;

	cptr = bufptr+1;

	loopcnt = 0;
	if ( inputarg (bufptr, cptr, dev) )
		return (-1);

	dev->opr = OPR_RDID;

	/* get pointer to physical drive data */
	if ( (dkptr=(struct dkinf *)getphptr(dev))==(struct dkinf *)-1 ) {
		printrc (dev);
		return(0);
	}

	/* can't overlap track, insure input C,H,S is valid */
	if ( cklimit (dev) == -1 )
		return (-1);

	while ( con_in() != 'Q' ) {
		if ( *cptr == 'L' ) {
			printchs (dev, loopcnt);
		}

		/* seek to cyl, read id */
		dev->q_flag |= DK_TO_LOC;	/* data into local memory */
		rwid (dev,dkptr, dev->scnt*8,0);

		if ( *(short *)&dev->rc1 )
			printrc(dev);

		if ( (*cptr != 'L') || dev->rc1 ) {
			ptr = (int *)dev->q_mem;
			printlf();
			for (i=0; i<dev->scnt; i++) {
				temp = *ptr++;
				printf ("S(%2x) %8x %8x\n", dev->q_devun.pdisk.sector++, temp, *ptr++);
			}
			break;			/* get out of while loop */
		}

		if ( ret == 0 ) {
			if ( checkid (dev) )
				printf (" ERR\n");
		}
		/* each sector has 8 bytes id field */
		setbuf (dev->q_mem, dev->scnt * 2, 0 );
		incchs ( dev, &loopcnt);
	}
	printlf();
	return (0);
}

checkid (dev)
register struct devq *dev;
{
	register int i; register short *ptr;
	ptr = (short *)dev->q_mem;

	for (i=0; i<dev->scnt; i++) {
		ptr+=2;
		if ( *ptr++ != dev->q_devun.pdisk.cyl )
			return (-1);
		if ( *ptr++ != (short)((dev->q_devun.pdisk.head<<8)|i) )
			return (-1);
	}
	return (0);
}

inputarg( bufptr, cptr, dev)
char *bufptr; register char *cptr; register struct devq *dev;
{
	int argu[6];

	dev->q_flag = DK_TO_LOC;		/* assume local memory */

	if ( *cptr == 'L' ) {
		if  ( getarg(bufptr, argu, 1) < 0)
			return (-1);
		dev->q_mem = (char *)LOCA;
		dev->q_devnum = (char)argu[0];
		dev->q_devun.pdisk.cyl = STARTCYL;
		dev->q_devun.pdisk.head = 0;
		dev->q_devun.pdisk.sector = 0;
		dev->scnt = sectsize;
	}
	else if  ( *cptr == ' ' || *cptr == 'M' ) {
		if  ( getarg(bufptr, argu, 6) < 0)
			return (-1);
		dev->q_mem = (char *)argu[0];
		dev->q_devnum = (char)argu[1];
		dev->q_devun.pdisk.cyl = argu[2];
		dev->q_devun.pdisk.head = argu[3];
		dev->q_devun.pdisk.sector = argu[4];
		dev->scnt = argu[5];
		if ( *cptr == 'M' ) {
			dev->q_flag &= ~DK_TO_LOC;	/* main memory */
			dev->q_mem = (char *)((int)dev->q_mem >> 2);
		}
	}
	else 
		return (-1);
	return (0);
}


cklimit(dev)
register struct devq *dev;
{
	if ( ((dev->q_devun.pdisk.sector+dev->scnt) > sectsize) || 
	(dev->q_devun.pdisk.cyl >= cylsize) || 
	(dev->q_devun.pdisk.head >= headsize) )
		return (-1); 
	return (0);
}


getdrive(bufptr)
char *bufptr;
{	int argu[2]; register struct devq *dev;
	if ( getarg(bufptr, argu, 1)<0 )
		return (-1);
 	if ( argu[0] >= MAX_PDRIVE )
		return (-1);

	/* initialize the device que to zero */
	dev = &req;
	initdevq (dev);
	dev->q_devnum = argu[0];
	dev->q_devtype = DISK;
	return (0);
}

/* 
	input default disk size
	N    <# of cyl/drive> <# of head/cyl> <# of sectors/head>
disksize(bufptr)
char *bufptr;
{
	int argu[3];
	if  ( getarg(bufptr, argu, 3) < 0)
		return (-1);
	cylsize = argu[0];
	headsize = argu[1];
	sectsize = argu[2];
	return (0);
}
*/

printchs(dev, loopcnt)
struct devq *dev; int loopcnt;
{
	if ( PRINT1 ) {
		prchs (dev);
		printf ("loop=%x   \r",loopcnt);
	}
}

/*
getpasswd()
{
	char buf[10];
	printf ("password:");
	if ( get(buf, sizeof buf -1) < 0 )
		return (-1);
	if ( *(int *)buf != 'ETER' )
		return (-1);
	return(0);
}
*/



incchs(dev, loopptr)
register struct devq *dev;
int *loopptr;
{
	if ( ++dev->q_devun.pdisk.head >= headsize ) {
		dev->q_devun.pdisk.head = 0;
		dev->q_devun.pdisk.cyl++;

		/* blink lit between green & off */
		if ( dev->q_devun.pdisk.cyl >= cylsize ) {
			dev->q_devun.pdisk.cyl = STARTCYL;
			(*loopptr)++;
		}
	}
	blinkled();
}

