/*----------------------------------------------------------------------------
/ dsetrvio.c - a portion of 'dsetup'
/
/---------------------------------------------------------------------------*/

#include "disksect.h"
#include "dsetup.h"
#include "dk.h"

#ifdef RO_UNIX
#include <sys/stat.h>
#define PERROR(x) perror(x)
#else
#define PERROR(x)
#endif

#ifndef REG
#define REG register
#endif

extern int scsi_dtc;

/*
 *      attach a physical reserved area.
 *
 *      would like to go through the icb device interface
 *      for now translate it as four rv's per hsdt some how
 *
 */

#ifdef STANDALONE
#define RV_PATTERN_0 1
#define RV_PATTERN_1 3
char DEV[10] = "c0d0r";
#endif

#ifdef UNIXSTANDALONE
#define RV_PATTERN 2
char *DEV = "rv0";
static int UNIXfd, UNIXpdnext;
#endif

#ifdef RO_UNIX
#define RV_PATTERN_0 10
#define RV_PATTERN_1 12

char *DEV = "/dev/dsk/c0d0r";
static int UNIXfd, UNIXpdnext;
static int UNIXfile;
#endif

pdopen(dev)
struct icbdev *dev;
{
    int fd,pdnum;
    int openflag = 2;
    int i;

    pdnum = dev->dev_num;
    if (pdnum < 0 || pdnum > 0x3d)
        error("disk number out of range");

#ifdef RO_UNIX
    openflag = 0;
#endif
#ifdef UNIXSTANDALONE
    DEV[RV_PATTERN] = pdnum + '0';
#else
   /* let's make sure that there are no extraneous characters left in DEV*/
    for(i=0;i<sizeof(DEV);i++)
	*(DEV+i) = 0;
    sprintf(DEV, "c%dd%dr", pdnum >> 4, pdnum & 0xf);
#endif
    if ((fd = open(DEV, openflag)) < 0) {
#ifdef RO_UNIX
        char td[31];

        sprintf(td, "/dev/rv%d", (pdnum & 3) | (pdnum >> 2));
        if ((fd = open(td, openflag)) < 0)
#endif
            { PERROR("dsetup "); error("open of %s failed", DEV); }
    }
    return(fd);
}

pdlseekck(fd, pos, how)
{
    if (lseek(fd,pos,how)<0)
        {PERROR("dsetup "); errxit("pd seek error, pos %d",pos);}
}

pdreadck(fd,p,s) {
    if (read(fd,p,s)<0)
        {PERROR("dsetup "); errxit("pd read error");}
}

pdwriteck(fd,p,s) {
    if (write(fd,p,s)<0)
        {PERROR("dsetup "); errxit("pd write error");}
}

pdreadany(fd,sector,buf)
char *buf;
{
    pdlseekck(fd, sector * BLKSIZE, 0);
    pdreadck(fd, buf, BLKSIZE);
/* will add alternate checking  someday */
    xprintf("pdreadany: $%x,",sector);
    return(0x400);
}

pdwrite(fd, sector, buf)
char *buf;
{
    pdlseekck(fd, sector * BLKSIZE, 0);
    pdwriteck(fd, buf, BLKSIZE);
    pdlseekck(fd, (sector + 1) * BLKSIZE, 0);
    pdwriteck(fd, buf, BLKSIZE);
    xprintf("pdwrite: $%x,",sector);
}

readphys0(setup)
REG struct setup *setup;
{
    struct sector0 *pd;

    setup->flag |= SET_CLEAR;           /* in case an error */
    setup->memPhysdisk = memalloc(sizeof (struct sector0), MEM_ALLIGN);
    pd = PD0(setup);
    setup->fd = pdopen(&setup->dev);
#if defined(UNIXSTANDALONE) | defined(RO_UNIX)
    UNIXfd = setup->fd;
#endif
    if (pdfread(setup->fd, 0, pd) < 0)
        error("cannot access physical disk");
#ifdef UNIXSTANDALONE
    UNIXpdnext = pd->nextsec;
#endif
    if (strcmp(pd->id, "INIT"))
        error("disk not formatted");
    if (pd->FORMAT_LEVEL)
        software_bug("readphys0", "Version problem with %d, run a new dsetup",
                pd->FORMAT_LEVEL);
    if (pd->rv_strt != 0)
        errxit("reserved area not at 0, can't continue");
    setup->flag &= ~SET_CLEAR;
}

rvwriteconfig(setup)
REG struct setup *setup;
{
    struct memuse *xmem;

    if (setup->flag & SET_NEW)
        xmem = memalloc(0x400, MEM_ALLIGN);
    else
        xmem = 0;

    /* verify protected disk parameters still the same */
    {
        REG struct confld *ld = setup->confld;
        REG struct logtype *logdrive;
        REG int i;
        REG struct sector0 *pd = PD0(setup);

        for (i = 0; i < LOGDR; i++, ld++)
            if (ld->flag & CFLD_PROTECT) {
                logdrive = &pd->logdrive[ld->logdriveindex];
                if (logdrive->ld_strt == ld->start &&
                        logdrive->ld_size == ld->cAssignSect &&
                        logdrive->ld_type == ld->type &&
                        logdrive->ld_mirror == -1 &&
                        logdrive->ld_skip == ld->cBad.cSkip) {/* temp for format '0' */
                    continue;
                }
                else
                    software_bug("pdwriteconfig", "Protected drive not equal");
            }
    }

    /* write out the spare table and skip list */
    if (pdfwrite(setup->fd, RV_SPARE_ID,
            setup->memSpare->p, setup->cMemSpare) < 0
            || pdfwrite(setup->fd, RV_SKIP_ID,
            setup->memSkip->p,setup->cMemSkip) < 0)
        errxit("pdfwrite failed, rerun dsetup to clean up");

    /* cause the alternate id's to be formatted */
    {
        REG struct physbadsector *bads;
        REG int cbad;
        REG struct sprs *spare = (struct sprs *)(setup->memSpare->p);
        REG struct sprs *tspare;

        cbad = setup->cMemBad;
        bads=(struct physbadsector *)(setup->memBad->p);
        for ( ; cbad > 0; cbad--, bads++) {
            struct {
                uint badsector, alternatesector, index;
            } iodata;

            if (bads->flag & BS_PROTECT) /* already alt_id marked */
                continue;
            if (bads->flag & BS_UNSPARE) {
                iodata.badsector = VALCHS(bads->cyl);
                tspare = &spare[bads->index];
                /* for UNSPARE index is passed as 2nd parm */
                if (bads->flag & BS_HOLE)
                    iodata.alternatesector = -1;
                else
                    iodata.alternatesector = bads->index;
                ioctlck(setup->fd, UNSPARE, &iodata);
            }
            else if (bads->flag & BS_HOLE) {
                iodata.badsector = VALCHS(bads->cyl);
                ioctlck(setup->fd, HWSPARE, &iodata);
            }
            else {
                iodata.badsector = VALCHS(bads->cyl);
                tspare = &spare[bads->index];
                iodata.alternatesector = VALCHS(tspare->altcyl);
                iodata.index = bads->index;
                ioctlck(setup->fd, PHSPARE, &iodata);
            }
        }
    }

    if (setup->flag & SET_WBADS) {
        /* bad list must be written after all sparing */
        struct sectid *bad;
        struct physbadsector *pbad;
        int i;

        setup->flag &= ~SET_WBADS;
        /* must squash the table, copy it in place */

        bad = (struct sectid *)(setup->memBad->p);
        pbad = (struct physbadsector *)bad;
        for (i = setup->cMemBad; i > 0; i--, bad++, pbad++) {
            if (pbad->flag & BS_UNSPARE) {
                setup->cMemBad--;
                i--;
                pbad++;
            }
            SETCHS(bad->cyl,VALCHS(pbad->cyl));
        }

        if (pdfwrite(setup->fd, RV_BAD_ID, setup->memBad->p, setup->cMemBad) < 0)
            errxit("cannot write bad block list");
    }

    {
        REG struct confld *ld = setup->confld;
        REG struct logtype *logdrive;
        REG int i;
        REG struct sector0 *pd = PD0(setup);
        int ldnum;
        int nextsect;

        /* initialize the boot pointer if a new config */
        if (setup->flag & SET_NEW) {
            struct boot_list *b = (struct boot_list *)(xmem->p);
            pdreadany(setup->fd, BOOT_SECTOR, b);
            b->boot_strt = BOOT_START;
            if (!(b->boot_size)){
                b->boot_size = setup->confRsv.cAssignSect - BOOT_START;
                pdwrite(setup->fd, BOOT_SECTOR, b);
            }
        }
        /*
         *  Ask what the next avail sector is, plug this number into
         *  the new sector 0 structure.  This will be written back.
         */
        ioctlck(setup->fd, NEXTRVSEC, &nextsect);
        pd->nextsec = nextsect;
        /* fill in the new sector 0 */
        /* what about the size of the reserved area? */
        /* what order should it happen in, consider the NEXTRVSEC */
        /* for now CLEAR MIRROR INFORMATION */

        logdrive = pd->logdrive;
        for (i = 0; i < LOGDR; i++, ld++, logdrive++) {
            memset(logdrive, 0, sizeof (*logdrive));
            if (!ld->type)
                continue;
            ldnum = i; /* for count of valid ld table entries */
            logdrive->ld_strt = ld->start;
            logdrive->ld_size = ld->cAssignSect;
            logdrive->ld_type = ld->type;
            logdrive->ld_mirror = -1;
            logdrive->ld_skip = ld->cBad.cSkip; /* temp for format '0' */
        }
        pd->pd_ldnum = ldnum+1;
        pd->rv_size = setup->confRsv.cAssignSect;
        pd->rv_skip = setup->confRsv.cBad.cSkip; /* temp for format '0' */
        pd->DSETUP_LEVEL = CURRENT_DSETUP_LEVEL;
        pdwrite(setup->fd, 0, pd);
        ioctlck(setup->fd, INIT, 0);
    }

    if (xmem)
        memfree(xmem);
}

/*---------------------------------------------------- checknewsetup() -------
/ Decide if this disk has been setup before.
/ Go checking spare and skip lists.  They should be empty.
/---------------------------------------------------------------------------*/
checknewsetup(setup)
struct setup *setup;
{
    register struct sector0 *pd = PD0(setup);

    if (pd->pd_ldnum != 0)              /* never been setup before */
        return(0);
    /* TODO: check out the lists */
    return(1);
}

cmp_chs(a, b) /* treat a chs like an int */
int *a, *b;
{
    return(*a - *b);
}

getbadlist(setup)
REG struct setup *setup;
{
    struct sectid *bad;
    struct physbadsector *pbad;
    int i;

    if (!setup->memPhysdisk)
        software_bug("getbadlist", "Cannot maketables without physdisk");

    setup->flag |= SET_CLEAR;

    setup->cMemBad = setup->pdstat.pd_bd_count;

    if (setup->cMemBad == 0 && !scsi_dtc) {
        warn("No bad sectors?!  Has disktest been run?");
        confirm();
    }

    setup->memBad = memalloc((setup->cMemBad + 10)
            * sizeof (struct physbadsector), PAGE_ALLIGN);
    bad = (struct sectid *) (setup->memBad->p);
    pbad = (struct physbadsector *) bad;

    if (pdfread(setup->fd, RV_BAD_ID, bad) < 0)
        errxit("Unable to read bad block list");

    qsort(bad, setup->cMemBad, sizeof (*bad), cmp_chs);

    /* must spread out the table, backwards copy it in place */
    i = setup->cMemBad - 1;

    /* set bad and pbad to point past the last elements */
    bad = &bad[i];
    pbad = &pbad[i];
    for ( ; i >= 0; i--, bad--, pbad--) {
        SETCHS(pbad->cyl, VALCHS(bad->cyl));
        pbad->flag = 0;
        pbad->index = -1;
    }
    setup->flag &= ~SET_CLEAR;
}

getsslist(setup)
struct setup *setup;
{
    REG struct sprs *sprs;
    REG struct sparedata *spare;
    REG struct physbadsector *bads;
    REG int i;
    uint tchs,chs;

    ssalloc(setup);
    setup->cMemSkip = setup->pdstat.pd_sk_count;
    pdfread(setup->fd, RV_SKIP_ID, setup->memSkip->p);

    bads = (struct physbadsector *)(setup->memBad->p);
    for (i = setup->cMemBad; i > 0; i--, bads++) { /* clear bad block links */
        bads->index = -1;
        bads->flag = BS_PROTECT | (bads->flag & BS_UNSPARE);
    }
    sprs = (struct sprs *)(setup->memSpare->p);
    spare = (struct sparedata *)sprs;
    i = setup->cMemSpare - 1;

    /*
     *  For now we know things groups totally by logical disk.
     *  So that spare tracks do not have sectors from more than
     *  one logic disk.
     */

    sprs = &sprs[i];
    spare = &spare[i];
    /* backwards copy in place to spread out and make room for flag */
    for ( ; i >= 0; i--, sprs--, spare--) {
        struct physbadsector keybads;
        extern cmp_bads();

        SETCHS(spare->altcyl, VALCHS(sprs->altcyl));
        SETCHS(spare->cyl, VALCHS(sprs->cyl));

        tchs = VALCHS(spare->cyl);
        if (tchs == -1)
            continue;
        spare->flag = BS_PROTECT;
        if (!(chs = tchs))
            chs = VALCHS(spare->altcyl);
        SETCHS(keybads.cyl, chs);
        bads = (struct physbadsector *) bsearch((char *) &keybads,
            setup->memBad->p, setup->cMemBad, sizeof(*bads), cmp_bads);
        if (!bads)
            errxit("getsslist: spared sector $%x not bad", VALCHS(chs));/* run dsck */
        if (tchs)
            bads->flag |= BS_SPARE;
        else
            bads->flag |= BS_HOLE;
        bads->index = i;
        xprintf("spare $%x alt $%x flag %x idx %d\n",
                VALCHS(spare->cyl), VALCHS(spare->altcyl), bads->flag, bads->index);
    }
    bads = (struct physbadsector *) (setup->memBad->p);
    for (i = setup->cMemBad; i > 0; i--, bads++) {
        if (bads->index == -1)
            bads->flag |= BS_HOLE;
    }
}

/*
 *      Get room for the spare and skip lists.
 *      Assume all skipped tracks will be put into
 *      the spare table.
 */
ssalloc(setup)
REG struct setup *setup;
{
    REG struct confld *ld;
    int oldcount;
    REG skipcount=0,sparecount=0;
    int i;

    /* how much of each type of list is needed */
    for (ld = &setup->confRsv, i = RV_LOGDR; i < LOGDR; i++, ld++) {
        switch (ld->type) {
            case LD_UNIXFS:
            case LD_USERSPLIT:
            case LD_PWF:
            case LD_USERSPARE:
            case LD_USERHOLE:
                sparecount += ld->cBad.cSkip;
                skipcount += ld->cBad.cTrack * PD0(setup)->sechead;
                break;
            case LD_SWAP:
            case LD_USERSKIP:
                skipcount += ld->cBad.cSkip;
                break;
            default:
                break;
        }
    }
    oldcount = setup->pdstat.pd_sp_count;

    /*NOWARN: if (!oldcount) printf("No existing spare tables\n"); */

    if (oldcount>sparecount) {
        /*NOWARN: warn("courious, more spare sectors that expected"); */
        sparecount = oldcount;
    }
    sparecount += (sparecount>>3) + 150; /* about 12 per cent (1/8) slop */
    if (setup->memSpare) {
        memfree(setup->memSpare);
    }
    setup->memSpare = memalloc(sparecount * sizeof(struct sparedata),PAGE_ALLIGN);
    if (pdfread(setup->fd,RV_SPARE_ID,setup->memSpare->p)<0)
        errxit("cannot read alternate/spare list");
    setup->cMemSpare = oldcount;
    oldcount = setup->pdstat.pd_sk_count;
    skipcount = skipcount / PD0(setup)->sechead + 2*LOGDR;
    skipcount += (skipcount>>3);
    if (oldcount>skipcount) {
        skipcount = oldcount;
    }
    if (setup->memSkip) {
        memfree(setup->memSkip);
    }
    setup->memSkip=memalloc(skipcount * sizeof(struct badtrck), MEM_ALLIGN);
    setup->cMemSkip = 0;
    memset(setup->memSkip->p, 0, setup->memSkip->c);
}

ioctlck(fd,n,p)
int *p;
{
#ifdef RO_UNIX
        return;
#endif
#ifdef STANDALONE
        char *s;
        static char hexc[] = "0123456789abcdef";
        int i;

        switch (n) {
            case INIT:
                s = "INIT";
                break;
            case PHSPARE:
                xprintf("bad = $%x, alt = $%x, idx = %d  ", *p, p[1], p[2]);
                s = "PHSPARE";
                break;
            case HWSPARE:
                xprintf("bad = $%x  ",*p);
                s = "HWSPARE";
                break;
            case UNSPARE:
                xprintf("bad = $%x, idx = %d  ", *p, p[1]);
                s = "UNSPARE";
                break;
            case NEXTRVSEC:
                s = "NEXTRVSEC";
                break;
            default:
                errxit("cannot do ioctl $%x",n);
        }
        xprintf("ioctl(%s)\n", s);
        if ((i=ioctl(fd, n, p)) == 0)
                return;
        PERROR("dset ");
        error("ioctl(%s) == $%x\n", s, i);
#endif
#ifdef UNIXSTANDALONE
        char *s;
        static char hexc[] = "0123456789abcdef";

        fd = UNIXfd;
        switch (n) {
            case INIT:
                s = "INIT";
                break;
/* should increment the used count in the sector */
            case PHSPARE:
                xprintf("bad = $%x, alt = $%x, idx = %d  ", *p, p[1], p[2]);
                s = "PHSPARE";
                break;
            case HWSPARE:
                xprintf("bad = $%x  ",*p);
                s = "HWSPARE";
                break;
            case UNSPARE:
                xprintf("bad = $%x, idx = %d  ", *p, p[1]);
                s = "UNSPARE";
                break;
            case NEXTRVSEC:
                *p = UNIXpdnext;
                UNIXpdnext += 2;
                s = "NEXTRVSEC";
                break;
            default:
                s = "UNKNOWN(00)";
                s[9] = hexc[n&0x0f];
                s[8] = hexc[(n>>4)&0x0f];
                errxit("ioctl(%s)\n", s);
        }
        xprintf("ioctl(%s)\n", s);
#endif
}

/*------------------------------ End of dsetrvio.c -------------------------*/
