/*----------------------------------------------------------------------------
/ scsimisc.c - miscellaneous functions
/
/ Craig J. Kim      July 1988
/ (c) Copyright 1988 ARIX Corp.  San Jose, CA
/---------------------------------------------------------------------------*/

/*---------------------------------------------------- a3toi() ---------------
/ converts a three byte integer to a four byte integer
/---------------------------------------------------------------------------*/
a3toi(cs)
char *cs;               /* where to get three-byte integer */
{
        union { int num; char cc[4]; } cv;

        cv.num = 0;
        memcpy(&cv.cc[1], cs, 3);
        return(cv.num);
}

/*---------------------------------------------------- itoa3() ---------------
/ packs an integer to a three byte memory
/---------------------------------------------------------------------------*/
itoa3(cs, num)
char *cs;               /* memory location */
int num;                /* number to be packed */
{
        union { int num; char cc[4]; } cv;

        cv.num = num;
        memcpy(cs, &cv.cc[1], 3);
}

/*-------------------------------- End of scsimisc.c -----------------------*/
