/*----------------------------------------------------------------------------
/ report.c
/
/ (c) Copyright 1988 ARIX Corp.  San Jose, CA
/---------------------------------------------------------------------------*/

#include "disktest.h"

report_errs()
{
	register i;
	char *rbslmsg;
	register count, newentries;
	register seqnum = 0;
	register struct sectid *sbptr;
	register lsect = 0x10; /* start of bad sector list */
	register struct badlist *bdptr = (struct badlist *)BadBuf;
	register struct sectid *tbptr = (struct sectid *)CompBuf;

	rbslmsg = "record bad sector list";
	show_status();
	TotEntries = 0;
	while(1) { /* copy the existing bad sector list into the track buffer */
		for(i=0; i<2; i++) {
			if(lsectop(PREADPS,lsect+i,bdptr+i,rbslmsg) < 0)
				goto exitrecord;
		}
		if((i = comp_bufs(bdptr,bdptr+1,sectsiz)) < sectsiz) {
			printf("sectors 0x%x and 0x%x are not equal at byte 0x%x...abort\n",
				lsect,lsect+1,i);
			goto exitrecord;
		}
		if(wrdcmp(BadId,bdptr->id) != 0 || bdptr->idfield != BADSECID ||
			bdptr->seqnum != seqnum++) {
				printf("bad sector block improperly initialized...abort\n");
				goto exitrecord;
		}
		sbptr = bdptr->badsctrinfo; /* first entry of block */
		count = bdptr->numofentries; /* leave numofentries intact */
		TotEntries += count;
		while(1) { /* copy this block */
			if(count == 0) break;
			*tbptr++ = *sbptr++; /* copy entry */
			count--;
		}
		if(bdptr->nextsec) lsect = bdptr->nextsec;
		else break; /* lsect remembers last sector number */
	}
	count = TotEntries; /* remember this amount */
	addnew(); /* add possible new entries bumping TotEntries */
	count = TotEntries - count; /* get number of new entries */
	newentries = count;
	while(count) {
		while(count && bdptr->numofentries < BADLSTSIZ) {
			*sbptr++ = *tbptr++; /* copy a new entry to sector buffer */
			count--; bdptr->numofentries++;
		}
		if(count) { /* is there more? */
			bdptr->nextsec = getnextlsect();
		}
		for(i=0; i<2; i++) { /* duplicate information */
			if(lsectop(PWRITPS,lsect+i,bdptr,rbslmsg) < 0) goto exitrecord;
		}
		lsect = bdptr->nextsec;
		init_buffer(bdptr,sizeof(struct badlist),0,1,0); /* zero buffer */
		*(unsigned *)bdptr->id = ASCIBAD;
		bdptr->idfield = BADSECID;
		bdptr->seqnum = seqnum++;
		sbptr = bdptr->badsctrinfo;
	}
	printf("%d entries added to bad sector list   %d total entries\n",
		newentries,TotEntries);
exitrecord:
	longjmp(MenuBuffer,1);
}

addnew()
{	register record = FALSE;
	register unsigned i, dis_err;
	register struct errinfo *ptr = ErrRootPtr;
	register struct errinfo *end_ptr = ErrListPtr;

	if(CompErr) {
        printf("Compare errors encountered during test...no recording of errors allowed\n");
	} else {
		if ((SoftDiskErr || HardDiskErr) &&
            getyn("Do you wish to record the errors that occured during this test")) {
			record = TRUE;
		}
	}
	dis_err = TRUE;
	errnum = 1;
	while(1) {
		for (i=0; i<11; i++) { /* one page at a time */
			if (end_ptr > ptr) {
				if (dis_err) display_error(ptr);
				if (record) record_error(ptr);
				ptr++;
			} else return;
		}
		if (dis_err) {
			if(!q_continue()) dis_err = FALSE;
		}
	}
}

record_error(listptr)
	register struct errinfo *listptr;
{	register unsigned i,k;
	register struct sectid *snptr = &listptr->sectnum;
	register struct sectid *tbptr = (struct sectid *)CompBuf;

	if ((listptr->harderrcount == 0) && (listptr->softerrcount < (Pass / 4)))
		return; /* not enough errors */
	switch(listptr->badvalue & 0xff00) { /* only record media errors */
		case 0x1100: /* crc error */
		case 0x1600: break; /* bad header */
		default: return;
	}
	for (i=0; i<(TBsize/sizeof(struct sectid)); i++, tbptr++) {
		if (i < TotEntries) {
			if (tbptr->cyl == snptr->cyl &&
				tbptr->head == snptr->head &&
				tbptr->sector == snptr->sector) return; /* item is in list already */
		} else {   /* at this point i == TotEntries */
			*tbptr = *snptr; /* add new entry */
			++TotEntries;
			return;
		}
	}
	printf("\nsize of bad sector table exceeded\n");
}

display_error(ptr)
	register struct errinfo *ptr;
{
	if (ptr->errtype == 0) {
		printf("%d) compare error -- first encounter pass %d  occurrances %d\n",
		errnum,ptr->passnum,ptr->softerrcount);
		printf("cylinder %x head %x sector %x byte %x sh be %x is %x\n",
		ptr->sectnum.cyl,ptr->sectnum.head,ptr->sectnum.sector,
		ptr->bytnum,ptr->pattern,ptr->badvalue);
	} else {
		printf("%d) disk error -- first encounter pass %d  occurrances soft %d hard %d\n",
		errnum,ptr->passnum,ptr->softerrcount,ptr->harderrcount);
		printf("cylinder %x head %x sector %x   pat %x  retcode %x\n",
		ptr->sectnum.cyl,ptr->sectnum.head,ptr->sectnum.sector,
		ptr->pattern,ptr->badvalue);
	}
	errnum++;
}

show_status()
{
	printf("\n\ndrive %2x status\n",UnitNum);
	if (Compare) printf("%d compare errors\n",CompErr);
	printf("%d soft disk errors\n%d hard disk errors\n%d complete passes\n",
		SoftDiskErr,HardDiskErr,Pass-1);
 }

id_sect(ptr)
	register struct sectid *ptr;
{
	printf("cylinder %d(0x%x) head %d(0x%x) sector %d(0x%x)\n",
		ptr->cyl,ptr->cyl,ptr->head,ptr->head,ptr->sector,ptr->sector);
}

/*-------------------------------- End of report.c -------------------------*/
