/*----------------------------------------------------------------------------
/ lsectop.c
/
/ (c) Copyright 1988 ARIX Corp.  San Jose, CA
/---------------------------------------------------------------------------*/

#include "disktest.h"

extern char abortmsg[];
unsigned char testbuf[SECTSIZ*2];

getnextlsect()
{
	struct devq devq;
	short numtries = 0;
	struct sectid chs[2];
	register i, j, lsect;
	register struct sectid *csptr, *ptr; /* compare sector pointer */
	char *nullsptr = "";

tryanother:
	if(numtries++ > 5) return(0); /* we are having serious problems */
	devq.q_devtype = DTDISK;
	devq.q_devnum = DriveNum;
	devq.q_cmd = NEXTRVSEC;
	devq.q_count = 0;
	devq.q_devun.block = 0;
	devq.q_priority = 0;
	devq.rc1 = 0;
	devq.rc2 = 0;
	i = devreq(SlotPtr,&devq);
	lsect = devq.q_devun.block;
	if(i < 0 || devq.rc1 || lsect == 0) return(0); /* error */
	for(i=0; i<2; i++) log_to_phys(lsect+i,&chs[i]);
	csptr = (struct sectid *)CompBuf;
	for(j=0; j<TotEntries; j++, csptr++) { /* is sector in bad sector list */
		for(i=0; i<2; i++) { /* check both sector and sector + 1 */
			ptr = &chs[i];
			if(ptr->cyl == csptr->cyl &&
				ptr->head == csptr->head &&
				ptr->sector == csptr->sector) goto tryanother;
		}
	}
	for(j=0; j<2; j++) {
		init_buffer(testbuf,SECTSIZ,0,1,0x55555555 << j);
		for(i=0; i<2; i++) {
			if(lsectop(PWRITPS,lsect+i,testbuf,nullsptr) < 0 ||
				lsectop(PREADPS,lsect+i,testbuf + SECTSIZ,nullsptr) < 0 ||
				comp_bufs(testbuf,testbuf+SECTSIZ,SECTSIZ) != SECTSIZ)
					goto tryanother;
		}
	}
	return(lsect);
}

/********************************************************************!HDR!*****
 * lsectop()
 * 	
 * description: 
 * 	construct a DTB request structure and invoke devreq()
 *	this routine uses disk parameters in MthrBlk to build the 
 *	devreq structure
 *
 * input:
 *
 * cmd - devreg command
 * lsect - logical sector number
 * bufptr - location that will receive data
 * msg - print this message if there is a problem and we bail
 *
 ********************************************************************!RDH!*****/
lsectop(cmd,lsect,bufptr,msg)
char *bufptr, *msg;
{	int h;
	struct devq devq;

	if (MthrBlk.sechead==0 || MthrBlk.headcyl==0) {
		printf("sector 0 improperly initialized: %s\n", msg?msg : "");
		return(-1);
	}
	h = lsect / MthrBlk.sechead;
	devq.q_devtype = DTDISK;
	devq.q_devnum = DriveNum;
	devq.q_cmd = cmd;
	devq.q_count = sectsiz;
	devq.q_devun.pdisk.cyl = h / MthrBlk.headcyl;
	devq.q_devun.pdisk.head = h % MthrBlk.headcyl;
	devq.q_devun.pdisk.sector = lsect - (h * MthrBlk.sechead);
	devq.q_extdtb = XDDFLT;
	devq.q_mem = bufptr; /* default timing info */
	devq.q_priority = 0;
	devq.q_mmu = 0;
	devq.q_flag = 0; /* retries ok */
	devq.rc1 = 0;
	devq.rc2 = 0;
	if((devreq(SlotPtr,&devq) < 0) || devq.rc1 || devq.rc2) {
		if(msg && *msg) {
			deverr(&devq);
			printf(abortmsg,msg,devq.rc1,devq.rc2);
		}
		return(-1);
	}
	return(0);
}

/********************************************************************!HDR!*****
 * psectop()
 * 	
 * set up DTB request to read a physical sector and issue the devreq()
 *
 * input: 
 *
 *	cmd		- DTB request command
 *	c		- cylinder
 *	h		- head
 *	s		- sector
 *	bufptr		- transfer location
 *	msg		- pointer to a message to display if
 *			  devreq fails
 *
 ********************************************************************!RDH!*****/
psectop(cmd, c, h, s, bufptr, msg)
char *bufptr, *msg;
{
	struct devq devq;

	bzero(&devq, sizeof(struct devq));
	devq.q_devtype = DTDISK;
	devq.q_devnum = DriveNum;
	devq.q_cmd = cmd;
	devq.q_count = sectsiz;
	devq.q_devun.pdisk.cyl = c;
	devq.q_devun.pdisk.head = h;
	devq.q_devun.pdisk.sector = s;
	devq.q_extdtb = XDDFLT;
	devq.q_mem = bufptr;
	devq.q_priority = 0;
	devq.q_mmu = 0;
	devq.q_flag = 0; /* retries ok */
	devq.rc1 = 0;
	devq.rc2 = 0;
	if((devreq(SlotPtr,&devq) < 0) || devq.rc1 || devq.rc2) {
		if(msg && *msg) printf(abortmsg,msg,devq.rc1,devq.rc2);
		return(-1);
	}
	return(0);
}

/*------------------------------ End of lsectop.c --------------------------*/
