/*----------------------------------------------------------------------------
/ getparam.c - all the disktest functions that deal with a user
/
/ Craig J. Kim      June 1988
/ (c) Copyright 1988 ARIX Corp.  San Jose, CA
/---------------------------------------------------------------------------*/

#include "cpu.h"
#include "icbcmd.h"
#include "icb.h"
#include "disktest.h"
#include "sysconf.h"


/*---------------------------------------------------- get_params() ----------
/ change current testing parameters including drive unit
/---------------------------------------------------------------------------*/
get_params()
{
    register unsigned temp;
	register unsigned short cyl,head;
	register char c;

    temp = UnitNum;                     /* save */
    do {
        if (!getdrive())                /* get new drive spec */
            return;
	if(UnitNum == temp)
	    break;
	if(initdrive())
	    return;
	else{
            if (getyn("Would you like to format the drive")){
                format();
		initdrive();
	        return;
	    }
	}
		
    } while (UnitNum != temp && initdrive() == -1);

    if (getyn("Test all but cylinder 0")) {
        BeginSector = MthrBlk.seccyl;   /* protect cylinder 0 */
		NumOfSectors = (MthrBlk.cyldisk - 1) * MthrBlk.seccyl;
	}
    else if (MthrBlk.pd_ldnum && getyn("Test a logical disk")) {
		while (1) {
            temp = get_num("Enter logical disk number");
            if (temp >= MthrBlk.pd_ldnum) {
                printf("Logical disk %d does not exist.  Try again.\n", temp);
				continue;
			}
			BeginSector = MthrBlk.logdrive[temp].ld_strt;
			NumOfSectors = MthrBlk.logdrive[temp].ld_size;
			return;
		}
	}
	else {
		while(1) {
            temp = get_num("Enter starting cylinder");
			if (temp > MthrBlk.cyldisk) {
				pr_no_good();
				continue;
			}
			cyl = temp;
            temp = get_num("Enter starting head");
			if (temp > MthrBlk.headcyl) {
				pr_no_good();
				continue;
			}
			head = temp;
            temp = get_num("Enter starting sector");
			if (temp > MthrBlk.sechead) {
				pr_no_good();
				continue;
			}
			temp += (cyl * MthrBlk.seccyl) + (head * MthrBlk.sechead);
			if (temp <= MthrBlk.nextsec) {
                printf("The first %d(0x%x) sectors of the disk contain bad block information\n", MthrBlk.nextsec, MthrBlk.nextsec);
                printf("Will start at next track instead.\n");
				
				temp = (MthrBlk.nextsec + MthrBlk.sechead - 1) /
                        MthrBlk.sechead * MthrBlk.sechead;
			}
			BeginSector = temp;
			break;
		}

        if (getyn("Test to end of drive")) {
            NumOfSectors = MthrBlk.cyldisk * MthrBlk.seccyl - BeginSector;
			return;
		}
			
        while (1) {
            temp = get_num("Enter number of sectors to be tested");
            if ((BeginSector + temp) > (MthrBlk.cyldisk * MthrBlk.seccyl))
                printf("Exceeds size of drive.  Try again.\n");
            else {
                NumOfSectors = temp;
                break;
			}
        }
    }
}

/*---------------------------------------------------- getdrive() ------------
/  get drive to test from human
/
/  user input must be of the form:
/
/      cMdN | cMdNr | X
/
/  where M and N is  >= 0 && < 16
/
/  or X is a long integer
/
/  temp contains controller id and device
/  the lower byte contains the drive number
/  the next byte contains the controller number
/
/  00 00 CC DD
/
/  sets globals Unitnum and DriveNum
/
/  Test for scsi and make longjmp if type changed
/
/----------------------------------------------------------------------------*/
getdrive()
{
    unsigned int temp, temp2;

    while (1) {
        printf("\nEnter drive to be tested--> ");
        if (gets(buffer, CBUFSIZ) < 0)
            prhuh();
        else if (usrabort()) {
            if (getyn("Change debug flag")) {
				debugflag ^= 1;
                printf("Debug is now %s.\n", debugflag ? "on" : "off");
				continue;
			}
			else
                return(FALSE);          /* user quits */
		}

        if (gdrive(&temp, buffer))
            if (chkdspec(temp) && checkdrive(temp)) {
                UnitNum = temp;
                DriveNum = temp & 0x0f;
                temp >>= 4;
                                        /* selected different drive type */
                if (temp != PrevUnitNum)
                    longjmp(GetDrvJmpBuf, 1);
                return(TRUE);           /* all is well now */
            }

        printf("\nInvalid drive unit specification.\n");
        printf("Format:  [c]C[d]D  where C is controller number\n");
        printf("                         D is drive number\n");
	}
}

/*---------------------------------------------------- checkdrive() ----------
/  using the externel SYSCONF information, checkdrive()
/  verifies that the input unit number corresponds to an HSDT
/      ( High Speed Disk Tape ) controller, an EDT ( Enhanced Disk Tape )
/      controller or a SCSI EDT controller
/
/  the function sets the global SlotPtr which is declared below
/
/ input:
/
/  unit number (bits 0-3 contain device number, bits 4-7 contain cntrlr #)
/
/ diagnostics:
/
/  returns true if input controller is an HSDT, EDT, or SCSI
/  controller board
/
/  returns false if contoller # is not an EDT, HSDT, or SCSI board.
/---------------------------------------------------------------------------*/
checkdrive(unit)
{
	register i;
	register cntrlr = unit >> 4;			/* controller number */
	register struct slot_info *slotptr = SYSCONF->slotinfo;

    for (i = 0; i < NUMSLOTS; i++, slotptr++) {
        if ((slotptr->bdptr)
                && (((slotptr->slotaddr->bdtypreg & BDTYPMSK) == HSDTBDTYP)
                || ((slotptr->slotaddr->bdtypreg & BDTYPMSK) == EDTBDTYP)
                || ((slotptr->slotaddr->bdtypreg & BDTYPMSK) == SCSIBDTYP))) {
            if (cntrlr-- == 0) {
				SlotPtr = slotptr;
                return(TRUE);
			}
		}
	}
    return(FALSE);
}

/*---------------------------------------------------- gdrive() --------------
/ get drive specification.  If it starts with a 'c', assume c#d#[#] format;
/ else #[ ]#[#] format.  This routine doesn't attempt to verify to validity of
/ drive specification as long as it fits the format.
/ It passes back drive index number.  Return TRUE for success; FALSE otherwise
/---------------------------------------------------------------------------*/
int gdrive(pdr, cs)
int *pdr;
char *cs;
{
    register int c;
    register char *p = cs;

    while (isspace(*p))                 /* skip white spaces */
        p++;

    if (*p == 'c') {                    /* c#d#[#] format */
        c = atoi(++p);
        while (isdigit(*p))
            p++;                        /* skip over additional numbers */
        if (*p++ != 'd')                /* not in c0d0 format */
            return(FALSE);
    }
    else {                              /* ##[#] format */
        if (!isdigit(*p))               /* no controller # */
            return(FALSE);
        c = *p - '0';                   /* controller number */
        p++;
        while (isspace(*p))
            p++;
    }

    if (!isdigit(*p))                   /* must be hex format */
        *pdr = (c << 4) | atox(p);
    else
        *pdr = (c << 4) | atoi(p);
    while (isxdigit(*p))                /* skip over what we converted */
        p++;
    return(TRUE);                       /* success */
}

/*---------------------------------------------------- chkdspec() ----------*/
chkdspec(drive)
int drive;
{
    register unsigned int controller = drive >> 4;
    register unsigned int disk = drive & 0x0f;

    if (controller > 3) {
        printf("Invalid controller %d - only controllers 0-3 supported\n",
            controller);
        return(FALSE);
    }

    if (isscsi(controller)) {
        if (disk > 13) {
            printf("Invalid drive %d - only disks 0..13 per SCSI controller\n",
                    disk);
            return(FALSE);
        }
    }
    else {
        if (disk > 3) {
            printf("Invalid drive %d - only disks 0-3 per controller\n", disk);
            return(FALSE);
        }
    }

    return(TRUE);
}

/*--------------------------------- End of getparam.c ----------------------*/
