/*----------------------------------------------------------------------------
/ dump.c - do displaying/dumping the read buffer
/
/ (c) Copyright 1988 ARIX Corp.  San Jose, CA
/---------------------------------------------------------------------------*/

#include "disktest.h"

/*---------------------------------------------------- q_comp_dump() ---------
/ asks the human whether or not i should compare the read buffer after
/ read requests and whether or not i should dump the buffer if a read
/ buffer compare fails
/
/ set the globals
/
/  Compare     - boolean; if TRUE, do read buffer compares
/  DumpIt      - boolean; if TRUE, dump the buffer on a failure
/
/---------------------------------------------------------------------------*/
q_comp_dump()
{
    if (Compare = getyn("Do you wish to compare the read buffer"))
        DumpIt = getyn("Do you wish to dump the read buffer on compare error");
}

/*---------------------------------------------------- dumper() --------------
/ this is used to dump the compare buffer
/---------------------------------------------------------------------------*/
dumper(address)
register unsigned *address;
{
    register unsigned i, j, k = 0;
    register unsigned *end_add = address + sectsiz / 4;

    while (address < end_add) {
        for (i = 0; i < 21; i++) {      /* for pagination */
            printf("%4x: ", k);         /* print offset */
            k += 0x20;                  /* label each line */
            for (j = 0; j < 4; j++)
                printf("%8x ", *address++);
			putchar(' ');
            for (j = 0; j < 4; j++)
                printf("%8x ", *address++);
            printf("\n");               /* print a line */
            if (address >= end_add)
                break;
		}
        if (!q_continue())
            report_errs();
	}
}

/*------------------------------ End of dump.c -----------------------------*/
