/*----------------------------------------------------------------------------
/ disktest.h - include for all disktest modules
/
/ (c) Copyright 1988 ARIX Corp.  San Jose, CA
/---------------------------------------------------------------------------*/

#define _DISKTEST_

#ifdef MAIN_MODULE
#define GLOBAL
#else
#define GLOBAL      extern
#endif

#include "disksect.h"
#include "setjmp.h"
#include "dk.h"
#include "vreg.h"

#ifndef VERSION
#define VERSION     6
#endif
#ifndef RELEASE
#define RELEASE     2
#endif

#define RETRYCOUNT  3                   /* ok... do it thrice */

#define TRUE        1                   /* are you sure? */
#define FALSE       0                   /* is there a truth in this? */
#define YES         1                   /* hmmm optimistic... */
#define NO          0                   /* just say NO! */

#define ESCAPE      0x1b                /* escape is ascii 27 */

#ifdef BLKSIZE
#define SECTSIZ     BLKSIZE             /* default sector size */
#else
#define SECTSIZ     1024
#endif

#define CBUFSIZ     9                   /* up to 9 chars from user */
#define MAXERR      0x4000              /* */

#define MAXSECHEAD  (42+7)                 /* maximum number of sectors/track */

#ifdef DEBUG
extern xdevreq();
#define devreq(a,b) xdevreq(a,b)
#endif

typedef unsigned char  uchar;
typedef unsigned short ushort;
typedef unsigned int   uint;
typedef unsigned long  ulong;


/* sector header descriptions for write/read sector id commands */

struct wrsecid {
        char    fmtf;                   /* format flags */
        uchar   cylhi;                  /* this cylinder, head, sector */
        uchar   cyllo;
        uchar   head;
        uchar   sec;
        char    pad[7];
};

struct rdsecid {
        uint    flags;                  /* always 0x00001900 */
        ushort  cyl;
        uchar   head;
        uchar   sector;
};

/* error structure */

struct errinfo {
        uint    passnum;
        struct sectid sectnum;
        uint    errtype;                /* 0 = compare error */
        uint    bytnum;                 /* or in the case of a disk error -- intword */
        uint    pattern;
        uint    softerrcount;           /* number of soft occurrances */
        uint    harderrcount;           /* number of hard occurrances */
        uint    badvalue;               /* bad compare value (return code) */
};

#ifdef MAIN_MODULE
        char    version = {VERSION};
        char    release = {RELEASE};
        ushort  sectsiz = {SECTSIZ};
        char    BadId[] = "BAD";
        char    *Prompt = "disktest-> ";
        char    *BadCmd = "Unrecognized command.  Type '?' for help\n";
#   ifdef DEBUG
        int     debugflag = TRUE;
#   else
        int     debugflag = FALSE;
#   endif
#else
GLOBAL  char    version;                /* major version number */
GLOBAL  char    release;                /* minor version number */
GLOBAL  ushort  sectsiz;                /* sector size in bytes */
GLOBAL  char    BadId[];                /* "BAD" */
GLOBAL  char    *Prompt;                /* "disktest-> " */
GLOBAL  char    *BadCmd;                /* "Unrecognized ... " */
GLOBAL  int     debugflag;              /* display debug messages */
#endif

GLOBAL  jmp_buf MenuBuffer;             /* back to menu */
GLOBAL  jmp_buf GetDrvJmpBuf;           /* change drive jump */
GLOBAL  jmp_buf fabort;                 /* format abort jump */

GLOBAL  struct slot_info *SlotPtr;      /* controller */
GLOBAL  struct sector0 MthrBlk;         /* Sector 0 Info (Mother Block) */
GLOBAL  struct errinfo *ErrRootPtr, *ErrListPtr;
GLOBAL  struct badlist BadList;         /* Bad Sector List */
GLOBAL  struct errinfo ErrData[MAXERR];

GLOBAL  ushort  errno;                  /* rc1 from last i/o error */
GLOBAL  short   autosize;               /* be clever about figuring out disk size */

GLOBAL  uchar   *TrackBuffer;           /* points aTrackBuffer[] */
GLOBAL  uchar   *CompBuf;               /* points aCompBuf[] */
GLOBAL  uchar   *BadBuf;                /* points aBadBuf[] */
GLOBAL  uint    *badblock;              /* bad block pointers to aBadBuf[] */
GLOBAL  uchar   aTrackBuffer[MAXSECHEAD * SECTSIZ * 4];
GLOBAL  uchar   aCompBuf[MAXSECHEAD * SECTSIZ * 4];
GLOBAL  uchar   aBadBuf[MAXSECHEAD * SECTSIZ * 4];
GLOBAL  uint    TBsize;                 /* size of above buffers in bytes */

GLOBAL  char    buffer[CBUFSIZ];        /* user input buffer */
GLOBAL  uint    Pattern;                /* test pattern */
GLOBAL  ushort  WrdsPerSect;            /* # of sectors / 2 */
GLOBAL  uchar   DriveNum, UnitNum;      /* Drive, Ctrlr */
GLOBAL  uchar   PrevUnitNum;            /* so we know when to jump */
GLOBAL  uint    Pass, BeginSector, NumOfSectors;
GLOBAL  uint    CompErr, SoftDiskErr, HardDiskErr;
GLOBAL  uchar   Compare, DumpIt;        /* how to handle tests */
GLOBAL  uchar   DBPat, AltPat;          /* DBPat debug pattern flag */
GLOBAL  int     TotEntries;             /* bad sector counter */
GLOBAL  ushort  errnum;
GLOBAL  int     ScsiDrv;                /* is it a scsi drive */


#undef GLOBAL

/*---------------------------- End of disktest.h ---------------------------*/
