#ident	"@(#)src.mk	23.41	4/8/91 Copyright (c) 1991 by Arix Corp."
# What all does:
#   sgsdef1: There are two versions of sgsdefs, the first points at the boot
#		   S90 ansi compiler.  The second points at the sgs created
#		   below.  This allows
#		   the target compiler to be used to create the release.
#		   Link the first sgsdefs to the proper name.
#		   This MUST happen before any clobbers to set up the environment
# clobberall: Do a complete clobber of source, binary, and release trees.
#    clobber: Clean up the source
# secclobber: Clobbers the security area
#bootclobber: Clobbers the bootsgs
#rootclobber: Clobbers the root binary tree
# relclobber: Clobbers the releasse area (src/release).
#   dir_dev1: Create the directory and device structure in the 'release' area.
#  includes1: Install the include files in the 'release' area.
#   sgsbins1: Using the boot sgs as defined in sgsdefs, create the sgs binaries.
# 		   Install them in the 'release' area.
#        cc1: Create a cc script for the 'release' area
# 		   area sgs.
#    sgsdef2: Link the second phase sgsdefs to the proper name.  This one points
# 		   at a different boot sgs area.
#      libs1: Make the libs
#      utils: Perform a 'make install' on the utils
#    diskrel: With the combined specfile, make a release on disk
#    sgsspec: Make an sgs spec file
#    sgssave: With the sgs_spec save off a copy of the sgs.
#    extract: Extract the saved sgs into this boot sgs area.
# 		   This goes into SROOT/bootsgs
#        cc2: Create a cc script for the boot sgs area.
# 		   This points into SROOT/bootsgs
#   sgsbins2: Perform a standard 'make install' on the sgs binaries.
#      libs2: Create libs and install in 'release' area.
#    compare: Finally, compare the release tape to the disk image.  They should
# 		   be the same

# Other important rules:
#
#     tape: creates a BRU tape from the previously built OS.
#  sectape: create a security overlay with INSTALL file.
#  sgstape: create a tape with an sgs
#      sgs: create an sgs
#     sgs1: create the bootsgs
#     sgs2: create the release sgs


IROOT =
include $(IROOT)/macdefs

#   the order of things is very important
#	dirs	devs	head	lib		cmd
#	dom	scripts man	spareroot	syslist

# for a 12 hour make which requires a lot of cpu time, use the fast make
# option (implemented for a1000).  warning:  libs must be made before
# fast1 and fast2.  the include files and libraries are needed by the
# rest of the utilities.


##  ensure that integration user is root with bourne shell
ENV_MSG = "warning:  this step must be done as root, using bourne shell."

DEV_SETUP = \
	dev

DIR_SETUP = \
	dir

SGS_DIR =   \
	cmd/sgs

LIBRARIES = \
	lib

# fast1 and fast2 components are in the cmd directory

FAST1 = \
	cmd/gen1.mk cmd/prog.mk

FAST2 = \
	cmd/gen2.mk cmd/idiot.mk cmd/sys.mk

FASTPOSIX = \
	cmd/posix.mk

SECURE = \
	cmd/sec_cmd.mk

FAST3	=	\
	 scripts spareroot syslist

#	 scripts patch spareroot syslist

PERF	= cmd/perf.mk

# at lower levels, clobber calls clean.  we won't have clean at this level
# the reel stuff!!

all:	ulimit
	@-echo "Making all, starting with sgs: ==== `date` ===="
	$(MAKE) -$(MAKEFLAGS)f src.mk sgs
	@-echo "DONE making sgs, now making utilities: ==== `date` ===="
	$(MAKE) -$(MAKEFLAGS)f src.mk utilities & WAIT_IDU=$$!;		\
	echo "waiting for utilities and libraries to finish...";	\
	wait $$WAIT_IDU;
	$(MAKE) -$(MAKEFLAGS)f src.mk diskrel
	@-echo "DONE making all: ==== `date` ===="

utilities: ulimit dir_dev2 includes2 utils
	@-echo "DONE making utilities: ==== `date` ===="

dir_dev1:	FRC
	$(MAKE) -$(MAKEFLAGS)f src.mk dir_dev
	@-echo "================= dir_dev1 DONE:   `date` ==================="

dir_dev2:	FRC
	$(MAKE) -$(MAKEFLAGS)f src.mk dir_dev
	@-echo "================= dir_dev2 DONE:   `date` ==================="

dir_dev:	dirs devs FRC
	@-echo "DONE making install directories and devices (dir_dev:)..."
	@-echo "==================== `date ` ==================="

includes1:	FRC
	$(MAKE) -$(MAKEFLAGS)f src.mk includes
	@-echo "================= includes1 DONE:   `date` ==================="

includes2:	FRC
	$(MAKE) -$(MAKEFLAGS)f src.mk includes
	@-echo "================= includes2 DONE:   `date` ==================="

includes:	std_check FRC
	@-echo "Making the include files: `date`"
	cd includes; $(MAKE) -$(MAKEFLAGS)f includes.mk install

sgsbins1:	FRC
	$(MAKE) -$(MAKEFLAGS)f src.mk sgsbins NOHUP=F
	@-echo "================== sgsbins1 DONE:   `date` ==================="

sgsbins2:	FRC
	$(MAKE) -$(MAKEFLAGS)f src.mk sgsbins NOHUP=S
	@-echo "================== sgsbins2 DONE:   `date` ==================="

sgsbins:	std_check $(SGS_DIR) FRC
	@-echo "Making sgs binaries.  see nohup.sgs: `date`"
	cd $(SROOT)/cmd/sgs;                                      \
		nice --19 $(MAKE) -$(MAKEFLAGS)f sgs.mk install > \
			../../nohup.sgs$(NOHUP) 2>&1
	@-echo "DONE making sgs: ==== `date` ===="

cc1:	$(IROOT) FRC
	@echo "Making cc1 script: ==== `date` ===="
	@echo "SGS=$(ROOT)" > $(IROOT)/cc
	$(MAKE) -$(MAKEFLAGS)f src.mk cc_script1

cc2:	$(IROOT) FRC
	@echo "Making cc2: === `date` ==="
	@echo "SGS=$(SROOT)/bootsgs" > $(IROOT)/cc
	$(MAKE) -$(MAKEFLAGS)f src.mk cc_script2

sgsdef1:	$(IROOT)/sgsdef1 FRC
	@-echo "Making boot sgs sgsdefs file: ==== `date` ===="
	rm -f $(IROOT)/sgsdefs
	ln $(IROOT)/sgsdef1 $(IROOT)/sgsdefs
	@-echo "DONE making boot sgs sgsdefs file"

sgsdef2:	$(IROOT)/sgsdef2 FRC
	@-echo "Making boot sgs sgsdefs file: ==== `date` ===="
	rm -f $(IROOT)/sgsdefs
	ln $(IROOT)/sgsdef2 $(IROOT)/sgsdefs
	@-echo "DONE making boot sgs sgsdefs file"

sgsdef3:	$(IROOT)/sgsdef3 FRC
	@-echo "Making boot sgs sgsdefs file: ==== `date` ===="
	rm -f $(IROOT)/sgsdefs
	ln $(IROOT)/sgsdef3 $(IROOT)/sgsdefs
	@-echo "DONE making boot sgs sgsdefs file"

libs1:	FRC
	$(MAKE) -$(MAKEFLAGS)f src.mk libs NOHUP=F
	@-echo "================ libs1 DONE:   `date` ======================"

libs2:	FRC
	$(MAKE) -$(MAKEFLAGS)f src.mk libs NOHUP=S
	@-echo "================ libs2 DONE:   `date` ======================"

libs:	std_check FRC
	@-echo "Making libraries.  see nohup.libs: ==== `date` ===="
	@-for i in $(LIBRARIES);                                          \
	do                                                                \
		echo "=============== $$i: `date ` ===================" ; \
		echo "cd $(SROOT)/$$i;\n" ;                               \
		echo "$(MAKE) -$(MAKEFLAGS)f $$i.mk install";             \
		cd $(SROOT)/$$i;                                          \
		nice --19 $(MAKE) -$(MAKEFLAGS)f $$i.mk install;          \
	done > nohup.libs$(NOHUP) 2>&1
	@echo "================== $$i DONE:  `date` =========================="

utils:	std_check $(FASTPOSIX) $(FAST1) $(FAST2) $(SECURE) FRC
	( 							    \
	nice --19 $(MAKE) -$(MAKEFLAGS)f src.mk fastposix	    \
		> nohup.posix 2>&1 & WAIT_POSIX=$$! ;		    \
	nice --19 $(MAKE) -$(MAKEFLAGS)f src.mk fast1 		    \
		> nohup.1 2>&1  & WAIT_ONE=$$! ;		    \
	nice --19 $(MAKE) -$(MAKEFLAGS)f src.mk fast2 		    \
		> nohup.2 2>&1  & WAIT_TWO=$$! ;		    \
	nice --19 $(MAKE) -$(MAKEFLAGS)f src.mk secure 		    \
		> nohup.secure 2>&1  & WAIT_SECURE=$$! ;	    \
	echo "waiting for $$WAIT_POSIX at `date`";                  \
	wait $$WAIT_POSIX;					    \
	echo "waiting for $$WAIT_ONE at `date`";                    \
	wait $$WAIT_ONE;				            \
	echo "waiting for $$WAIT_TWO at `date`";                    \
	wait $$WAIT_TWO;					    \
	echo "waiting for $$WAIT_SECURE at `date`";                 \
	wait $$WAIT_SECURE; 					\
	$(MAKE) -$(MAKEFLAGS)f src.mk fast3 		    \
		> nohup.3 2>&1;)
	@echo "================ utils DONE:  `date` =========================="

sgsspec: FRC
	@echo "Making sgs spec file: === `date` ==="
	cd $(BUILD)/system/pm;					\
	$(MAKE) spec.M68020 MACH=M68020;			\
	$(MAKE) spec.M68040 MACH=M68040;			\
	$(MAKE) sspec.M68020 SECUREFLAG=YES MACH=M68020;	\
	$(MAKE) sspec.M68040 SECUREFLAG=YES MACH=M68040;	\
	cd $(BUILD);						\
		rm -f system/*/sgs_spec;			\
		for i in system/pm/spec.*			\
			system/dsdb/spec.*			\
			system/pm/sspec.*			\
			system/iopm/spec.*			\
			system/acdb/spec.*;			\
		do						\
			grep "usr/include/sys" $$i >>		\
				`dirname $$i`/sgs_spec;		\
		done
	cd $(BUILD);						\
	$(IROOT)/mkspec full system/*/sgs_spec util/sgs_spec	\
		util/sgs.$(MACH) util/sgs_only			\
		> sgs_spec;					\
	rm -f system/*/sgs_spec

sgssave:	ulimit std_check sgsspec FRC
	@echo "Making sgssave: === `date` ==="
	cd $(BUILD);                                       \
	cat sgs_spec | $(IROOT)/maketape -T $(NEWDATE) -ovC131072 > \
		$(SROOT)/release/s$(ONETWO).$(NEWDATE)

diskrel:	specfiles makedisks FRC
	@echo "================ diskrel DONE:  `date` ======================="

specfiles:	ulimit std_check FRC
	@echo "Making specfiles: === `date` ==="
	cd $(BUILD);							\
	$(IROOT)/mkspec full						\
		system/pm/sspec.M68020 util/sec_only > sspec.M68020;	\
	$(IROOT)/mkspec full						\
		system/pm/sspec.M68040 util/sec_only > sspec.M68040;	\
	$(IROOT)/mkspec root system/*/spec.generic 			\
		system/*/spec.M68020 util/*spec util/*M68020 >		\
		rspec.M68020;						\
	$(IROOT)/mkspec root system/*/spec.generic 			\
		system/*/spec.M68040 util/*spec util/*M68040 >		\
		rspec.M68040;						\
	$(IROOT)/mkspec usr system/*/spec.generic 			\
		system/*/spec.M68020 util/*spec util/*M68020 >		\
		uspec.M68020;						\
	$(IROOT)/mkspec usr system/*/spec.generic 			\
		system/*/spec.M68040 util/*spec util/*M68040 >		\
		uspec.M68040
	@echo "================ specfiles DONE:  `date` ======================"

makedisks:	ulimit std_check FRC
	@echo "Making specfiles: === `date` ==="
	cd $(BUILD);							\
	echo BUILDING ROOT M68040 disk release;				\
	$(IROOT)/maketape -T $(NEWDATE) -ovC131072 < rspec.M68040 >	\
		$(SROOT)/release/r40.$(NEWDATE);			\
	echo BUILDING USR M68040 disk release;				\
	$(IROOT)/maketape -T $(NEWDATE) -ovC131072 < uspec.M68040 >	\
		$(SROOT)/release/u40.$(NEWDATE);			\
	echo BUILDING ROOT M68020 disk release;				\
	$(IROOT)/maketape -T $(NEWDATE) -ovC131072 < rspec.M68020 >	\
		$(SROOT)/release/r20.$(NEWDATE);			\
	echo BUILDING USR M68020 disk release;				\
	$(IROOT)/maketape -T $(NEWDATE) -ovC131072 < uspec.M68020 >	\
		$(SROOT)/release/u20.$(NEWDATE);			\
	echo BUILDING SECURE M68040 disk release;			\
	$(IROOT)/maketape -T $(NEWDATE) -ovC131072 < sspec.M68040 >	\
		$(SROOT)/release/x40.$(NEWDATE);			\
	echo BUILDING SECURE M68020 disk release;			\
	$(IROOT)/maketape -T $(NEWDATE) -ovC131072 < sspec.M68020 >	\
		$(SROOT)/release/x20.$(NEWDATE)
	@echo "================ makedisks DONE:  `date` ======================"

extract: FRC
	@echo "Making extract: === `date` ==="
	if [ ! -d $(SROOT)/bootsgs ];     	\
	then                              	\
		mkdir $(SROOT)/bootsgs;   	\
	fi
	cd $(SROOT)/bootsgs; cpio -iudvBm <	\
		$(SROOT)/release/s$(ONETWO).$(NEWDATE)

fast1 :	std_check $(FAST1) FRC
	@-echo "fast make:  making fast1..."
	@-for i in $(FAST1);                                                 \
	do                                                                   \
		echo "=================== $$i: `date ` ==================="; \
		echo "cd $(SROOT)/cmd;\n" ;                                  \
		echo "$(MAKE) -$(MAKEFLAGS)f $(SROOT)/$$i install";          \
		cd $(SROOT)/cmd;                                             \
			$(MAKE) -$(MAKEFLAGS)f $(SROOT)/$$i install;         \
	done
	@echo "==================fast1: DONE:  `date` ======================"

fast2 :	std_check $(FAST2) FRC
	@-echo "fast make:  making fast2..."
	@-for i in $(FAST2);                                                 \
	do                                                                   \
		echo "=================== $$i: `date ` ==================="; \
		echo "cd $(SROOT)/cmd;\n" ;                                  \
		echo "$(MAKE) -$(MAKEFLAGS)f $(SROOT)/$$i install";          \
		cd $(SROOT)/cmd;                                             \
		$(MAKE) -$(MAKEFLAGS)f $(SROOT)/$$i install;                 \
	done
	@echo "==================fast2: DONE:  `date` ======================"


fastposix :	std_check $(FASTPOSIX) FRC
	-@echo "fast make:  making fastposix..."
	-@for i in $(FASTPOSIX);                                          \
	do                                                                \
		echo "=============== $$i: `date ` ===================" ; \
		echo "cd $(SROOT)/cmd;\n" ;                               \
		echo "$(MAKE) -$(MAKEFLAGS)f $(SROOT)/$$i install";       \
		cd $(SROOT)/cmd;                                          \
		$(MAKE) -$(MAKEFLAGS)f $(SROOT)/$$i install; 	          \
	done
	@echo "============ fastposix: DONE:  `date` ======================"

fast3 :	std_check $(FAST3) FRC
	@-echo "fast make:  making fast3..."
	@-for i in $(FAST3);                                                 \
	do                                                                   \
		echo "Making $$i";                                           \
		echo "==================== $$i: `date ` =================="; \
		echo "cd $(SROOT)/$$i;\n" ;                                  \
		echo "$(MAKE) -$(MAKEFLAGS)f $$i.mk install";                \
		cd $(SROOT)/$$i;                                             \
		$(MAKE) -$(MAKEFLAGS)f $$i.mk install;                       \
	done
	@echo "==================fast3: DONE:  `date` ======================"

secure :	std_check $(SECURE) FRC
	@-echo "fast make:  making secure..."
	@-for i in $(SECURE);                                                \
	do                                                                   \
		echo "=================== $$i: `date ` ==================="; \
		echo "cd $(SROOT)/cmd;\n" ;                                  \
		echo "$(MAKE) -$(MAKEFLAGS)f $(SROOT)/$$i install";          \
		cd $(SROOT)/cmd;                                             \
		$(MAKE) -$(MAKEFLAGS)f $(SROOT)/$$i install;                 \
	done
	@echo "==================secure: DONE:  `date` ======================"

compare: FRC
	echo "============== scripts compare: `date ` ===================" ; \
	cd $(SROOT)/scripts; $(MAKE) -$(MAKEFLAGS)f scripts.mk compare
	@echo ===================== all DONE:  `date` =======================

perf:	std_check $(PERF) FRC
	-@echo "fast make:  making perf..."
	-@for i in $(PERF);                                                 \
	do                                                                  \
	     echo "==================== $$i: `date ` ===================" ; \
	     echo "cd $(SROOT)/cmd;\n" ;                                    \
	     echo "$(MAKE) -$(MAKEFLAGS)f $(SROOT)/$$i install";            \
	     cd $(SROOT)/cmd;                                               \
		$(MAKE) -$(MAKEFLAGS)f $(SROOT)/$$i install; 	            \
	done
	@echo "================ perf: DONE:  `date` ======================"

clobberall:	clobber rootclobber bootclobber secclobber relclobber FRC
	@echo "============== clobberall DONE `date` ======================"

clobber : $(LIBRARIES) $(FAST1) $(FAST2) $(FASTPOSIX) \
		$(FAST3) $(PERF) $(SECURE) FRC
	chmod -x $(IROOT)/ins
	@-for i in $(LIBRARIES);                                            \
	do                                                                  \
	     echo "==================== $$i: `date ` ===================" ; \
	     echo "cd $(SROOT)/$$i;\n" ;                                    \
	     echo "$(MAKE) -$(MAKEFLAGS)f $$i.mk clobber";                  \
	     cd $(SROOT)/$$i;                                               \
		$(MAKE) -$(MAKEFLAGS)f $$i.mk clobber;                      \
	done
	@-for i in $(FAST1);                                                \
	do                                                                  \
		echo "================== $$i: `date ` ===================" ;\
		echo "cd $(SROOT)/cmd;\n" ;                                 \
		echo "$(MAKE) -$(MAKEFLAGS)f $(SROOT)/$$i clobber";         \
		cd $(SROOT)/cmd;                                            \
		$(MAKE) -$(MAKEFLAGS)f $(SROOT)/$$i clobber;                \
	done
	@-for i in $(FAST2);                                                \
	do                                                                  \
		echo "================== $$i: `date ` ===================" ;\
		echo "cd $(SROOT)/cmd;\n" ;                                 \
		echo "$(MAKE) -$(MAKEFLAGS)f $(SROOT)/$$i clobber";         \
		cd $(SROOT)/cmd;                                            \
		$(MAKE) -$(MAKEFLAGS)f $(SROOT)/$$i clobber;                \
	done
	@-for i in $(FASTPOSIX);                                            \
	do                                                                  \
		echo "================= $$i: `date ` ===================" ; \
		echo "cd $(SROOT)/cmd;\n" ;                                 \
		echo "$(MAKE) -$(MAKEFLAGS)f $(SROOT)/$$i clobber";         \
		cd $(SROOT)/cmd;                                            \
		$(MAKE) -$(MAKEFLAGS)f $(SROOT)/$$i clobber;                \
	done
	@-for i in $(FAST3);                                                \
	do                                                                  \
		echo "Making $$i";                                          \
		echo "================= $$i: `date ` ===================" ; \
		echo "cd $(SROOT)/$$i;\n" ;                                 \
		echo "$(MAKE) -$(MAKEFLAGS)f $$i.mk clobber";               \
		cd $(SROOT)/$$i;                                            \
		$(MAKE) -$(MAKEFLAGS)f $$i.mk clobber;                      \
	done
	@-for i in $(PERF);                                                 \
	do                                                                  \
		echo "================= $$i: `date ` ===================" ; \
		echo "cd $(SROOT)/cmd;\n" ;                                 \
		echo "$(MAKE) -$(MAKEFLAGS)f $(SROOT)/$$i clobber";         \
		cd $(SROOT)/cmd;                                            \
		$(MAKE) -$(MAKEFLAGS)f $(SROOT)/$$i clobber;                \
	done
	@-for i in $(SECURE);                                               \
	do                                                                  \
		echo "================= $$i: `date ` ===================" ; \
		echo "cd $(SROOT)/cmd;\n" ;                                 \
		echo "$(MAKE) -$(MAKEFLAGS)f $(SROOT)/$$i clobber";         \
		cd $(SROOT)/cmd;                                            \
		$(MAKE) -$(MAKEFLAGS)f $(SROOT)/$$i clobber;                \
	done
	#
	@echo "================= cmd/sgs: `date ` ==================="
	@echo "cd $(SROOT)/cmd/sgs"
	@echo "$(MAKE) -$(MAKEFLAGS)f $(SROOT)/cmd/sgs/sgs.mk clobber"
	cd $(SROOT)/cmd/sgs; $(MAKE) -$(MAKEFLAGS)f sgs.mk clobber
	#
	# remove the network services library that is not distributed
	rm -f $(SROOT)/libns.a
	@echo "================= clobber DONE ============================="

secclobber:	FRC
	if [ "$(SECROOT)" != "" ]; 					\
	then								\
		cd $(SECROOT); rm -rf *;				\
	else								\
		echo "SECROOT not defined.  cannot perform secclobber";	\
	fi

rootclobber:	FRC
	if [ "$(ROOT)" != "" ]; 					\
	then								\
		cd $(ROOT); rm -rf *;					\
	else								\
		echo "ROOT not defined.  cannot perform rootclobber";	\
	fi

bootclobber:	FRC
	if [ "$(SROOT)" != "" ]; 					\
	then								\
		rm -rf $(SROOT)/bootsgs;				\
	else								\
		echo "SROOT not defined.  cannot perform bootclobber";	\
	fi

relclobber:	FRC
	rm -f $(SROOT)/release/x20.$(NEWDATE)
	rm -f $(SROOT)/release/x40.$(NEWDATE)
	rm -f $(SROOT)/release/r20.$(NEWDATE)
	rm -f $(SROOT)/release/r40.$(NEWDATE)
	rm -f $(SROOT)/release/u20.$(NEWDATE)
	rm -f $(SROOT)/release/u40.$(NEWDATE)
	rm -f $(SROOT)/release/s1.$(NEWDATE)
	rm -f $(SROOT)/release/s2.$(NEWDATE)
	rm -f $(SROOT)/release/d.$(NEWDATE)

$(SGS_DIR):
	@echo "cannot locate $(SROOT)/$@"

$(LIBRARIES):
	@echo "cannot locate $(SROOT)/$@"

$(FAST1):
	@echo "cannot locate $(SROOT)/$@"

$(FAST2):
	@echo "cannot locate $(SROOT)/$@"

$(FASTPOSIX):
	@echo "cannot locate $(SROOT)/$@"

$(FAST3):
	@echo "cannot locate $(SROOT)/$@"

$(PERF):
	@echo "cannot locate $(SROOT)/$@"

std_check: FRC
	chmod +x $(IROOT)/ins
	chmod +x $(IROOT)/mkspec
	chmod +x $(IROOT)/lorder
	chmod +x $(IROOT)/ulimit_check
	chmod +x $(IROOT)/stdinlorder
	@echo $(ENV_MSG)
	@if [ "$(ROOT)" = "" -o "$(ROOT)" = "/" ] ;                         \
	then                                                                \
		echo "Error: 'root' is set to '' or '/' - cannot install!" ;\
	fi;

ulimit:	ulimit_look ulimit_check FRC
	@echo "ulimit check DONE"

ulimit_look: FRC
	sh $(IROOT)/ulimit_check

ulimit_check:	$(IROOT)/ulimit_ok FRC
	@echo 'ulimit ok!!'

cc_script1: FRC
	echo "\$$SGS/bin/cc	 					\
		-YS,\$$SGS/lib 						\
		-Yp,\$$SGS/lib 						\
		-Y0,\$$SGS/lib 						\
		-Y1,\$$SGS/lib 						\
		-Y2,\$$SGS/lib 						\
		-Y3,\$$SGS/lib 						\
		-Ya,\$$SGS/bin 						\
		-Yl,\$$SGS/bin 						\
		-YL,\$$SGS/lib 						\
		-YU,\$$SGS/usr/lib					\
		-YI,\$$SGS/usr/include \"\$$@\"" >> $(IROOT)/cc;	\
		chmod ugo+x $(IROOT)/cc

cc_script2: FRC
	echo "\$$SGS/bin/cc	 					\
		-YS,\$$SGS/lib 						\
		-Yp,\$$SGS/lib 						\
		-Y0,\$$SGS/lib 						\
		-Y1,\$$SGS/lib 						\
		-Y2,\$$SGS/lib 						\
		-Y3,\$$SGS/lib 						\
		-Ya,\$$SGS/bin 						\
		-Yl,\$$SGS/bin 						\
		-YL,\$$SGS/lib 						\
		-YU,\$$SGS/usr/lib					\
		-YI,\$$SGS/usr/include              \
		-0 \"\$$@\"" >> $(IROOT)/cc;	\
		chmod ugo+x $(IROOT)/cc

dirs:	$(DIR_SETUP) std_check FRC
	@-echo "Making install directories (dirs:)..."
	@-echo "==================== `date ` ==================="
	cd $(DIR_SETUP); $(MAKE) -$(MAKEFLAGS)f dir.mk install
	@-echo "DONE making dirs: ==== `date` ===="

devs:	std_check FRC
	@-echo "Making devices (devs:)..."
	@-echo "==================== `date ` ==================="
	cd $(DEV_SETUP); $(MAKE) -$(MAKEFLAGS)f dev.mk install
	@-echo "DONE making dev: ==== `date` ===="

tape020:
	$(MAKE)	-ief src.mk tape MACH=20

tape040:
	$(MAKE)	-ief src.mk tape MACH=40

tape:	ulimit std_check FRC
	@echo "Making tape: === `date` ==="
	@cd $(BUILD);                                                  \
	if [ -s system/stand/cmd/bootimage -a                          \
		-s $(SROOT)/release/r$(MACH).$(NEWDATE) -a             \
		-s $(SROOT)/release/u$(MACH).$(NEWDATE) ]  ;           \
	then                                                           \
	echo dd if=$(BUILD)/system/stand/cmd/bootimage of=$(NOREW);    \
	dd if=$(BUILD)/system/stand/cmd/bootimage of=$(NOREW) bs=128k; \
	echo dd if=$(SROOT)/release/r$(MACH).$(NEWDATE) of=$(NOREW);   \
	dd if=$(SROOT)/release/r$(MACH).$(NEWDATE) of=$(NOREW) bs=128k;\
	echo dd if=$(SROOT)/release/u$(MACH).$(NEWDATE) of=$(REW);     \
	dd if=$(SROOT)/release/u$(MACH).$(NEWDATE) of=$(REW) bs=128k;  \
	else                                                           \
		echo "the OS must be built before a tape can be made"; \
	fi
	@echo "DONE making M680$(MACH) tape: ===== `date` ======"

sectape020:
	$(MAKE)	-ief src.mk sectape MACH=20

sectape040:
	$(MAKE)	-ief src.mk sectape MACH=40

sectape:	ulimit std_check FRC
	@echo "Making sectape: === `date` ==="
	@cd $(BUILD);                                                       \
	if [ -s $(SROOT)/release/x$(MACH).$(NEWDATE) ] ;                    \
	then                                                                \
		echo '$(SEC_INSTALL)/INSTALL INSTALL bin bin -rwx------' |  \
	    	    $(IROOT)/maketape -T $(NEWDATE) -ovC131072 > $(NOREW) ; \
		dd if=$(SROOT)/release/x$(MACH).$(NEWDATE) of=$(REW) bs=128k; \
	else                                                                \
		echo "the security overlay has not been build";             \
	fi
	@echo "DONE making sectape: ===== `date` ======"

domtape:	ulimit std_check FRC
	@echo "Making domtape: === `date` ==="
	@cd $(BUILD);                                               \
	echo '$(DOM_INSTALL)/INSTALL INSTALL bin bin -rwx------' |  \
		$(IROOT)/maketape -T $(NEWDATE) -ovC131072 > $(NOREW) ;      \
	$(IROOT)/mkspec full util/dom_only > dom_spec;              \
	cat dom_spec | $(IROOT)/maketape -T$(NEWDATE) -ovC131072 >           \
		$(SROOT)/release/d.$(NEWDATE);                       \
	dd if=$(SROOT)/release/d.$(NEWDATE) of=$(REW) bs=128k;       \
	echo "DONE making domtape: ===== `date` ======"

sgstape:	ulimit std_check sgsname FRC
		cd $(BUILD);						\
		if [ -s $(SROOT)/release/s2.$(NEWDATE) ];		\
		then							\
		(							\
	echo '$(SGS_INSTALL)/INSTALL INSTALL bin bin -rwx------';	\
	echo /tmp/cross_sgs.name cross_sgs.name bin bin -rwx------;	\
		) |							\
		$(IROOT)/maketape -T $(NEWDATE) -ovC131072 > $(NOREW);	\
		dd if=$(SROOT)/release/s2.$(NEWDATE) of=$(REW) bs=128k;	\
		else							\
			echo "The sgs must be built first.";		\
		fi
		rm -f /tmp/cross_sgs.name

sgsname:        FRC
		echo "System 5/ANSI SGS release $(RELEASE)" > 		\
			/tmp/cross_sgs.name

sgs:
	@-echo "=========== Making sgs : `date` ==================="
	$(MAKE) -$(MAKEFLAGS)f src.mk sgs1 > nohup.sgs1F 2>&1
	$(MAKE) -$(MAKEFLAGS)f src.mk sgs2 > nohup.sgs2F 2>&1
	@-echo "=========== DONE making sgs : `date` =============="

sgs1:	ulimit std_check clobberall sgsdef1 dir_dev1 includes1 \
	sgsbins1 cc1 sgsdef2 libs1 FRC
	$(MAKE) -$(MAKEFLAGS)f src.mk sgssave extract ONETWO=1
	@-echo "DONE making  sgs1: ==== `date` ===="

sgs2:	ulimit std_check clobber sgsdef3 cc2 FRC
	@-echo "Starting build of release sgs : `date`"
	$(MAKE) -$(MAKEFLAGS)f src.mk sgsbins2 & WAIT_IDX=$$!; \
	$(MAKE) -$(MAKEFLAGS)f src.mk libs2 & WAIT_IDY=$$!; \
	echo "Waiting for release sgs to finish building..."; \
	wait $$WAIT_IDX; \
	wait $$WAIT_IDY
	$(MAKE) -$(MAKEFLAGS)f src.mk sgssave extract ONETWO=2>nohup.sgs2S 2>&1
	@-echo "========= DONE making sgs2 : `date` ==========="

binsave:	ulimit std_check sgsspec bin_spec
		cd $(BUILD);                                      \
		cat bin_spec | $(IROOT)/maketape -T$(NEWDATE) -ovC131072 > \
			$(SROOT)/release/b$(NEWDATE)
		@-echo "DONE making binsave : ==== `date` ===="

libsave:	ulimit std_check sgsspec lib_spec
		cd $(BUILD);                                      \
		cat lib_spec | $(IROOT)/maketape -T$(NEWDATE) -ovC131072 > \
			$(SROOT)/release/l$(NEWDATE)
		@-echo "DONE making libsave : ==== `date` ===="

incsave:	ulimit std_check includespec
		cd $(BUILD);                                      \
		cat inc_spec | $(IROOT)/maketape -T$(NEWDATE) -ovC131072 > \
			$(SROOT)/release/I$(NEWDATE)
		@-echo "DONE making incsave : ==== `date` ===="

includespec:	ulimit std_check sgsspec FRC
		cd $(BUILD);\
		grep '.h' sgs_spec > inc_spec
		@-echo "DONE making includespec : ==== `date` ===="

bin_spec:	ulimit std_check FRC
		cd $(BUILD);\
		grep -v '.\.' sgs_spec > bin_spec
		@-echo "DONE making bin_spec : ==== `date` ===="

lib_spec:	ulimit std_check FRC
		cd $(BUILD);\
		grep '.\.' sgs_spec | grep -v '.h' > lib_spec
		@-echo "DONE making lib_spec : ==== `date` ===="

FRC:
