#ident	"@(#)puts.c	25.1	12/2/91 Copyright (c) 1991 by Arix Corp."
/*	Copyright (c) 1984 AT&T	*/
/*	  All Rights Reserved  	*/

/*	THIS IS UNPUBLISHED PROPRIETARY SOURCE CODE OF AT&T	*/
/*	The copyright notice above does not evidence any   	*/
/*	actual or intended publication of such source code.	*/

#include <stdio.h>
#include "_stdio.h"
#include <string.h>

extern int puts(char *ptr)
{
	char *p;
	register int ndone = 0, n; 
	register unsigned char *cptr, *bufend;

	if (_WRTCHK(stdout))
		return (EOF);

	bufend = _bufend(stdout);

	for ( ; ; ptr += n) {
		while ((n = bufend - (cptr = stdout->_ptr)) <= 0) /* full buf */
			if (_xflsbuf(stdout) == EOF)
				return(EOF);
#ifdef _ANSI 
		if ((p = _memccpy(cptr, ptr, '\0', n)) != NULL)
#else
		if ((p = memccpy(cptr, ptr, '\0', n)) != NULL)
#endif /* _ANSI */
			n = p - (char *) cptr;
		stdout->_cnt -= n;
		stdout->_ptr += n;
		_BUFSYNC(stdout);
		ndone += n;
		if (p != NULL) {
			stdout->_ptr[-1] = '\n'; /* overwrite '\0' with '\n' */
			if (stdout->_flag & (_IONBF | _IOLBF)) /* flush line */
				if (_xflsbuf(stdout) == EOF)
					return(EOF);
			return(ndone);
		}
	}
}
