#	START NEW ARIX SCCS HEADER
#
#	@(#) mach.mk: version 23.1 created on 11/15/90 at 13:39:48
#
#	Copyright (c) 1990 by Arix Corporation
#	All Rights Reserved
#
#	@(#)mach.mk	23.1	11/15/90 Copyright (c) 1990 by Arix Corporation
#
#	END NEW ARIX SCCS HEADER
#
#	dmach.mk	
#	ATT: ident	"vi:port/makefile.usg	1.36"

#	Makefile for vi

#ident	"@(#)vi/mach:mach.mk	23.1"

include	$(IROOT)/macdefs

# Posix binary
SVID_FLAG=

BINDIR = $(ROOT)/usr/bin

LIBDIR	= $(ROOT)/usr/lib
EX	= ex

# dux#1 - modified to run under install.  
# Dependency on usr/src/cmd/lib/libcurses/screen/term.h
# INSINC = $(ROOT)/usr/include		
INSINC = $(INCRT)

LINC = ../local
VERSION = SVR3.1
OPTIONS = -DBIGVI -DUSG -DSTDIO -DLISP -DCHDIR $(DOPTIONS)
TERMLIB = -lgen $(DTERMLIB) -lcurses -lsec

# DEBUGFLAGS = -DTRACE -g
DEBUGFLAGS =

LOCAL_CFLAGS = $(DEBUGFLAGS) -I$(LINC) $(OPTIONS) -DTABS=8 -DSINGLE
LOCAL_LIBS   = -lsec
SIZE = size

FOLD = ../misc/fold
CTAGS = ../misc/ctags
XSTR = ../misc/xstr
MKSTR = ../misc/mkstr
CXREF = ../misc/cxref

MAKEFILE = makefile.usg

MAINS = ex expreserve exrecover

OBJECTS =  bcopy.o ex.o ex_addr.o ex_cmds.o ex_cmds2.o \
	ex_cmdsub.o ex_data.o ex_extern.o ex_get.o \
	ex_io.o ex_put.o ex_re.o ex_set.o ex_subr.o \
	ex_temp.o ex_tty.o ex_unix.o ex_v.o ex_vadj.o \
	ex_vget.o ex_vmain.o ex_voper.o ex_vops.o \
	ex_vops2.o ex_vops3.o ex_vput.o ex_vwind.o \
	printf.o strings.o  expreserve.o exrecover.o

TEMPS = x.c xs.c strings

SOURCES =  bcopy.c ex.c ex_addr.c ex_cmds.c ex_cmds2.c \
	ex_cmdsub.c ex_data.c ex_extern.c ex_get.c \
	ex_io.c ex_put.c ex_re.c ex_set.c ex_subr.c \
	ex_temp.c ex_tty.c ex_unix.c ex_v.c ex_vadj.c \
	ex_vget.c ex_vmain.c ex_voper.c ex_vops.c \
	ex_vops2.c ex_vops3.c ex_vput.c ex_vwind.c \
	printf.c exrecover.c expreserve.c


MISC = READ_ME makeoptions asfix.c70 ex.news makefile.370 makefile.c70 \
	makefile.70 ovdoprnt.s ovprintf.c rofix

ALL:		$(MAINS) 

ex:		bcopy.o ex.o ex_addr.o ex_cmds.o ex_cmds2.o \
		ex_cmdsub.o ex_data.o ex_extern.o ex_get.o \
		ex_io.o ex_put.o ex_re.o ex_set.o ex_subr.o \
		ex_temp.o ex_tty.o ex_unix.o ex_v.o ex_vadj.o \
		ex_vget.o ex_vmain.o ex_voper.o ex_vops.o \
		ex_vops2.o ex_vops3.o ex_vput.o ex_vwind.o \
		printf.o strings.o
	$(CC) -o ex  bcopy.o ex.o ex_addr.o ex_cmds.o ex_cmds2.o \
	ex_cmdsub.o ex_data.o ex_extern.o ex_get.o \
	ex_io.o ex_put.o ex_re.o ex_set.o ex_subr.o \
	ex_temp.o ex_tty.o ex_unix.o ex_v.o ex_vadj.o \
	ex_vget.o ex_vmain.o ex_voper.o ex_vops.o \
	ex_vops2.o ex_vops3.o ex_vput.o ex_vwind.o \
	printf.o strings.o  $(LDFLAGS) $(TERMLIB) $(LOCAL_LIBS)

.c.o:
	${MKSTR} - exstrings x $*.c
	${CC} -E ${CFLAGS} x$*.c | ${XSTR} -c -
	rm -f x$*.c
	${CC} ${CFLAGS} -c x.c
	mv x.o $*.o

expreserve:	expreserve.o 
	$(CC) -s  expreserve.o  -o expreserve -lgen  $(LDFLAGS) -lsec 

exrecover:	exrecover.o 
	$(CC) -s  -o exrecover exrecover.o ex_extern.o -lgen $(DTERMLIB) $(LDFLAGS) -lsec 

bcopy.o:	bcopy.c
	$(CC) -c  $(CFLAGS) bcopy.c

ex.o:		 ex.h $(INCRT)/sys/types.h $(INCRT)/ctype.h \
		 $(INCRT)/errno.h $(INCRT)/signal.h $(INCRT)/setjmp.h \
		 $(INCRT)/sys/stat.h $(INCRT)/termio.h $(INCRT)/sys/termio.h \
		 $(INSINC)/term.h ex_tune.h $(LINC)/uparm.h ex_vars.h \
		 ex_argv.h ex_temp.h ex_tty.h 

ex_addr.o:	 ex.h $(INCRT)/sys/types.h $(INCRT)/ctype.h \
		 $(INCRT)/errno.h $(INCRT)/signal.h \
		 $(INCRT)/setjmp.h $(INCRT)/sys/stat.h \
		 $(INCRT)/termio.h $(INCRT)/sys/termio.h \
		 $(INSINC)/term.h ex_tune.h $(LINC)/uparm.h ex_vars.h \
		 ex_re.h

ex_cmds.o:	 ex.h $(INCRT)/sys/types.h $(INCRT)/ctype.h \
		 $(INCRT)/errno.h $(INCRT)/signal.h \
		 $(INCRT)/setjmp.h $(INCRT)/sys/stat.h \
		 $(INCRT)/termio.h $(INCRT)/sys/termio.h \
		 $(INSINC)/term.h ex_tune.h $(LINC)/uparm.h ex_vars.h \
		 ex_argv.h ex_temp.h ex_tty.h ex_vis.h 

ex_cmds2.o:	 ex.h $(INCRT)/sys/types.h $(INCRT)/ctype.h \
		 $(INCRT)/errno.h $(INCRT)/signal.h \
		 $(INCRT)/setjmp.h $(INCRT)/sys/stat.h \
		 $(INCRT)/termio.h $(INCRT)/sys/termio.h \
		 $(INSINC)/term.h ex_tune.h $(LINC)/uparm.h ex_vars.h \
		 ex_argv.h ex_temp.h ex_tty.h ex_vis.h 

ex_cmdsub.o:	 ex.h $(INCRT)/sys/types.h $(INCRT)/ctype.h \
		 $(INCRT)/errno.h $(INCRT)/signal.h \
		 $(INCRT)/setjmp.h $(INCRT)/sys/stat.h \
		 $(INCRT)/termio.h $(INCRT)/sys/termio.h \
		 $(INSINC)/term.h ex_tune.h $(LINC)/uparm.h ex_vars.h \
		 ex_argv.h ex_temp.h ex_tty.h ex_vis.h $(INCRT)/stdio.h 

ex_data.o:	 ex.h $(INCRT)/sys/types.h $(INCRT)/ctype.h \
		 $(INCRT)/errno.h $(INCRT)/signal.h \
		 $(INCRT)/setjmp.h $(INCRT)/sys/stat.h \
		 $(INCRT)/termio.h $(INCRT)/sys/termio.h \
		 $(INSINC)/term.h ex_tune.h $(LINC)/uparm.h \
		 ex_vars.h ex_tty.h 

ex_extern.o:	 ex.h $(INCRT)/sys/types.h $(INCRT)/ctype.h \
		 $(INCRT)/errno.h $(INCRT)/signal.h \
		 $(INCRT)/setjmp.h $(INCRT)/sys/stat.h \
		 $(INCRT)/termio.h $(INCRT)/sys/termio.h \
		 $(INSINC)/term.h ex_tune.h $(LINC)/uparm.h ex_vars.h \
		 ex_argv.h ex_re.h ex_temp.h ex_tty.h ex_vis.h 

ex_get.o:	 ex.h $(INCRT)/sys/types.h $(INCRT)/ctype.h \
		 $(INCRT)/errno.h $(INCRT)/signal.h \
		 $(INCRT)/setjmp.h $(INCRT)/sys/stat.h \
		 $(INCRT)/termio.h $(INCRT)/sys/termio.h \
		 $(INSINC)/term.h ex_tune.h $(LINC)/uparm.h \
	 	 ex_vars.h ex_tty.h 

ex_io.o:	 ex.h $(INCRT)/sys/types.h $(INCRT)/ctype.h \
		 $(INCRT)/errno.h $(INCRT)/signal.h \
		 $(INCRT)/setjmp.h $(INCRT)/sys/stat.h \
		 $(INCRT)/termio.h $(INCRT)/sys/termio.h \
		 $(INSINC)/term.h ex_tune.h $(LINC)/uparm.h ex_vars.h \
		 ex_argv.h ex_temp.h ex_tty.h ex_vis.h 

ex_put.o:	 ex.h $(INCRT)/sys/types.h $(INCRT)/ctype.h \
		 $(INCRT)/errno.h $(INCRT)/signal.h \
		 $(INCRT)/setjmp.h $(INCRT)/sys/stat.h \
		 $(INCRT)/termio.h $(INCRT)/sys/termio.h \
		 $(INSINC)/term.h ex_tune.h $(LINC)/uparm.h \
		 ex_vars.h ex_tty.h ex_vis.h 

ex_re.o:	 ex.h $(INCRT)/sys/types.h $(INCRT)/ctype.h \
		 $(INCRT)/errno.h $(INCRT)/signal.h \
		 $(INCRT)/setjmp.h $(INCRT)/sys/stat.h \
		 $(INCRT)/termio.h $(INCRT)/sys/termio.h \
		 $(INSINC)/term.h ex_tune.h $(LINC)/uparm.h \
		 ex_vars.h ex_re.h 

ex_set.o:	 ex.h $(INCRT)/sys/types.h $(INCRT)/ctype.h \
		 $(INCRT)/errno.h $(INCRT)/signal.h \
		 $(INCRT)/setjmp.h $(INCRT)/sys/stat.h \
		 $(INCRT)/termio.h $(INCRT)/sys/termio.h \
		 $(INSINC)/term.h ex_tune.h $(LINC)/uparm.h \
		 ex_vars.h ex_temp.h ex_tty.h 

ex_subr.o:	 ex.h $(INCRT)/sys/types.h $(INCRT)/ctype.h \
		 $(INCRT)/errno.h $(INCRT)/signal.h \
		 $(INCRT)/setjmp.h $(INCRT)/sys/stat.h \
		 $(INCRT)/termio.h $(INCRT)/sys/termio.h \
		 $(INSINC)/term.h ex_tune.h $(LINC)/uparm.h \
		 ex_vars.h ex_re.h ex_tty.h ex_vis.h 

ex_temp.o:	 ex.h $(INCRT)/sys/types.h $(INCRT)/ctype.h \
		 $(INCRT)/errno.h $(INCRT)/signal.h \
		 $(INCRT)/setjmp.h $(INCRT)/sys/stat.h \
		 $(INCRT)/termio.h $(INCRT)/sys/termio.h \
		 $(INSINC)/term.h ex_tune.h $(LINC)/uparm.h \
		 ex_vars.h ex_temp.h ex_vis.h ex_tty.h 

ex_tty.o:	 ex.h $(INCRT)/sys/types.h $(INCRT)/ctype.h \
		 $(INCRT)/errno.h $(INCRT)/signal.h \
		 $(INCRT)/setjmp.h $(INCRT)/sys/stat.h \
		 $(INCRT)/termio.h $(INCRT)/sys/termio.h \
		 $(INSINC)/term.h ex_tune.h $(LINC)/uparm.h \
		 ex_vars.h ex_tty.h 

ex_unix.o:	 ex.h $(INCRT)/sys/types.h $(INCRT)/ctype.h \
		 $(INCRT)/errno.h $(INCRT)/signal.h \
		 $(INCRT)/setjmp.h $(INCRT)/sys/stat.h \
		 $(INCRT)/termio.h $(INCRT)/sys/termio.h \
		 $(INSINC)/term.h ex_tune.h $(LINC)/uparm.h \
		 ex_vars.h ex_temp.h ex_tty.h ex_vis.h 

ex_v.o:		 ex.h $(INCRT)/sys/types.h $(INCRT)/ctype.h \
		 $(INCRT)/errno.h $(INCRT)/signal.h \
		 $(INCRT)/setjmp.h $(INCRT)/sys/stat.h \
		 $(INCRT)/termio.h $(INCRT)/sys/termio.h \
		 $(INSINC)/term.h ex_tune.h $(LINC)/uparm.h \
		 ex_vars.h ex_re.h ex_tty.h ex_vis.h 

ex_vadj.o:	 ex.h $(INCRT)/sys/types.h $(INCRT)/ctype.h \
		 $(INCRT)/errno.h $(INCRT)/signal.h \
		 $(INCRT)/setjmp.h $(INCRT)/sys/stat.h \
		 $(INCRT)/termio.h $(INCRT)/sys/termio.h \
		 $(INSINC)/term.h ex_tune.h $(LINC)/uparm.h \
		 ex_vars.h ex_tty.h ex_vis.h 

ex_vget.o:	 ex.h $(INCRT)/sys/types.h $(INCRT)/ctype.h \
		 $(INCRT)/errno.h $(INCRT)/signal.h \
		 $(INCRT)/setjmp.h $(INCRT)/sys/stat.h \
		 $(INCRT)/termio.h $(INCRT)/sys/termio.h \
		 $(INSINC)/term.h ex_tune.h $(LINC)/uparm.h \
		 ex_vars.h ex_tty.h ex_vis.h 

ex_vmain.o:	 ex.h $(INCRT)/sys/types.h $(INCRT)/ctype.h \
		 $(INCRT)/errno.h $(INCRT)/signal.h \
		 $(INCRT)/setjmp.h $(INCRT)/sys/stat.h \
		 $(INCRT)/termio.h $(INCRT)/sys/termio.h \
		 $(INSINC)/term.h ex_tune.h $(LINC)/uparm.h \
		 ex_vars.h ex_tty.h ex_vis.h 

ex_voper.o:	 ex.h $(INCRT)/sys/types.h $(INCRT)/ctype.h \
		 $(INCRT)/errno.h $(INCRT)/signal.h \
		 $(INCRT)/setjmp.h $(INCRT)/sys/stat.h \
		 $(INCRT)/termio.h $(INCRT)/sys/termio.h \
		 $(INSINC)/term.h ex_tune.h $(LINC)/uparm.h \
		 ex_vars.h ex_tty.h ex_vis.h 

ex_vops.o:	 ex.h $(INCRT)/sys/types.h $(INCRT)/ctype.h \
		 $(INCRT)/errno.h $(INCRT)/signal.h \
		 $(INCRT)/setjmp.h $(INCRT)/sys/stat.h \
		 $(INCRT)/termio.h $(INCRT)/sys/termio.h \
		 $(INSINC)/term.h ex_tune.h $(LINC)/uparm.h \
		 ex_vars.h ex_tty.h ex_vis.h 

ex_vops2.o:	 ex.h $(INCRT)/sys/types.h $(INCRT)/ctype.h \
		 $(INCRT)/errno.h $(INCRT)/signal.h \
		 $(INCRT)/setjmp.h $(INCRT)/sys/stat.h \
		 $(INCRT)/termio.h $(INCRT)/sys/termio.h \
		 $(INSINC)/term.h ex_tune.h $(LINC)/uparm.h \
		 ex_vars.h ex_tty.h ex_vis.h 

ex_vops3.o:	 ex.h $(INCRT)/sys/types.h $(INCRT)/ctype.h \
		 $(INCRT)/errno.h $(INCRT)/signal.h \
		 $(INCRT)/setjmp.h $(INCRT)/sys/stat.h \
		 $(INCRT)/termio.h $(INCRT)/sys/termio.h \
		 $(INSINC)/term.h ex_tune.h $(LINC)/uparm.h \
		 ex_vars.h ex_tty.h ex_vis.h 

ex_vput.o:	 ex.h $(INCRT)/sys/types.h $(INCRT)/ctype.h \
		 $(INCRT)/errno.h $(INCRT)/signal.h \
		 $(INCRT)/setjmp.h $(INCRT)/sys/stat.h \
		 $(INCRT)/termio.h $(INCRT)/sys/termio.h \
		 $(INSINC)/term.h ex_tune.h $(LINC)/uparm.h \
		 ex_vars.h ex_tty.h ex_vis.h 

ex_vwind.o:	 ex.h $(INCRT)/sys/types.h $(INCRT)/ctype.h \
		 $(INCRT)/errno.h $(INCRT)/signal.h \
		 $(INCRT)/setjmp.h $(INCRT)/sys/stat.h \
		 $(INCRT)/termio.h $(INCRT)/sys/termio.h \
		 $(INSINC)/term.h ex_tune.h $(LINC)/uparm.h \
		 ex_vars.h ex_tty.h ex_vis.h 

expreserve.o:	 $(INCRT)/stdio.h $(INCRT)/ctype.h \
		 $(INCRT)/sys/types.h $(INCRT)/sys/stat.h \
		 $(INCRT)/sys/fs/s5dir.h $(INCRT)/pwd.h $(LINC)/uparm.h 
		$(CC) $(CFLAGS) -c expreserve.c 

exrecover.o:	 $(INCRT)/stdio.h ex.h $(INCRT)/sys/types.h \
		 $(INCRT)/ctype.h $(INCRT)/errno.h \
		 $(INCRT)/signal.h $(INCRT)/setjmp.h \
		 $(INCRT)/sys/stat.h $(INCRT)/termio.h \
		 $(INCRT)/sys/termio.h $(INSINC)/term.h ex_tune.h \
		 $(LINC)/uparm.h ex_vars.h ex_temp.h ex_tty.h \
		 $(LINC)/uparm.h $(INCRT)/sys/fs/s5dir.h 
		$(CC) $(CFLAGS) -c exrecover.c 

printf.o:	 $(INCRT)/varargs.h	

strings.o:	strings
	${XSTR}
	${CC} -S xs.c
	ed - <rofix xs.s
	$(CC) -c xs.s
	mv xs.o strings.o
	rm xs.s

GLOBALINCS = $(LINC)/uparm.h $(INCRT)/ctype.h $(INCRT)/errno.h \
	$(INCRT)/pwd.h $(INCRT)/setjmp.h $(INCRT)/signal.h \
	$(INCRT)/stdio.h $(INCRT)/sys/fs/s5dir.h $(INCRT)/sys/stat.h \
	$(INCRT)/sys/termio.h $(INCRT)/sys/types.h \
	$(INSINC)/term.h $(INCRT)/termio.h $(INCRT)/varargs.h 

LOCALINCS = ex.h ex_argv.h ex_re.h ex_temp.h ex_tty.h ex_tune.h ex_vars.h \
	ex_vis.h

clean:
	rm -f $(OBJECTS) $(TEMPS)

clobber:
	rm -f $(OBJECTS) $(MAINS) $(LIBMAIN) $(TEMPS) expreserve \
		exstrings exrecover dex dexrecover dexpreserve \
		dexstrings

all : ALL

install:
	-rm -f ${BINDIR}/ex ${BINDIR}/vi ${BINDIR}/view \
	       ${BINDIR}/edit ${BINDIR}/vedit
	if [ -s dex ]; \
	then \
		$(INS) dex ${BINDIR}/dex; \
		chmod 1755 ${BINDIR}/dex; \
		chown root $(BINDIR)/dex; \
		chgrp bin $(BINDIR)/dex; \
		$(INS) dexstrings ${LIBDIR}/dexstrings; \
		chmod 644 $(LIBDIR)/dexstrings; \
		chown bin $(LIBDIR)/dexstrings; \
		chgrp bin $(LIBDIR)/dexstrings; \
		$(INS) dexrecover ${LIBDIR}/dexrecover; \
		chmod 4755 $(LIBDIR)/dexrecover; \
		chown root $(LIBDIR)/dexrecover; \
		chgrp bin $(LIBDIR)/dexrecover; \
		$(INS) dexpreserve ${LIBDIR}/dexpreserve; \
		chmod 4755 $(LIBDIR)/dexpreserve; \
		chown root $(LIBDIR)/dexpreserve; \
		chgrp bin $(LIBDIR)/dexpreserve; \
		ln ${BINDIR}/dex ${BINDIR}/dedit; \
		ln ${BINDIR}/dex ${BINDIR}/dvi; \
		ln ${BINDIR}/dex ${BINDIR}/dview; \
		ln ${BINDIR}/dex ${BINDIR}/dvedit; \
	fi
	$(INS) ex ${BINDIR}/ex 
	chmod 1755 $(BINDIR)/ex
	chown root $(BINDIR)/ex
	chgrp bin $(BINDIR)/ex
	$(INS) exstrings ${LIBDIR}/exstrings 
	chmod 644 $(LIBDIR)/exstrings 
	chown bin $(LIBDIR)/exstrings 
	chgrp bin $(LIBDIR)/exstrings 
	$(INS) exrecover ${LIBDIR}/exrecover 
	chmod 4755 $(LIBDIR)/exrecover 
	chown root $(LIBDIR)/exrecover 
	chgrp bin $(LIBDIR)/exrecover 
	$(INS) expreserve ${LIBDIR}/expreserve 
	chmod 4755 $(LIBDIR)/expreserve 
	chown root $(LIBDIR)/expreserve 
	chgrp bin $(LIBDIR)/expreserve 
	ln ${BINDIR}/ex ${BINDIR}/edit
	ln ${BINDIR}/ex ${BINDIR}/vi
	ln ${BINDIR}/ex ${BINDIR}/view
	ln ${BINDIR}/ex ${BINDIR}/vedit
	@if [ ! -s $(ROOT)/usr/preserve ]; \
	then \
		mkdir $(ROOT)/usr/preserve; \
	fi
	chmod 777 $(ROOT)/usr/preserve
	chgrp bin $(ROOT)/usr/preserve
	chown bin $(ROOT)/usr/preserve
	touch $(NEWDATE) $(ROOT)/usr/preserve

#	These targets are useful but optional

partslist:
	@echo $(MAKEFILE) $(SOURCES) $(LOCALINCS)  |  tr ' ' '\012'  |  sort

productdir:
	@echo $(DIR) | tr ' ' '\012' | sort

product:
	@echo $(MAINS)  |  tr ' ' '\012'  | \
	sed 's;^;$(DIR)/;'
	@echo $(LIBMAIN)  |  tr ' ' '\012'  | \
	sed 's;^;$(LIBDIR)/;'

srcaudit:
	@fileaudit $(MAKEFILE) $(LOCALINCS) $(SOURCES) $(MISC) -o $(OBJECTS) $(MAINS) $(LIBMAIN)

ctags:
	@-if [ "$(SOURCE)" = "" ] ;\
	then 					\
	echo " usage: $(MAKE) -$(MAKEFLAGS)f b.mk ctags SOURCE=utility_name" ;\
	else				\
	ctags	$(SOURCE)	;\
	echo 'grep $$* \\' > greplist 	;\
	for i in $(SOURCE)  /dev/null	;\
	do 				\
	echo "$$i \\" >> greplist	;\
	done 				;\
	echo /dev/null >> greplist	;\
	chmod +x greplist		;\
	fi
