#	START NEW ARIX SCCS HEADER
#
#	@(#) uucp.mk: version 25.1 created on 12/2/91 at 18:16:23
#
#	Copyright (c) 1990 by Arix Corporation
#	All Rights Reserved
#
#	@(#)uucp.mk	25.1	12/2/91 Copyright (c) 1990 by Arix Corporation
#
#	END NEW ARIX SCCS HEADER
#
#	Copyrigt (c) 1984 AT&T
#	  All Rights Reserved

#	THIS IS UNPUBLISHED PROPRIETARY SOURCE CODE OF AT&T
#	The copyright notice above does not evidence any
#	actual or intended publication of such source code.

#	ATT:#ident	"uucp:uucp.mk	2.17"

#ident	"@(#)uucp:uucp.mk	25.1"

include $(IROOT)/macdefs

#
# ***************************************************************
# *	Copyright (c) 1984 AT&T Technologies, Inc.		*
# *                 All Rights Reserved				*
# *	THIS IS UNPUBLISHED PROPRIETARY SOURCE			*
# *	CODE OF AT&T TECHNOLOGIES, INC.				*
# *	The copyright notice above does not			*
# *	evidence any actual or intended				*
# *	publication of such source code.			*
# ***************************************************************
#

#	/*  11/45, 11/70, and VAX version ('-i' has no effect on VAX)	*/
#	/* for 11/23, 11/34 (without separate I/D), IFLAG= */
#
#	CFLAGS:
#	-DSMALL is use on small machine (3B2).
#	It reduces debugging statements in the object code.
#
#	${S5CFLAGS} is an environment variable set for the
#	SAFARI V build.  It MUST have a value of "-Ml", 
#	which specifies that the "large model" should be used
#	for compiling and linking.


#	NOTE - when UNETLIB is to be used, define UNET in parms.h
# add eio.o to PROTOCOLS below
# UNETLIB = -lunet
#	NOTE - when TCP is defined in parms.h
# add eio.o to PROTOCOLS below
#	NOTE - when DKLIB is to be used, define DATAKIT in parms.h
# add dio.o to PROTOCOLS below
# DKLIB = -ldk
# 	NOTE - some sites use -lbtl for compatibility
# BTLLIB = -lbtl 
#	NOTE - when TLI is defined in parms.h
# add eio.o to PROTOCOLS below
TLILIB = -lnsl_s

# PROTOCOLS= dio.o	# for datakit
# PROTOCOLS =  		# if no datakit and no unet
PROTOCOLS = eio.o	# TCP, TLI, or unet, no datakit

LIBS= ${BTLLIB} ${DKLIB} ${UNETLIB} ${TLILIB} -lsec

# some versions of unix don't have strpbrk in libc
# STRPBRK = strpbrk.o
# STRPBRKSRC = strpbrk.c
# Use my getopt until the argument gobbling is fixed!

# use this on systems that don't have getopt() in libc
# GETOPT = getopt.o
# GETOPTSRC = getopt.c

# BSD can't compile uugetty -- remove next line for BSD
UUGETTY=uugetty

OWNER=uucp
GRP=daemon
BIN=$(ROOT)/usr/bin
INSDIR=$(ROOT)/usr/lib/uucp
UPATH=.
# The a.out files go to ODIR
ODIR=.

# INS=cpset
# If you system does not have "cpset"
# use the one in the uucp source directory and use the
#  next INS=../uucp/Cpset line instead of the INS=cpset line above.
# INS=../uucp/Cpset

# OLD=-o will create OLDname when install is executed before copy.

# if you change these directories, change them in uucp.h as well

SPOOL=$(ROOT)/usr/spool
LOCKS=$(ROOT)/usr/spool/locks
PUBDIR=$(ROOT)/usr/spool/uucppublic
UUCPDIR=$(ROOT)/usr/spool/uucp
#		things are linked from UUCPDIR into XQTDIR and CORRUPT
XQTDIR=	$(UUCPDIR)/.Xqtdir
#		this is optional
CORRUPT=$(UUCPDIR)/.Corrupt
#		for logfiles
LOGDIR=$(UUCPDIR)/.Log
#		for sequence number files
SEQDIR=$(UUCPDIR)/.Sequence
#		for STST files
STATDIR=$(UUCPDIR)/.Status
LOGUUCP=$(LOGDIR)/uucp
LOGUUX=$(LOGDIR)/uux
LOGUUXQT=$(LOGDIR)/uuxqt
LOGCICO=$(LOGDIR)/uucico
WORKSPACE=$(UUCPDIR)/.Workspace
ADMIN=$(UUCPDIR)/.Admin
#		for saving old log files
OLDLOG=$(UUCPDIR)/.Old
#		maximum number of uuxqts at one file in this file
MAXUUXQTS=$(INSDIR)/Maxuuxqts

#		Maximum number of uuscheds at one time
MAXUUSCHEDS=$(INSDIR)/Maxuuscheds

CLEAN=
LINTOP=
COMMANDS=uucp uux uuxqt uucico uusched
TOOLS=uuname uucheck uustat uucleanup $(UUGETTY)
OFILES=utility.o cpmv.o expfile.o gename.o getpwinfo.o \
	ulockf.o xqt.o logent.o versys.o gnamef.o systat.o \
	sysfiles.o strsave.o $(GETOPT)
LFILES=utility.c cpmv.c expfile.c gename.c getpwinfo.c \
	ulockf.c xqt.c logent.c versys.c gnamef.c systat.c \
	sysfiles.c strsave.c $(GETOPTSRC)
OUUCP=uucpdefs.o uucp.o gwd.o permission.o getargs.o uucpname.o\
	versys.o gtcfile.o $(STRPBRK) chremdir.o mailst.o
LUUCP=uucpdefs.c uucp.c gwd.c permission.c getargs.c uucpname.c\
	versys.c gtcfile.c $(STRPBRKSRC) chremdir.c mailst.c
OUUX=uucpdefs.o uux.o gwd.o permission.o getargs.o getprm.o\
	uucpname.o versys.o gtcfile.o chremdir.o $(STRPBRK)
LUUX=uucpdefs.c uux.c gwd.c permission.c getargs.c getprm.c\
	uucpname.c versys.c gtcfile.c chremdir.c $(STRPBRKSRC)
OUUXQT=uucpdefs.o uuxqt.o mailst.o getprm.o gnamef.o uucpname.o \
	permission.o getargs.o gtcfile.o $(STRPBRK) \
	shio.o chremdir.o
LUUXQT=uucpdefs.c uuxqt.c mailst.c getprm.c gnamef.c uucpname.c \
	permission.c getargs.c gtcfile.c $(STRPBRKSRC) \
	shio.c chremdir.c
OUUCICO=uucpdefs.o cico.o conn.o callers.o cntrl.o pk0.o pk1.o \
	gio.o xio.o anlwrk.o permission.o getargs.o gnamef.o \
	gnxseq.o pkdefs.o imsg.o gtcfile.o \
	mailst.o uucpname.o line.o chremdir.o \
	interface.o statlog.o strecpy.o stoa.o push.o\
	$(STRPBRK) $(PROTOCOLS)
LUUCICO=uucpdefs.c cico.c conn.c callers.c cntrl.c pk0.c pk1.c \
	gio.c xio.c anlwrk.c permission.c getargs.c gnamef.c \
	gnxseq.c pkdefs.c imsg.c gtcfile.c \
	mailst.c uucpname.c line.c chremdir.c \
	interface.c statlog.c strecpy.c stoa.c \
	$(STRPBRKSRC) eio.c dio.c push.c
OUUNAME=uuname.o uucpname.o uucpdefs.o getpwinfo.o sysfiles.o strsave.o
LUUNAME=uuname.c uucpname.c uucpdefs.c getpwinfo.c sysfiles.c strsave.c
OUUSTAT=uustat.o gnamef.o expfile.o uucpdefs.o getpwinfo.o ulockf.o getargs.o \
	utility.o uucpname.o versys.o strsave.o sysfiles.o $(STRPBRK) 
LUUSTAT=uustat.c gnamef.c expfile.c uucpdefs.c getpwinfo.c ulockf.c getargs.c \
	utility.c uucpname.c versys.c strsave.c sysfiles.c $(STRPBRKSRC) 
OUUSCHED=uusched.o gnamef.o expfile.o uucpdefs.o getpwinfo.o ulockf.o \
	systat.o getargs.o utility.o
LUUSCHED=uusched.c gnamef.c expfile.c uucpdefs.c getpwinfo.c ulockf.c \
	systat.c getargs.c utility.c
OUUCLEANUP=uucleanup.o gnamef.o expfile.o uucpdefs.o getpwinfo.o \
	uucpname.o ulockf.o getargs.o cpmv.o utility.o
LUUCLEANUP=uucleanup.c gnamef.c expfile.c uucpdefs.c getpwinfo.c \
	uucpname.c ulockf.c getargs.c cpmv.c utility.c
OUUGETTY=uugetty.o ulockf.o uucpdefs.o 
LUUGETTY=uugetty.c ulockf.c uucpdefs.c 

SOURCE= \
anlwrk.c       getopt.c       mailst.c       sysfiles.c     uuname.c \
callers.c      getprm.c       parms.h        sysfiles.h     uusched.c \
chremdir.c     getpwinfo.c    permission.c   systat.c       uustat.c \
cico.c         gio.c          pk.h           ulockf.c       uux.c \
cntrl.c        gnamef.c       pk0.c          utility.c      uuxqt.c \
conn.c         gnxseq.c       pk1.c          uucheck.c      versys.c \
cpmv.c         gtcfile.c      pkdefs.c       uucleanup.c    xio.c \
dio.c          gwd.c          shio.c         uucp.c         xqt.c \
eio.c          imsg.c         statlog.c      uucp.h \
expfile.c      interface.c    strecpy.c      uucpdefs.c \
gename.c       line.c         strpbrk.c      uucpname.c \
getargs.c      logent.c       strsave.c      stoa.c	uugetty.c push.c

INIT=init

all:	$(INIT) $(COMMANDS) $(TOOLS) 

install:	mkdirs all shells cp

shells:
	#	For cross environment, copy default files

	/bin/cp Devices Dialers Systems Permissions Poll Dialcodes $(ROOT)/usr/lib/uucp/
	ROOT=$(ROOT) /bin/sh SetUp
	echo 5 > $(MAXUUXQTS)
	echo 2 > $(MAXUUSCHEDS)
	-chown $(OWNER) $(MAXUUXQTS)
	-chmod 444 $(MAXUUXQTS)
	-chgrp $(GRP) $(MAXUUXQTS)
	-chown $(OWNER) $(MAXUUSCHEDS)
	-chmod 444 $(MAXUUSCHEDS)
	-chgrp $(GRP) $(MAXUUSCHEDS)

	$(INS) uudemon.poll $(INSDIR)/uudemon.poll
	chmod 555 $(INSDIR)/uudemon.poll
	chown $(OWNER) $(INSDIR)/uudemon.poll
	chgrp $(GRP) $(INSDIR)/uudemon.poll

	$(INS) uudemon.clea $(INSDIR)/uudemon.cleanu
	chmod 555 $(INSDIR)/uudemon.cleanu
	chown $(OWNER) $(INSDIR)/uudemon.cleanu
	chgrp $(GRP) $(INSDIR)/uudemon.cleanu

	$(INS) uudemon.hour $(INSDIR)/uudemon.hour
	chmod 555 $(INSDIR)/uudemon.hour
	chown $(OWNER) $(INSDIR)/uudemon.hour
	chgrp $(GRP) $(INSDIR)/uudemon.hour

	$(INS) uudemon.admi $(INSDIR)/uudemon.admin
	chmod 555 $(INSDIR)/uudemon.admin
	chown $(OWNER) $(INSDIR)/uudemon.admin
	chgrp $(GRP) $(INSDIR)/uudemon.admin

	$(INS) remote.unkno $(INSDIR)/remote.unknown
	chmod 555 $(INSDIR)/remote.unknown 
	chown $(OWNER) $(INSDIR)/remote.unknown 
	chgrp $(GRP) $(INSDIR)/remote.unknown 

	$(INS) Uutry $(INSDIR)/Uutry
	chmod 555 $(INSDIR)/Uutry 
	chown $(OWNER) $(INSDIR)/Uutry 
	chgrp $(GRP) $(INSDIR)/Uutry 

	$(INS) SetUp $(INSDIR)/SetUp
	chmod 555 $(INSDIR)/SetUp 
	chown $(OWNER) $(INSDIR)/SetUp 
	chgrp $(GRP) $(INSDIR)/SetUp 

	$(INS) uulog $(BIN)/uulog
	chmod 555 $(BIN)/uulog 
	chown $(OWNER) $(BIN)/uulog 
	chgrp $(GRP) $(BIN)/uulog 

	$(INS) uuto $(BIN)/uuto
	chmod 555 $(BIN)/uuto 
	chown $(OWNER) $(BIN)/uuto 
	chgrp $(GRP) $(BIN)/uuto 

	$(INS) uupick $(BIN)/uupick
	chmod 555 $(BIN)/uupick 
	chown $(OWNER) $(BIN)/uupick 
	chgrp $(GRP) $(BIN)/uupick 

	if [ -z "$(ROOT)" -o "$(ROOT)" = "/" ]; then ./uucheck; fi

cp:	all 
	$(INS) uuname $(BIN)/uuname
	chmod 4111 $(BIN)/uuname 
	chown $(OWNER) $(BIN)/uuname 
	chgrp $(GRP) $(BIN)/uuname 

	$(INS) uucp $(BIN)/uucp
	chmod 4111 $(BIN)/uucp 
	chown $(OWNER) $(BIN)/uucp 
	chgrp $(GRP) $(BIN)/uucp 

	$(INS) uux $(BIN)/uux
	chmod 4111 $(BIN)/uux 
	chown $(OWNER) $(BIN)/uux 
	chgrp $(GRP) $(BIN)/uux 

	$(INS) uustat $(BIN)/uustat
	chmod 4111 $(BIN)/uustat 
	chown $(OWNER) $(BIN)/uustat 
	chgrp $(GRP) $(BIN)/uustat 

	$(INS) uuxqt $(INSDIR)/uuxqt
	chmod 4111 $(INSDIR)/uuxqt 
	chown $(OWNER) $(INSDIR)/uuxqt 
	chgrp $(GRP) $(INSDIR)/uuxqt 

	$(INS) uucico $(INSDIR)/uucico
	chmod 4111 $(INSDIR)/uucico 
	chown $(OWNER) $(INSDIR)/uucico 
	chgrp $(GRP) $(INSDIR)/uucico 

	$(INS) uusched $(INSDIR)/uusched
	chmod 4111 $(INSDIR)/uusched 
	chown $(OWNER) $(INSDIR)/uusched 
	chgrp $(GRP) $(INSDIR)/uusched 

	$(INS) uugetty $(INSDIR)/uugetty
	chmod 111 $(INSDIR)/uugetty 
	chown $(OWNER) $(INSDIR)/uugetty 
	chgrp $(GRP) $(INSDIR)/uugetty 

# uucheck should only be run by root or uucp administrator
# uucleanup should only be run by root or uucp administrator
	$(INS) uucheck $(INSDIR)/uucheck
	chmod 110 $(INSDIR)/uucheck 
	chown $(OWNER) $(INSDIR)/uucheck 
	chgrp $(GRP) $(INSDIR)/uucheck 

	$(INS) uucleanup $(INSDIR)/uucleanup
	chmod 110 $(INSDIR)/uucleanup 
	chown $(OWNER) $(INSDIR)/uucleanup 
	chgrp $(GRP) $(INSDIR)/uucleanup 

init:	anlwrk.o permission.o cpmv.o expfile.o gename.o \
	getargs.o getprm.o getpwinfo.o gnamef.o \
	gnxseq.o gwd.o imsg.o logent.o \
	mailst.o shio.o \
	systat.o ulockf.o uucpname.o versys.o xqt.o

uucp:	$(OUUCP) $(OFILES)
	$(CC) $(OUUCP) $(OFILES) $(LIBS) -o $(ODIR)/uucp $(LDFLAGS)

uux:	$(OUUX) $(OFILES)
	$(CC) $(OUUX)  $(OFILES) $(LIBS) -o $(ODIR)/uux  $(LDFLAGS)

uuxqt:	$(OUUXQT) $(OFILES)
	$(CC) $(OUUXQT) $(OFILES) $(LIBS) -o $(ODIR)/uuxqt $(LDFLAGS)

uucico:	$(OUUCICO) $(OFILES)
	$(CC) $(OUUCICO) $(OFILES) $(LIBS) -o $(ODIR)/uucico $(LDFLAGS)

uuname:	$(OUUNAME)
	$(CC) $(OUUNAME) $(LIBS) -o $(ODIR)/uuname $(LDFLAGS)

uustat:	$(OUUSTAT) $(GETOPT)
	$(CC) $(OUUSTAT) $(GETOPT) $(LIBS) -o $(ODIR)/uustat $(LDFLAGS)
 
uucleanup:	$(OUUCLEANUP) $(GETOPT)
	$(CC) $(OUUCLEANUP) $(GETOPT) $(LIBS) -o $(ODIR)/uucleanup $(LDFLAGS)
 
uusched:	$(OUUSCHED) $(GETOPT)
	$(CC) $(OUUSCHED) $(GETOPT) $(LIBS) -o $(ODIR)/uusched $(LDFLAGS)
 
uucheck:	uucheck.o uucpname.o $(GETOPT)
	$(CC) uucheck.o uucpname.o $(GETOPT) $(LIBS) -o $(ODIR)/uucheck $(LDFLAGS)
 
uugetty:	$(OUUGETTY)
	$(CC) $(OUUGETTY) -o $(ODIR)/uugetty $(LDFLAGS)
 
uugetty.o:	uugetty.c 
	$(CC) $(CFLAGS) -c  uugetty.c

uucheck.o:	permission.c

sysfiles.o:	sysfiles.h

utility.o permission.o cico.o conn.o callers.o cpmv.o\
	anlwrk.o cntrl.o expfile.o gename.o\
	getpwinfo.o gio.o xio.o gnamef.o gnxseq.o gwd.o imsg.o ioctl.o\
	logent.o mailst.o sdmail.o line.o shio.o\
	systat.o ulockf.o uucpdefs.o uucpname.o uuname.o\
	uucleanup.o uucheck.o uusched.o  uucp.o uustat.o dio.o \
	uux.o uuxqt.o versys.o xqt.o interface.o statlog.o push.o \
	strecpy.o:	uucp.h parms.h

mkdirs:
	-if [ ! -d $(SPOOL) ] ;\
	then \
		mkdir $(SPOOL); \
	fi
	-chmod 775 $(SPOOL)
	-chgrp bin $(SPOOL)
	-chown root $(SPOOL)
	-if [ ! -d $(INSDIR) ] ;\
	then \
		mkdir $(INSDIR); \
	fi
	-chmod 755 $(INSDIR)
	-chown $(OWNER) $(INSDIR)
	-chgrp $(GRP) $(INSDIR)
	-if [ ! -d $(UUCPDIR) ] ;\
	then \
		mkdir $(UUCPDIR); \
	fi
	-chmod 777 $(UUCPDIR)
	-chown $(OWNER) $(UUCPDIR)
	-chgrp $(GRP) $(UUCPDIR)
	-if [ ! -d $(PUBDIR) ] ;\
	then \
		mkdir $(PUBDIR); \
	fi
	-chmod 777 $(PUBDIR)
	-chown $(OWNER) $(PUBDIR)
	-chgrp $(GRP) $(PUBDIR)
	-if [ ! -d $(XQTDIR) ] ;\
	then \
		mkdir $(XQTDIR); \
	fi
	-chmod 777 $(XQTDIR)
	-chown $(OWNER) $(XQTDIR)
	-chgrp $(GRP) $(XQTDIR)
	-if [ ! -d $(CORRUPT) ] ;\
	then \
		mkdir $(CORRUPT); \
	fi
	-chmod 777 $(CORRUPT)
	-chown $(OWNER) $(CORRUPT)
	-chgrp $(GRP) $(CORRUPT)
	-if [ ! -d $(LOGDIR) ] ;\
	then \
		mkdir $(LOGDIR); \
	fi
	-chmod 777 $(LOGDIR)
	-chown $(OWNER) $(LOGDIR)
	-chgrp $(GRP) $(LOGDIR)
	-if [ ! -d $(SEQDIR) ] ;\
	then \
		mkdir $(SEQDIR); \
	fi
	-chmod 777 $(SEQDIR)
	-chown $(OWNER) $(SEQDIR)
	-chgrp $(GRP) $(SEQDIR)
	-if [ ! -d $(STATDIR) ] ;\
	then \
		mkdir $(STATDIR); \
	fi
	-chmod 777 $(STATDIR)
	-chown $(OWNER) $(STATDIR)
	-chgrp $(GRP) $(STATDIR)
	-if [ ! -d $(LOGUUCP) ] ;\
	then \
		mkdir $(LOGUUCP); \
	fi
	-chmod 777 $(LOGUUCP)
	-chown $(OWNER) $(LOGUUCP)
	-chgrp $(GRP) $(LOGUUCP)
	-if [ ! -d $(LOGUUX) ] ;\
	then \
		mkdir $(LOGUUX); \
	fi
	-chmod 777 $(LOGUUX)
	-chown $(OWNER) $(LOGUUX)
	-chgrp $(GRP) $(LOGUUX)
	-if [ ! -d $(LOGUUXQT) ] ;\
	then \
		mkdir $(LOGUUXQT); \
	fi
	-chmod 777 $(LOGUUXQT)
	-chown $(OWNER) $(LOGUUXQT)
	-chgrp $(GRP) $(LOGUUXQT)
	-if [ ! -d $(LOGCICO) ] ;\
	then \
		mkdir $(LOGCICO); \
	fi
	-chmod 777 $(LOGCICO)
	-chown $(OWNER) $(LOGCICO)
	-chgrp $(GRP) $(LOGCICO)
	-if [ ! -d $(WORKSPACE) ] ;\
	then \
		mkdir $(WORKSPACE); \
	fi
	-chmod 777 $(WORKSPACE)
	-chown $(OWNER) $(WORKSPACE)
	-chgrp $(GRP) $(WORKSPACE)
	-if [ ! -d $(LOCKS) ] ;\
	then \
		mkdir $(LOCKS); \
	fi
	-chmod 755 $(LOCKS)
	-chown $(OWNER) $(LOCKS)
	-chgrp $(GRP) $(LOCKS)
	-if [ ! -d $(ADMIN) ] ;\
	then \
		mkdir $(ADMIN); \
	fi
	-chmod 777 $(ADMIN)
	-chown $(OWNER) $(ADMIN)
	-chgrp $(GRP) $(ADMIN)
	-if [ ! -d $(OLDLOG) ] ;\
	then \
		mkdir $(OLDLOG); \
	fi
	-chmod 777 $(OLDLOG)
	-chown $(OWNER) $(OLDLOG)
	-chgrp $(GRP) $(OLDLOG)

ctags:
	ctags	$(SOURCE)
	echo 'grep $$* \\' > greplist
	for i in $(SOURCE)		;\
	do echo "$$i \\" >> greplist	;\
	done
	echo /dev/null >> greplist
	chmod +x greplist

clean:
	-rm -f *.o

clobber:	clean
	-rm -f $(COMMANDS) $(TOOLS) tags greplist
