#	START NEW ARIX SCCS HEADER
#
#	@(#) tplot.mk: version 25.1 created on 12/2/91 at 18:10:35
#
#	Copyright (c) 1990 by Arix Corporation
#	All Rights Reserved
#
#	@(#)tplot.mk	25.1	12/2/91 Copyright (c) 1990 by Arix Corporation
#
#	END NEW ARIX SCCS HEADER
#
#	Copyright (c) 1984 AT&T
#	  All Rights Reserved

#	THIS IS UNPUBLISHED PROPRIETARY SOURCE CODE OF AT&T
#	The copyright notice above does not evidence any
#	actual or intended publication of such source code.
#	ATT: ident	"tplot:tplot.mk	1.8"
#	tplot make file

#ident	"@(#)tplot:tplot.mk	25.1"

include	$(IROOT)/macdefs

OL = $(ROOT)
SL = $(ROOT)/usr/src/cmd
INSDIR = $(OL)/usr/bin
INSLIB = $(OL)/usr/lib
RDIR = $(SL)/tplot
REL = current
LIST = lp
IFLAG = -i
SOURCE = banner.c driver.c tplot.sh vplot.c

all: t4014 t300 t300s t450 vplot tplot

t4014: driver.o
	$(CC) $(CFLAGS) $(VERS)  -o t4014 driver.o -l4014 -lm $(LDFLAGS)

t300:	driver.o
	$(CC) $(CFLAGS) $(VERS)  -o t300 driver.o -l300 -lm $(LDFLAGS)

t300s: driver.o
	$(CC) $(CFLAGS) $(VERS)  -o t300s driver.o -l300s -lm $(LDFLAGS)

t450:	driver.o
	$(CC) $(CFLAGS) $(VERS)  -o t450 driver.o -l450 -lm $(LDFLAGS)

vplot:	vplot.o banner.o
	$(CC) $(CFLAGS) $(VERS)  -o vplot vplot.o banner.o $(LDFLAGS)

tplot:	tplot.sh
	cp tplot.sh tplot

install: all
	$(INS) t4014 $(INSLIB)/t4014 
	chmod 755 $(INSLIB)/t4014
	chown bin $(INSLIB)/t4014
	chgrp bin $(INSLIB)/t4014
#
	$(INS) t300 $(INSLIB)/t300 
	chmod 755 $(INSLIB)/t300
	chown bin $(INSLIB)/t300
	chgrp bin $(INSLIB)/t300
#
	$(INS) t300s $(INSLIB)/t300s 
	chmod 755 $(INSLIB)/t300s
	chown bin $(INSLIB)/t300s
	chgrp bin $(INSLIB)/t300s
#
	$(INS) t450 $(INSLIB)/t450 
	chmod 755 $(INSLIB)/t450
	chown bin $(INSLIB)/t450
	chgrp bin $(INSLIB)/t450
#
	$(INS) vplot $(INSLIB)/vplot 
	chmod 755 $(INSLIB)/vplot
	chown bin $(INSLIB)/vplot
	chgrp bin $(INSLIB)/vplot
#
	$(INS) tplot $(INSDIR)/tplot 
	chmod 755 $(INSDIR)/tplot
	chown bin $(INSDIR)/tplot
	chgrp bin $(INSDIR)/tplot


build:	bldmk
	get -p -r`gsid tplot current` s.tplot.src $(REWIRE) | ntar -d $(RDIR) -g

bldmk:
	get -p -r`gsid tplot.mk current` s.tplot.mk > $(RDIR)/tplot.mk

listing:
	pr tplot.mk $(SOURCE) | $(LIST)

listmk:
	pr tplot.mk | $(LIST)

edit:
	get -e -p s.tplot.src | ntar -g

delta:
	ntar -p $(SOURCE) > tplot.src
	delta s.tplot.src
	rm -f $(SOURCE)

mkedit:  ;  get -e s.tplot.mk
mkdelta: ;  delta s.tplot.mk

clean:
	 -rm -f *.o

clobber: clean
	 -rm -f t4014 t300 t300s t450 vplot tplot greplist tags

delete:	clobber
	-rm -f $(SOURCE)

ctags:
	@-if [ "$(SOURCE)" = "" ] ;\
	then 					\
	echo " usage: $(MAKE) -$(MAKEFLAGS)f b.mk ctags SOURCE=utility_name" ;\
	else				\
	ctags	$(SOURCE)	;\
	echo 'grep $$* \\' > greplist 	;\
	for i in $(SOURCE)  /dev/null	;\
	do 				\
	echo "$$i \\" >> greplist	;\
	done 				;\
	echo /dev/null >> greplist	;\
	chmod +x greplist		;\
	fi


