/*	START NEW ARIX SCCS HEADER			*/
/*							*/
/*	@(#) tension.c: version 25.1 created on 12/2/91 at 18:08:56	*/
/*							*/
/*	Copyright (c) 1990 by Arix Corporation		*/
/*	All Rights Reserved				*/
/*							*/
#ident	"@(#)tension.c	25.1	12/2/91 Copyright (c) 1990 by Arix Corporation"
/*							*/
/*	END NEW ARIX SCCS HEADER			*/
/*							*/

/*
 * tension/erase
 *
 *	tension/erase an archive tape.
 *
 *	tension and erase should be the same program linked to each other.
 *
 */

/*	kd0	kelly	tension/erase now exits immediately if device 
 *			specified is not a cartridge tape drive device
 */

#include <stdio.h>
#include <string.h>
#include <fcntl.h>
#include <sys/ioctl.h>

/* these two should be picked out of the mfs ioctl.h, but just in case */
#ifndef ERASE
#define ERASE	0x8
#endif
#ifndef TENSION
#define TENSION	0x7
#endif

#define	TAPE	2		/* kd0 */

extern int	errno;
extern char	*sys_errlist[];

char	*usage = "%s [cartridge_tape_device_name]\n";
char	*operation;
int	progname;

main(argc,argv)
int	argc;
char	*argv[];
{
	int	fd, arg, mode, type;
	char	*device;

	/*
	 * decide if this program was called as tension or erase.
	 * set operation and progname accordingly
	 */

	getname(argv[0]);

	switch ( argc ) {
	case  1:
		/* no args, default to /dev/rmt1 */
		device = "/dev/rmt1";
		break;
	case  2:
		device = argv[1];
		break;
	default:

		fprintf(stderr,"%s: too many arguments\n%s\n", argv[0], usage);
		exit(1);
	}

	printf("Opening %s\n", device);

	/* erase must open for writing */
	mode = progname == TENSION ? O_RDONLY : O_RDWR;

	if ( (fd = open(device, mode)) == -1 ) {
		fprintf(stderr,"%s: can't open %s (%s)\n", argv[0], device,
		  sys_errlist[errno]);
		fprintf(stderr,usage, argv[0]);
		exit(fd);
	}

	if ( ioctl(fd, PERGET, &type) == -1 ) 	/* kd0 */
	{
		fprintf(stderr, "Initial ioctl failed (%s)\n",
			sys_errlist[errno]);
		close(fd);
		exit(-1);
	}
	else
	{
		if (type != TAPE)
		{
			fprintf(stderr,"%s: %s is not a cartridge tape device\n", 
				argv[0], device);
			fprintf(stderr, usage, argv[0]);
			close(fd);
			exit(-1);
		}
	}
		

	arg = REWIND;

	printf("Rewinding %s\n", device);

	if ( ioctl(fd, PERSET, &arg) == -1 ) {
		fprintf(stderr, "Rewind ioctl failed (%s)\n",
		  sys_errlist[errno]);
		close(fd);
		exit(-1);
	}

	printf("Starting %s of %s\n", operation, device);

	arg = progname;

	if ( ioctl(fd, PERSET, &arg) == -1 ) {
		fprintf(stderr, "%s ioctl failed (%s)\n",
		  operation, sys_errlist[errno]);
		close(fd);
		exit(-1);
	}

	printf("%s of %s complete\n", operation, device);

	exit(0);
}

/*
 * getname
 *
 *	check to see if the program was called as erase or tension.
 *	ignore leading path prefixes. 
 *
 *	set operation to point to a string containing "Erase" or "Tension"
 *	set progname to TENSION or ERASE
 */

getname(name)
char	*name;
{
	char	*p;

	if ( (p = strrchr(name, '/')) == NULL )
		p = name;
	else
		p++;	/* point p at trailing path component */

	
	if ( strcmp(p, "tension") == 0 ) {
		operation = "Tension";
		progname = TENSION;
	}
	else if ( strcmp(p, "erase") == 0 ) {
		operation = "Erase";
		progname = ERASE;
	}
	else {
		fprintf(stderr,
		  "Program must be named either tension or erase\n");
		exit(-1);
	}
}
