/*	START NEW ARIX SCCS HEADER			*/
/*							*/
/*	@(#) drv.c: version 25.1 created on 12/2/91 at 18:08:05	*/
/*							*/
/*	Copyright (c) 1990 by Arix Corporation		*/
/*	All Rights Reserved				*/
/*							*/
#ident	"@(#)drv.c	25.1	12/2/91 Copyright (c) 1990 by Arix Corporation"
/*							*/
/*	END NEW ARIX SCCS HEADER			*/
/*							*/

#include <sys/fs/s5dir.h>
#include <fcntl.h>
#include "in_data.h"

#define nodup(inp)	(inp)->in_nodup = 1

extern int	debugflag, ncntrl;
extern int	errno;
extern char	sys_errlist[];
extern char	*mr;
struct direct *nextdir();
extern char	*strcpy(), *strncpy(), *strchr(), *strrchr(), *memset();
extern void	die(), exit_msg();

char		*driver_funcs[] = {
#define DF_INIT			0
	"init",
#define DF_START		1
	"start",
#define DF_POWER		2
	"power",
#define DF_OPEN			3
	"open",
#define DF_CLOSE		4
	"close",
#define DF_READ			5
	"read",
#define DF_WRITE		6
	"write",
#define DF_IOCTL		7
	"ioctl",
#define DF_STRATEGY		8
	"strategy",
#define DF_PRINT		9
	"print",
	NULL
};
int debugflag;

get_drv(name, prefix)
	char *name, *prefix;
{
	int nfuncs;

	while( (nfuncs = next_driver(name, prefix)) == NULL );
	if ( nfuncs == EOF )
		return(NULL);
	return(1);
}

/*
 *	next_driver gets the next driver name and prefix.
 *	returns number of functions defined
 */
int
next_driver(name, prefix)
	char *name, *prefix;
{
	char		path[100];
	struct direct 	*dp;
	char		funcs[10];
	int		i, j;
	static int	first = 1;

	if (first) {
		dp = nextdir(mr) ;
		first--;
	}
	else
		dp = nextdir(NULL);
	if (dp == NULL)
		return(EOF);
	memset(funcs, 0, sizeof(funcs));
	strcpy(name,dp->d_name);
	sprintf(path, "%s/%s", mr, name);
	get_master(path, funcs, prefix);
	for ( i=j=0 ; driver_funcs[i] ; i++ ) 
		if ( funcs[i] ) 
			j++;
	return(j);
}

/*
 *	nextdir() : return next filename in directory
 * 	if dirname is not NULL, opens dirname and returns first filename.
 *	if dirname is NULL, it returns next filename in the current directory.
 */

struct direct *
nextdir(dirname)
char	*dirname;
{
	static struct direct	dent = { 0 };
	static int		dummy = 0;
	static int		fd = -1;
	int			rv;

	if (dirname != NULL) {
		if (fd >= 0)
			(void) close(fd);
		if ((fd = open(dirname, O_RDONLY)) < 0) {
			err(NULL, "getdir: cannot open %s (%s)",
				dirname, sys_errlist[errno]);
			return (NULL);
		}
	}
	else if (fd < 0)
		return (NULL);

	/*
	 * read the directory
	 */
	while ((rv = read(fd, (char *)&dent, sizeof(dent))) == sizeof(dent)) 
		if (dent.d_ino != 0 && *dent.d_name != '.')
			return (&dent);
	if (rv != 0)
		exit_msg(NULL, "getdir: Read error in %s", dirname);

        close(fd);
	fd = -1;
	return (NULL);
}


/*
 * get_master -- opens and parses the named master file in the master dir
 */

get_master(file,funcs, prefix)
char	*file, *funcs, *prefix;
{
	register in_t	*inp;
	in_t		input;
	register int	req, drvfile;
	char		word[MAXLEN];
	static char	*master_sections[] = {	/* master file sections	*/
		"%DRIVER",
		NULL
	};

	if (debugflag)
		printf("get_master: %s\n", file);
	inp = &input;
	openfile(inp, file);

	while (findword(inp, word) != EOF) {
		if (debugflag)
			printf("parse_driver : word = %s\n",word);
		switch (selectlist(word, master_sections)) {
		case 0:		/* %DRIVER */
			parse_driver(inp, funcs, prefix);
			break;
		default:
			if (*word == '%') {
				parse_skipsect(inp);
				break;
			}
			err(inp, "Not a master section header: '%s'", word);
		}
	}

	fclose(inp->in_fp);
	return (req);
}


/*
 * parse_skipsect -- skip a section, paying no attention to its contents
 */

parse_skipsect(inp)
register in_t	*inp;
{
	char	word[MAXLEN];

	if (debugflag)
		printf("parse_skipsect: %s\n", inp->in_filename);

	while (nextline(inp) == 0)
		if (nextword(inp, word) == 0 && *word == '%') {
			ungetline(inp);			/* unget this line */
			return;				/* next section header*/
		}

	inp->in_ptr = NULL;				/* EOF: zap last line */
}


/*
 * parse_driver -- parse the driver section of a master file
 *	Format:
 *		Name:		driver_name
 *		Funcs:		[major_number . . .]
 *		(all other fields ignored)
 *
 */

parse_driver(inp,funcs, prefix)
register in_t	*inp;
register char 	*funcs, *prefix;
{
	register int		i, req, lreq, editdrv;
	register char		*a;
	char			word[MAXLEN];
	char			array[DSIZE];
	static char		*driver_fields[] = {
		"Prefix:",
		"Funcs:",
		NULL
	};

	if (debugflag)
		printf("parse_driver: %s\n", inp->in_filename);

	a = array;
	memset(a, 0, NEL(array));
	req = lreq = editdrv = 0;

	while (findcmd(inp, word) == 0) 
		switch (selectlist(word, driver_fields)) {
		case 0:		/* Prefix: */
			if (nextword(inp, word))
				err(inp, "Missing prefix name from Prefix:");
			strcpy(prefix, word);
			funcs[0] = 1;	/* JAS all drivers will now have an
					 * open. */
		CASE 1:		/* Funcs: */
			funcs[0] = 1;	/* JAS all drivers will now have an
					 * open. */
		}
}


/*
 * nextline -- get the next line of input, returns EOF or 0
 */

nextline(inp)
register in_t	*inp;
{
	if (fgets(inp->in_buf, (int)sizeof(inp->in_buf), inp->in_fp) == NULL) {
		inp->in_ptr = NULL;			/* EOF: zap last line */
		return (EOF);
	}
	++inp->in_lineno;
	inp->in_ptr = inp->in_buf;
	strcpy(inp->in_dup, inp->in_buf);		/* copy line */
	inp->in_nodup = 0;
	return (0);
}
void
error(string,arg1,arg2,arg3)
char	*string;
{
	char buffer[256];

	sprintf( buffer, string, arg1, arg2, arg3 );
	fprintf(stderr, "%s: %s\n", progname, buffer);
}

void
exit_msg(string,arg1,arg2,arg3)
char	*string;
{
	error(string,arg1,arg2,arg3);
	die(1);
}

void
die(n)
	int n;
{
	exit(n);
}
