#	START NEW ARIX SCCS HEADER
#
#	@(#) stty.mk: version 25.1 created on 12/2/91 at 18:06:39
#
#	Copyright (c) 1990 by Arix Corporation
#	All Rights Reserved
#
#	@(#)stty.mk	25.1	12/2/91 Copyright (c) 1990 by Arix Corporation
#
#	END NEW ARIX SCCS HEADER
#
#	Copyright (c) 1984 AT&T
#	  All Rights Reserved

#	THIS IS UNPUBLISHED PROPRIETARY SOURCE CODE OF AT&T
#	The copyright notice above does not evidence any
#	actual or intended publication of such source code.
#	ATT: ident	"stty:stty.mk	1.2"

#ident	"@(#)stty:stty.mk	25.1"
#	Makefile for stty 

include	$(IROOT)/macdefs

# This is a posix binary.  Turn off the SVID flag
SVID_FLAG=

DIR = $(ROOT)/bin

INC = $(ROOT)/usr/include

SIZE = size

MAKEFILE = stty.mk

MAINS = stty

OBJECTS =  stty.o

SOURCES =  stty.c

ALL:		$(MAINS)

all : ALL

install: ALL
	$(INS) stty $(DIR)/stty
	chmod 755 $(DIR)/stty
	chgrp bin $(DIR)/stty
	chown bin $(DIR)/stty

stty:	stty.o
	$(CC) $(CFLAGS) -o stty stty.o $(LDFLAGS)

stty.o:		 $(INCRT)/stdio.h \
		 $(INCRT)/sys/types.h \
		 $(INCRT)/sys/termio.h \
		 $(INCRT)/sys/stermio.h 

GLOBALINCS = $(INCRT)/stdio.h \
	$(INCRT)/sys/stermio.h \
	$(INCRT)/sys/termio.h \
	$(INCRT)/sys/types.h 


clean:
	rm -f $(OBJECTS)

clobber: clean
	rm -f $(MAINS) greplist tags

newmakefile:
	makefile -m -f $(MAKEFILE)  -s INC $(INC)
#bottom#

size: ALL
	$(SIZE) $(MAINS)

strip: ALL
	$(STRIP) $(MAINS)

#	These targets are useful but optional

partslist:
	@echo $(MAKEFILE) $(SOURCES) $(LOCALINCS)  |  tr ' ' '\012'  |  sort

productdir:
	@echo $(DIR) | tr ' ' '\012' | sort

product:
	@echo $(MAINS)  |  tr ' ' '\012'  | \
	sed 's;^;$(DIR)/;'

srcaudit:
	@fileaudit $(MAKEFILE) $(LOCALINCS) $(SOURCES) -o $(OBJECTS) $(MAINS)

ctags:	
	ctags	$(SOURCES)
	echo 'grep $$* \\' > greplist
	for i in $(SOURCES)	;\
	do echo "$$i \\"	;\
	done >> greplist
	echo /dev/null >> greplist
	chmod +x greplist

