
/*	START NEW ARIX SCCS HEADER			*/
/*							*/
/*	@(#) stripe.c: version 23.1 created on 11/15/90 at 13:26:26	*/
/*							*/
/*	Copyright (c) 1990 by Arix Corporation		*/
/*	All Rights Reserved				*/
/*							*/
#ident	"@(#)stripe.c	23.1	11/15/90 Copyright (c) 1990 by Arix Corporation"
/*							*/
/*	END NEW ARIX SCCS HEADER			*/
/*							*/
/*
 *
 *	stripe - common source for S90 and A1000
 *
 *	make sure to include S3000 define if make is a S90 make
 *	absence of this define calls out a A1000 verion
 *
 *	10/20/89 - wp0 -  delete ioctl GET_NUM_TRACKS
 *		   calculate from disk size and cylinder size
 *		   needed for scsi support
 *	10/20/89 - wp1 - add -t option
 *			 user supplied track size
 *
 *	JPC 001	 - Fixed several bugs and made various changes to make
 *		   stripe pass lint.  Keep it that way.
 */
#include <stdio.h>
#include <string.h>
#include <errno.h>
#include <fcntl.h>
#include <sys/types.h>
#include <sys/stat.h>
#include <sys/sysmacros.h>
#include <sys/ioctl.h>
#include <sys/buf.h>
#include <sys/vd.h>

#define	M_PROMPT	1
#define M_FILE		2

#define S_MAKE		0
#define S_DISPLAY	1
#define S_DELETE	2

extern int	errno, sys_nerr;		/* JPC 001 */
extern char 	*sys_errlist[];

extern void	exit(), perror();		/* JPC 001 */
extern char	*strdup();

vd_t vdisk;

struct dev_desc {
	int controller;
	int disk;
	int slice;
} ;

char		*prog_name;

char 		*getstring();
void		gettrksz();

int	vd_fd,
	mode = 0,
	min_tracks = 1000000;

FILE	*config_file;

char 	*string = 0;
char	*filename = 0;
int 	cmd_arg = S_MAKE, verbose = 0;
int	asktrack = 0;
int	dsksize;
int 	ntracks;


/*VARARGS1*/		/* JPC 001 */
errprt(fmt, a, b, c, d)
char	*fmt;
{
	int	err_num = errno;

	fprintf(stderr, "%s : ", prog_name);
	fprintf(stderr, fmt, a, b, c, d);
        if (err_num > 0 && err_num < sys_nerr)
		fprintf(stderr, " (%s)\n", sys_errlist[err_num]);
	else if (err_num)
		fprintf(stderr, " (error number %d)\n", err_num);
	else
		fputc('\n', stderr);
}

main(argc,argv)
	int argc; char *argv[];
{
	extern	char	*optarg;
	int	c;
	int 	uncool = 0;
	int 	strdirty = 0;

	setbuf(stdout,(char *)0);
	setbuf(stderr,(char *)0);
	prog_name = argv[0];

	while ((c = getopt(argc, argv, "tvo:d:f:s:i:")) != -1) {
		switch(c) {
			case 'v' :
				verbose++;
				break;
			case 'f' :
				mode = M_FILE;
				if (strdirty)
					uncool = 1;
				filename = optarg;
				strdirty = 1;
				break;
			case 'o' :
				cmd_arg = S_MAKE;
				if (strdirty)
					uncool = 1;
				string = optarg;
				strdirty = 1;
				break;
			case 's' :
			case 'i' :
				cmd_arg = S_DISPLAY;
				if (strdirty)
					uncool = 1;
				string = optarg;
				strdirty = 1;
				break;
			case 'd' :
				cmd_arg = S_DELETE;
				if (strdirty)
					uncool = 1;
				string = optarg;
				strdirty = 1;
				break;
			case 't' :
				asktrack = 1;
				break;
			default :
				uncool++;
		}
	}
	if (uncool) {
fprintf(stderr,"usage: %s [-f filename] [{-s | -d | -o} vdisk]\n",prog_name);
fprintf(stderr,"where: -s vdisk  -  show stripe information for vdisk\n");
fprintf(stderr,"       -d vdisk  -  delete an existing stripe vdisk\n");
fprintf(stderr,"       -o vdisk  -  open or configure a new stripe vdisk\n");
fprintf(stderr,"       -t vdisk  -  user define stripe size\n");
fprintf(stderr,"       No arguments defaults to -o and prompts for vdisk name\n");
		return (1);
	}

	switch (cmd_arg) {
	
	case S_MAKE:
		makevd();
		break;
	case S_DISPLAY:
		showvd();
		break;
	case S_DELETE:
		clearvd();
		break;
	default:
		errprt("Unknown Command\n");
	}
	return (0);
}

/*VARARGS1*/		/* JPC 001 */
prompt(fmt, a, b, c)
char	*fmt;
{
	if (mode == M_PROMPT)
		printf(fmt, a, b, c);
}

makevd()
{
	int 	i, uncool = 0;

	if ( mode == M_FILE ) {
		if ((config_file = fopen(filename,"r")) == NULL) {
			printf("%s : cannot open config file %s\n",
				prog_name,filename);
			exit (1);
		}
	}
	else
		mode = M_PROMPT;
	prompt("\nStriped Disk Configuration\n\n");
	getvd();
	/*
	**	get v_num_stripe_components
	*/
	uncool = 1;
	do {
		prompt("\nNumber of Stripe Components -> ");
		string = getstring();
		vdisk.v_num_stripe_components = i = atoi(string);
		if (i > 0 && i <= MAX_STRIPE_COMPONENTS)
			uncool = 0;
		else {
			printf("'%s' invalid : valid numbers are 1-%d\n",
				string,MAX_STRIPE_COMPONENTS);
			if (mode != M_PROMPT) {
				printf("%s : invalid specification, aborting\n",
					prog_name );
				exit (1);
			}
		}
	} while (uncool);
	/*
	**	get data for each stripe and calculate s_track_size and s_size
	*/
	for (i = 0; i < vdisk.v_num_stripe_components; ++i) {
		uncool = 1;
		do {
			prompt("Name of character device for stripe %d -> ",i);
			string = getstring();
			uncool = getstripe(&vdisk.v_sd[i],string) ||
				 dupdev(&vdisk,i);
			if (uncool && mode != M_PROMPT)
				exit (1);

			if (uncool == 0 && asktrack == 1) {
				gettrksz (&vdisk.v_sd[i], i);
			}
			if (uncool == 0) {
				ntracks = dsksize / vdisk.v_sd[i].s_track_size;
				if (ntracks < min_tracks)
					min_tracks = ntracks;
			}

		} while (uncool);

		vdisk.v_cyl_size += vdisk.v_sd[i].s_track_size;
	}
	vdisk.v_size = min_tracks * vdisk.v_cyl_size;
	if (verbose)
		dump_vdisk(&vdisk);
	if ((ioctl(vd_fd,SET_VIRT_DISK,&vdisk)) == -1) {
		perror("ioctl to set virtual disk failed");
		exit (1);
	}
}

#ifdef	S3000
showvd()
{
	int i;
	dev_t dev;
	char dev_name[80];

	if (getstripe((stripe_t *)NULL,string))
		exit(1);
	if ((ioctl(vd_fd,GET_VIRT_DISK,&vdisk))==-1) {
		perror("ioctl GET_VIRT_DISK failed");
		exit (1);
	}
	if (!vdisk.v_configured) {
		printf("%s : striped disk %s is not configured. Exiting!\n",
			prog_name,string);
		exit (1);
	}
	printf("\n                Striped Disk %s\n\n",string) ;
	printf("        %d components, %d sectors, %d sectors/cylinder\n\n",
		vdisk.v_num_stripe_components,vdisk.v_size, vdisk.v_cyl_size);
	if (vdisk.v_self_destruct)
	printf("       [This stripe will SELF DESTRUCT on final close.]\n");
	printf("       component         device          sectors/track\n");
	printf("      --------------------------------------------------\n");
	for (i=0;i< vdisk.v_num_stripe_components;++i) {
		dev = vdisk.v_sd[i].s_cdev;
		if (get_dev_name(dev_name, dev ))  /* cannot find name */
		       printf("     %6d           %4d, %3d             %5d\n",
			/****	i, (dev>>8) & 0x7f,dev & 0xf,  /*shen 8/11/89*/	
				i, major(dev), minor(dev),	/* JPC 001 */	
				vdisk.v_sd[i].s_track_size );
		else	/* found name */
			printf("     %6d         %-20s    %5d\n",
				i, dev_name, vdisk.v_sd[i].s_track_size );

	}
	printf("\n");
}
#else	/* S3000 */
showvd()
{
register int	i;

	if (getstripe((stripe_t *)NULL,string))
		exit ();
	if ((ioctl(vd_fd,GET_VIRT_DISK,&vdisk))==-1) {
		perror("ioctl GET_VIRT_DISK failed");
		exit (1);
	}
	if (!vdisk.v_configured) {
		printf("%s : striped disk %s is not configured. Exiting!\n",
			prog_name,string);
		exit (1);
	}
	printf("\n                Striped Disk %s\n\n",string) ;
	printf("        %d stripes, %d sectors, %d sectors/cylinder\n\n",
		vdisk.v_num_stripe_components,vdisk.v_size, vdisk.v_cyl_size);
	printf("       stripe         disk device        sectors/track\n");
	printf("      --------------------------------------------------\n");
	for (i=0;i< vdisk.v_num_stripe_components;++i)
		printf("        %3d         /dev/rdsk/c%dd%ds%d        %5d\n",i,
			(vdisk.v_sd[i].s_cdev>>6) & 3,	/* controller */
			(vdisk.v_sd[i].s_cdev>>4) & 3,	/* disk	*/
			vdisk.v_sd[i].s_cdev & 0xf,	/* slice */
			vdisk.v_sd[i].s_track_size );
	printf("\n");
}
#endif	/* S3000 */

clearvd()
{
	if (getstripe((stripe_t *)NULL,string))
		exit (1);
	if ((ioctl(vd_fd,CLEAR_VIRT_DISK,0)) == -1) {
		if (errno == EINVAL)
			fprintf(stderr,
			"%s : striped disk %s is not configured. Exiting!\n",
				prog_name,string);
		else
			perror("Attempt to delete the stripe failed");
		exit (1);
	}
	(void) close(vd_fd);
	if ((vd_fd = open(string, O_RDONLY)) >= 0 &&
	    ioctl(vd_fd, GET_VIRT_DISK, &vdisk) == 0 && vdisk.v_self_destruct) {
		printf("Stripe %s is in use.  It will be deleted when it is\n",
		  string);
		printf("closed by all processes using it.\n");
	}
	exit(0);
}

getvd()
{
	int 	uncool = 1;

	if ((cmd_arg == S_MAKE) && string && *string) {
		prompt("Enter character device of virtual disk -> %s\n",string);
		uncool = getstripe((stripe_t *)NULL,string);
		if (uncool == 0)
			return;
		if (mode != M_PROMPT)
			exit (1);
	}
	do {
		prompt("Enter character device of virtual disk -> ");
		string = getstring();
		uncool = getstripe((stripe_t *)NULL,string);
		if (uncool && mode != M_PROMPT)
			exit (1);
	} while (uncool);
	return;
}

int
getstripe(stripe,chrdev)
	stripe_t *stripe;
	char	 *chrdev;
{
	struct stat 	chrstat;
	int 		chrfd;

	if (stat(chrdev, &chrstat) < 0) {
		errprt("cannot stat character device %s",chrdev);
		return (1);
	}
	if ((chrstat.st_mode & S_IFMT) != S_IFCHR) {
		printf("%s not a character special device.\n",chrdev);
		return (1);
	}
	if ((chrfd = open(chrdev, O_RDONLY)) < 0) {
		errprt("cannot open character device %s",chrdev);
		return (1);
	}
	if (*chrdev != '/') {
		errprt(
		  "device pathnames must start with / (Ex: /dev/rdsk/c1d2s3)");
		return (1);
	}

	if (stripe != NULL) { /* this is a stripe component, not a vd */
		stripe->s_cdev = chrstat.st_rdev;
		stripe->s_bdev = (dev_t) 0;
		stripe->s_track_size = ioctl(chrfd, GET_TRACK_SIZE, 0);
		if ((int)stripe->s_track_size <= 0) {
			errprt("ioctl (GET_TRACK_SIZE) on %s failed",chrdev);
			return (1);
		}

		/* wp0 */
		if ((dsksize=ioctl(chrfd,GET_DISK_SIZE,0))==-1) {
			errprt("ioctl (GET_DISK_SIZE) on %s failed",chrdev);
			return (1);
		}

		close(chrfd);
	} else {
		vd_fd = chrfd;
	}
	return (0);
}

int
dupdev(vdp,n)
	vd_t *vdp;
	int n;
{
	int i;

	for ( i=0 ; i<n ; i++ )
		if (vdp->v_sd[n].s_cdev == vdp->v_sd[i].s_cdev) {
			printf("stripe %d is the same as stripe %d\n",n,i);
			return (1);
		}
	return 0;
}

char *
getstring()
{
	char	*p, s[256];

	if (!fgets(s, sizeof(s), (mode == M_PROMPT ? stdin : config_file)))
		exit(1);
	if ((p = strtok(s, " \n\t")) == NULL)
		return ("");
	if (p[0] == 'q' || p[0] == 'Q')
		exit(1);
	return (strdup(p));
}

void
gettrksz (stripe, i)
stripe_t *stripe;
int i;
{
	int trksz;
	int bad_trksz = 1;

	do {
		prompt("\nEnter track size for stripe component %d ", i);
		prompt("(default:%d) -> ", stripe->s_track_size);
		string = getstring();
		if (string[0] == 0) 
			break;
		trksz = atoi(string);
		if (trksz > 0 && trksz <= dsksize) {
			stripe->s_track_size = trksz;
			bad_trksz = 0;
		}
		else {
			printf ("%s invalid:\n", string);
			if (mode != M_PROMPT) {
				printf ("%s: aborting\n", prog_name);
				exit (1);
			}
		}
		
	} while (bad_trksz);
	
}

dump_vdisk(vdp)
	vd_t *vdp;
{
	int i;

	printf("\nv_num_stripe_components = %d\n",vdp->v_num_stripe_components);
	printf("v_cyl_size = 		  %d\n\n",vdp->v_cyl_size);
	printf("v_size = 		  %d\n\n",vdp->v_size);
	for (i=0;i< vdp->v_num_stripe_components;++i)
#ifdef	S3000
		printf("v_sd[%d] : s_cdev = 0x%04x, s_track_size = %d\n",
		  i, vdp->v_sd[i].s_cdev,
#else
	printf("v_sd[%d] : s_cdev = %d ;  s_track_size = %d\n",i,
			vdp->v_sd[i].s_cdev,
#endif
			vdp->v_sd[i].s_track_size);
}

#ifdef	S3000
get_dev_name(devname, dev)
register char	*devname;
register dev_t	dev;
{
	register uint	i;
	register int	ret, majnum;

/*	majnum = (dev >> 8) & 0x7f;	/* shen 8/11/89 spr#2660*/
	majnum = major(dev);		/* JPC 001 */

	for ( i = ret = 0 ; ret != -1 ; i++) {
		ret = getmaj("iopmb", i);
		if ( ret == majnum ) {
			sprintf(devname,"/dev/rdsk/c%dd%ds%d",
			   (i / 8), (dev>>4) & 0xf, dev & 0xf );
			return (0);
		}
	}
	return (-1);
}

#define MAXMAJORS	10
#define NDEVICES	3
#define MAJOR_MAX	127

getmaj(name, number)
register char	*name;
register uint	number;
{
	static struct majdat {
		char	name[16];
		short	nmaj;
/*		short	maj[MAXMAJORS] */
		uchar	maj[MAJOR_MAX] 	/* shen per hans 8/10/89 2660*/
	} majlist[NDEVICES];		/* JPC 001 */
	register struct majdat	*majp;

	register int 		i;
	register FILE		*fp;
	uint	 		num;
	char 			cmd[80];
	static int 		nknown = 0;

	for (i = nknown, majp = majlist; --i >= 0; majp++) {
		if (!strcmp(name, majp->name))
			if (number < majp->nmaj)
				return (majp->maj[number]);
			else
				return (-1);
	}

	majp = &majlist[nknown++] ;

	strcpy(majp->name, name);

	sprintf(cmd,"exec /etc/drvinstall -m %s -n",name);

	if ((fp = popen(cmd, "r")) == NULL) {
		perror("popen failed");
		exit (1);
	}
	for (i = 0; fscanf(fp, "%d", &num) == 1 ; i++) {
		if (num > MAJOR_MAX) {
			errno = 0;
			errprt("drvinstall returned bad major # = %d", num);
			exit(1);
		}
		majp->maj[i] = num;
	}
	pclose(fp);
	if ((majp->nmaj = i) <= number)
		return (-1);

	return (majp->maj[number]);
}
#endif	/* S3000 */
