#	START NEW ARIX SCCS HEADER
#
#	@(#) spell.mk: version 25.1 created on 12/2/91 at 18:05:15
#
#	Copyright (c) 1990 by Arix Corporation
#	All Rights Reserved
#
#	@(#)spell.mk	25.1	12/2/91 Copyright (c) 1990 by Arix Corporation
#
#	END NEW ARIX SCCS HEADER
#
#	Copyright (c) 1984 AT&T
#	  All Rights Reserved

#	THIS IS UNPUBLISHED PROPRIETARY SOURCE CODE OF AT&T
#	The copyright notice above does not evidence any
#	actual or intended publication of such source code.
#	ATT:ident	"spell:spell.mk	1.12"
#	spell make file

#ident	"@(#)spell:spell.mk	25.1"

#	Note:  In using the -f flag it is assumed that either
#	both the host and the target machines need the -f, or
#	neither needs it.  If one needs it and the other does
#	not, it is assumed that the machine that does not need
#	it will treat it appropriately.

# _SH_ is used by 3B15 View-path environment

IROOT =
include $(IROOT)/macdefs
OL = $(ROOT)
SL = $(ROOT)/usr/src/cmd
RDIR = ${SL}/spell
REL = current
CSID = -r`gsid spellcode ${REL}`
DSID = -r`gsid spelldata ${REL}`
SHSID = -r`gsid spell.sh ${REL}`
CMPRSID = -r`gsid compress.sh ${REL}`
MKSID = -r`gsid spell.mk ${REL}`
BIN = P108
LIST = opr -ttx -b${BIN}
CINSDIR = $(OL)/usr/bin
PINSDIR = $(OL)/usr/lib/spell
SFILES = spellprog.c spellin.c
DFILES = american british local list extra stop
SOURCE = hash.c hashcheck.c hashlook.c hashmake.c huff.c malloc.c $(SFILES)

compile all: spell hlista hlistb hstop spellin spellprog hashmake hashcheck \
	compress

spell:	spellprog spell.sh
	cp spell.sh spell

spelldir:
	if [ ! -d ${PINSDIR} ] ;\
	then mkdir ${PINSDIR} ;\
	fi ;
	chmod 777 ${PINSDIR}
	chgrp bin ${PINSDIR}
	chown bin ${PINSDIR}

compress:  spelldir compress.sh
	cp compress.sh compress

spellprog: spelldir spellprog.c hash.c hashlook.c huff.c malloc.c
	$(CC) $(CFLAGS) -s spellprog.c hash.c hashlook.c huff.c malloc.c -o spellprog -lm $(LDFLAGS)

spellin1: spelldir spellin.c huff.c
	$(SGS_NATIVE)/bin/cc -s spellin.c huff.c -o spellin1 -lm
	rm -f spellin.o huff.o

spellin: spelldir spellin.c huff.c
	$(CC) $(CFLAGS) -s spellin.c huff.c -o spellin -lm $(LDFLAGS)

hashcheck: spelldir hashcheck.c hash.c huff.c
	$(CC) $(CFLAGS) -s hashcheck.c hash.c huff.c -o hashcheck -lm $(LDFLAGS)

hashmk1: spelldir hashmake.c hash.c
	/bin/cc -s hashmake.c hash.c -o hashmk1
	rm -r hashmake.o hash.o

hashmake: spelldir hashmake.c hash.c
	$(CC) $(CFLAGS) -s hashmake.c hash.c -o hashmake $(LDFLAGS)

alldata: hlista hlistb hstop
	rm htemp1

htemp1:	list local extra hashmk1
	cat list local extra | ./hashmk1 >htemp1

hlista: spellin1 hashmk1 spelldir american hashmake spellin htemp1
	./hashmk1 <american |sort -u - htemp1 >htemp2
	./spellin1 `wc htemp2|sed -n 's/\([^ ]\) .*/\1/p' ` <htemp2 >hlista
	rm htemp2

hlistb: hashmk1 spellin1 spelldir british htemp1
	./hashmk1 <british |sort -u - htemp1 >htemp2
	./spellin1 `wc htemp2|sed -n 's/\([^ ]\) .*/\1/p' ` <htemp2 >hlistb
	rm htemp2


hstop:	spellin1 hashmk1 spelldir stop 
	./hashmk1 <stop | sort -u >htemp2
	./spellin1 `wc htemp2|sed -n 's/\([^ ]\) .*/\1/p' ` <htemp2 >hstop
	rm htemp2

install: all
	$(INS) spell $(CINSDIR)/spell
	chmod 755 $(CINSDIR)/spell
	chown bin $(CINSDIR)/spell
	chgrp bin $(CINSDIR)/spell
	$(INS) compress $(PINSDIR)/compress
	chmod 755 $(PINSDIR)/compress
	chown bin $(PINSDIR)/compress
	chgrp bin $(PINSDIR)/compress
	$(INS) hashcheck $(PINSDIR)/hashcheck
	chmod 755 $(PINSDIR)/hashcheck
	chown bin $(PINSDIR)/hashcheck
	chgrp bin $(PINSDIR)/hashcheck
	$(INS) hashmake $(PINSDIR)/hashmake
	chmod 755 $(PINSDIR)/hashmake
	chown bin $(PINSDIR)/hashmake
	chgrp bin $(PINSDIR)/hashmake
	$(INS) hlista $(PINSDIR)/hlista
	chmod 644 $(PINSDIR)/hlista
	chown bin $(PINSDIR)/hlista
	chgrp bin $(PINSDIR)/hlista
	$(INS) hlistb $(PINSDIR)/hlistb
	chmod 644 $(PINSDIR)/hlistb
	chown bin $(PINSDIR)/hlistb
	chgrp bin $(PINSDIR)/hlistb
	$(INS) hstop $(PINSDIR)/hstop
	chmod 644 $(PINSDIR)/hstop
	chown bin $(PINSDIR)/hstop
	chgrp bin $(PINSDIR)/hstop
	$(INS) spellprog $(PINSDIR)/spellprog
	chmod 755 $(PINSDIR)/spellprog
	chown bin $(PINSDIR)/spellprog
	chgrp bin $(PINSDIR)/spellprog
	$(INS) spellin $(PINSDIR)/spellin
	chmod 755 $(PINSDIR)/spellin
	chown bin $(PINSDIR)/spellin
	chgrp bin $(PINSDIR)/spellin
	echo "" > $(PINSDIR)/spellhist
	chmod 666 $(PINSDIR)/spellhist
	chown bin $(PINSDIR)/spellhist
	chgrp bin $(PINSDIR)/spellhist

listing:  ;  pr spell.mk spell.sh compress.sh ${SFILES} ${DFILES} | ${LIST}
listmk:   ;  pr spell.mk | ${LIST}
listsh:	  ;  pr spell.sh | ${LIST}
listcomp: ;  pr compress.sh | ${LIST}
listcode: ;  pr ${SFILES} | ${LIST}
listdata: ;  pr ${DFILES} | ${LIST}

build:  bldmk bldsh bldcomp bldcode blddata
	:
bldcode:  ;  get -p ${CSID} s.spell.src ${REWIRE} | ntar -d ${RDIR} -g
blddata:  ;  get -p ${DSID} s.spell.data | ntar -d ${RDIR} -g
bldsh:	  ;  get -p ${SHSID} s.spell.sh ${REWIRE} > ${RDIR}/spell.sh
bldcomp:  ;  get -p ${CMPRSID} s.compress.sh ${REWIRE} > ${RDIR}/compress.sh
bldmk:    ;  get -p ${MKSID} s.spell.mk > ${RDIR}/spell.mk

edit:	sedit dedit mkedit shedit compedit
	:
sedit:	;  get -p -e s.spell.src | ntar -g
dedit:	;  get -p -e s.spell.data | ntar -g
shedit:	;  get -e s.spell.sh
compedit: ; get -e s.compress.sh

delta:	sdelta ddelta mkdelta shdelta compdelta
	:
sdelta:
	ntar -p ${SFILES} > spell.src
	delta s.spell.src
	rm -f ${SFILES}
ddelta:
	ntar -p ${DFILES} > spell.data
	delta s.spell.data
	rm -f ${DFILES}
shdelta:
	delta s.spell.sh
compdelta: ; delta s.compress.sh

mkedit:	;  get -e s.spell.mk
mkdelta: ; delta s.spell.mk

clean:
	rm -f *.o

clobber: clean shclobber compclobber
	rm -f spell spellprog spellin hashmake hlist* \
		hstop spellin1 hashmk1 greplist tags
	-rm -f htemp1 htemp2 hashcheck
shclobber: ; rm -f spell
compclobber: ; rm -f compress

delete:	clobber shdelete compdelete
	rm -f ${SFILES} ${DFILES}
shdelete: shclobber
	rm -f spell.sh
compdelete: compclobber
	rm -f compress.sh

ctags:	
	ctags	$(SOURCE)
	echo 'grep $$* \\' > greplist
	for i in $(SOURCE)	;\
	do echo "$$i \\"	;\
	done >> greplist
	echo /dev/null >> greplist
	chmod +x greplist

