/*	START NEW ARIX SCCS HEADER			*/
/*							*/
/*	@(#) tcb.c: version 25.1 created on 12/2/91 at 18:03:17	*/
/*							*/
/*	Copyright (c) 1990 by Arix Corporation		*/
/*	All Rights Reserved				*/
/*							*/
#ident	"@(#)tcb.c	25.1	12/2/91 Copyright (c) 1990 by Arix Corporation"
/*							*/
/*	END NEW ARIX SCCS HEADER			*/
/*							*/
#ifdef	TCB

#include "mac.h"

#include <sys/types.h>
#include <sys/stat.h>
#include <sys/dir.h>
#include <sys/security.h>

#ifdef SVMLS 
#include <mlsfiles.h>
#endif

#ident	"@(#)tcb.c	9.3 System V/MLS source as of 8/11/89 17:23:23"

#define SYSTEM	0

tcb_file(fd)
int fd;
{

#ifdef SVMLS
	static char *smsg1  = "Attempt by superuser to execute untrusted code";
	static char *smsg2  = ": permission denied";
	static char *lblfile = MLSLABELSFILE;

	struct stat buf;
	struct mlsdlbl label;

	register int i;


	/* Not root ... then don't check
	 */
	if ( (getuid() != 0) && (geteuid() != 0) )
		return (0);

	/* Stat file if can't stat return error
	 */
	if ( fstat(fd, &buf) != 0 )
		return(-1);

	/* Only check regular files.
	 */
	if ( buf.st_mode & S_IFREG )
	{
		/* Open labels file if can't open return error
		 */
		if ( (fd = open(lblfile, 0)) < 0 )
			return (-1);

		/* Look up gid in labels file
		 */
		i = gid_label(buf.st_gid, &label, fd);

		/* Close labels file
		 */
		close(fd);

		/* If this not a system level file or could not find the
		 * gid in labels file  then print error message and return
		 * NOTE: Uses short circuit logic
		 */
		if ( ( i == -1 ) || ( label.d_lbl.lbl_lvl != SYSTEM ) )
		{
			prs_cntl(smsg1);
			prs_cntl(smsg2);
			newline();
			return (-1);
		}
	}

#endif /* SVMLS */

	/* Looks fine
	 */
	return (0);
}

#ifdef SVMLS

/* Search labels file for gid
 */
int gid_label(gid, dlbl, fd)
int gid;
struct mlsdlbl *dlbl;
int fd;
{
	long offset, last_offset;

	offset = (MLSHASH(gid) * sizeof(struct mlsdlbl));
	last_offset = 0L;

	if (lblread(dlbl, offset, fd) == 0)
		return (-1);

	if ( dlbl->d_flags & MLSVALID )
	{
		if ( dlbl->d_lbl.lbl_gid == gid ) 
			last_offset = offset;

		while ( dlbl->d_hash )
		{
			offset = dlbl->d_hash;

			if ( lblread(dlbl, offset, fd) == 0 )
				return (-1);

			if ( dlbl->d_flags & MLSVALID  )
				if ( dlbl->d_lbl.lbl_gid == gid )
					last_offset = offset;
		}
	}

	if ( ( last_offset == 0L ) && ( gid != 0 ) )
		return (-1);

	if ( lblread(dlbl, last_offset, fd) == 0 )
		return (-1);

	if ( dlbl->d_flags & MLSREMOVED )
		return (-1);

	return (0);
}

/* Read labels file
 */
int lblread(p, offset, fd)
struct mlsdlbl *p;
long offset;
int fd;
{
	static char msg1[] = "sh lblread: lseek failed";
	static char msg2[] = "sh lblread: read failed";

	if ( lseek(fd, offset, 0) == -1)
	{
		prs_cntl(msg1);
		newline();
		return(0);
	}

	if ( read(fd, p, sizeof(struct mlsdlbl)) != sizeof(struct mlsdlbl) )
	{
		prs_cntl(msg2);
		newline();
		return(0);
	}

	if ( lseek(fd, -(long) (sizeof(struct mlsdlbl)), 1) == -1)
	{
		prs_cntl(msg1);
		newline();
		return(0);
	}

	return(1);
}
#endif /* SVMLS */
#endif /* TCB */
