/*	START NEW ARIX SCCS HEADER			*/
/*							*/
/*	@(#) stak.c: version 25.1 created on 12/2/91 at 18:03:04	*/
/*							*/
/*	Copyright (c) 1990 by Arix Corporation		*/
/*	All Rights Reserved				*/
/*							*/
#ident	"@(#)stak.c	25.1	12/2/91 Copyright (c) 1990 by Arix Corporation"
/*							*/
/*	END NEW ARIX SCCS HEADER			*/
/*							*/
/*	Copyright (c) 1984 AT&T	*/
/*	  All Rights Reserved  	*/

/*	THIS IS UNPUBLISHED PROPRIETARY SOURCE CODE OF AT&T	*/
/*	The copyright notice above does not evidence any   	*/
/*	actual or intended publication of such source code.	*/

/*	ATT:#ident	"sh:stak.c	1.8"			*/

#ident	"@(#)sh:stak.c	25.1"

/*
 * UNIX shell
 */

#include	"defs.h"


/* ========	storage allocation	======== */

char *
getstak(asize)			/* allocate requested stack */
int	asize;
{
	register char	*oldstak;
	register int	size;

	size = round(asize, BYTESPERWORD);
	pushchk(size);
	oldstak = stakbot;
	staktop = stakbot += size;
	return(oldstak);
}

/*
 * set up stack for local use
 * should be followed by `endstak'
 */
char *
locstak()
{
	if (brkend - stakbot < BRKINCR)
	{
		if (setbrk(brkincr) == -1)
			error(nostack);
		if (brkincr < BRKMAX)
			brkincr += 256;
	}
	return(stakbot);
}

char *
savstak()
{
	assert(staktop == stakbot);
	return(stakbot);
}

char *
endstak(argp)		/* tidy up after `locstak' */
register char	*argp;
{
	register char	*oldstak;

	*argp++ = 0;
	pushchk((long)round(argp,BYTESPERWORD)-(long)staktop);
	oldstak = stakbot;
	stakbot = staktop = (char *)round(argp, BYTESPERWORD);
	return(oldstak);
}

tdystak(x)		/* try to bring stack back to x */
register char	*x;
{
	while ((char *)(stakbsy) > (char *)(x))
	{
		free(stakbsy);
		stakbsy = stakbsy->word;
	}
	staktop = stakbot = max((char *)(x), (char *)(stakbas));
	rmtemp(x);
}

stakchk()
{
	if ((brkend - stakbas) > BRKINCR + BRKINCR)
		if (setbrk(-BRKINCR)==-1) error(nostack);
}

char *
cpystak(x)
char	*x;
{
	return(endstak(movstr(x, locstak())));
}

stakbrk(incr) {
	incr = round(BRKINCR+incr,BRKINCR);
	if (setbrk(incr)==-1) error(nostack);
}

#ifdef dumb
pushchk(incr) /* hanna */
	long	incr;
{
/*	incr= round(incr,BYTESPERWORD); */
	if ((brkend-staktop)<incr)
	if (setbrk(incr) ==-1) error(nostack);
}
pushstak(c) /* hanna */
	/* replaces macro in stak.h.  Does a stakprobe first */
	char	c;
{
	pushchk(sizeof c);
	*staktop++ = c;
}
#endif
