/*	START NEW ARIX SCCS HEADER			*/
/*							*/
/*	@(#) snoop.c: version 25.1 created on 12/2/91 at 18:03:00	*/
/*							*/
/*	Copyright (c) 1990 by Arix Corporation		*/
/*	All Rights Reserved				*/
/*							*/
#ident	"@(#)snoop.c	25.1	12/2/91 Copyright (c) 1990 by Arix Corporation"
/*							*/
/*	END NEW ARIX SCCS HEADER			*/
/*							*/
#ifdef TCB
#include <fcntl.h>
#include <sys/types.h>
#include <time.h>

#define	SHEXCL	"/etc/shexcl"		/* exclusion list */
#define	EOF	(-1)

#define	UID	0
#define	GID	1

static char	buf[128];
static char	*bp = buf;
static char	*bufend = buf;

static int	getline(), getch();
extern long	strtol();

int
snoop(argc, argv)
int	argc;
char	*argv[];
{
	ushort	real[2], eff[2];
	char	line[128];
	ushort	lo, hi;
	int	id, fd;
	char	*p, *q;

	real[UID] = getuid();
	real[GID] = getgid();

	eff[UID]  = geteuid();
	eff[GID]  = getegid();

	if ( real[UID] != eff[UID] || real[GID] != eff[GID] )
	{
		if ((fd = open(SHEXCL, O_RDONLY)) < 0)
			return 0;

		while ( getline(line, sizeof(line), fd) )
		{
			id = (*line == 'u') ? UID : (*line == 'g') ? GID : -1;

			lo = hi = strtol(p = line+1, &q, 10);

			if ( q > p && *q == ':' )
				hi = strtol(++q, &p, 10);

			if ( id == -1 || p == q )
				continue;

			if ( real[id] != eff[id] && eff[id] >= lo
				&& (hi == 0 || eff[id] <= hi) )
			{
				close(fd);
				return 1;
			}
		}
		close(fd);
	}
	return 0;
}

static int
getline(s, len, fd)
char	*s;
int	len;
int	fd;
{
	int	c;

	while ( (c = getch(fd)) != EOF )
	{
		if ( len > 1 )
		{
			*s++ = c;
			len--;
		}
		if ( c == '\n' )
		{
			*s = 0;
			return 1;
		}
	}
	return 0;
}

static int
getch(fd)
int	fd;
{
	int	n;

	if ( bp == bufend )
	{
		if ( ( n = read(fd, buf, sizeof buf) ) <= 0 )
			return EOF;
		bufend = buf + n;
		bp = buf;
	}
	return *bp++;
}
#endif /* TCB */
