/*	START NEW ARIX SCCS HEADER			*/
/*							*/
/*	@(#) fault.c: version 25.1 created on 12/2/91 at 18:01:55	*/
/*							*/
/*	Copyright (c) 1990 by Arix Corporation		*/
/*	All Rights Reserved				*/
/*							*/
#ident	"@(#)fault.c	25.1	12/2/91 Copyright (c) 1990 by Arix Corporation"
/*							*/
/*	END NEW ARIX SCCS HEADER			*/
/*							*/
/*	Copyright (c) 1984 AT&T	*/
/*	  All Rights Reserved  	*/

/*	THIS IS UNPUBLISHED PROPRIETARY SOURCE CODE OF AT&T	*/
/*	The copyright notice above does not evidence any   	*/
/*	actual or intended publication of such source code.	*/

/*	AT&T: #ident	"sh:fault.c	1.13.1.1"		*/


/*
 * UNIX shell
 */

#include	"defs.h"
#include	<sys/types.h>

extern done();

char	*trapcom[MAXTRAP];
BOOL	trapflg[MAXTRAP] =
{
	0,
	0,	/* hangup */
	0,	/* interrupt */
	0,	/* quit */
	0,	/* illegal instr */
	0,	/* trace trap */
	0,	/* IOT */
	0,	/* EMT */
	0,	/* float pt. exp */
	0,	/* kill */
	0, 	/* bus error */
	0,	/* memory faults */
	0,	/* bad sys call */
	0,	/* bad pipe call */
	0,	/* alarm */
	0, 	/* software termination */
	0,	/* unassigned */
	0,	/* unassigned */
	0,	/* death of child */
	0,	/* power fail */
#ifdef	_POSIX_SOURCE
	0,	/* window change */
	0,	/* Not used */
	0,	/* SIGPOLL 22 */
	0,	/* SIGSTOP 23 */
	0,	/* SIGTSTP 24 */
	0,	/* SIGCONT 25 */
	0,	/* SIGTTIN 26 */
	0,	/* SIGTTOU 27 */
	0,	/* SIGSAK  28 */
#endif	/* _POSIX_SOURCE */
};

(*(sigval[]))() = 
{
	0,
	done, 	/* hangup */
	fault,	/* interrupt */
	fault,	/* quit */
	done,	/* illegal instr */
	done,	/* trace trap */
	done,	/* IOT */
	done,	/* EMT */
	done,	/* floating pt. exp */
	0,	/* kill */
	done, 	/* bus error */
	done,	/* memory faults */
	done, 	/* bad sys call */
	done,	/* bad pipe call */
	fault,	/* alarm */
	fault,	/* software termination */
	done,	/* unassigned */
	done,	/* unassigned */
	done,	/* death of child */
	done,	/* power fail */
#ifdef	_POSIX_SOURCE
	done,	/* Window change */
	done,	/* 21 */
	done,	/* SIGPOLL 22 */
	done,	/* SIGSTOP 23 */
	fault,	/* SIGTSTP 24 */
	done,	/* SIGCONT 25 */
	fault,	/* SIGTTIN 26 */
	fault,	/* SIGTTOU 27 */
	done,	/* SIGSAK  28 */
#endif	/* _POSIX_SOURCE */
};

/* ========	fault handling routines	   ======== */

int	sh_had_job_control = 0;
int	sh_in_job_session = 0;


/* this routine sets SIGHUP to SIG_IGN and sets the IS_MODIFIED flag
 * to NOT_MODIFIED.  See the explaination in main.c at the call to bip_sighup
*/
bip_sighup()
{
	/* only do this if we are the child of a job_control shell!! */
	if ( !sh_had_job_control )
		return;

	sigset ( SIGHUP, SIG_IGN );
	sigval [ SIGHUP ] = SIG_IGN;
	trapflg[ SIGHUP ] = 0;
}

fault(sig)
register int	sig;
{
	register int	flag;

#ifdef not_any_more
	if (sig == SIGSEGV)
	{
		if (setbrk(brkincr) == -1)
			error(nospace);
	}
	else if (sig == SIGALRM)
#else
	if (sig == SIGALRM)
#endif

	{
		if (flags & waiting)
			done();
	}
	else
	{
		flag = (trapcom[sig] ? TRAPSET : SIGSET);
		trapnote |= flag;
		trapflg[sig] |= flag;
		if (sig == SIGINT)
			wasintr++;
	}
}

stdsigs()
{
	setsig(SIGHUP);
	setsig(SIGINT);
	ignsig(SIGQUIT);
	setsig(SIGILL);
	setsig(SIGTRAP);
	setsig(SIGIOT);
	setsig(SIGEMT);
	setsig(SIGFPE);
	setsig(SIGBUS);
	sigset(SIGSEGV, SIG_DFL);
	setsig(SIGSYS);
	setsig(SIGPIPE);
	sigset(SIGALRM, fault);
	setsig(SIGTERM);
	setsig(SIGUSR1);
	setsig(SIGUSR2);
#ifdef	_POSIX_SOURCE
#ifdef	SIGTSTP
	/*
	 * mu0 - partial job control - see xec.c for 'suspend' command.
	 * Always ignore SIGTTIN, SIGTTOU, SIGTSTP.
	 * We can still use 'suspend' to stop ourselves
	 * and return to a job control knowing parent.
	 */
	ignsig (SIGTTIN);
	ignsig (SIGTTOU);
	ignsig (SIGTSTP);
#endif	/* SIGTSTP */
#endif	/* _POSIX_SOURCE */
}

#ifdef	_POSIX_SOURCE
#ifdef	SIGTSTP

#include	<sys/sysarix.h>

setjobstate()
{
#ifdef	ARIXPOSIX
#include <sys/proc.h>
int	pflags;	/* must be on stack	*/

	/*
	 *	Turn off job control flag in our proc structure.
	 *	Don't just clear the flags because there are other
	 *	flags in use.
	 *	But, if SVID complience flag is set then only that
	 *	flag must be set.
	 *	This also makes sure that we never receive the
	 *	SIGTTIN, SIGTTOU, SIGTSTP and SIGSTOP signals.
	 */
	sh_had_job_control = 0;
	sh_in_job_session = 0;
	if (sysarix(ARIXPOSIX,ARIXGETPOSFLAGS,0,&pflags) >= 0) {

		/* If we are SVID, turn off all job control */
		if ( pflags & SVID_COMPAT_PROC ) {
			pflags = SVID_COMPAT_PROC;
		}
		else
		{
			if ( pflags & JOB_CONTROL_PROC )
			{
				pflags &= ~JOB_CONTROL_PROC;
				sh_had_job_control = 1;
				sh_in_job_session = 1;
			}
		}
		sysarix( ARIXPOSIX, ARIXSETPOSFLAGS, 0, &pflags );
	}
#endif	/* ARIXPOSIX */
}
#endif	/* SIGTSTP */
#endif	/* _POSIX_SOURCE */

ignsig(n)
{
	register int	s, i;

	i = n;
	if ((s = (sigset(i, SIG_IGN) == SIG_IGN)) == 0)
	{
		trapflg[i] |= SIGMOD;
	}
	return(s);
}

getsig(n)
{
	register int	i;

	if (trapflg[i = n] & SIGMOD || ignsig(i) == 0)
		sigset(i, fault);
}


setsig(n)
{
	register int	i;

	if (ignsig(i = n) == 0)
		sigset(i, sigval[i]);
}

oldsigs()
{
	register int	i;
	register char	*t;

	i = MAXTRAP;
	while (i--)
	{
		t = trapcom[i];
		if (t == 0 || *t)
			clrsig(i);
		trapflg[i] = 0;
	}
	trapnote = 0;
}

clrsig(i)
int	i;
{
	free(trapcom[i]);
	trapcom[i] = 0;
	if (trapflg[i] & SIGMOD)
	{
		trapflg[i] &= ~SIGMOD;
		sigset(i, sigval[i]);
	}
}

/*
 * check for traps
 */
chktrap()
{
	register int	i = MAXTRAP;
	register char	*t;

	trapnote &= ~TRAPSET;
	while (--i)
	{
		if (trapflg[i] & TRAPSET)
		{
			trapflg[i] &= ~TRAPSET;
			if (t = trapcom[i])
			{
				int	savxit = exitval;

				execexp(t, 0);
				exitval = savxit;
				exitset();
			}
		}
	}
}
