/*	START NEW ARIX SCCS HEADER			*/
/*							*/
/*	@(#) maketape.c: version 25.1 created on 12/2/91 at 17:51:23	*/
/*							*/
/*	Copyright (c) 1990 by Arix Corporation		*/
/*	All Rights Reserved				*/
/*							*/
#ident	"@(#)maketape.c	25.1	12/2/91 Copyright (c) 1990 by Arix Corporation"
/*							*/
/*	END NEW ARIX SCCS HEADER			*/
/*							*/

/*	Copyright (c) 1984 AT&T	*/
/*	  All Rights Reserved  	*/

/*	THIS IS UNPUBLISHED PROPRIETARY SOURCE CODE OF AT&T	*/
/*	The copyright notice above does not evidence any   	*/
/*	actual or intended publication of such source code.	*/

/*	ATT: maketape.c	1.17	*/
/*	maketape	COMPILE:	cc -O maketape.c -s -i -o maketape 
	maketape -- copy file collections
*/

#ident	"@(#)maketape:maketape.c	25.1"

/* sw1 1/16/85: david stone : align Cbuf/Dbuf on 4k boundary */
/* sw3 2/1/86: steve meyer :  increase CPIOBSZ to 5120*32 from 4096  */
/* sw4 10/14/86 ejb: If you can't read a file (-o option) quit, because */
/*		     the header will already have been written		*/
/* sw5 12/18/86 ejb  removed 'r' option from -p usage line		*/
/* eb0 4/15/87  ejb  if we can't open /dev/tty, give an error and die   */
/* eb1 6/19/87  ejb  if -p option gets an error reading or writing a    */
/*     file, print an error message, and die with a non-zero return code*/
/* eb2 7/6/87 Made multi-volume to archive work.			*/
/* eb3 7/9/87 combined BBuf and Buf into one smaller buffer		*/
/* 12/04/87 sw6 : fixed bus error 					*/
/* 1/10/88 kelly: combined 5.3.1 capabilities into source. Includes	*/
/*	internationalization						*/
/* hh1 4/13/88 hans : fixed -v option to show 0 length files on output  */ 

#include "errmsg.h"
#include <fcntl.h>
#include <stdio.h>
#include <signal.h>
#include <sys/stat.h>
#include <sys/errno.h>
#include <varargs.h>	/* jc0 */

/* includes for IPCS  - hh2*/
#include <sys/ipc.h>
#include <sys/shm.h>
#include <sys/sem.h>
#include <sys/sysmacros.h>

/*#include <limits.h>*/		/* jc2 */
#include <time.h>		/* jc2 */

#define EQ(x,y)	(strcmp(x,y)==0)
/* for VAX, Interdata, ... */
#define MKSHORT(v,lv) {U.l=1L;if(U.c[0]) U.l=lv,v[0]=U.s[1],v[1]=U.s[0]; else U.l=lv,v[0]=U.s[0],v[1]=U.s[1];}
#define MAGIC	070707		/* cpio magic number */
#define IN	1		/* copy in */
#define OUT	2		/* copy out */
#define PASS	3		/* direct copy */
#define HDRSIZE	(Hdr.h_name - (char *)&Hdr)	/* header size minus filename field */
#define LINKS	1000		/* max no. of links allowed */
#define CHARS	76		/* ASCII header size minus filename field */
#define BUFSIZE 512		/* In u370, can't use BUFSIZ nor BSIZE */
#define CPIOBSZ 5120*8		/* file read/write */
#define	FORMAT	"%b %e %H:%M:%S %Y"   /* Date and Time formats */

/* stuff for Archive fast streaming tape */

#include <sys/ioctl.h>
#include <sys/termio.h>
#define LAST	0x8
#define BNUM	0x20000
#define TBLKSIZ	0x200
#define TAPE	2
char *fastbuf;
char *fstptr;
char *fstwptr;
static int qflag;
 
/**** declarations for fork capabilities - hh2 / hh3  *****/
#define P(n) semcall(sem,n,-1)
#define V(n) semcall(sem,n,1)
#define fullbuff 	0
#define emptybuff 	1
int 		pid = -1, 
	 	blksiz, nblks,
		shmid[3], semid, sem,
		shmn;
char		*shm[2];
struct	shseg	{
	int	last, 
		nread[2],
		quit,	
		chdead;
	char	fname[20];
	} *share;
int debug = 0;

/* end stuff for Archive fast streaming tape */

struct	stat	Statb, Xstatb;

	/* Cpio header format */
static struct header {
	short	h_magic,
		h_dev;
	ushort	h_ino,
		h_mode,
		h_uid,
		h_gid;
	short	h_nlink,
		h_rdev,
		h_mtime[2],
		h_namesize,
		h_filesize[2];
	char	h_name[256];
} Hdr;

static unsigned	Bufsize = BUFSIZE;		/* default record size */
static union { short Buf[CPIOBSZ/2]; char BBuf[CPIOBSZ]; } B; /* eb3 */
static short	*Dbuf;
static char	*Cbuf;
static int	Wct, Wc;
static short	*Wp;
static char	*Cp;

static
short	Option,
	Dir,
	Uncond,
	Link,
	Rename,
	Toc,
	Verbose,
	Select,
	Mod_time,
	Acc_time,
	Cflag,
	fflag,
	Swap,
	byteswap,
	bothswap,
	halfswap,
	Tflag;		/* jc2 */

static
int	Ifile,
	Ofile,
	Input = 0,
	Output = 1;

static
long	Blocks,
	pBlocks,
	Longfile,
	Longtime;

static
char	Fullname[256],
	Name[256];
static	int	Pathend;
static	int	usrmask;

static
FILE	*Rtty,
	*Wtty;
static 	/* jc0 */
char	ttyname[] = "/dev/tty";

static	char	*Pattern[100];
static	char	Strhdr[500];
static	char	*Chdr = Strhdr;
static
short	Dev,
	Uid,
	Gid,
	A_directory,
	A_special,
	Filetype = S_IFMT;

extern	errno;
extern  char	*optarg;
char	*malloc();
char 	*cd();
FILE 	*popen();

union { long l; short s[2]; char c[4]; } U;

static char	time_buf[50];		/* array to hold date and time */
static char	*swfile;
static char	*eommsg = "Change to part %d and press RETURN key. [q] ";

/* for VAX, Interdata, ... */
long mklong(v)
short v[];
{
	U.l = 1;
	if(U.c[0])
		U.s[0] = v[1], U.s[1] = v[0];
	else
		U.s[0] = v[0], U.s[1] = v[1];
	return U.l;
}

/* --------------------------------------------------------BEGIN     jc2 */
static struct specification {	
	ushort	new_mode,
		new_uid,
		new_gid;
	time_t	new_time;
	char	old_name[PATH_MAX],
		new_name[PATH_MAX];
	short	n_links;
} Spec;
time_t New_time, Old_time;
char *Old_date="0101000070";

			/* next 3 lines swiped from date.c */
char		buf[100];
#define	year_size(A)	(((A) % 4) ? 365 : 366)
static short	month_size[12] = { 31, 28, 31, 30, 31, 30, 31, 31, 30, 31, 30, 31 };

char *cmd;

#define MODE_LEN	10+1	/* length of the mode string + 1 for the */
				/*   terminating null (0) */

#define MAX_LINE	256	/* maximum length of input line for T option */


/* *******  WARNING WARNING WARNING WARNING WARNING WARNING WARNING ******* */

/* WARNING:  grouplist and ownerlist depend on the entries in the /etc/group */
/* and /etc/passwd file.

/* If the values in /etc/passwd and /etc/group change, then the following */
/* items must also change. */

/* *******  WARNING WARNING WARNING WARNING WARNING WARNING WARNING ******* */

#define NAME_LEN	8+1	/* size of owner/group name allowed */
				/* used "pwck" of passwd entry to get limit */
				/*  (+1 for the terminating null (0) */

struct List {
	char name[NAME_LEN];
	int number;
};

struct List Grouplist[] = {	/* from usr/src/cmd/adm/group */
	"root",    0,
	"other",   1,
	"bin",     2,
	"sys",     3,
	"adm",     4,
	"mail",    6,
	"rje",     8,
	"daemon", 12,
	"xbin", 15
};

struct List Ownerlist[] = {	/* from usr/src/cmd/adm/mach/passwd */
	"root",     0,
	"daemon",   1,
	"bin",      2,
	"sys",      3,
	"adm",      4,
	"uucp",     5,
	"nuucp",    6,
	"lp",      71,
	"listen",  81
};

				/* maximum uid number (0 based) */
#define MAX_OWNER	(sizeof(Ownerlist)/(sizeof(Ownerlist[0].name)+sizeof(Ownerlist[0].number)))
				/* maximum gid number (0 based) */
#define MAX_GROUP	(sizeof(Grouplist)/(sizeof(Grouplist[0].name)+sizeof(Grouplist[0].number)))

/* ------------------------------------------------------------END jc2 */

main(argc, argv)
char **argv;
{
	register ct;
	register char *fullp;
	register i;
	void onint(), onhup(), onquit();
	int mktape=0; /* jc2 */
	void Tusage(); /* jc2 */

	int ans;
	long sav_Blocks, sav_pBlocks;
	long	filesz;
	int c,type; /* Archive */
	Pattern[0] = "*";

	setbuf(stderr,0);
	signal(SIGSYS, 1);
	if(*argv[1] != '-')
		usage();
	Uid = getuid();
	usrmask = umask(0);
	umask(usrmask);
	Gid = getgid();

			/* begin jc2 - swiped from mv.c */
/* note that the remnant "Tflag" is here as well as the "mktape" flag. */
/* it is not clear at this time whether the program will be called "cpio" */
/* or "maketape" in the final offering */
	/*
	 * Determine command invoked (cpio or maketape) 
	 */
	
	if (cmd = (char *)strrchr(argv[0], '/'))
		++cmd;
	else
		cmd = argv[0];

	mktape=(EQ(cmd, "maketape")); /* set mktape flag appropriately */
	  	 /* end jc2 */
	
	
	/* Set flags based on command. */
/* command line restriction if if program is called "maketape"  jc2 */

	while( (ans = (mktape ? getopt( argc, argv, "aBC:ovVT:") : getopt( argc,
 argv, "aBC:ifopcdklmrSsbtuvDVM:6eI:O:"))) != EOF ) {
		switch(ans) {
		case 'a':		/* reset access time */
			Acc_time++;
			break;
		case 'B':		/* change record size to 5120 bytes */
			Bufsize = 5120;
			break;
		case 'C':
			Bufsize = atoi(optarg);
			if (Bufsize == 0)
				errmsg(EERROR,"Illegal argument to -%c, '%s'.",
					ans, optarg);
			break;
		case 'i':
			Option = IN;
			if((c = ioctl(Input,PERGET,&type)) != -1){
				if(type == TAPE){
					qflag |= IN;
					type = 0;
				}
			}else if((c = ioctl(Output,PERGET,&type)) != -1){
				if(type == TAPE){
					qflag |= OUT;
					type = 0;
				}

			}
			if(argc > 2 ) {	/* save patterns, if any */
				for(i = 0; (i+2) < argc; ++i)
					Pattern[i] = argv[i+2];
			}
			break;
		case 'f':	/* do not consider patterns in cmd line */
			fflag++;
			break;
		case 'o':
			Option = OUT;
			if((c = ioctl(Output,PERGET,&type)) != -1){
				if(type == TAPE){
					qflag |= OUT;
					type = 0;
				}
			}else if((c = ioctl(Input,PERGET,&type)) != -1){
				if(type == TAPE){
					qflag |= IN;
					type = 0;
				}
			}
			break;
		case 'p':
			if(argc != 3)
				usage();
			if(access(argv[2], 2) == -1) {
accerr:
				fprintf(stderr,"cannot write in <%s>\n", argv[2]);
				doexit(2);
			}
			strcpy(Fullname, argv[2]);	/* destination directory */
			strcat(Fullname, "/");
			stat(Fullname, &Xstatb);
			if((Xstatb.st_mode&S_IFMT) != S_IFDIR)
				goto accerr;
			Option = PASS;
			if((c = ioctl(Input,PERGET,&type)) != -1){
				if(type == TAPE){
					qflag |= IN;
					type = 0;
				}
			}
			Dev = Xstatb.st_dev;
			break;
		case 'c':		/* ASCII header */
			Cflag++;
			break;
		case 'd':		/* create directories when needed */
			Dir++;
			break;
		case 'l':		/* link files, when necessary */
			Link++;
			break;
		case 'm':		/* retain mod time */
			Mod_time++;
			break;
		case 'r':		/* rename files interactively */
			Rename++;
			Rtty = fopen("/dev/tty", "r");
			Wtty = fopen("/dev/tty", "w");
			if(Rtty==NULL || Wtty==NULL) {
				fprintf(stderr,"Cannot rename (/dev/tty missing)\n");
				doexit(2);
			}
			break;
		case 'S':		/* swap halfwords */
			halfswap++;
			Swap++;
			break;
		case 's':		/* swap bytes */
			byteswap++;
			Swap++;
			break;
		case 'b':
			bothswap++;
			Swap++;
			break;
		case 't':		/* table of contents */
			Toc++;
			break;
		case 'u':		/* copy unconditionally */
			Uncond++;
			break;
		case 'v':		/* verbose table of contents */
			Verbose=1;
			break;
		case 'V':		/* print a dot '.' for each file */
			Verbose=2;
			break;
		case 'M':		/* alternate message for end-of-media */
			eommsg = optarg;	/* jc0 */
			break;
		case '6':		/* for old, sixth-edition files */
			Filetype = 060000;
			break;
		case 'I':		
			chkswfile( swfile, ans, Option);
			close(Input);
			if(open(optarg, O_RDONLY) != Input)
				cannotopen(optarg, "input");
			swfile = optarg;
			break;
		case 'O':		
			chkswfile( swfile, ans, Option);
			close(Output);
			if(open(optarg, O_WRONLY | O_CREAT | O_TRUNC,0666)
				!= Output)
				cannotopen(optarg, "output");
			swfile = optarg;
			break;
		case 'k':	/* jc0 */
			fprintf(stderr,"The '-k' option is not available.\n");
			doexit(2);
		case 'D':
			debug++;
			fprintf(stderr,"Debugging has been enabled.\n");
			break;
		case 'T':
			Tflag++;	/* jc2 */
				/* process time here to catch usage */
			if ( optarg[0] == '.')	/* use current date */
				time(&New_time);
			else
				New_time=change_to_seconds(optarg);

			if (New_time == 0)
				(void) Tusage();
				/* only calculate Old_time once */
			Old_time=change_to_seconds(Old_date);
			break;
		default:
			if (mktape)
				(void) Tusage();
			usage();
		}
	}

	if (mktape && (Option != OUT)) {	 /* jc2 */
		fprintf(stderr,"Error:  The 'T' option requires\n");
		fprintf(stderr,"the 'o' option.\n\n");
		(void) Tusage();
	}

	if(!Option) {
		fprintf(stderr,"Options must include o|i|p\n");
		doexit(2);
	}

	if(Option == PASS) {
		if(Rename) {
			fprintf(stderr,"Pass and Rename cannot be used together\n");
			doexit(2);
		}
		if(Bufsize == 5120) {
			printf("`B' option is irrelevant with the '-p' option\n");
			Bufsize = BUFSIZE;
		}
	}else  {
/* sw1 */
		if(Cflag) {
		    Cp = Cbuf = (char *)malloc(Bufsize+8192);
		    Cp = Cbuf = (Cp + 4096) - ((int)Cp % 4096);
		}
		else {
		    Wp = (short *)malloc(Bufsize+8192);
		    Wp = Dbuf = (Wp + 4096) - ((int)Wp % 4096);
		}
	}
	Wct = Bufsize >> 1;
	Wc = Bufsize;

	if(qflag & OUT) 
		dofork();	/* hh2 shen for fast cpio output */
	else {
		if ((fastbuf=malloc(BNUM)) == NULL) {
			fprintf(stderr,"Insufficient memory\n");
			doexit(2);
		}
		fstptr = fstwptr = fastbuf;
	}	

	switch(Option) {

	case OUT:		/* get filename, copy header and file out */
		while(getname()) {
			(void) signal(SIGINT, onint);
			(void) signal(SIGHUP, onhup);
			(void) signal(SIGQUIT, onquit);

			if( mklong(Hdr.h_filesize) == 0L) {
			   	if( Cflag )
					writehdr(Chdr,CHARS+Hdr.h_namesize);
			   	else
					bwrite(&Hdr, HDRSIZE+Hdr.h_namesize);
				if(Verbose) 	     /* hh1 */
					verbdot(stderr, Hdr.h_name);
			   	continue;
			}
			if (Tflag){	/* jc2 */
				if((Ifile = open(Spec.old_name, 0)) < 0) {
					fprintf(stderr,"<%s> ?\n", Spec.old_name);
					doexit(2); /* "T" aborts on error */
				}
			}else{
				if((Ifile = open(Hdr.h_name, 0)) < 0) {
					fprintf(stderr,"<%s> ?\n", Hdr.h_name);
					continue;
				}
			}
			if ( Cflag )
				writehdr(Chdr,CHARS+Hdr.h_namesize);
			else
			{
				bwrite(&Hdr, HDRSIZE+Hdr.h_namesize);
}
			for(filesz=mklong(Hdr.h_filesize); filesz>0; filesz-= CPIOBSZ){
				ct = filesz>CPIOBSZ? CPIOBSZ: filesz;
				if(read(Ifile, B.BBuf, ct) < 0) { /* eb3 */
					if (Tflag)	/* jc2 */
						fprintf(stderr,"Cannot read %s\n", Spec.old_name);
					else
						fprintf(stderr,"Cannot read %s\n", Hdr.h_name);
					doexit(1); /* sw4 */
				}
				Cflag? writehdr(B.BBuf,ct): bwrite(B.Buf,ct); /* eb3 */
			}
			close(Ifile);
			if(Acc_time)
				if (Tflag)	/* jc2 */
					utime(Spec.old_name, &Statb.st_atime);
				else
					utime(Hdr.h_name, &Statb.st_atime);
			if(Verbose)
				verbdot(stderr, Hdr.h_name);
		}
	/* copy trailer, after all files have been copied */

		strcpy(Hdr.h_name, "TRAILER!!!");
		Hdr.h_magic = MAGIC;
		MKSHORT(Hdr.h_filesize, 0L);
		Hdr.h_namesize = strlen("TRAILER!!!") + 1;
		if ( Cflag )  {
			bintochar(0L);
			writehdr(Chdr,CHARS+Hdr.h_namesize);
		}
		else
			bwrite(&Hdr, HDRSIZE+Hdr.h_namesize);
		sav_Blocks = Blocks;
		sav_pBlocks = pBlocks;

		if(qflag) qflag |= LAST;  
		Cflag? writehdr(Cbuf, Bufsize): bwrite(Dbuf, Bufsize);
		Blocks = sav_Blocks;
		pBlocks = sav_pBlocks;
		break;

	case IN:
		pwd();
		while(gethdr()) {
			(void) signal(SIGINT, onint);
			(void) signal(SIGHUP, onhup);
			(void) signal(SIGQUIT, onquit);
			Ofile = ckname(Hdr.h_name)? openout(Hdr.h_name): 0;
			for(filesz=mklong(Hdr.h_filesize); filesz>0; filesz-= CPIOBSZ){
				ct = filesz>CPIOBSZ? CPIOBSZ: filesz;
				Cflag? readhdr(B.BBuf,ct): bread(B.Buf, ct); /* eb3 */
				if(Ofile) {
					if(Swap)
						swap(B.Buf,ct); /* eb3 */
					if(write(Ofile, B.BBuf, ct) < 0) { /* eb3 */
					 fprintf(stderr,"Cannot write %s\n", Hdr.h_name);
					 continue;
					}
				}
			}
			if(Ofile) {
				close(Ofile);
				if(chmod(Hdr.h_name, Hdr.h_mode) < 0) {
					fprintf(stderr,"Cannot chmod <%s> (errno:%d)\n", Hdr.h_name, errno);
				}
				set_time(Hdr.h_name, mklong(Hdr.h_mtime), mklong(Hdr.h_mtime));
			}
			if(!Select)
				continue;
			if(Verbose)
				if(Toc)
					pentry(Hdr.h_name);
				else
					verbdot(stdout, Hdr.h_name);
			else if(Toc)
				puts(Hdr.h_name);
		}
		break;

	case PASS:		/* move files around */
			(void) signal(SIGINT, onint);
			(void) signal(SIGHUP, onhup);
			(void) signal(SIGQUIT, onquit);
		fullp = Fullname + strlen(Fullname);

		while(getname()) {
			if (A_directory && !Dir)
				fprintf(stderr,"Use `-d' option to copy <%s>\n",Hdr.h_name);
			if(!ckname(Hdr.h_name))
				continue;
			i = 0;
			while(Hdr.h_name[i] == '/')
				i++;
			strcpy(fullp, &(Hdr.h_name[i]));

			if(Link
			&& !A_directory
			&& Dev == Statb.st_dev)  {
/* ???			&& (Uid == Statb.st_uid || !Uid)) {*/
				if(link(Hdr.h_name, Fullname) < 0) { /* missing dir.? */
					if(errno == EEXIST)
						fprintf(stderr, "Cannot link <%s> & <%s> (errno:%d)\n",
						 Hdr.h_name, Fullname, errno);
					else {
						unlink(Fullname);
						missdir(Fullname);
						if(link(Hdr.h_name, Fullname) < 0) {
							fprintf(stderr, "Cannot link <%s> & <%s> (errno:%d)\n", Hdr.h_name, Fullname, errno);
							continue;
						}
					}
				}

/* try creating (only twice) */
				ans = 0;
				do {
					if(link(Hdr.h_name, Fullname) < 0) { /* missing dir.? */
						if(errno == EEXIST) {
							ans = 3;
							break;
							}
						else
							unlink(Fullname);
						ans += 1;
					}else {
						ans = 0;
						break;
					}
				}while(ans < 2 && missdir(Fullname) == 0);
				if(ans == 1) {
					fprintf(stderr,"Cannot create directory for <%s> (errno:%d)\n", Fullname, errno);
					doexit(1);
				}else if(ans == 2) {
					fprintf(stderr,"Cannot link <%s> & <%s> (errno:%d)\n", Hdr.h_name, Fullname, errno);
					doexit(1);
				}

				if(!Link)
					if(chmod(Hdr.h_name, Hdr.h_mode) < 0) {
						fprintf(stderr,"Cannot chmod <%s> (errno:%d)\n", Hdr.h_name, errno);
					}
				set_time(Hdr.h_name, mklong(Hdr.h_mtime), mklong(Hdr.h_mtime));
				goto ckverbose;
			}
			if(!(Ofile = openout(Fullname)))
				continue;
			if (Tflag){ /* jc2 */
				if((Ifile = open(Spec.old_name, 0)) < 0) {
					fprintf(stderr,"<%s> ?\n", Spec.old_name);
					close(Ofile);
					doexit(2);
				}
			}else{
				if((Ifile = open(Hdr.h_name, 0)) < 0) {
					fprintf(stderr,"<%s> ?\n", Hdr.h_name);
					close(Ofile);
					continue;
				}
			}
			filesz = Statb.st_size;
			for(; filesz > 0; filesz -= CPIOBSZ) {
				ct = filesz>CPIOBSZ? CPIOBSZ: filesz;
				if(read(Ifile, B.BBuf, ct) < 0) { /* eb3 */
					if(Tflag) /* jc2 */
						fprintf(stderr,"Cannot read %s\n",Spec.old_name);
					else
						fprintf(stderr,"Cannot read %s\n", Hdr.h_name);
					doexit(1); /* was a break;  eb1 */
				}
				if(Ofile)
					if(write(Ofile, B.BBuf, ct) < 0) { /* eb3 */
					 fprintf(stderr,"Cannot write %s\n", Hdr.h_name);
					 doexit(1); /* was a break;  eb1 */
					}
				Blocks += ((ct + (BUFSIZE - 1)) / BUFSIZE);
			}
			close(Ifile);
			if(Acc_time)
				if (Tflag) /* jc2 */
					utime(Spec.old_name, &Statb.st_atime);
				else
					utime(Hdr.h_name, &Statb.st_atime);
			if(Ofile) {
				close(Ofile);
				if(chmod(Fullname, Hdr.h_mode) < 0) {
					fprintf(stderr,"Cannot chmod <%s> (errno:%d)\n", Fullname, errno);
				}
				set_time(Fullname, Statb.st_atime, mklong(Hdr.h_mtime));
ckverbose:
				if(Verbose)
					verbdot(stderr,Fullname);
			}
		}
	}
	/* print number of blocks actually copied */
	   Blocks += ((pBlocks + (BUFSIZE - 1)) / BUFSIZE);
	   fprintf(stderr,"%ld blocks\n", Blocks );
	doexit(0);
}

static
usage()
{
	errusage("%s\n\t%s %s\n\t%s %s\n\t%s %s\n\t%s %s\n",
		    "-o[acvVB] [-Cbufsize] [-Mmessage] <name-list >collection",
	Err.source, "-o[acvVB] -Ocollection [-Cbufsize] [-Mmessage] <name-list",
	Err.source, "-i[bcdkmrsStuvVfB6] [-Cbufsize] [-Mmessage] [pattern ...] <collection",
	Err.source, "-i[bcdkmrsStuvVfB6] -Icollection [-Cbufsize] [-Mmessage] [pattern ...]",
	Err.source, "-p[adlmruvV] directory <name-list");
}

static
chkswfile( sp, c, option )
char	*sp;
char	c;
short	option;
{
	if( !option )
		fprintf(stderr,"-%c must be specified before -%c option.",
			c == 'I' ? 'i' : 'o', c );
	if( (c == 'I'  &&  option != IN)  ||  (c == 'O'  &&  option != OUT) )
		fprintf(stderr,"-%c option not permitted with -%c option.", c,
			option );
	if( !sp )
		return;
	fprintf(stderr,"No more than one -I or -O flag permitted.");
}

static
cannotopen( sp, mode )
char	*sp, *mode;
{
	fprintf(stderr,"Cannot open <%s> for %s.", sp, mode );
}

static
int
getname()		/* get file name, get info for header */
{
	register char *namep; /*sw6*/
	register ushort ftype;
	long tlong;

	for(;;) {
		namep = Name; /*sw6*/
		if (Tflag){	/* get a whole specification string jc2 */
			if(getspec() == 0)
				return 0;
			strcpy(namep,Spec.old_name); /* for compatability  */
				/* with the manipulation of namep below */
		} else if(gets(namep) == NULL) return 0;

		if(*namep == '.' && namep[1] == '/') {
			namep++;
			while(*namep == '/') namep++;
		}
		if (Tflag) 	/* jc2 */
			strcpy(Spec.old_name, namep);
		else
			strcpy(Hdr.h_name, namep);

		if(stat(namep, &Statb) < 0) {
			fprintf(stderr,"< %s > ?\n", namep); /* jc0 - changed */
				/* Hdr.h_name to namep */
			if (Tflag)	/* jc2 */
				doexit(2);	/* abort on error */
			continue;
		}

		Hdr.h_magic = MAGIC;
		Hdr.h_dev = Statb.st_dev;
		Hdr.h_ino = Statb.st_ino;
		if (Tflag){	/* jc2 */
			Hdr.h_nlink = Spec.n_links;
			strcpy(Hdr.h_name,Spec.new_name);
			Hdr.h_uid = Spec.new_uid;
			Hdr.h_gid = Spec.new_gid;
			Hdr.h_mode = Spec.new_mode;
			ftype = Hdr.h_mode & Filetype;
			MKSHORT(Hdr.h_mtime, Spec.new_time);
		}
		else{
			Hdr.h_nlink = Statb.st_nlink;
			Hdr.h_uid = Statb.st_uid;
			Hdr.h_gid = Statb.st_gid;
			Hdr.h_mode = Statb.st_mode;
			ftype = Statb.st_mode & Filetype;
			MKSHORT(Hdr.h_mtime, Statb.st_mtime);
		}
		A_directory = (ftype == S_IFDIR);
		A_special = (ftype == S_IFBLK)
			|| (ftype == S_IFCHR)
			|| (ftype == S_IFIFO);
		Hdr.h_namesize = strlen(Hdr.h_name) + 1;
		tlong = (Hdr.h_mode&S_IFMT) == S_IFREG? Statb.st_size: 0L;
		MKSHORT(Hdr.h_filesize, tlong);
		Hdr.h_rdev = Statb.st_rdev;
		if( Cflag )
			bintochar(tlong);
		return 1;
	}
}

static
bintochar(t)		/* ASCII header write */
long t;
{
	sprintf(Chdr,"%.6o%.6ho%.6ho%.6ho%.6ho%.6ho%.6ho%.6ho%.11lo%.6ho%.11lo%s",
		MAGIC,Statb.st_dev,Statb.st_ino,Statb.st_mode,Statb.st_uid,
		Statb.st_gid,Statb.st_nlink,Statb.st_rdev & 00000177777,
		Statb.st_mtime,(short)strlen(Hdr.h_name)+1,t,Hdr.h_name);
}

static
chartobin()		/* ASCII header read */
{
	sscanf(Chdr,"%6ho%6ho%6ho%6ho%6ho%6ho%6ho%6ho%11lo%6ho%11lo",
		&Hdr.h_magic,&Hdr.h_dev,&Hdr.h_ino,&Hdr.h_mode,&Hdr.h_uid,
		&Hdr.h_gid,&Hdr.h_nlink,&Hdr.h_rdev,&Longtime,&Hdr.h_namesize,
		&Longfile);
	MKSHORT(Hdr.h_filesize, Longfile);
	MKSHORT(Hdr.h_mtime, Longtime);
}

static
gethdr()		/* get file headers */
{
	register ushort ftype;

	if (Cflag)  {
		readhdr(Chdr,CHARS);
		chartobin();
	}
	else
		bread(&Hdr, HDRSIZE);

	if(Hdr.h_magic != MAGIC) {
		fprintf(stderr,"Out of phase--get help\n");
		fprintf(stderr,"Perhaps the \"-c\" option should be used\n");
		doexit(2);
	}
	if(Cflag)
		readhdr(Hdr.h_name, Hdr.h_namesize);
	else
		bread(Hdr.h_name, Hdr.h_namesize);
	if(EQ(Hdr.h_name, "TRAILER!!!"))
		return 0;
	ftype = Hdr.h_mode & Filetype;
	A_directory = (ftype == S_IFDIR);
	A_special =(ftype == S_IFBLK)
		|| (ftype == S_IFCHR)
		|| (ftype == S_IFIFO);
	return 1;
}

static
ckname(namep)	/* check filenames with patterns given on cmd line */
register char *namep;
{
	++Select;
	if(fflag ^ !nmatch(namep, Pattern)) {
		Select = 0;
		return 0;
	}
	if(Rename && !A_directory) {	/* rename interactively */
		fprintf(Wtty, "Rename <%s>\n", namep);
		fflush(Wtty);
		fgets(namep, 128, Rtty);
		if(feof(Rtty))
			doexit(2);
		namep[strlen(namep) - 1] = '\0';
		if(EQ(namep, "")) {
			fprintf(stderr,"Skipped\n");
			return 0;
		}
	}
	return !Toc;
}

static
openout(namep)	/* open files for writing, set all necessary info */
register char *namep;
{
	register f;
	register char *np;
	int ans;

	if(!strncmp(namep, "./", 2))
		namep += 2;
	np = namep;
/*
	if(Option == IN)
		Cd_name = namep = cd(namep);
*/
	if(A_directory) {
		if(!Dir
		|| Rename
		|| EQ(namep, ".")
		|| EQ(namep, ".."))	/* do not consider . or .. files */
			return 0;
		if(stat(namep, &Xstatb) == -1) {

/* try creating (only twice) */
			ans = 0;
			do {
				if(makdir(namep) != 0) {
					ans += 1;
				}else {
					ans = 0;
					break;
				}
			}while(ans < 2 && missdir(namep) == 0);
			if(ans == 1) {
				fprintf(stderr,"Cannot create directory for <%s> (errno:%d)\n", namep, errno);
				return(0);
			}else if(ans == 2) {
				fprintf(stderr,"Cannot create directory <%s> (errno:%d)\n", namep, errno);
				return(0);
			}
		}

ret:
		if(chmod(namep, Hdr.h_mode) < 0) {
			fprintf(stderr,"Cannot chmod <%s> (errno:%d)\n", namep, errno);
		}
		if(Uid == 0)
			if(chown(namep, Hdr.h_uid, Hdr.h_gid) < 0) {
				fprintf(stderr,"Cannot chown <%s> (errno:%d)\n", namep, errno);
			}
		set_time(namep, mklong(Hdr.h_mtime), mklong(Hdr.h_mtime));
		return 0;
	}
	if(Hdr.h_nlink > 1)
		if(!postml(namep, np))
			return 0;
	if(stat(namep, &Xstatb) == 0) {
		if(Uncond && !((!(Xstatb.st_mode & S_IWRITE) || A_special) && (Uid != 0))) {
			if(unlink(namep) < 0) {
				fprintf(stderr,"cannot unlink current <%s> (errno:%d)\n", namep, errno);
			}
		}
		if(!Uncond && (mklong(Hdr.h_mtime) <= Xstatb.st_mtime)) {
		/* There's a newer version of file on destination */
			if(mklong(Hdr.h_mtime) < Xstatb.st_mtime)
				fprintf(stderr,"current <%s> newer\n", np);
			return 0;
		}
	}
	if(Option == PASS
	&& Hdr.h_ino == Xstatb.st_ino
	&& Hdr.h_dev == Xstatb.st_dev) {
		fprintf(stderr,"Attempt to pass file to self!\n");
		doexit(2);
	}
	if(A_special) {
		if((Hdr.h_mode & Filetype) == S_IFIFO)
			Hdr.h_rdev = 0;

/* try creating (only twice) */
		ans = 0;
		do {
			if(mknod(namep, Hdr.h_mode, Hdr.h_rdev) < 0) {
				ans += 1;
			}else {
				ans = 0;
				break;
			}
		}while(ans < 2 && missdir(np) == 0);
		if(ans == 1) {
			fprintf(stderr,"Cannot create directory for <%s> (errno:%d)\n", namep, errno);
			return(0);
		}else if(ans == 2) {
			fprintf(stderr,"Cannot mknod <%s> (errno:%d)\n", namep, errno);
			return(0);
		}

		goto ret;
	}
/* try creating (only twice) */
	ans = 0;
	do {
		if((f = creat(namep, ~usrmask)) < 0) {
			ans += 1;
		}else {
			ans = 0;
			break;
		}
	}while(ans < 2 && missdir(np) == 0);
	if(ans == 1) {
		fprintf(stderr,"Cannot create directory for <%s> (errno:%d)\n", namep, errno);
		return(0);
	}else if(ans == 2) {
		fprintf(stderr,"Cannot create <%s> (errno:%d)\n", namep, errno);
		return(0);
	}

	if(Uid == 0)
		chown(namep, Hdr.h_uid, Hdr.h_gid);
	return f;
}

static
bread(b, c)
register c;
register short *b;
{
	static nleft = 0;
	static short *ip;
	register int in;
	register int rv;
	register short *p = ip;

	pBlocks += c;
	c = (c+1)>>1;
	if (pBlocks > BUFSIZE) {
		Blocks += pBlocks/BUFSIZE;
		pBlocks = pBlocks%BUFSIZE;
		Blocks += pBlocks/BUFSIZE;
	}
	while(c--) {
		if(nleft == 0) {
			in = 0;
 		    if(qflag & IN){
			while((rv=readit(Bufsize-in,&(((char *)Dbuf)[in]))) != Bufsize - in) {
 				if(rv <= 0) {
					Input = chgreel(0, Input, rv); /* jc0 */
					continue;
				}
 				in += rv;
 				nleft += (rv >> 1);
 			}
 			nleft += (rv >> 1);
 			p = Dbuf;
 	   	    }
			else {
			while((rv=read(Input, &(((char *)Dbuf)[in]), Bufsize - in)) != Bufsize - in) {
				if(rv <= 0) {
					Input = chgreel(0, Input, rv); /* jc0 */
					continue;
				}
				in += rv;
				nleft += (rv >> 1);
			    }
			nleft += (rv >> 1);
			p = Dbuf;
			
			}
		}
		*b++ = *p++;
		--nleft;
	}
	ip = p;
}

static
readhdr(b, c)
register c;
register char *b;
{
	static nleft = 0;
	static char *ip;
	register int in;
	register int rv;
	register char *p = ip;

	pBlocks += c;
	if (pBlocks > BUFSIZE) {
		Blocks += pBlocks/BUFSIZE;
		pBlocks = pBlocks%BUFSIZE;
		Blocks += pBlocks/BUFSIZE;
	}

	while(c--)  {
		if(nleft == 0) {
			in = 0;
 		    if(qflag & IN){
 			while((rv=readit(Bufsize-in,&(((char *)Cbuf)[in]))) != Bufsize - in) {
 				if(rv <= 0) {
 					Input = chgreel(0, Input, rv); /* jc0 */
 					continue;
 				}
 				in += rv;
 				nleft += rv;
 			}
 			nleft += rv;
 			p = Cbuf;
 	   	    }
			else {
			while((rv=read(Input, &(((char *)Cbuf)[in]), Bufsize - in)) != Bufsize - in) {
				if(rv <= 0) {
					Input = chgreel(0, Input, rv); /*jc0*/
					continue;
				}
				in += rv;
				nleft += rv;
				}
			nleft += rv;
			p = Cbuf;
			}
		}
		*b++ = *p++;
		--nleft;
	}
	ip = p;
}

void onint()
{	
	(void) signal(SIGINT, onint);	/* have to reset error handling */
	doexit(4);
}

void onhup()
{	
	(void) signal(SIGHUP, onhup);	/* ditto */
	doexit(4);
}

void onquit()
{	
	(void) signal(SIGQUIT, onquit); /* take a wild guess */
	doexit(4);
}


static
bwrite(rp, c)
register short *rp;
register c;
{
	register short *wp = Wp;
	register int in, rv;

	pBlocks += c;
	c = (c+1)>>1;
	if (pBlocks > BUFSIZE) {
		Blocks += pBlocks/BUFSIZE;
		pBlocks = pBlocks%BUFSIZE;
	}

	while (c) {

		if(!Wct) {
		    in = 0;
 		    if(qflag & OUT){
 			while( (rv=writeit(Bufsize - in,&(((char *)Dbuf)[in]))) 
					!= Bufsize - in ) {
				if(rv < 0) 
				     die(10,"maketape : writeit returned error\n");  /* jc2 */
				in += rv;  
 			}
 			Wct = Bufsize >> 1;
 			wp = Dbuf;
 		    }
			else{
 				while((rv=write(Output, &(((char *)Dbuf)[in]),Bufsize - in)) != Bufsize - in) {
					if(rv < 0) {
 						Output = chgreel(1, Output, rv); /* jc0 */
						continue;
					}
					in += rv;
 				}
				Wct = Bufsize >> 1;
				wp = Dbuf;
			}
		}

/* sw2 */
		if ( c < Wct ) {
			memcpy(wp, rp, (c << 1) );
			wp += c;
			rp += c;
			Wct -= c;
			c = 0;
		}
		else {
			memcpy(wp, rp, (Wct << 1) );
			wp += Wct;
			rp += Wct;
			c -= Wct;
			Wct = 0;
		}

	}
	Wp = wp;
}

static
writehdr(rp, c)
register char *rp;
register c;
{
	register char *cp = Cp;
	register int in, rv;

	pBlocks += c;
	if (pBlocks > BUFSIZE) {
		Blocks += pBlocks/BUFSIZE;
		pBlocks = pBlocks%BUFSIZE;
	}

	while(c--)  {
		if(!Wc)  {
		    in = 0;
 		    if(qflag & OUT){
 			while( (rv=writeit(Bufsize - in,&(((char *)Cbuf)[in]))) 
					!= Bufsize - in ) {
				if(rv < 0) 
				    die(11,"maketape : writeit returned error\n"); /* jc2 */
				in += rv;
 			}
 			Wc = Bufsize;
 			cp = Cbuf;
 		    }
			else{
 				while((rv=write(Output, &(((char *)Cbuf)[in]),
				Bufsize - in)) != Bufsize - in) {
					if(rv < 0) {
 						Output = chgreel(1, Output, rv); /* jc0 */
						continue;
					}
					in += rv;
 				}
				Wc = Bufsize;
				cp = Cbuf;
			}
		}
		*cp++ = *rp++;
		--Wc;
	}
	Cp = cp;
}

static
postml(namep, np)		/* linking funtion */
register char *namep, *np;
{
	register i;
	static struct ml {
		short	m_dev,
			m_ino;
		char	m_name[2];
	} *ml[LINKS];
	static	mlinks = 0;
	char *mlp;
	int ans;

	for(i = 0; i < mlinks; ++i) {
		if(mlinks == LINKS) break;
		if(ml[i]->m_ino==Hdr.h_ino &&
			ml[i]->m_dev==Hdr.h_dev) {
			if(Verbose == 1)
			  	fprintf(stderr,"%s linked to %s\n",ml[i]->m_name, np);
			if(Verbose)
				verbdot(stdout, np);
			unlink(namep);
			if(Option == IN && *ml[i]->m_name != '/') {
				Fullname[Pathend] = '\0';
				strcat(Fullname, ml[i]->m_name);
				mlp = Fullname;
			}
			mlp = ml[i]->m_name;

/* try linking (only twice) */
			ans = 0;
			do {
				if(link(mlp, namep) < 0) {
					ans += 1;
				}else {
					ans = 0;
					break;
				}
			}while(ans < 2 && missdir(np) == 0);
			if(ans == 1) {
				fprintf(stderr,"Cannot create directory for <%s> (errno:%d)\n", np, errno);
				return(0);
			}else if(ans == 2) {
				fprintf(stderr,"Cannot link <%s> & <%s> (errno:%d)\n", ml[i]->m_name, np, errno);
				return(0);
			}

			set_time(namep, mklong(Hdr.h_mtime), mklong(Hdr.h_mtime));
			return 0;
		}
	}
	if(mlinks == LINKS
	|| !(ml[mlinks] = (struct ml *)malloc(strlen(np) + 2 + sizeof(struct ml)))) {
		static int first=1;

		if(first)
			if(mlinks == LINKS)
				fprintf(stderr,"Too many links\n");
			else
				fprintf(stderr,"No memory for links\n");
		mlinks = LINKS;
		first = 0;
		return 1;
	}
	ml[mlinks]->m_dev = Hdr.h_dev;
	ml[mlinks]->m_ino = Hdr.h_ino;
	strcpy(ml[mlinks]->m_name, np);
	++mlinks;
	return 1;
}

static
pentry(namep)		/* print verbose table of contents */
register char *namep;
{

	static short lastid = -1;
#include <pwd.h>
	static struct passwd *pw;
	struct passwd *getpwuid();
	static char tbuf[32];
	register pid;
	static status;

	if(pid = fork())
		{
		while(wait(&status) != pid);
		}
	else if(pid == -1) {
		fprintf(stderr,"Cannot fork, try again\n");
		doexit(2);
	}
	else {
	printf("%-7o", Hdr.h_mode & 0177777);
	if(lastid == Hdr.h_uid)
		printf("%-6s", pw->pw_name);
	else {
		setpwent();
		if(pw = getpwuid((int)Hdr.h_uid)) {
			printf("%-6s", pw->pw_name);
			lastid = Hdr.h_uid;
		} else {
			printf("%-6d", Hdr.h_uid);
			lastid = -1;
		}
	}
	printf("%7ld ", mklong(Hdr.h_filesize));
	U.l = mklong(Hdr.h_mtime);
	cftime(time_buf, FORMAT, (long *)&U.l);
	printf(" %s  %s\n", time_buf, namep);
	doexit(0);
	}
}

		/* pattern matching functions */
static
nmatch(s, pat)
char *s, **pat;
{
	if(EQ(*pat, "*"))
		return 1;
	while(*pat) {
		if((**pat == '!' && !gmatch(s, *pat+1))
		|| gmatch(s, *pat))
			return 1;
		++pat;
	}
	return 0;
}
static
gmatch(s, p)
register char *s, *p;
{
	register int c;
	register cc, ok, lc, scc;

	scc = *s;
	lc = 077777;
	switch (c = *p) {

	case '[':
		ok = 0;
		while (cc = *++p) {
			switch (cc) {

			case ']':
				if (ok)
					return(gmatch(++s, ++p));
				else
					return(0);

			case '-':
				ok |= ((lc <= scc) && (scc <= (cc=p[1])));
			}
			if (scc==(lc=cc)) ok++;
		}
		return(0);

	case '?':
	caseq:
		if(scc) return(gmatch(++s, ++p));
		return(0);
	case '*':
		return(umatch(s, ++p));
	case 0:
		return(!scc);
	}
	if (c==scc) goto caseq;
	return(0);
}

static
umatch(s, p)
register char *s, *p;
{
	if(*p==0) return(1);
	while(*s)
		if (gmatch(s++,p)) return(1);
	return(0);
}

static
makdir(namep)		/* make needed directories */
register char *namep;
{
	static status;
	register pid;

	if(pid = fork())
		{
		while(wait(&status) != pid);
		}
	else if(pid == -1) {
		fprintf(stderr,"Cannot fork, try again\n");
		doexit(2);
	}
	else {
		close(2);
		execl("/bin/mkdir", "mkdir", namep, 0);
		doexit(2);
	}
	return ((status>>8) & 0377)? 1: 0;
}

static
swap(buf, ct)		/* swap halfwords, bytes or both */
register ct;
register char *buf;
{
	register char c;
	register union swp { long	longw; short	shortv[2]; char charv[4]; } *pbuf;
	int savect, n, i;
	char *savebuf;
	short cc;

	savect = ct;	savebuf = buf;
	if(byteswap || bothswap) {
		if (ct % 2) buf[ct] = 0;
		ct = (ct + 1) / 2;
		while (ct--) {
			c = *buf;
			*buf = *(buf + 1);
			*(buf + 1) = c;
			buf += 2;
		}
		if (bothswap) {
			ct = savect;
			pbuf = (union swp *)savebuf;
			if (n = ct % sizeof(union swp)) {
				if(n % 2)
					for(i = ct + 1; i <= ct + (sizeof(union swp) - n); i++) pbuf->charv[i] = 0;
				else
					for (i = ct; i < ct + (sizeof(union swp) - n); i++) pbuf->charv[i] = 0;
			}
			ct = (ct + (sizeof(union swp) -1)) / sizeof(union swp);
			while(ct--) {
				cc = pbuf->shortv[0];
				pbuf->shortv[0] = pbuf->shortv[1];
				pbuf->shortv[1] = cc;
				++pbuf;
			}
		}
	}
	else if (halfswap) {
		pbuf = (union swp *)buf;
		if (n = ct % sizeof(union swp))
			for (i = ct; i < ct + (sizeof(union swp) - n); i++) pbuf->charv[i] = 0;
		ct = (ct + (sizeof(union swp) -1)) / sizeof(union swp);
		while (ct--) {
			cc = pbuf->shortv[0];
			pbuf->shortv[0] = pbuf->shortv[1];
			pbuf->shortv[1] = cc;
			++pbuf;
		}
	}
}
static
set_time(namep, atime, mtime)	/* set access and modification times */
register *namep;
long atime, mtime;
{
	static long timevec[2];

	if(!Mod_time)
		return;
	timevec[0] = atime;
	timevec[1] = mtime;
	utime(namep, timevec);
}

static int	reelcount = 1;	/* used below and in chgreel() */	/* jc0 */

static
chgreel(x, fl, rv) /* x : 0 = input, 1 = output */
{		   /* fl - file descriptor ; rv - return value from write */
	register f;
	char str[BUFSIZ];
	struct stat statb;
	int tmperrno;

	tmperrno = errno;
	fstat(fl, &statb);
	if ((statb.st_mode&S_IFMT) != S_IFCHR)
		{
		if (x && rv == -1)
			switch (tmperrno)
				{
				case EFBIG:	fperr("maketape: ulimit reached for output file\n"); /* jc2 */
						break;
				case ENOSPC:	fperr("maketape: no space left for output file\n"); /* jc2 */
						break;
				default:	errmsg( EERROR,
							"write() failed\n");
				}
		else
			fperr( "Can't read input:  end of file encountered \
prior to expected end of archive.\n");
		doexit(2);
		}
	if ( (rv == 0) || ( (rv == -1) && 
		(tmperrno == ENOSPC || tmperrno == ENXIO || tmperrno == EIO)) )
		fperr("\007Reached end of medium on %s.\n",x?"output":"input");
	else
		{
		fperrno( "\007Encountered an error on %s", x? "output":"input");
		doexit(2);
		}
	if( Rtty == NULL )
		Rtty = zfopen( EERROR, ttyname, "r");
	close(fl);
	reelcount++;
again:
	if( swfile ) {
	    askagain:
		fperr( eommsg, reelcount );
		fgets(str, sizeof str, Rtty);
		switch( *str ) {
		case '\n':
			strcpy( str, swfile );
			break;
		case 'q':
			doexit(2);
		default:
			goto askagain;
		}
	}
	else {
		fperr("If you want to go on, type device/file name when ready.\n");
		fgets(str, sizeof str, Rtty);
		str[strlen(str) - 1] = '\0';
		if(!*str)
			doexit(2);
	}
	if((f = open(str, x )) < 0) {
		fperr("That didn't work, cannot open \"%s\"\n", str);
		if( errno )
			perror("");
		goto again;
	}
	return f;
}

static
missdir(namep)
register char *namep;
{
	register char *np;
	register ct = 2;

	for(np = namep; *np; ++np)
		if(*np == '/') {
			if(np == namep) continue; /* skip over 'root slash' */
			*np = '\0';
			if(stat(namep, &Xstatb) == -1) {
				if(Dir) {
					if((ct = makdir(namep)) != 0) {
						*np = '/';
						return(ct);
					}
				}else {
					fprintf(stderr,"missing 'd' option\n");
					return(-1);
				}
			}
			*np = '/';
		}
	if (ct == 2) ct = 0;		/* the file already exists */
	return ct;
}

static
pwd()		/* get working directory */
{
	FILE *dir;

	dir = popen("pwd", "r");
	fgets(Fullname, 256, dir);
	if(pclose(dir))
		doexit(2);
	Pathend = strlen(Fullname);
	Fullname[Pathend - 1] = '/';
}
static
char * cd(n)		/* change directories */
register char *n;
{
	char *p_save = Name, *n_save = n, *p_end = 0;
	register char *p = Name;
	static char dotdot[]="../../../../../../../../../../../../../../../../../../../../../../../../../../../../../../../../";
	int slashes, ans;

	if(*n == '/') /* don't try to chdir on full pathnames */
		return n;
	for(; *p && *n == *p; ++p, ++n) { /* whatever part of strings == */
		if(*p == '/')
			p_save = p+1, n_save = n+1;
	}

	p = p_save;
	*p++ = '\0';
	for(slashes = 0; *p; ++p) { /* if prev is longer, chdir("..") */
		if(*p == '/')
			++slashes;
	}
	p = p_save;
	if(slashes) {
		slashes = slashes * 3 - 1;
		dotdot[slashes] = '\0';
		chdir(dotdot);
		dotdot[slashes] = '/';
	}

	n = n_save;
	for(; *n; ++n, ++p) {
		*p = *n;
		if(*n == '/')
			p_end = p+1, n_save = n+1;
	}
	*p = '\0';

	if(p_end) {
		*p_end = '\0';
		if(chdir(p_save) == -1) {
			if((ans = missdir(p_save)) == -1) {
				fprintf(stderr,"Cannot chdir (no `d' option)\n");
				doexit(2);
			} else if (ans > 0)  {
				fprintf(stderr,"Cannot chdir - no write permission\n");
				doexit(2);
			} else if(chdir(p_save) == -1)  {
				fprintf(stderr,"Cannot chdir\n");
				doexit(2);
			}
		}
	} else
		*p_save = '\0';
	return n_save;
}

static
readit(bcount,baddr)
int bcount;
char *baddr;
{

	int i,blkread;
	static newcnt = 0;
	static oldcnt = 0; /* eb2 */
	static bytecnt = 0;
	char *iptr;
	static short rblkdone;

	if(bytecnt >= newcnt){
		if((newcnt = read(Input,fastbuf,BNUM)) <= 0)
			return(newcnt);
		fstptr = fastbuf;
		bytecnt = 0;
		if(oldcnt) { /* eb2 */
			fstptr += oldcnt;
			bytecnt += oldcnt;
			oldcnt = 0;
		}
		if(newcnt != BNUM)
			oldcnt = newcnt;
	}

	for(i=0,iptr = baddr; i<bcount && bytecnt < newcnt;i++,bytecnt++)
		*iptr++ = *fstptr++;
	return(i);
}

static
writeit(bcount,baddr)
int bcount;
char *baddr;
{
	int i, finished = 0;
	char *optr;
	static totwcnt=0;

	for( i=0,optr=baddr ; i<bcount && totwcnt<BNUM ; i++,totwcnt++ )
		*fstwptr++ = *optr++;

	finished = ( ( i == bcount ) && ( qflag & LAST ) );

	if( totwcnt == BNUM || finished ) {
		if ( finished )
			share->last = shmn;
		writeit2(BNUM);
		totwcnt = 0;	/* ready to start filling next buffer */
	}
	return(i);
}

dofork()	/* hh2 shen for fast cpio output */
{
	int i;
	struct shmid_ds *sbuf; 

	/* get semaphores : 0 & 1 for shared memory buffers 0 & 1, resp., */
	/*		2 for end-of-tape syncronization on input	  */

		if((sem = semget(IPC_PRIVATE,3,IPC_CREAT | 0600)) == -1)
			die(5,"maketape : unable to get semaphore\n"); /* jc2 */

	/* get shared memory segments : 0 & 1 for buffers, 2 for handshake */

		if((shmid[0] = shmget(IPC_PRIVATE,BNUM,IPC_CREAT | 0600)) == -1)
			die(5,"maketape: unable to get shared memory\n"); /* jc2 */
		if((shmid[1] = shmget(IPC_PRIVATE,BNUM,IPC_CREAT | 0600)) == -1)
			die(5,"maketape: unable to get shared memory\n"); /* jc2 */
		if((shmid[2] = shmget(IPC_PRIVATE,sizeof(*share),
					IPC_CREAT|0600)) == -1 )
			die(5,"maketape: unable to get shared memory\n"); /* jc2 */
		if((shm[0]  = (char *)shmat(shmid[0],0,0)) == (char *)(-1))
			die(5,"maketape: unable to attach shared memory\n"); /* jc2 */
		if((shm[1]  = (char *)shmat(shmid[1],0,0)) == (char *)(-1))
			die(5,"maketape: unable to attach shared memory\n"); /* jc2 */
		if((share = (struct shseg *)shmat(shmid[2],0,0)) == 
					(struct shseg *)(-1))
			die(5,"maketape: unable to attach shared memory\n"); /* jc2 */
		/* 
		** now that shared memory segments are attached, they can be 
		** removed.  This way, a kill -9 will not leave segments around
		*/
		for(i=0;i<=2;i++)
			shmctl(shmid[i],IPC_RMID,sbuf);

		share->last = -1;
		share->chdead   = 0;
		V(emptybuff);

		fstptr = fstwptr = fastbuf = shm[0];

		if((pid = fork()) == -1)
			die(6,"maketape : unable to fork\n"); /* jc2 */

		if(!pid) 		/* child */
			wrchld();
		else
			close(Output); /* parent doesn't need output file */
}

writeit2(siz)
	int   siz;
{	static first=1;

	V(fullbuff);
	if (debug)
	      fprintf(stderr,"parent : released a buffer, last = %d\n",
			share->last);
	P(emptybuff);
	if (debug)
		fprintf(stderr,"parent : got a buffer\n");
	if (share->chdead)
		doexit(12);
	shmn ^= 1;	/* if we just did 0, do 1 (and vice versa) */ 
	fstptr = fstwptr = fastbuf = shm[shmn];
	return(siz);
}

wrchld()
{
	int rv; 

	while (1) {
		P(fullbuff);
		if (debug)
			fprintf(stderr,"child : got a buffer\n");
		while ( ( rv = write(Output,shm[shmn],BNUM) ) != BNUM ) {
			if (debug)
				fprintf(stderr,"child : in error condition\n");
			if ( share->last != shmn ) 	/* not last buffer */
				P(fullbuff);    
			Output = chgreel(1,Output,rv);
			if ( write(Output,shm[shmn],BNUM) != BNUM )
				die(13,"maketape: child write error - aborting\n"); /* jc2 */
			if ( share->last != shmn ) {		
				V(emptybuff);
				shmn ^= 1;
			}
		}
		if ( share->last == shmn ) 
			exit(0);
		V(emptybuff);
		if (debug)
			fprintf(stderr,"child : released a buffer\n");
		shmn ^= 1;		/* switch buffers */
	} 
}

#ifdef MULTI_READ
readit2(siz)
	int   siz;
{	static first=1;
	static chwaiting=0;

	switch (chwaiting){
		case 1 : chwaiting++;
			return(-1);
		case 2 : close(Input);
			V(sem,2); /* release child to die or open new output */
			P(sem,2); /* wait for child to finish open attempt   */
			chwaiting = 0;
	}
	if (share->chdead) doexit(1);	
	if(first)
		first--; /* first time's charm : don' wanna V or set shmn */
	else {
		V(sem,shmn);
		shmn = (shmn ? 0 : 1);	/* if we just did : 0, do 1, 1, do 0 */ 
	}
	P(sem,shmn);
	fstptr = fstwptr = fastbuf = shm[shmn];

	if(share->nread[shmn] != BNUM)
		chwaiting++;

	return(share->nread[shmn]);
}

rdchld()
{	int 	first=2;
	while (1) {		/* first time on 0 & 1, P(semaphore[0|1]) */
		if(first) 
			first--;
		else 
			P(sem,shmn);
		if(share->quit) {
			V(sem,shmn);
			doexit(0);
		}
		if((share->nread[shmn] = read(Input,shm[shmn],BNUM)) != BNUM){
			V(sem,shmn);		/* release block */
			P(sem,2);		/* wait for parent to decide */
			if(share->fname) {
				if((Input=open(share->fname,O_RDONLY))== NULL){
				fprintf(stderr,"maketape : cannot open %s\n", /* jc2 */
						share->fname);
					share->chdead++;
					doexit(2);
				}
				V(sem,2);  
			}
			else {
				V(sem,2);  
				doexit(0);
			}
		}
		else
			V(sem,shmn);
		shmn = (shmn ? 0 : 1);
	} 
}		
#endif

die(n,s)
	int n; char *s;
{
	fprintf(stderr,s);
	doexit(n);
}

		
static int	verbcount = 0;
static FILE	*verbout = 0;
/*
	In -V verbose mode, print out a dot for each file processed.
*/
static
verbdot( fp, cp )
FILE	*fp;
char	*cp;
{

	if( !verbout )
		verbout = fp;
	if( Verbose == 2 ) {
		fputc( '.', fp );
		if( ++verbcount >= 50 ) {
			/* start a new line of dots */
			verbcount = 0;
			fputc( '\n', fp );
		}
	}
	else {
		fputs( cp, fp );
		fputc( '\n', fp );
	}
}

doexit(n)
	int n;
{
	int ss, arg;

	if(pid > 0){
		if ( n ) {			/* abnormal termination  */
			share->last = shmn;	/* signal child to quit  */
			V(fullbuff);
		}		
		V(2); 	/* if child is waiting, release him (NOTUSED) */
		while (pid != wait(&arg));
		arg=0;
		if ( (ss=semctl(sem, 0, IPC_RMID, arg)) == -1 )
			perror("maketape: unable to release semaphore"); /* jc2 */
	}
	else 
		if ( pid == 0 && n ) {		/* child abnormal end */
			share->chdead++;
			V(emptybuff);
		}
	exit(n);
}

semcall(sid,num,op)
	int sid, num, op;
{
	struct sembuf sb;
	sb.sem_num = num;
	sb.sem_op = op;
	sb.sem_flg = 0;
	if (semop(sid,&sb,1) == -1){
		fprintf(stderr,"maketape : semaphore error # %d\n", /* jc2 */
			errno);
		doexit(7);
	}
}

/*
	print message on the stderr
*/
static
fperr( va_alist )
va_dcl
{
	va_list	args;
	char	*fmt;

	resetverbcount();
	va_start( args );
	fmt = va_arg( args, char * );
	vfprintf( stderr, fmt, args );
	fflush( stderr );
}

/*
	print message on the stderr followed by error number and meaning.
*/
static
fperrno( va_alist )
va_dcl
{
	va_list	args;
	char	*fmt;

	resetverbcount();
	va_start( args );
	fmt = va_arg( args, char * );
	vfprintf( stderr, fmt, args );
	fprintf( stderr, ", errno %d, ", errno );
	fflush( stderr );
	perror("");
}

static
resetverbcount()
{
	if( Verbose == 2  &&  verbcount ) {
		fputc( '\n', verbout );
		verbcount = 0;
	}
}


/* GETSPEC jc2 */
/* Called by getname:  The form of input data is: */
/* old_file_name new_file_name new_owner_name new_group_name new_mode  old_date 
   links */
/* Example: */
/* 	./S/usr/src/boo ./bin/hoo root sys -rwxrwxrwx o 2 */
/* Getspec returns "0" when no more data, prints message and exits on error */

/* Note:  the leading "/" is not allowed for the target file name. */
/* NOTE:  on entry, Spec.new_time has already been loaded */

/* NOTE:  To change the number of options: alter "inputusage" message; */
/* 	change MAXARG, below; and change the sscanf line to look for more */
/* 	strings; add the appropriate option processing (including modifying */
/*	"getoption", and modify OPTSIZE as needed. */

static
int
getspec()	/* the specification is a null-terminated string */
{	/* load a global specification structure */

#define MINARG	5	/* minimum number of items for "scan" */
#define MAXARG	7	/* maximum number of items for "scan" */
#define MAXOPT	(MAXARG - MINARG)	/* maximum number of options allowed */
#define OPTLEN	5	/* number of characters for option + termination null */
			/* maximum number of links currently is LINKS=1000 */
#define EXTRA 5		/* extra space in the array to gracefully catch */
			/* strings which are too long */

	char owner_name[NAME_LEN + EXTRA];
	char group_name[NAME_LEN + EXTRA];
	char mode_string[MODE_LEN + EXTRA];
	int i;
	int ok;
	int num_arg;
	char option[MAXOPT][OPTLEN + EXTRA];	/* 0 based array */
	int time_flag=0; 
	int link_flag=0;
	short links=0;
	char *str[MAX_LINE];	/* get an input line */
	void inputusage();
	char junk[MAX_LINE];	/* get additional items on the spec line */
	void printline();


	for (i=0; i<MAXOPT; i++)	/* start out with illegal value */
		option[i][0]=-1;

	/* if options are not set on sscanf, they will be unchanged on */
	/* return from sscanf */
		
	if(gets(str) == NULL)
		return(0);

	num_arg=sscanf(str,"%s %s %s %s %s %s %s %s",Spec.old_name, Spec.new_name, owner_name, group_name,mode_string,option[0],option[1],junk); 

	if ((num_arg == 0) || (num_arg == EOF))
		return(0);	/* we're done, but no error */

	if ((num_arg < MINARG) ||  (num_arg > MAXARG) )
		(void) inputusage(str);

	for (i=0; i< MAXOPT; i++){
		if (option[i][0] == -1)	/* we're done */
			break;
		if(get_option(option[i],&time_flag,&link_flag,&links) == 0)
			(void) inputusage(str);	/* error */
	}

	Spec.new_time=(time_flag ? Old_time : New_time);
	Spec.n_links=(link_flag ? links : 1); /* 1=default number of links */
			/* note that this doesn't "hurt" directories */

	if (Spec.new_name[0] == '/'){
		fprintf(stderr,"The new file name may NOT be of the form: /filename.\n"); 
		fprintf(stderr,"Absolute path names are not allowed.\n"); 
		printline(str);
		doexit(2);
	}

		/* map owner name to a number */

	if (strlen(owner_name) > (NAME_LEN-1)) {  /* don't count terminating */
						/* null here */
		fprintf(stderr,"Error:  The maximum length of a owner name is %d characters.\n",NAME_LEN);
		printline(str);
		doexit(2);
	}
	ok=0;
	for (i=0; i<MAX_OWNER; i++){
		if (strcmp(Ownerlist[i].name,owner_name) == 0){
			Spec.new_uid=Ownerlist[i].number;
			ok=1;
			break;
		}
	}

	if (! ok){
		fprintf(stderr,"Unknown owner: %s\n",owner_name); 
		printline(str);
		doexit(2);
	}

		/* map group name to a number */

	if (strlen(group_name) > (NAME_LEN-1)) {  /* don't count terminating */
						/* null here */
		fprintf(stderr,"Error:  The maximum length of a group name is %d characters.\n",NAME_LEN);
		printline(str);
		doexit(2);
	}

	ok=0;
	for (i=0; i<MAX_GROUP; i++){
		if (strcmp(Grouplist[i].name,group_name) == 0){
			Spec.new_gid=Grouplist[i].number;
			ok=1;
			break;
		}
	}

	if (! ok){
		fprintf(stderr,"Unknown group: %s\n",group_name); 
		printline(str);
		doexit(2);
	}


		/* translate mode string to a number */

	if ((Spec.new_mode=getmode(mode_string)) == 0){
		fprintf(stderr,"Error:  mode needs to be of the form: drwxrwxrwx  \n");
		fprintf(stderr,"(see the documentation for 'ls').\n");
		printline(str);
		doexit(2);	
	}

	return(1);	/* good status */
}

/* GETMODE:  jc2 */
/* Expected ascii string: */
/*    [d,b,c,p,-] - file type */
/*    [r,-][w,-][x,-,s,S] - owner permissions (last field "s" is set uid)*/
/*    [r,-][w,-][x,-,s,l] - group permissions (last field "s" is set group id)*/
/*    [r,-][w,-][x,-,t,T] - other (world) permissions (last field is set */
/*				sticky bit */
/* (In this case, each field must have a value, the choice is within the  */
/*  brackets).  Example:   -rwsr-xr-t */
/* note that "s or t" impiles "x" in the corresponding field */
/* note that "S, l or T" impiles NO "x" in the corresponding field */
/* This display is identical to that shown by "ls -l" */
/* getmode returns "0" if error, otherwise returns the mode. */

static
int
getmode(str)
char str[MODE_LEN];
{
	int mode=0;

#ifndef S_IRGRP	/* 5.3 stat.h defines these, 5.2 stat.h does not */
#define	S_IRGRP	00040		/* read permission: group */
#define	S_IWGRP	00020		/* write permission: group */
#define	S_IXGRP	00010		/* execute permission: group */
#define	S_IROTH	00004		/* read permission: other */
#define	S_IWOTH	00002		/* write permission: other */
#define	S_IXOTH	00001		/* execute permission: other */
#endif

	if (strlen(str) != MODE_LEN-1)	/* don't count terminating null here */
		return(0);

	switch(str[0]){
		case 'd':
			mode |= S_IFDIR; /* directory */
			break;
		case 'c':
			mode |= S_IFCHR; /* character special */
			break;
		case 'b':
			mode |= S_IFBLK; /* block special */
			break;
		case 'p':
			mode |= S_IFIFO; /* fifo */
			break;
		case '-':
			mode |= S_IFREG; /* regular */
			break;
		default:
			return(0);
	}
	
	if (str[1] == 'r')	/* owner modes */
		mode |= S_IREAD;
	else if (str[1] != '-')
		return(0);

	if (str[2] == 'w')
		mode |= S_IWRITE;
	else if (str[2] != '-')
		return(0);

	switch (str[3]){
		case 'x':
			mode |= S_IEXEC;
			break;
		case 's':
			mode |= S_ISUID;
			mode |= S_IEXEC;
			break;
		case 'S':
			mode |= S_ISUID;
			break;
		case '-':
			break;	/* okay */
		default:
			return(0);
	}

	if (str[4] == 'r')	/* group modes */
		mode |= S_IRGRP;
	else if (str[4] != '-')
		return(0);

	if (str[5] == 'w')
		mode |= S_IWGRP;
	else if (str[5] != '-')
		return(0);

	switch (str[6]){
		case 'x':
			mode |= S_IXGRP;
			break;
		case 's':
			mode |= S_ISGID;
			mode |= S_IXGRP;
			break;
		case 'l':
			mode |= S_ISGID;
			break;
		case '-':
			break;
		default:
			return(0);
	}

	if (str[7] == 'r')	/* world modes */
		mode |= S_IROTH;
	else if (str[7] != '-')
		return(0);

	if (str[8] == 'w')
		mode |= S_IWOTH;
	else if (str[8] != '-')
		return(0);

	switch (str[9]){
		case 'x':
			mode |= S_IXOTH;
			break;
		case 't':
			mode |= S_IXOTH;
			mode |= S_ISVTX;
			break;
		case 'T':
			mode |= S_ISVTX;
			break;
		case '-':
			break;
		default:
			return(0);
	}

	return(mode);
}
	

/* convert time from the the form used for "touch" to the form produced by */
/* "time" */
/* returns 0 if error */

static
time_t
change_to_seconds(date)
char *date;
{
	register int i;
	int mm, dd, hh, min, yy, wf;
	struct tm	*current_date;
	long		clock;
	extern long altzone;

	current_date=localtime(&clock);
	/*  Parse date string  */

	if(strlen(date) != 10) 
		return(0);

	yy = 1900 + atoi(&date[8]);
	date[8] = '\0';

	min = atoi(&date[6]);
	date[6] = '\0';
	hh = atoi(&date[4]);
	date[4] = '\0';
	dd = atoi(&date[2]);
	date[2] = '\0';
	mm = atoi(&date[0]);
	if(hh == 24)
		hh = 0, dd++;

	/*  Validate date elements  */
	if(!((mm >= 1 && mm <= 12) && (dd >= 1 && dd <= 31) &&
		(hh >= 0 && hh <= 23) && (min >= 0 && min <= 59))) {
		return(0);
	}

	/*  Build date and time number  */
	for(clock = 0, i = 1970; i < yy; i++)
		clock += year_size(i);
	/*  Adjust for leap year  */
	if (year_size(yy) == 366 && mm >= 3)
		clock += 1;
	/*  Adjust for different month lengths  */
	while(--mm)
		clock += month_size[mm - 1];
	/*  Load up the rest  */
	clock += (dd - 1);
	clock *= 24;
	clock += hh;
	clock *= 60;
	clock += min;
	clock *= 60;

	/* convert to GMT assuming standard time */
	/* correction is made in localtime(3C) */

	clock += timezone;

	/* correct if daylight savings time in effect */

	if (localtime(&clock)->tm_isdst)
		clock = clock - (timezone - altzone); 

	return(clock);
}

/* look at the string and determine whether to set the time flag or the */
/* number of links.  Check for error conditions. Return 0 if error, 1 if */
/* success */

static
int
get_option(str,tim_flag,lnk_flag,lnks)
char *str[OPTLEN + EXTRA];
int *tim_flag, *lnk_flag;
short *lnks;
{
	short links;

	if (strlen(str) > (OPTLEN-1)) {	/* don't count terminating null here */
		fprintf(stderr,"Error:  the old_date or links option is limited to %d characters\n",OPTLEN);
		return(0);
	}

	if (!strcmp(str,"o")) {	/* use the old time? */
		if (*tim_flag != 0)	/* error if time flag already set */
			return(0);
		(*tim_flag)++;
	} else {	/* look for links */
		if (*lnk_flag != 0)	/* error if link flag already set */
			return(0);
		links=atoi(str);	
		if ((links < 1) || (links > LINKS)){  /* links out of range */
			fprintf(stderr,"Error:  The number of links must be 1-%d\n",LINKS);
			return(0);	
		}
		(*lnk_flag)++;	/* set link flag */
		*lnks=links;	
	}
	return(1);	/* okay */
}

static
void
Tusage()
{
	fprintf(stderr,"Usage:  maketape -T date -o[avVB] < name-list > collection\n");
/*	fprintf(stderr,"        maketape -T date -p[advV] directory < name-list\n"); */
	fprintf(stderr,"date is either '.' [current ");
	fprintf(stderr,"date] or mmddhhMMyy\n");
	doexit(2);
}

static
void
inputusage(inputline)
char *inputline[MAX_LINE];
{
	void printline();

	fprintf(stderr,"Input must be of the form:  \n\n");
	fprintf(stderr,"old_file_name new_file_name new_owner_name new_group_name new_mode [o] [links]\n");
	printline(inputline);
	doexit(2);	
}

static
void
printline(input)
char *input[MAX_LINE];
{
	fprintf(stderr,"\nThe incorrect input line was:\n");
	fprintf(stderr,"%s\n",input);
}

