# include "stdio.h"
# define U(x) x
# define NLSTATE yyprevious=YYNEWLINE
# define BEGIN yybgin = yysvec + 1 +
# define INITIAL 0
# define YYLERR yysvec
# define YYSTATE (yyestate-yysvec-1)
# define YYOPTIM 1
# define YYLMAX 200
# define output(c) putc(c,yyout)
# define input() (((yytchar=yysptr>yysbuf?U(*--yysptr):getc(yyin))==10?(yylineno++,yytchar):yytchar)==EOF?0:yytchar)
# define unput(c) {yytchar= (c);if(yytchar=='\n')yylineno--;*yysptr++=yytchar;}
# define yymore() (yymorfg=1)
# define ECHO fprintf(yyout, "%s",yytext)
# define REJECT { nstr = yyreject(); goto yyfussy;}
int yyleng; extern char yytext[];
int yymorfg;
extern char *yysptr, yysbuf[];
int yytchar;
FILE *yyin = {stdin}, *yyout = {stdout};
extern int yylineno;
struct yysvf { 
	struct yywork *yystoff;
	struct yysvf *yyother;
	int *yystops;};
struct yysvf *yyestate;
extern struct yysvf yysvec[], *yybgin;
#ident	"@(#)ld.lex	24.1	10/28/91 Copyright (c) 1991 by Arix Corp."

#include "system.h"
#include "extrns.h"		/* external function definitions */
#include <signal.h>
#include "bool.h"
#include "paths.h"
#include "sgs.h"
#include "y.tab.h"		/* tokens generated by yacc      */

#if TRVEC
#include "tv.h"
#include "ldtv.h"
#endif

#include "instr.h"

extern char version[];		/* ld version information */

/*
 *	There are four start states for the lex parse:
 *
 *	A	: look for initial keyword of a ld directive
 *	MEMoREG	: scan a ld directive
 *	COMA	: skip a stand-alone comment
 *	COMoMR	: skip a comment at the end of a directive
 */

#define RET1(a)   {yylval.ivalue=a;moveit(1);return(a);}
#define RET2(a,b) {yylval.sptr=a;moveit(2);return(b);}
#define RET3(a,b) {yylval.lptr=a;moveit(3);return(b);}



#define LSAVSIZE 6
long lsavarea[LSAVSIZE];	/* save area for integer tokens */
int lsavndx = 0;
extern long *savelng();
extern enum scope scope_directive;

#define CSAVSIZE 1024
char csavarea[CSAVSIZE];	/* save area for string tokens */
char *csavptr = &csavarea[0];
extern char *savestr();

char inline[256];		/* global save area for the current input line */
char *inptr = &inline[0];

char **argptr;		/* main procedure argument list */
int argcnt;		/*	and count		*/


extern int in_y_exp;	/*	in_y_exp :
			 *		TRUE  : yacc is parsing assignment
			 *		FALSE : yacc is not in assignment
			 *
			 *	See explanation is ld.yac.
			 */

int	assigncnt;	/* number of assignment slots		*/


#if FLEXNAMES
#	define STRBASE 6144
#else
#	define STRBASE 3072
#endif
/*eject*/
# define A 2
# define INaNAME 4
# define MEMoREG 6
# define COMA 8
# define COMoMR 10
# define INaCOM 12
# define YYNEWLINE 10
yylex(){
int nstr; extern int yyprevious;
		long longint;	/* local variables used in processing */
		char *p;	/* numbers and strings		      */
 		int  symbols_seen; /* For hide/export processing */
 		char *badscope = "No symbols specified in hide/export statement!";
while((nstr = yylook()) >= 0)
yyfussy: switch(nstr){
case 0:
if(yywrap()) return(0); break;
case 1:
	BEGIN COMA;
break;
case 2:
BEGIN COMoMR;
break;
case 3:
BEGIN A;
break;
case 4:
BEGIN MEMoREG;
break;
case 5:
BEGIN INaCOM;
break;
case 6:
BEGIN INaNAME;
break;
case 7:
;
break;
case 8:
{ BEGIN MEMoREG; RET1(MEMORY); }
break;
case 9:
{ BEGIN MEMoREG; RET1(REGIONS); }
break;
case 10:
	{ BEGIN MEMoREG; RET1(TV); }
break;
case 11:
RET1(SECTIONS);
break;
case 12:
RET1(DSECT);
break;
case 13:
RET1(NOLOAD);
break;
case 14:
	RET1(COPY);
break;
case 15:
	RET1(INFO);
break;
case 16:
RET1(OVERLAY);
break;
case 17:
RET1(COMMN);
break;
case 18:
{ BEGIN INaNAME; RET1(HIDE); }
break;
case 19:
{ BEGIN INaNAME; RET1(EXPORT); }
break;
case 20:
	{ BEGIN A; RET1(RBRACE); }
break;
case 21:
  RET1(ORG);
break;
case 22:
  RET1(LEN);
break;
case 23:
RET1(SPARE);
break;
case 24:
RET1(RANGE);
break;
case 25:
RET1(ASSIGN);
break;
case 26:
{
			if (scope_directive == __undefined) {
 				REJECT;
 				}
 			sym_scope(yytext, scope_directive);
 			symbols_seen++;
 			}
break;
case 27:
	{
 			symbols_seen = 0;
 			RET1(LBRACE);
 			}
break;
case 28:
	{
 			if (symbols_seen == 0)
 				lderror(2, 0, NULL, badscope);
 			BEGIN A;
 			RET1(RBRACE);
 			}
break;
case 29:
	RET1(DOT);
break;
case 30:
	RET1(RBRACE);
break;
case 31:
	RET1(LBRACE);
break;
case 32:
	RET1(RPAREN);
break;
case 33:
	RET1(LPAREN);
break;
case 34:
	RET1(RSQBRACK);
break;
case 35:
	RET1(LSQBRACK);
break;
case 36:
	RET1(COLON);
break;
case 37:
	RET1(SEMICOL);
break;
case 38:
	RET1(MINUS);
break;
case 39:
	RET1(EQ);
break;
case 40:
	RET1(GT);
break;
case 41:
	RET1(COMMA);
break;
case 42:
	RET1(AND);
break;
case 43:
	RET1(ANDAND);
break;
case 44:
	RET1(OR);
break;
case 45:
	RET1(OROR);
break;
case 46:
	RET1(EQEQ);
break;
case 47:
	RET1(NE);
break;
case 48:
	RET1(BNOT);
break;
case 49:
	RET1(NOT);
break;
case 50:
	RET1(DIV);
break;
case 51:
	RET1(MULT);
break;
case 52:
	RET1(PC);
break;
case 53:
	RET1(LT);
break;
case 54:
	RET1(GE);
break;
case 55:
	RET1(LE);
break;
case 56:
	RET1(LSHIFT);
break;
case 57:
	RET1(RSHIFT);
break;
case 58:
	RET1(PLUS);
break;
case 59:
	RET1(PLUSEQ);
break;
case 60:
	RET1(MINUSEQ);
break;
case 61:
	RET1(MULTEQ);
break;
case 62:
	RET1(DIVEQ);
break;
case 63:
RET1(ALIGN);
break;
case 64:
RET1(BLOCK);
break;
case 65:
RET1(GROUP);
break;
case 66:
RET1(PHY);
break;
case 67:
RET1(SIZEOF);
break;
case 68:
RET1(ADDR);
break;
case 69:
RET1(NEXT);
break;
case 70:
RET1(BIND);
break;
case 71:
{
	lineno++;
	inptr = &inline[0];
	}
break;
case 72:
{
	*inptr++ = ' ';
	*inptr   = '\0';
	}
break;
case 73:
{
		lderror(0, 0, NULL, "Discarding '%c' in scope/hide directive",
			yytext[0]);
		}
break;
case 74:
{
		longint = 0L;
		for(p=yytext+1; *p != '\0'; p++)  {
			longint = longint * 8 + (*p-'0');
			}
		RET3(savelng(longint), LONGINT);
		}
break;
case 75:
{
		longint = 0L;
		for(p=yytext; *p != '\0'; p++)  {
			longint = longint * 10 + (*p-'0');
			}
		RET3(savelng(longint), LONGINT);
		}
break;
case 76:
 {
		longint = 0L;
		for(p=yytext+2; *p != '\0'; p++)  {
			longint = longint << 4;
			if (*p >= '0' && *p <= '9')
				longint += *p-'0';
			else if (*p >= 'a' && *p <= 'f')
				longint += *p-'a'+10;
			else longint += *p-'A'+10;
			}
		RET3(savelng(longint), LONGINT);
		}
break;
case 77:
{
			yyless(yyleng-2);
			RET2(savestr(yytext), NAME);
		}
break;
case 78:
{
			if ( in_y_exp )
				REJECT;
			yyless(yyleng-2);
			RET2(savestr(yytext), FILENAME);
		}
break;
case 79:
	{
			RET2(savestr(yytext), NAME);
		}
break;
case 80:
	{
			if ( in_y_exp )
				REJECT;
			RET2(savestr(yytext), FILENAME);
		}
break;
case -1:
break;
default:
fprintf(yyout,"bad switch yylook %d",nstr);
} return(0); }
/* end of yylex */
/*eject*/
main(argc,argv)
int argc;
char *argv[];
{

/*
 * This is the MAIN procdure for PASS 1 of ld
 *
 * PASS 1 is the parsing pass:
 *	1. The ld command line, and any specified ifiles, are
 *		scanned for good syntax.
 *	2. Control blocks are constructed, containing the information
 *		extracted from the input.
 *	3. If there are no errors, the control blocks are written out
 *		to a "transfer file", for reading by PASS 2.
 *	4. If there are no errors, PASS 2 is called via a system 
 *		"execl" call.
 */

/*
 * Initialize PASS 1
 */

	initpass1();
	argptr = argv;
	argcnt = argc;
	if ( argcnt <= 1 )
	{
		fprintf( stderr, "Usage: %sld [ options ] file ...\n", SGS );
		exit(1);
	}

/*
 * Process the command-line arguments to ld
 */

	lineno = 0;
	curfilnm = savefn("*command line*");

	undefine();	/* undefine start symbol if necessary */

	while( --argcnt )
		if( **++argptr == '-' )
			/*
			 * The argument is a flag
			 */
			pflags( ++(*argptr), FALSE );
		else {
			/*
			 * The argument is a file name
			 */
			BEGIN A;
			filespec(*argptr);
			}

/*
 * Perform a consistency check among the ld flags:
 *	1. "-h" and "-X" flags
 *	2. "-ild", "-r", and "-a" flags
 *	3. "-r" and "-s" flags
 *	4. "-p" and "-B" flags
 *
 * Assign default values to the ld flags
 *	1. "-h" flag
 *	2. "-a" flag
 *	3. "-p" flag
 */

	if( Xflag )
		if( hflag > 0 ) {
			if( hflag < sizeof(AOUTHDR) )
				lderror(1, 0,NULL, "optional header size (%d bytes) is too small to contain the UNIX a.out header (%d bytes)",
					hflag, sizeof(AOUTHDR) );
			}
		else
			hflag = sizeof(AOUTHDR);
#if ILDOPT
	if (ildflag) {
		rflag = 1;
		if (sflag) {
			lderror (0, 0, NULL, "both -ild and -s flags are set. -s flag turned off");
			sflag = 0;
		}
	}
#endif
	if( rflag  &&  sflag ) {
		lderror(0, 0,NULL, "both -r and -s flags are set. -s flag turned off" );
		sflag = 0;
		}
	if ( Bflag && (pflag > 0) && (pflag < Bflag)) {
		lderror(0, 0, NULL, "pflag(%d) less than Bflag, set to value of Bflag(%d)\n",
			pflag, Bflag);
		pflag = Bflag;
		}
/*
 * The documentation claims that the aflag is assumed if neither -r nor -a
 * is specified as any of the options.  Therefore, the only time that we
 * need to turn OFF the aflag is if ONLY -r was specified AND the -a flag
 * was NOT specified (aflag < 2). The aflag will be greater than 1 if it
 * was explicitly given on the command line.
 */
	if( rflag && (aflag < 2) )
		aflag = 0;

/*
 * Supply version information
 */

	if( Vflag ) {
		fprintf( stderr, "%sld : %s : Version %s",
			SGS, RELEASE, version );
		if( Vflag == 2 ) {
#if AR16WR
 			fprintf( stderr, " : PDP 11/70-45 : " );
#endif
#if AR32WR
			fprintf( stderr, " : VAX 11/780 : " );
#endif
#if ! AR16WR && ! AR32WR
#ifdef u3b
 			fprintf( stderr, " : 3B-20 : " );
#else
			fprintf( stderr, " : non-DEC : ");
#endif
#endif
#if TS
 			fprintf( stderr, "UN*X TS" );
#else
 			fprintf( stderr, "UN*X" );
#endif
			}
		fprintf( stderr, "\n" );
		}

/*
 * Exit if any errors were found
 */

	if(errlev != 0){
		exit(errlev);
		}

/*
 * Call PASS 2
 */

	pass2();
}
long *
savelng(l)
long l;
{

/*
 * Copy a long token into local save area and return a pointer to it.
 *
 * The save area is used as a circular buffer
 */

	lsavndx++;
	lsavndx %= LSAVSIZE;
	lsavarea[lsavndx] = l;

	return( &lsavarea[lsavndx] );
}




char *
savestr(p) 
char *p;
{

/*
 * Copy a string into local save area and return a pointer to it
 *
 * The save area is used as a circular buffer
 */

	register char *saveptr;

	if( csavptr > (csavarea + CSAVSIZE - 256) )
		csavptr = csavarea;
	saveptr = csavptr;

	while( *csavptr++ = *p++ );

	return( saveptr );
}




moveit(type)
int type;
{
	register char *p;

	p = &yytext[0];

	while( *inptr++ = *p++ );
	inptr--;

}
/*eject*/
initpass1()
{
	register int oldmode;
	int ldexit();
	long times();

/*
 * Set the following signals to be caught, unless ld is running in the
 * background. In this case, leave them set at "ignore"
 */

	if( signal(SIGINT, ldexit)  ==  SIG_IGN )
		signal(SIGINT, SIG_IGN);
	if( signal(SIGHUP, ldexit)  ==  SIG_IGN )
		signal(SIGHUP, SIG_IGN);
	if( signal(SIGQUIT, ldexit)  ==  SIG_IGN )
		signal(SIGQUIT, SIG_IGN);


#if PERF_DATA
	ttime = times(&ptimes);
#endif

/*
 * Allocate the global file name save area
 */

	strbase = myalloc(STRBASE);
	strnext = strbase;
	strlimit = strbase + STRBASE;

	/* bk: by default, environ is reserved by implementation */
	make_equate( "environ", "_environ" );
}
int yyvstop[] = {
0,

72,
0,

71,
0,

49,
0,

79,
80,
0,

52,
79,
0,

42,
0,

33,
0,

32,
0,

51,
0,

58,
0,

41,
0,

38,
0,

29,
79,
80,
0,

50,
80,
0,

74,
75,
79,
80,
0,

75,
79,
80,
0,

36,
0,

37,
0,

53,
0,

39,
0,

40,
0,

79,
80,
0,

79,
80,
0,

79,
80,
0,

79,
80,
0,

79,
80,
0,

79,
80,
0,

79,
80,
0,

79,
80,
0,

79,
80,
0,

79,
80,
0,

79,
80,
0,

79,
80,
0,

79,
80,
0,

79,
80,
0,

79,
80,
0,

35,
0,

34,
0,

79,
80,
0,

79,
80,
0,

79,
80,
0,

79,
80,
0,

79,
80,
0,

79,
80,
0,

31,
0,

44,
0,

30,
0,

48,
0,

73,
0,

72,
73,
0,

26,
73,
0,

26,
73,
0,

27,
73,
0,

28,
73,
0,

50,
80,
0,

79,
80,
0,

79,
80,
0,

79,
80,
0,

79,
80,
0,

79,
80,
0,

79,
80,
0,

79,
80,
0,

22,
79,
80,
0,

21,
79,
80,
0,

79,
80,
0,

23,
79,
80,
0,

20,
30,
0,

7,
0,

7,
72,
0,

7,
0,

7,
0,

7,
0,

47,
0,

79,
0,

80,
0,

80,
0,

43,
0,

61,
0,

59,
0,

60,
0,

80,
0,

1,
0,

80,
0,

62,
0,

74,
75,
79,
80,
0,

79,
80,
0,

56,
0,

55,
0,

46,
0,

54,
0,

57,
0,

79,
80,
0,

79,
80,
0,

79,
80,
0,

79,
80,
0,

79,
80,
0,

79,
80,
0,

79,
80,
0,

79,
80,
0,

79,
80,
0,

79,
80,
0,

79,
80,
0,

79,
80,
0,

79,
80,
0,

79,
80,
0,

79,
80,
0,

79,
80,
0,

79,
80,
0,

79,
80,
0,

10,
79,
80,
0,

79,
80,
0,

79,
80,
0,

79,
80,
0,

79,
80,
0,

79,
80,
0,

79,
80,
0,

79,
80,
0,

79,
80,
0,

45,
0,

26,
0,

5,
26,
0,

2,
0,

79,
80,
0,

79,
80,
0,

79,
80,
0,

79,
80,
0,

79,
80,
0,

79,
80,
0,

79,
80,
0,

79,
80,
0,

79,
80,
0,

79,
80,
0,

3,
0,

4,
0,

6,
0,

80,
0,

77,
78,
0,

77,
0,

78,
0,

76,
79,
80,
0,

79,
80,
0,

79,
80,
0,

79,
80,
0,

79,
80,
0,

79,
80,
0,

79,
80,
0,

79,
80,
0,

79,
80,
0,

79,
80,
0,

79,
80,
0,

79,
80,
0,

79,
80,
0,

79,
80,
0,

79,
80,
0,

79,
80,
0,

66,
79,
80,
0,

79,
80,
0,

79,
80,
0,

79,
80,
0,

79,
80,
0,

79,
80,
0,

79,
80,
0,

79,
80,
0,

79,
80,
0,

79,
80,
0,

79,
80,
0,

79,
80,
0,

79,
80,
0,

79,
80,
0,

79,
80,
0,

79,
80,
0,

79,
80,
0,

22,
79,
80,
0,

21,
79,
80,
0,

79,
80,
0,

79,
80,
0,

79,
80,
0,

68,
79,
80,
0,

79,
80,
0,

70,
79,
80,
0,

79,
80,
0,

79,
80,
0,

14,
79,
80,
0,

79,
80,
0,

79,
80,
0,

79,
80,
0,

18,
79,
80,
0,

15,
79,
80,
0,

79,
80,
0,

69,
79,
80,
0,

79,
80,
0,

79,
80,
0,

79,
80,
0,

79,
80,
0,

79,
80,
0,

79,
80,
0,

79,
80,
0,

79,
80,
0,

79,
80,
0,

79,
80,
0,

79,
80,
0,

79,
80,
0,

79,
80,
0,

79,
80,
0,

79,
80,
0,

79,
80,
0,

79,
80,
0,

79,
80,
0,

79,
80,
0,

63,
79,
80,
0,

64,
79,
80,
0,

79,
80,
0,

12,
79,
80,
0,

79,
80,
0,

65,
79,
80,
0,

79,
80,
0,

79,
80,
0,

79,
80,
0,

79,
80,
0,

79,
80,
0,

79,
80,
0,

79,
80,
0,

79,
80,
0,

79,
80,
0,

79,
80,
0,

24,
79,
80,
0,

23,
79,
80,
0,

79,
80,
0,

79,
80,
0,

79,
80,
0,

17,
79,
80,
0,

19,
79,
80,
0,

8,
79,
80,
0,

13,
79,
80,
0,

79,
80,
0,

79,
80,
0,

79,
80,
0,

67,
79,
80,
0,

25,
79,
80,
0,

22,
79,
80,
0,

16,
79,
80,
0,

9,
79,
80,
0,

79,
80,
0,

11,
79,
80,
0,
0};
# define YYTYPE int
struct yywork { YYTYPE verify, advance; } yycrank[] = {
0,0,	0,0,	0,0,	0,0,	
0,0,	0,0,	0,0,	0,0,	
0,0,	0,0,	1,15,	1,16,	
3,15,	3,16,	15,15,	0,0,	
0,0,	0,0,	0,0,	0,0,	
0,0,	0,0,	0,0,	0,0,	
0,0,	0,0,	0,0,	0,0,	
0,0,	0,0,	0,0,	0,0,	
0,0,	1,15,	0,0,	3,15,	
3,17,	15,15,	0,0,	3,18,	
3,19,	3,20,	0,0,	3,21,	
3,22,	3,23,	3,24,	3,25,	
3,26,	3,27,	3,28,	3,29,	
3,30,	3,30,	3,30,	3,30,	
3,30,	3,30,	3,30,	3,30,	
3,30,	3,31,	3,32,	3,33,	
3,34,	3,35,	10,84,	11,85,	
3,36,	3,37,	3,38,	3,39,	
3,40,	3,18,	3,41,	3,42,	
3,43,	3,18,	3,18,	3,18,	
3,44,	3,45,	3,46,	3,47,	
3,18,	3,48,	3,49,	3,50,	
3,18,	3,18,	3,18,	3,18,	
3,18,	3,18,	3,51,	12,85,	
3,52,	13,86,	3,18,	14,86,	
3,53,	3,54,	3,18,	3,18,	
3,18,	3,18,	3,55,	3,18,	
3,18,	3,18,	3,18,	3,18,	
3,18,	3,56,	3,18,	3,57,	
3,18,	3,18,	3,58,	3,18,	
3,18,	3,18,	3,18,	3,18,	
3,18,	3,18,	3,59,	3,60,	
3,61,	3,62,	5,63,	6,67,	
17,87,	6,68,	20,92,	23,93,	
24,94,	26,95,	5,64,	5,16,	
33,102,	33,103,	34,104,	35,105,	
35,106,	37,18,	38,18,	40,18,	
39,18,	60,134,	37,109,	44,18,	
44,117,	37,110,	38,18,	40,18,	
39,18,	38,111,	70,138,	44,18,	
43,18,	7,69,	5,65,	39,112,	
84,148,	5,65,	5,65,	40,113,	
43,18,	85,149,	43,116,	86,150,	
5,63,	0,0,	5,65,	0,0,	
5,66,	5,65,	5,65,	7,70,	
47,18,	7,18,	7,18,	7,18,	
47,121,	5,65,	7,18,	7,18,	
47,18,	0,0,	7,71,	7,18,	
7,72,	7,73,	5,65,	41,18,	
7,74,	7,75,	7,18,	42,18,	
46,18,	0,0,	56,18,	41,18,	
42,115,	45,18,	45,118,	42,18,	
46,18,	41,114,	56,18,	7,76,	
8,69,	45,18,	0,0,	0,0,	
45,119,	5,65,	46,120,	48,18,	
48,122,	91,153,	7,77,	55,18,	
0,0,	7,78,	0,0,	48,18,	
7,79,	7,80,	8,70,	55,18,	
8,18,	8,18,	8,18,	56,131,	
0,0,	8,18,	8,18,	7,81,	
91,153,	8,71,	8,18,	8,72,	
8,73,	0,0,	0,0,	8,74,	
8,75,	8,18,	9,82,	0,0,	
5,67,	50,18,	5,68,	49,18,	
49,123,	57,18,	9,83,	9,16,	
49,124,	50,18,	8,76,	49,18,	
54,18,	57,18,	58,18,	53,18,	
0,0,	55,130,	73,18,	50,125,	
54,18,	8,77,	58,18,	53,18,	
8,78,	0,0,	73,18,	8,79,	
8,80,	78,18,	9,82,	0,0,	
73,140,	9,82,	9,82,	71,18,	
71,139,	78,18,	8,81,	9,84,	
9,82,	57,132,	9,82,	71,18,	
9,82,	9,82,	9,82,	53,126,	
0,0,	54,128,	0,0,	58,133,	
54,129,	9,82,	0,0,	53,127,	
72,18,	72,118,	74,141,	107,156,	
75,18,	74,18,	9,82,	0,0,	
72,18,	75,124,	108,18,	107,18,	
75,18,	74,18,	109,18,	108,157,	
75,142,	110,18,	108,18,	78,145,	
0,0,	0,0,	109,18,	0,0,	
109,158,	110,18,	0,0,	0,0,	
110,159,	9,82,	18,0,	18,0,	
18,0,	18,0,	18,0,	18,0,	
18,0,	18,0,	18,0,	18,0,	
18,0,	18,0,	18,0,	18,0,	
18,0,	18,0,	18,0,	18,0,	
18,0,	18,0,	18,0,	18,0,	
18,0,	18,0,	18,0,	18,0,	
18,0,	18,0,	18,0,	18,0,	
18,0,	18,0,	18,0,	18,0,	
18,0,	18,18,	18,88,	18,0,	
18,0,	18,0,	18,0,	18,0,	
18,89,	18,0,	18,89,	77,18,	
18,90,	18,18,	18,18,	0,0,	
0,0,	0,0,	0,0,	77,18,	
0,0,	18,18,	0,0,	18,0,	
18,0,	18,0,	18,0,	18,0,	
18,0,	18,0,	18,18,	79,18,	
0,0,	111,18,	0,0,	112,18,	
112,162,	0,0,	113,18,	79,18,	
114,18,	111,18,	111,160,	112,18,	
77,144,	111,161,	113,18,	115,165,	
114,18,	0,0,	113,163,	114,164,	
0,0,	18,18,	117,18,	115,18,	
18,0,	18,0,	18,0,	18,0,	
79,146,	18,0,	117,18,	117,167,	
19,88,	19,88,	0,0,	0,0,	
0,0,	0,0,	0,0,	0,0,	
0,0,	0,0,	19,88,	19,91,	
19,88,	19,88,	19,88,	19,88,	
19,88,	19,88,	19,88,	19,88,	
19,88,	19,88,	0,0,	0,0,	
18,0,	18,0,	18,0,	18,0,	
18,0,	19,88,	19,88,	19,88,	
19,88,	19,88,	19,88,	19,88,	
19,88,	19,88,	19,88,	19,88,	
19,88,	19,88,	19,88,	19,88,	
19,88,	19,88,	19,88,	19,88,	
19,88,	19,88,	19,88,	19,88,	
19,88,	19,88,	19,88,	0,0,	
0,0,	0,0,	0,0,	19,88,	
0,0,	19,88,	19,88,	19,88,	
19,88,	19,88,	19,88,	19,88,	
19,88,	19,88,	19,88,	19,88,	
19,88,	19,88,	19,88,	19,88,	
19,88,	19,88,	19,88,	19,88,	
19,88,	19,88,	19,88,	19,88,	
19,88,	19,88,	19,88,	27,0,	
27,0,	27,0,	27,0,	27,0,	
27,0,	27,0,	27,0,	27,0,	
27,0,	27,0,	27,0,	27,0,	
27,0,	27,0,	27,0,	27,0,	
27,0,	27,0,	27,0,	27,0,	
27,0,	27,0,	27,0,	27,0,	
27,0,	27,0,	27,0,	27,0,	
27,0,	27,0,	27,0,	27,0,	
27,0,	27,0,	36,18,	36,88,	
27,0,	27,0,	27,0,	27,0,	
27,0,	36,89,	27,0,	36,89,	
36,18,	36,90,	36,18,	36,18,	
36,18,	36,18,	36,18,	36,18,	
36,18,	36,18,	36,18,	36,18,	
27,0,	27,0,	27,0,	27,0,	
27,0,	27,0,	27,0,	36,18,	
36,18,	36,18,	36,107,	36,18,	
36,18,	36,18,	36,18,	36,18,	
36,18,	36,18,	36,108,	36,18,	
36,18,	36,18,	36,18,	36,18,	
36,18,	36,18,	36,18,	36,18,	
36,18,	36,18,	36,18,	36,18,	
36,18,	27,0,	27,0,	27,0,	
27,0,	36,18,	27,0,	36,18,	
36,18,	36,18,	36,18,	36,18,	
36,18,	36,18,	36,18,	36,18,	
36,18,	36,18,	36,18,	36,18,	
36,18,	36,18,	36,18,	36,18,	
36,18,	36,18,	36,18,	36,18,	
36,18,	36,18,	36,18,	36,18,	
36,18,	27,0,	27,0,	27,0,	
27,0,	27,0,	28,0,	28,0,	
28,0,	28,0,	28,0,	28,0,	
28,0,	28,0,	28,0,	28,0,	
28,0,	28,0,	28,0,	28,0,	
28,0,	28,0,	28,0,	28,0,	
28,0,	28,0,	28,0,	28,0,	
28,0,	28,0,	28,0,	28,0,	
28,0,	28,0,	28,0,	28,0,	
28,0,	28,0,	28,0,	28,0,	
28,0,	28,96,	28,0,	28,0,	
28,0,	28,0,	28,0,	28,97,	
76,18,	28,0,	80,18,	119,18,	
28,98,	28,96,	28,96,	0,0,	
76,18,	0,0,	80,18,	119,169,	
0,0,	28,96,	0,0,	28,0,	
28,0,	28,0,	28,99,	28,0,	
28,0,	28,0,	28,96,	116,18,	
0,0,	116,166,	0,0,	120,18,	
120,170,	126,18,	122,18,	116,18,	
76,126,	122,172,	118,18,	120,18,	
121,18,	126,18,	122,18,	80,133,	
76,127,	0,0,	118,18,	0,0,	
121,18,	28,96,	80,147,	76,143,	
28,0,	28,0,	28,0,	28,0,	
124,18,	28,0,	118,168,	123,173,	
123,18,	121,171,	138,18,	139,18,	
124,18,	126,175,	0,0,	156,18,	
123,18,	0,0,	138,18,	139,18,	
131,18,	139,183,	140,18,	156,18,	
0,0,	138,182,	124,174,	140,184,	
131,18,	156,193,	140,18,	0,0,	
28,0,	28,0,	28,0,	28,0,	
28,0,	29,0,	29,0,	29,0,	
29,0,	29,0,	29,0,	29,0,	
29,0,	29,0,	29,0,	29,0,	
29,0,	29,0,	29,0,	29,0,	
29,0,	29,0,	29,0,	29,0,	
29,0,	29,0,	29,0,	29,0,	
29,0,	29,0,	29,0,	29,0,	
29,0,	29,0,	29,0,	29,0,	
29,0,	29,0,	29,0,	29,0,	
131,180,	127,18,	29,0,	29,0,	
29,0,	29,0,	29,0,	128,18,	
29,0,	127,18,	129,18,	130,18,	
29,100,	29,100,	0,0,	128,18,	
0,0,	0,0,	129,18,	130,18,	
29,30,	132,18,	29,0,	29,0,	
29,0,	29,0,	29,0,	29,0,	
29,0,	132,18,	142,186,	133,18,	
141,18,	142,18,	0,0,	143,18,	
144,18,	146,18,	127,176,	133,18,	
141,18,	142,18,	141,185,	143,18,	
144,18,	146,18,	0,0,	0,0,	
0,0,	128,177,	0,0,	147,18,	
29,101,	129,178,	130,179,	29,0,	
29,0,	29,0,	29,0,	147,18,	
29,0,	157,18,	158,195,	160,18,	
157,194,	161,18,	159,196,	159,18,	
0,0,	157,18,	158,18,	160,18,	
160,197,	161,18,	132,171,	159,18,	
165,18,	165,202,	144,188,	146,191,	
147,192,	0,0,	143,187,	0,0,	
165,18,	133,181,	161,198,	29,0,	
29,0,	29,0,	29,0,	29,0,	
30,0,	30,0,	30,0,	30,0,	
30,0,	30,0,	30,0,	30,0,	
30,0,	30,0,	30,0,	30,0,	
30,0,	30,0,	30,0,	30,0,	
30,0,	30,0,	30,0,	30,0,	
30,0,	30,0,	30,0,	30,0,	
30,0,	30,0,	30,0,	30,0,	
30,0,	30,0,	30,0,	30,0,	
30,0,	30,0,	30,0,	0,0,	
145,18,	30,0,	30,0,	30,0,	
30,0,	30,0,	163,18,	30,0,	
145,18,	162,199,	162,18,	30,30,	
30,30,	0,0,	163,18,	0,0,	
0,0,	163,200,	162,18,	30,30,	
0,0,	30,0,	30,0,	30,0,	
30,0,	30,0,	30,0,	30,0,	
164,18,	0,0,	166,18,	167,18,	
168,18,	0,0,	0,0,	145,189,	
164,18,	145,190,	166,18,	167,18,	
168,18,	166,203,	167,204,	174,18,	
174,210,	164,201,	0,0,	0,0,	
168,205,	0,0,	169,18,	174,18,	
170,18,	0,0,	30,0,	30,0,	
30,0,	30,0,	169,18,	30,0,	
170,18,	169,206,	172,18,	173,18,	
182,18,	183,18,	170,207,	172,208,	
183,216,	182,215,	172,18,	173,18,	
182,18,	183,18,	184,18,	185,18,	
207,18,	184,217,	185,218,	173,209,	
0,0,	0,0,	184,18,	185,18,	
207,233,	0,0,	30,0,	30,0,	
30,0,	30,0,	30,0,	65,0,	
65,0,	65,0,	65,0,	65,0,	
65,0,	65,0,	65,0,	65,0,	
65,0,	65,0,	65,0,	65,0,	
65,0,	65,0,	65,0,	65,0,	
65,0,	65,0,	65,0,	65,0,	
65,0,	65,0,	65,0,	65,0,	
65,0,	65,0,	65,0,	65,0,	
65,0,	65,0,	65,0,	65,135,	
65,0,	65,0,	65,135,	65,135,	
65,0,	65,0,	65,0,	65,0,	
176,18,	65,0,	65,0,	65,135,	
175,18,	65,135,	65,135,	65,135,	
176,18,	0,0,	0,0,	0,0,	
175,18,	177,18,	65,135,	0,0,	
65,0,	65,0,	65,0,	65,0,	
65,0,	177,18,	65,0,	65,135,	
178,18,	179,18,	181,18,	0,0,	
180,18,	186,18,	187,18,	188,18,	
178,18,	179,18,	181,18,	176,211,	
180,18,	186,18,	187,18,	188,18,	
190,18,	194,18,	0,0,	186,219,	
0,0,	177,195,	65,135,	0,0,	
190,18,	194,18,	175,193,	194,225,	
65,0,	196,18,	65,0,	178,212,	
232,249,	197,18,	0,0,	181,214,	
196,226,	196,18,	199,18,	200,18,	
232,18,	197,18,	188,221,	187,220,	
197,227,	0,0,	199,18,	200,18,	
192,18,	0,0,	179,213,	190,222,	
180,205,	200,229,	199,228,	0,0,	
192,18,	65,0,	65,0,	65,0,	
65,0,	65,0,	66,0,	66,0,	
66,0,	66,0,	66,0,	66,0,	
66,0,	66,0,	66,0,	66,0,	
66,0,	66,0,	66,0,	66,0,	
66,0,	66,0,	66,0,	66,0,	
66,0,	66,0,	66,0,	66,0,	
66,0,	66,0,	66,0,	66,0,	
66,0,	66,0,	66,0,	66,0,	
66,0,	66,0,	192,224,	66,0,	
66,0,	96,96,	0,0,	66,0,	
66,0,	66,0,	66,0,	66,136,	
66,0,	66,0,	0,0,	96,96,	
96,98,	96,96,	96,96,	96,96,	
96,96,	96,96,	96,96,	96,96,	
96,96,	96,96,	96,96,	66,0,	
66,0,	66,0,	66,0,	66,0,	
0,0,	66,0,	96,96,	96,96,	
96,96,	96,96,	96,96,	96,96,	
96,96,	96,96,	96,96,	96,96,	
96,96,	96,96,	96,96,	96,96,	
96,96,	96,96,	96,96,	96,96,	
96,96,	96,96,	96,96,	96,96,	
96,96,	96,96,	96,96,	96,96,	
0,0,	0,0,	0,0,	66,0,	
96,96,	66,0,	96,96,	96,96,	
96,96,	96,96,	96,96,	96,96,	
96,96,	96,96,	96,96,	96,96,	
96,96,	96,96,	96,96,	96,96,	
96,96,	96,96,	96,96,	96,96,	
96,96,	96,96,	96,96,	96,96,	
96,96,	96,96,	96,96,	96,96,	
66,0,	66,0,	66,0,	66,0,	
66,0,	69,0,	69,0,	69,0,	
69,0,	69,0,	69,0,	69,0,	
69,0,	69,0,	69,0,	69,0,	
69,0,	69,0,	69,0,	69,0,	
69,0,	69,0,	69,0,	69,0,	
69,0,	69,0,	69,0,	69,0,	
69,0,	69,0,	69,0,	69,0,	
69,0,	69,0,	69,0,	69,0,	
69,0,	69,0,	69,0,	69,0,	
69,96,	69,0,	69,0,	69,0,	
69,0,	69,0,	69,137,	191,18,	
69,0,	201,18,	212,18,	69,98,	
69,96,	69,96,	0,0,	191,18,	
0,0,	201,18,	212,18,	0,0,	
69,96,	201,230,	69,0,	69,0,	
69,0,	69,99,	69,0,	69,0,	
69,0,	69,96,	204,18,	209,18,	
206,232,	218,18,	218,241,	206,18,	
209,235,	208,18,	204,18,	209,18,	
0,0,	218,18,	191,223,	206,18,	
204,231,	208,18,	219,18,	219,242,	
208,234,	212,226,	0,0,	210,18,	
69,96,	0,0,	219,18,	69,0,	
69,0,	69,0,	69,0,	210,18,	
69,0,	215,18,	210,236,	89,89,	
215,238,	0,0,	0,0,	0,0,	
0,0,	215,18,	89,89,	0,0,	
89,89,	89,89,	89,151,	89,89,	
89,89,	89,89,	89,89,	89,89,	
89,89,	89,89,	89,89,	89,89,	
89,89,	0,0,	0,0,	69,0,	
69,0,	69,0,	69,0,	69,0,	
89,89,	89,89,	89,89,	89,89,	
89,89,	89,89,	89,89,	89,89,	
89,89,	89,89,	89,89,	89,89,	
89,89,	89,89,	89,89,	89,89,	
89,89,	89,89,	89,89,	89,89,	
89,89,	89,89,	89,89,	89,89,	
89,89,	89,89,	0,0,	0,0,	
0,0,	0,0,	89,89,	0,0,	
89,89,	89,89,	89,89,	89,89,	
89,89,	89,89,	89,89,	89,89,	
89,89,	89,89,	89,89,	89,89,	
89,89,	89,89,	89,89,	89,89,	
89,89,	89,89,	89,89,	89,89,	
89,89,	89,89,	89,89,	89,89,	
89,89,	89,89,	90,0,	90,0,	
90,0,	90,0,	90,0,	90,0,	
90,0,	90,0,	90,0,	90,0,	
90,0,	90,0,	90,0,	90,0,	
90,0,	90,0,	90,0,	90,0,	
90,0,	90,0,	90,0,	90,0,	
90,0,	90,0,	90,0,	90,0,	
90,0,	90,0,	90,0,	90,0,	
90,0,	90,0,	90,0,	90,0,	
90,0,	90,96,	90,0,	90,0,	
90,0,	90,0,	90,0,	90,152,	
211,18,	90,0,	213,18,	220,18,	
90,98,	90,96,	90,96,	0,0,	
211,18,	0,0,	213,18,	220,18,	
0,0,	90,96,	0,0,	90,0,	
90,0,	90,0,	90,152,	90,0,	
90,0,	90,0,	90,96,	214,18,	
216,18,	217,18,	221,18,	222,18,	
223,18,	224,18,	217,240,	214,18,	
216,18,	217,18,	221,18,	222,18,	
223,18,	224,18,	220,243,	229,18,	
216,239,	0,0,	211,225,	0,0,	
227,18,	90,96,	213,230,	229,18,	
90,0,	90,0,	90,0,	90,0,	
227,18,	90,0,	227,246,	229,247,	
233,250,	231,18,	0,0,	233,18,	
234,18,	223,241,	224,242,	0,0,	
222,245,	231,18,	214,237,	233,18,	
234,18,	236,18,	234,251,	236,253,	
0,0,	0,0,	221,244,	0,0,	
0,0,	236,18,	231,248,	0,0,	
90,0,	90,0,	90,0,	90,0,	
90,0,	98,0,	98,0,	98,0,	
98,0,	98,0,	98,0,	98,0,	
98,0,	98,0,	98,0,	98,0,	
98,0,	98,0,	98,0,	98,0,	
98,0,	98,0,	98,0,	98,0,	
98,0,	98,0,	98,0,	98,0,	
98,0,	98,0,	98,0,	98,0,	
98,0,	98,0,	98,0,	98,0,	
98,0,	98,0,	98,0,	98,0,	
98,96,	98,0,	98,0,	98,0,	
98,0,	98,0,	98,154,	235,18,	
98,0,	237,18,	0,0,	98,98,	
98,96,	98,96,	0,0,	235,18,	
0,0,	237,18,	235,252,	0,0,	
98,96,	0,0,	98,0,	98,0,	
98,0,	98,154,	98,0,	98,0,	
98,0,	98,96,	238,18,	239,18,	
0,0,	243,18,	240,18,	239,255,	
0,0,	244,18,	238,18,	239,18,	
238,254,	243,18,	240,18,	237,253,	
240,189,	244,18,	250,18,	0,0,	
0,0,	0,0,	0,0,	251,18,	
98,96,	252,18,	250,18,	98,0,	
98,0,	98,0,	98,0,	251,18,	
98,0,	252,18,	258,18,	252,258,	
0,0,	0,0,	251,257,	250,256,	
0,0,	0,0,	258,18,	0,0,	
0,0,	244,255,	0,0,	243,254,	
0,0,	258,259,	0,0,	0,0,	
0,0,	0,0,	0,0,	0,0,	
0,0,	0,0,	0,0,	98,0,	
98,0,	98,0,	98,0,	98,0,	
100,0,	100,0,	100,0,	100,0,	
100,0,	100,0,	100,0,	100,0,	
100,0,	100,0,	100,0,	100,0,	
100,0,	100,0,	100,0,	100,0,	
100,0,	100,0,	100,0,	100,0,	
100,0,	100,0,	100,0,	100,0,	
100,0,	100,0,	100,0,	100,0,	
100,0,	100,0,	100,0,	100,0,	
100,0,	100,0,	100,0,	0,0,	
245,18,	100,0,	100,0,	100,0,	
100,0,	100,0,	0,0,	100,0,	
245,18,	0,0,	0,0,	100,100,	
100,100,	0,0,	0,0,	0,0,	
0,0,	0,0,	0,0,	100,30,	
0,0,	100,0,	100,0,	100,0,	
100,0,	100,0,	100,0,	100,0,	
0,0,	0,0,	0,0,	0,0,	
0,0,	0,0,	0,0,	0,0,	
0,0,	0,0,	0,0,	0,0,	
0,0,	0,0,	245,189,	0,0,	
0,0,	0,0,	0,0,	0,0,	
0,0,	0,0,	0,0,	0,0,	
0,0,	0,0,	100,0,	100,0,	
100,0,	100,0,	0,0,	100,0,	
0,0,	0,0,	0,0,	0,0,	
0,0,	0,0,	0,0,	0,0,	
0,0,	0,0,	0,0,	0,0,	
0,0,	0,0,	0,0,	0,0,	
0,0,	0,0,	0,0,	0,0,	
0,0,	0,0,	0,0,	0,0,	
0,0,	0,0,	100,0,	100,0,	
100,0,	100,0,	100,0,	101,0,	
101,0,	101,0,	101,0,	101,0,	
101,0,	101,0,	101,0,	101,0,	
101,0,	101,0,	101,0,	101,0,	
101,0,	101,0,	101,0,	101,0,	
101,0,	101,0,	101,0,	101,0,	
101,0,	101,0,	101,0,	101,0,	
101,0,	101,0,	101,0,	101,0,	
101,0,	101,0,	101,0,	101,0,	
101,0,	101,0,	0,0,	0,0,	
101,0,	101,0,	101,0,	101,0,	
101,0,	0,0,	101,0,	0,0,	
0,0,	0,0,	101,155,	101,155,	
0,0,	0,0,	0,0,	0,0,	
0,0,	0,0,	101,155,	0,0,	
101,0,	101,0,	101,0,	101,0,	
101,0,	101,0,	101,0,	101,155,	
0,0,	0,0,	0,0,	0,0,	
0,0,	0,0,	0,0,	0,0,	
0,0,	0,0,	0,0,	0,0,	
0,0,	0,0,	0,0,	0,0,	
0,0,	0,0,	0,0,	0,0,	
0,0,	0,0,	0,0,	0,0,	
0,0,	101,0,	101,0,	101,0,	
101,0,	0,0,	101,0,	0,0,	
0,0,	0,0,	0,0,	0,0,	
0,0,	0,0,	0,0,	0,0,	
0,0,	0,0,	0,0,	0,0,	
0,0,	0,0,	0,0,	0,0,	
0,0,	0,0,	0,0,	0,0,	
0,0,	0,0,	0,0,	0,0,	
0,0,	101,0,	101,0,	101,0,	
101,0,	101,0,	125,0,	125,0,	
125,0,	125,0,	125,0,	125,0,	
125,0,	125,0,	125,0,	125,0,	
125,0,	125,0,	125,0,	125,0,	
125,0,	125,0,	125,0,	125,0,	
125,0,	125,0,	125,0,	125,0,	
125,0,	125,0,	125,0,	125,0,	
125,0,	125,0,	125,0,	125,0,	
125,0,	125,0,	125,0,	125,0,	
125,0,	0,0,	0,0,	125,0,	
125,0,	125,0,	125,0,	125,0,	
0,0,	125,0,	0,0,	0,0,	
0,0,	0,0,	0,0,	0,0,	
0,0,	0,0,	0,0,	0,0,	
0,0,	0,0,	0,0,	125,0,	
125,0,	125,0,	125,0,	125,0,	
125,0,	125,0,	0,0,	0,0,	
0,0,	0,0,	0,0,	0,0,	
0,0,	0,0,	0,0,	0,0,	
0,0,	0,0,	0,0,	0,0,	
0,0,	0,0,	0,0,	0,0,	
0,0,	0,0,	0,0,	0,0,	
0,0,	0,0,	0,0,	0,0,	
125,0,	125,0,	125,0,	125,0,	
0,0,	125,0,	0,0,	0,0,	
0,0,	0,0,	0,0,	0,0,	
0,0,	0,0,	0,0,	0,0,	
0,0,	0,0,	0,0,	0,0,	
0,0,	0,0,	0,0,	0,0,	
0,0,	0,0,	0,0,	0,0,	
0,0,	0,0,	0,0,	0,0,	
125,0,	125,0,	125,0,	125,0,	
125,0,	135,0,	135,0,	135,0,	
135,0,	135,0,	135,0,	135,0,	
135,0,	135,0,	135,0,	135,0,	
135,0,	135,0,	135,0,	135,0,	
135,0,	135,0,	135,0,	135,0,	
135,0,	135,0,	135,0,	135,0,	
135,0,	135,0,	135,0,	135,0,	
135,0,	135,0,	135,0,	135,0,	
135,0,	0,0,	135,0,	135,0,	
0,0,	0,0,	135,0,	135,0,	
135,0,	135,0,	0,0,	135,0,	
135,0,	0,0,	0,0,	0,0,	
0,0,	0,0,	0,0,	0,0,	
0,0,	0,0,	0,0,	0,0,	
0,0,	0,0,	135,0,	135,0,	
135,0,	135,0,	135,0,	0,0,	
135,0,	0,0,	0,0,	0,0,	
0,0,	0,0,	0,0,	0,0,	
0,0,	0,0,	0,0,	0,0,	
0,0,	0,0,	0,0,	0,0,	
0,0,	0,0,	0,0,	0,0,	
0,0,	0,0,	0,0,	0,0,	
0,0,	0,0,	0,0,	0,0,	
0,0,	0,0,	135,0,	0,0,	
135,0,	0,0,	0,0,	0,0,	
0,0,	0,0,	0,0,	0,0,	
0,0,	0,0,	0,0,	0,0,	
0,0,	0,0,	0,0,	0,0,	
0,0,	0,0,	0,0,	0,0,	
0,0,	0,0,	0,0,	0,0,	
0,0,	0,0,	0,0,	135,0,	
135,0,	135,0,	135,0,	135,0,	
136,0,	136,0,	136,0,	136,0,	
136,0,	136,0,	136,0,	136,0,	
136,0,	136,0,	136,0,	136,0,	
136,0,	136,0,	136,0,	136,0,	
136,0,	136,0,	136,0,	136,0,	
136,0,	136,0,	136,0,	136,0,	
136,0,	136,0,	136,0,	136,0,	
136,0,	136,0,	136,0,	136,0,	
0,0,	136,0,	136,0,	0,0,	
0,0,	136,0,	136,0,	136,0,	
136,0,	0,0,	136,0,	136,0,	
0,0,	0,0,	0,0,	0,0,	
0,0,	0,0,	0,0,	0,0,	
0,0,	0,0,	0,0,	0,0,	
0,0,	136,0,	136,0,	136,0,	
136,0,	136,0,	0,0,	136,0,	
0,0,	0,0,	0,0,	0,0,	
0,0,	0,0,	0,0,	0,0,	
0,0,	0,0,	0,0,	0,0,	
0,0,	0,0,	0,0,	0,0,	
0,0,	0,0,	0,0,	0,0,	
0,0,	0,0,	0,0,	0,0,	
0,0,	0,0,	0,0,	0,0,	
0,0,	136,0,	0,0,	136,0,	
0,0,	0,0,	0,0,	0,0,	
0,0,	0,0,	0,0,	0,0,	
0,0,	0,0,	0,0,	0,0,	
0,0,	0,0,	0,0,	0,0,	
0,0,	0,0,	0,0,	0,0,	
0,0,	0,0,	0,0,	0,0,	
0,0,	0,0,	136,0,	136,0,	
136,0,	136,0,	136,0,	151,0,	
151,0,	151,0,	151,0,	151,0,	
151,0,	151,0,	151,0,	151,0,	
151,0,	151,0,	151,0,	151,0,	
151,0,	151,0,	151,0,	151,0,	
151,0,	151,0,	151,0,	151,0,	
151,0,	151,0,	151,0,	151,0,	
151,0,	151,0,	151,0,	151,0,	
151,0,	151,0,	151,0,	151,0,	
151,0,	151,0,	151,89,	151,0,	
151,0,	151,0,	151,0,	151,0,	
151,154,	0,0,	151,0,	0,0,	
0,0,	151,151,	151,89,	151,89,	
0,0,	0,0,	0,0,	0,0,	
0,0,	0,0,	151,89,	0,0,	
151,0,	151,0,	151,0,	151,154,	
151,0,	151,0,	151,0,	151,89,	
0,0,	0,0,	0,0,	0,0,	
0,0,	0,0,	0,0,	0,0,	
0,0,	0,0,	0,0,	0,0,	
0,0,	0,0,	0,0,	0,0,	
0,0,	0,0,	0,0,	0,0,	
0,0,	0,0,	151,89,	0,0,	
0,0,	151,0,	151,0,	151,0,	
151,0,	0,0,	151,0,	0,0,	
0,0,	0,0,	0,0,	0,0,	
0,0,	0,0,	0,0,	0,0,	
0,0,	0,0,	0,0,	0,0,	
0,0,	0,0,	0,0,	0,0,	
0,0,	0,0,	0,0,	0,0,	
0,0,	0,0,	0,0,	0,0,	
0,0,	151,0,	151,0,	151,0,	
151,0,	151,0,	155,0,	155,0,	
155,0,	155,0,	155,0,	155,0,	
155,0,	155,0,	155,0,	155,0,	
155,0,	155,0,	155,0,	155,0,	
155,0,	155,0,	155,0,	155,0,	
155,0,	155,0,	155,0,	155,0,	
155,0,	155,0,	155,0,	155,0,	
155,0,	155,0,	155,0,	155,0,	
155,0,	155,0,	155,0,	155,0,	
155,0,	0,0,	0,0,	155,0,	
155,0,	155,0,	155,0,	155,0,	
0,0,	155,0,	0,0,	0,0,	
0,0,	155,155,	155,155,	0,0,	
0,0,	0,0,	0,0,	0,0,	
0,0,	155,155,	0,0,	155,0,	
155,0,	155,0,	155,0,	155,0,	
155,0,	155,0,	155,155,	0,0,	
0,0,	0,0,	0,0,	0,0,	
0,0,	0,0,	0,0,	0,0,	
0,0,	0,0,	0,0,	0,0,	
0,0,	0,0,	0,0,	0,0,	
0,0,	0,0,	0,0,	0,0,	
0,0,	0,0,	0,0,	0,0,	
155,0,	155,0,	155,0,	155,0,	
0,0,	155,0,	0,0,	0,0,	
0,0,	0,0,	0,0,	0,0,	
0,0,	0,0,	0,0,	0,0,	
0,0,	0,0,	0,0,	0,0,	
0,0,	0,0,	0,0,	0,0,	
0,0,	0,0,	0,0,	0,0,	
0,0,	0,0,	0,0,	0,0,	
155,0,	155,0,	155,0,	155,0,	
155,0,	171,0,	171,0,	171,0,	
171,0,	171,0,	171,0,	171,0,	
171,0,	171,0,	171,0,	171,0,	
171,0,	171,0,	171,0,	171,0,	
171,0,	171,0,	171,0,	171,0,	
171,0,	171,0,	171,0,	171,0,	
171,0,	171,0,	171,0,	171,0,	
171,0,	171,0,	171,0,	171,0,	
171,0,	171,0,	171,0,	171,0,	
0,0,	0,0,	171,0,	171,0,	
171,0,	171,0,	171,0,	0,0,	
171,0,	0,0,	0,0,	0,0,	
0,0,	0,0,	0,0,	0,0,	
0,0,	0,0,	0,0,	0,0,	
0,0,	0,0,	171,0,	171,0,	
171,0,	171,0,	171,0,	171,0,	
171,0,	0,0,	0,0,	0,0,	
0,0,	0,0,	0,0,	0,0,	
0,0,	0,0,	0,0,	0,0,	
0,0,	0,0,	0,0,	0,0,	
0,0,	0,0,	0,0,	0,0,	
0,0,	0,0,	0,0,	0,0,	
0,0,	0,0,	0,0,	171,0,	
171,0,	171,0,	171,0,	0,0,	
171,0,	0,0,	0,0,	0,0,	
0,0,	0,0,	0,0,	0,0,	
0,0,	0,0,	0,0,	0,0,	
0,0,	0,0,	0,0,	0,0,	
0,0,	0,0,	0,0,	0,0,	
0,0,	0,0,	0,0,	0,0,	
0,0,	0,0,	0,0,	171,0,	
171,0,	171,0,	171,0,	171,0,	
189,0,	189,0,	189,0,	189,0,	
189,0,	189,0,	189,0,	189,0,	
189,0,	189,0,	189,0,	189,0,	
189,0,	189,0,	189,0,	189,0,	
189,0,	189,0,	189,0,	189,0,	
189,0,	189,0,	189,0,	189,0,	
189,0,	189,0,	189,0,	189,0,	
189,0,	189,0,	189,0,	189,0,	
189,0,	189,0,	189,0,	0,0,	
0,0,	189,0,	189,0,	189,0,	
189,0,	189,0,	0,0,	189,0,	
0,0,	0,0,	0,0,	0,0,	
0,0,	0,0,	0,0,	0,0,	
0,0,	0,0,	0,0,	0,0,	
0,0,	189,0,	189,0,	189,0,	
189,0,	189,0,	189,0,	189,0,	
0,0,	0,0,	0,0,	0,0,	
0,0,	0,0,	0,0,	0,0,	
0,0,	0,0,	0,0,	0,0,	
0,0,	0,0,	0,0,	0,0,	
0,0,	0,0,	0,0,	0,0,	
0,0,	0,0,	0,0,	0,0,	
0,0,	0,0,	189,0,	189,0,	
189,0,	189,0,	0,0,	189,0,	
0,0,	0,0,	0,0,	0,0,	
0,0,	0,0,	0,0,	0,0,	
0,0,	0,0,	0,0,	0,0,	
0,0,	0,0,	0,0,	0,0,	
0,0,	0,0,	0,0,	0,0,	
0,0,	0,0,	0,0,	0,0,	
0,0,	0,0,	189,0,	189,0,	
189,0,	189,0,	189,0,	193,0,	
193,0,	193,0,	193,0,	193,0,	
193,0,	193,0,	193,0,	193,0,	
193,0,	193,0,	193,0,	193,0,	
193,0,	193,0,	193,0,	193,0,	
193,0,	193,0,	193,0,	193,0,	
193,0,	193,0,	193,0,	193,0,	
193,0,	193,0,	193,0,	193,0,	
193,0,	193,0,	193,0,	193,0,	
193,0,	193,0,	0,0,	0,0,	
193,0,	193,0,	193,0,	193,0,	
193,0,	0,0,	193,0,	0,0,	
0,0,	0,0,	0,0,	0,0,	
0,0,	0,0,	0,0,	0,0,	
0,0,	0,0,	0,0,	0,0,	
193,0,	193,0,	193,0,	193,0,	
193,0,	193,0,	193,0,	0,0,	
0,0,	0,0,	0,0,	0,0,	
0,0,	0,0,	0,0,	0,0,	
0,0,	0,0,	0,0,	0,0,	
0,0,	0,0,	0,0,	0,0,	
0,0,	0,0,	0,0,	0,0,	
0,0,	0,0,	0,0,	0,0,	
0,0,	193,0,	193,0,	193,0,	
193,0,	0,0,	193,0,	0,0,	
0,0,	0,0,	0,0,	0,0,	
0,0,	0,0,	0,0,	0,0,	
0,0,	0,0,	0,0,	0,0,	
0,0,	0,0,	0,0,	0,0,	
0,0,	0,0,	0,0,	0,0,	
0,0,	0,0,	0,0,	0,0,	
0,0,	193,0,	193,0,	193,0,	
193,0,	193,0,	195,0,	195,0,	
195,0,	195,0,	195,0,	195,0,	
195,0,	195,0,	195,0,	195,0,	
195,0,	195,0,	195,0,	195,0,	
195,0,	195,0,	195,0,	195,0,	
195,0,	195,0,	195,0,	195,0,	
195,0,	195,0,	195,0,	195,0,	
195,0,	195,0,	195,0,	195,0,	
195,0,	195,0,	195,0,	195,0,	
195,0,	0,0,	0,0,	195,0,	
195,0,	195,0,	195,0,	195,0,	
0,0,	195,0,	0,0,	0,0,	
0,0,	0,0,	0,0,	0,0,	
0,0,	0,0,	0,0,	0,0,	
0,0,	0,0,	0,0,	195,0,	
195,0,	195,0,	195,0,	195,0,	
195,0,	195,0,	0,0,	0,0,	
0,0,	0,0,	0,0,	0,0,	
0,0,	0,0,	0,0,	0,0,	
0,0,	0,0,	0,0,	0,0,	
0,0,	0,0,	0,0,	0,0,	
0,0,	0,0,	0,0,	0,0,	
0,0,	0,0,	0,0,	0,0,	
195,0,	195,0,	195,0,	195,0,	
0,0,	195,0,	0,0,	0,0,	
0,0,	0,0,	0,0,	0,0,	
0,0,	0,0,	0,0,	0,0,	
0,0,	0,0,	0,0,	0,0,	
0,0,	0,0,	0,0,	0,0,	
0,0,	0,0,	0,0,	0,0,	
0,0,	0,0,	0,0,	0,0,	
195,0,	195,0,	195,0,	195,0,	
195,0,	198,0,	198,0,	198,0,	
198,0,	198,0,	198,0,	198,0,	
198,0,	198,0,	198,0,	198,0,	
198,0,	198,0,	198,0,	198,0,	
198,0,	198,0,	198,0,	198,0,	
198,0,	198,0,	198,0,	198,0,	
198,0,	198,0,	198,0,	198,0,	
198,0,	198,0,	198,0,	198,0,	
198,0,	198,0,	198,0,	198,0,	
0,0,	0,0,	198,0,	198,0,	
198,0,	198,0,	198,0,	0,0,	
198,0,	0,0,	0,0,	0,0,	
0,0,	0,0,	0,0,	0,0,	
0,0,	0,0,	0,0,	0,0,	
0,0,	0,0,	198,0,	198,0,	
198,0,	198,0,	198,0,	198,0,	
198,0,	0,0,	0,0,	0,0,	
0,0,	0,0,	0,0,	0,0,	
0,0,	0,0,	0,0,	0,0,	
0,0,	0,0,	0,0,	0,0,	
0,0,	0,0,	0,0,	0,0,	
0,0,	0,0,	0,0,	0,0,	
0,0,	0,0,	0,0,	198,0,	
198,0,	198,0,	198,0,	0,0,	
198,0,	0,0,	0,0,	0,0,	
0,0,	0,0,	0,0,	0,0,	
0,0,	0,0,	0,0,	0,0,	
0,0,	0,0,	0,0,	0,0,	
0,0,	0,0,	0,0,	0,0,	
0,0,	0,0,	0,0,	0,0,	
0,0,	0,0,	0,0,	198,0,	
198,0,	198,0,	198,0,	198,0,	
202,0,	202,0,	202,0,	202,0,	
202,0,	202,0,	202,0,	202,0,	
202,0,	202,0,	202,0,	202,0,	
202,0,	202,0,	202,0,	202,0,	
202,0,	202,0,	202,0,	202,0,	
202,0,	202,0,	202,0,	202,0,	
202,0,	202,0,	202,0,	202,0,	
202,0,	202,0,	202,0,	202,0,	
202,0,	202,0,	202,0,	0,0,	
0,0,	202,0,	202,0,	202,0,	
202,0,	202,0,	0,0,	202,0,	
0,0,	0,0,	0,0,	0,0,	
0,0,	0,0,	0,0,	0,0,	
0,0,	0,0,	0,0,	0,0,	
0,0,	202,0,	202,0,	202,0,	
202,0,	202,0,	202,0,	202,0,	
0,0,	0,0,	0,0,	0,0,	
0,0,	0,0,	0,0,	0,0,	
0,0,	0,0,	0,0,	0,0,	
0,0,	0,0,	0,0,	0,0,	
0,0,	0,0,	0,0,	0,0,	
0,0,	0,0,	0,0,	0,0,	
0,0,	0,0,	202,0,	202,0,	
202,0,	202,0,	0,0,	202,0,	
0,0,	0,0,	0,0,	0,0,	
0,0,	0,0,	0,0,	0,0,	
0,0,	0,0,	0,0,	0,0,	
0,0,	0,0,	0,0,	0,0,	
0,0,	0,0,	0,0,	0,0,	
0,0,	0,0,	0,0,	0,0,	
0,0,	0,0,	202,0,	202,0,	
202,0,	202,0,	202,0,	203,0,	
203,0,	203,0,	203,0,	203,0,	
203,0,	203,0,	203,0,	203,0,	
203,0,	203,0,	203,0,	203,0,	
203,0,	203,0,	203,0,	203,0,	
203,0,	203,0,	203,0,	203,0,	
203,0,	203,0,	203,0,	203,0,	
203,0,	203,0,	203,0,	203,0,	
203,0,	203,0,	203,0,	203,0,	
203,0,	203,0,	0,0,	0,0,	
203,0,	203,0,	203,0,	203,0,	
203,0,	0,0,	203,0,	0,0,	
0,0,	0,0,	0,0,	0,0,	
0,0,	0,0,	0,0,	0,0,	
0,0,	0,0,	0,0,	0,0,	
203,0,	203,0,	203,0,	203,0,	
203,0,	203,0,	203,0,	0,0,	
0,0,	0,0,	0,0,	0,0,	
0,0,	0,0,	0,0,	0,0,	
0,0,	0,0,	0,0,	0,0,	
0,0,	0,0,	0,0,	0,0,	
0,0,	0,0,	0,0,	0,0,	
0,0,	0,0,	0,0,	0,0,	
0,0,	203,0,	203,0,	203,0,	
203,0,	0,0,	203,0,	0,0,	
0,0,	0,0,	0,0,	0,0,	
0,0,	0,0,	0,0,	0,0,	
0,0,	0,0,	0,0,	0,0,	
0,0,	0,0,	0,0,	0,0,	
0,0,	0,0,	0,0,	0,0,	
0,0,	0,0,	0,0,	0,0,	
0,0,	203,0,	203,0,	203,0,	
203,0,	203,0,	205,0,	205,0,	
205,0,	205,0,	205,0,	205,0,	
205,0,	205,0,	205,0,	205,0,	
205,0,	205,0,	205,0,	205,0,	
205,0,	205,0,	205,0,	205,0,	
205,0,	205,0,	205,0,	205,0,	
205,0,	205,0,	205,0,	205,0,	
205,0,	205,0,	205,0,	205,0,	
205,0,	205,0,	205,0,	205,0,	
205,0,	0,0,	0,0,	205,0,	
205,0,	205,0,	205,0,	205,0,	
0,0,	205,0,	0,0,	0,0,	
0,0,	0,0,	0,0,	0,0,	
0,0,	0,0,	0,0,	0,0,	
0,0,	0,0,	0,0,	205,0,	
205,0,	205,0,	205,0,	205,0,	
205,0,	205,0,	0,0,	0,0,	
0,0,	0,0,	0,0,	0,0,	
0,0,	0,0,	0,0,	0,0,	
0,0,	0,0,	0,0,	0,0,	
0,0,	0,0,	0,0,	0,0,	
0,0,	0,0,	0,0,	0,0,	
0,0,	0,0,	0,0,	0,0,	
205,0,	205,0,	205,0,	205,0,	
0,0,	205,0,	0,0,	0,0,	
0,0,	0,0,	0,0,	0,0,	
0,0,	0,0,	0,0,	0,0,	
0,0,	0,0,	0,0,	0,0,	
0,0,	0,0,	0,0,	0,0,	
0,0,	0,0,	0,0,	0,0,	
0,0,	0,0,	0,0,	0,0,	
205,0,	205,0,	205,0,	205,0,	
205,0,	225,0,	225,0,	225,0,	
225,0,	225,0,	225,0,	225,0,	
225,0,	225,0,	225,0,	225,0,	
225,0,	225,0,	225,0,	225,0,	
225,0,	225,0,	225,0,	225,0,	
225,0,	225,0,	225,0,	225,0,	
225,0,	225,0,	225,0,	225,0,	
225,0,	225,0,	225,0,	225,0,	
225,0,	225,0,	225,0,	225,0,	
0,0,	0,0,	225,0,	225,0,	
225,0,	225,0,	225,0,	0,0,	
225,0,	0,0,	0,0,	0,0,	
0,0,	0,0,	0,0,	0,0,	
0,0,	0,0,	0,0,	0,0,	
0,0,	0,0,	225,0,	225,0,	
225,0,	225,0,	225,0,	225,0,	
225,0,	0,0,	0,0,	0,0,	
0,0,	0,0,	0,0,	0,0,	
0,0,	0,0,	0,0,	0,0,	
0,0,	0,0,	0,0,	0,0,	
0,0,	0,0,	0,0,	0,0,	
0,0,	0,0,	0,0,	0,0,	
0,0,	0,0,	0,0,	225,0,	
225,0,	225,0,	225,0,	0,0,	
225,0,	0,0,	0,0,	0,0,	
0,0,	0,0,	0,0,	0,0,	
0,0,	0,0,	0,0,	0,0,	
0,0,	0,0,	0,0,	0,0,	
0,0,	0,0,	0,0,	0,0,	
0,0,	0,0,	0,0,	0,0,	
0,0,	0,0,	0,0,	225,0,	
225,0,	225,0,	225,0,	225,0,	
226,0,	226,0,	226,0,	226,0,	
226,0,	226,0,	226,0,	226,0,	
226,0,	226,0,	226,0,	226,0,	
226,0,	226,0,	226,0,	226,0,	
226,0,	226,0,	226,0,	226,0,	
226,0,	226,0,	226,0,	226,0,	
226,0,	226,0,	226,0,	226,0,	
226,0,	226,0,	226,0,	226,0,	
226,0,	226,0,	226,0,	0,0,	
0,0,	226,0,	226,0,	226,0,	
226,0,	226,0,	0,0,	226,0,	
0,0,	0,0,	0,0,	0,0,	
0,0,	0,0,	0,0,	0,0,	
0,0,	0,0,	0,0,	0,0,	
0,0,	226,0,	226,0,	226,0,	
226,0,	226,0,	226,0,	226,0,	
0,0,	0,0,	0,0,	0,0,	
0,0,	0,0,	0,0,	0,0,	
0,0,	0,0,	0,0,	0,0,	
0,0,	0,0,	0,0,	0,0,	
0,0,	0,0,	0,0,	0,0,	
0,0,	0,0,	0,0,	0,0,	
0,0,	0,0,	226,0,	226,0,	
226,0,	226,0,	0,0,	226,0,	
0,0,	0,0,	0,0,	0,0,	
0,0,	0,0,	0,0,	0,0,	
0,0,	0,0,	0,0,	0,0,	
0,0,	0,0,	0,0,	0,0,	
0,0,	0,0,	0,0,	0,0,	
0,0,	0,0,	0,0,	0,0,	
0,0,	0,0,	226,0,	226,0,	
226,0,	226,0,	226,0,	228,0,	
228,0,	228,0,	228,0,	228,0,	
228,0,	228,0,	228,0,	228,0,	
228,0,	228,0,	228,0,	228,0,	
228,0,	228,0,	228,0,	228,0,	
228,0,	228,0,	228,0,	228,0,	
228,0,	228,0,	228,0,	228,0,	
228,0,	228,0,	228,0,	228,0,	
228,0,	228,0,	228,0,	228,0,	
228,0,	228,0,	0,0,	0,0,	
228,0,	228,0,	228,0,	228,0,	
228,0,	0,0,	228,0,	0,0,	
0,0,	0,0,	0,0,	0,0,	
0,0,	0,0,	0,0,	0,0,	
0,0,	0,0,	0,0,	0,0,	
228,0,	228,0,	228,0,	228,0,	
228,0,	228,0,	228,0,	0,0,	
0,0,	0,0,	0,0,	0,0,	
0,0,	0,0,	0,0,	0,0,	
0,0,	0,0,	0,0,	0,0,	
0,0,	0,0,	0,0,	0,0,	
0,0,	0,0,	0,0,	0,0,	
0,0,	0,0,	0,0,	0,0,	
0,0,	228,0,	228,0,	228,0,	
228,0,	0,0,	228,0,	0,0,	
0,0,	0,0,	0,0,	0,0,	
0,0,	0,0,	0,0,	0,0,	
0,0,	0,0,	0,0,	0,0,	
0,0,	0,0,	0,0,	0,0,	
0,0,	0,0,	0,0,	0,0,	
0,0,	0,0,	0,0,	0,0,	
0,0,	228,0,	228,0,	228,0,	
228,0,	228,0,	230,0,	230,0,	
230,0,	230,0,	230,0,	230,0,	
230,0,	230,0,	230,0,	230,0,	
230,0,	230,0,	230,0,	230,0,	
230,0,	230,0,	230,0,	230,0,	
230,0,	230,0,	230,0,	230,0,	
230,0,	230,0,	230,0,	230,0,	
230,0,	230,0,	230,0,	230,0,	
230,0,	230,0,	230,0,	230,0,	
230,0,	0,0,	0,0,	230,0,	
230,0,	230,0,	230,0,	230,0,	
0,0,	230,0,	0,0,	0,0,	
0,0,	0,0,	0,0,	0,0,	
0,0,	0,0,	0,0,	0,0,	
0,0,	0,0,	0,0,	230,0,	
230,0,	230,0,	230,0,	230,0,	
230,0,	230,0,	0,0,	0,0,	
0,0,	0,0,	0,0,	0,0,	
0,0,	0,0,	0,0,	0,0,	
0,0,	0,0,	0,0,	0,0,	
0,0,	0,0,	0,0,	0,0,	
0,0,	0,0,	0,0,	0,0,	
0,0,	0,0,	0,0,	0,0,	
230,0,	230,0,	230,0,	230,0,	
0,0,	230,0,	0,0,	0,0,	
0,0,	0,0,	0,0,	0,0,	
0,0,	0,0,	0,0,	0,0,	
0,0,	0,0,	0,0,	0,0,	
0,0,	0,0,	0,0,	0,0,	
0,0,	0,0,	0,0,	0,0,	
0,0,	0,0,	0,0,	0,0,	
230,0,	230,0,	230,0,	230,0,	
230,0,	241,0,	241,0,	241,0,	
241,0,	241,0,	241,0,	241,0,	
241,0,	241,0,	241,0,	241,0,	
241,0,	241,0,	241,0,	241,0,	
241,0,	241,0,	241,0,	241,0,	
241,0,	241,0,	241,0,	241,0,	
241,0,	241,0,	241,0,	241,0,	
241,0,	241,0,	241,0,	241,0,	
241,0,	241,0,	241,0,	241,0,	
0,0,	0,0,	241,0,	241,0,	
241,0,	241,0,	241,0,	0,0,	
241,0,	0,0,	0,0,	0,0,	
0,0,	0,0,	0,0,	0,0,	
0,0,	0,0,	0,0,	0,0,	
0,0,	0,0,	241,0,	241,0,	
241,0,	241,0,	241,0,	241,0,	
241,0,	0,0,	0,0,	0,0,	
0,0,	0,0,	0,0,	0,0,	
0,0,	0,0,	0,0,	0,0,	
0,0,	0,0,	0,0,	0,0,	
0,0,	0,0,	0,0,	0,0,	
0,0,	0,0,	0,0,	0,0,	
0,0,	0,0,	0,0,	241,0,	
241,0,	241,0,	241,0,	0,0,	
241,0,	0,0,	0,0,	0,0,	
0,0,	0,0,	0,0,	0,0,	
0,0,	0,0,	0,0,	0,0,	
0,0,	0,0,	0,0,	0,0,	
0,0,	0,0,	0,0,	0,0,	
0,0,	0,0,	0,0,	0,0,	
0,0,	0,0,	0,0,	241,0,	
241,0,	241,0,	241,0,	241,0,	
242,0,	242,0,	242,0,	242,0,	
242,0,	242,0,	242,0,	242,0,	
242,0,	242,0,	242,0,	242,0,	
242,0,	242,0,	242,0,	242,0,	
242,0,	242,0,	242,0,	242,0,	
242,0,	242,0,	242,0,	242,0,	
242,0,	242,0,	242,0,	242,0,	
242,0,	242,0,	242,0,	242,0,	
242,0,	242,0,	242,0,	0,0,	
0,0,	242,0,	242,0,	242,0,	
242,0,	242,0,	0,0,	242,0,	
0,0,	0,0,	0,0,	0,0,	
0,0,	0,0,	0,0,	0,0,	
0,0,	0,0,	0,0,	0,0,	
0,0,	242,0,	242,0,	242,0,	
242,0,	242,0,	242,0,	242,0,	
0,0,	0,0,	0,0,	0,0,	
0,0,	0,0,	0,0,	0,0,	
0,0,	0,0,	0,0,	0,0,	
0,0,	0,0,	0,0,	0,0,	
0,0,	0,0,	0,0,	0,0,	
0,0,	0,0,	0,0,	0,0,	
0,0,	0,0,	242,0,	242,0,	
242,0,	242,0,	0,0,	242,0,	
0,0,	0,0,	0,0,	0,0,	
0,0,	0,0,	0,0,	0,0,	
0,0,	0,0,	0,0,	0,0,	
0,0,	0,0,	0,0,	0,0,	
0,0,	0,0,	0,0,	0,0,	
0,0,	0,0,	0,0,	0,0,	
0,0,	0,0,	242,0,	242,0,	
242,0,	242,0,	242,0,	246,0,	
246,0,	246,0,	246,0,	246,0,	
246,0,	246,0,	246,0,	246,0,	
246,0,	246,0,	246,0,	246,0,	
246,0,	246,0,	246,0,	246,0,	
246,0,	246,0,	246,0,	246,0,	
246,0,	246,0,	246,0,	246,0,	
246,0,	246,0,	246,0,	246,0,	
246,0,	246,0,	246,0,	246,0,	
246,0,	246,0,	0,0,	0,0,	
246,0,	246,0,	246,0,	246,0,	
246,0,	0,0,	246,0,	0,0,	
0,0,	0,0,	0,0,	0,0,	
0,0,	0,0,	0,0,	0,0,	
0,0,	0,0,	0,0,	0,0,	
246,0,	246,0,	246,0,	246,0,	
246,0,	246,0,	246,0,	0,0,	
0,0,	0,0,	0,0,	0,0,	
0,0,	0,0,	0,0,	0,0,	
0,0,	0,0,	0,0,	0,0,	
0,0,	0,0,	0,0,	0,0,	
0,0,	0,0,	0,0,	0,0,	
0,0,	0,0,	0,0,	0,0,	
0,0,	246,0,	246,0,	246,0,	
246,0,	0,0,	246,0,	0,0,	
0,0,	0,0,	0,0,	0,0,	
0,0,	0,0,	0,0,	0,0,	
0,0,	0,0,	0,0,	0,0,	
0,0,	0,0,	0,0,	0,0,	
0,0,	0,0,	0,0,	0,0,	
0,0,	0,0,	0,0,	0,0,	
0,0,	246,0,	246,0,	246,0,	
246,0,	246,0,	247,0,	247,0,	
247,0,	247,0,	247,0,	247,0,	
247,0,	247,0,	247,0,	247,0,	
247,0,	247,0,	247,0,	247,0,	
247,0,	247,0,	247,0,	247,0,	
247,0,	247,0,	247,0,	247,0,	
247,0,	247,0,	247,0,	247,0,	
247,0,	247,0,	247,0,	247,0,	
247,0,	247,0,	247,0,	247,0,	
247,0,	0,0,	0,0,	247,0,	
247,0,	247,0,	247,0,	247,0,	
0,0,	247,0,	0,0,	0,0,	
0,0,	0,0,	0,0,	0,0,	
0,0,	0,0,	0,0,	0,0,	
0,0,	0,0,	0,0,	247,0,	
247,0,	247,0,	247,0,	247,0,	
247,0,	247,0,	0,0,	0,0,	
0,0,	0,0,	0,0,	0,0,	
0,0,	0,0,	0,0,	0,0,	
0,0,	0,0,	0,0,	0,0,	
0,0,	0,0,	0,0,	0,0,	
0,0,	0,0,	0,0,	0,0,	
0,0,	0,0,	0,0,	0,0,	
247,0,	247,0,	247,0,	247,0,	
0,0,	247,0,	0,0,	0,0,	
0,0,	0,0,	0,0,	0,0,	
0,0,	0,0,	0,0,	0,0,	
0,0,	0,0,	0,0,	0,0,	
0,0,	0,0,	0,0,	0,0,	
0,0,	0,0,	0,0,	0,0,	
0,0,	0,0,	0,0,	0,0,	
247,0,	247,0,	247,0,	247,0,	
247,0,	248,0,	248,0,	248,0,	
248,0,	248,0,	248,0,	248,0,	
248,0,	248,0,	248,0,	248,0,	
248,0,	248,0,	248,0,	248,0,	
248,0,	248,0,	248,0,	248,0,	
248,0,	248,0,	248,0,	248,0,	
248,0,	248,0,	248,0,	248,0,	
248,0,	248,0,	248,0,	248,0,	
248,0,	248,0,	248,0,	248,0,	
0,0,	0,0,	248,0,	248,0,	
248,0,	248,0,	248,0,	0,0,	
248,0,	0,0,	0,0,	0,0,	
0,0,	0,0,	0,0,	0,0,	
0,0,	0,0,	0,0,	0,0,	
0,0,	0,0,	248,0,	248,0,	
248,0,	248,0,	248,0,	248,0,	
248,0,	0,0,	0,0,	0,0,	
0,0,	0,0,	0,0,	0,0,	
0,0,	0,0,	0,0,	0,0,	
0,0,	0,0,	0,0,	0,0,	
0,0,	0,0,	0,0,	0,0,	
0,0,	0,0,	0,0,	0,0,	
0,0,	0,0,	0,0,	248,0,	
248,0,	248,0,	248,0,	0,0,	
248,0,	0,0,	0,0,	0,0,	
0,0,	0,0,	0,0,	0,0,	
0,0,	0,0,	0,0,	0,0,	
0,0,	0,0,	0,0,	0,0,	
0,0,	0,0,	0,0,	0,0,	
0,0,	0,0,	0,0,	0,0,	
0,0,	0,0,	0,0,	248,0,	
248,0,	248,0,	248,0,	248,0,	
249,0,	249,0,	249,0,	249,0,	
249,0,	249,0,	249,0,	249,0,	
249,0,	249,0,	249,0,	249,0,	
249,0,	249,0,	249,0,	249,0,	
249,0,	249,0,	249,0,	249,0,	
249,0,	249,0,	249,0,	249,0,	
249,0,	249,0,	249,0,	249,0,	
249,0,	249,0,	249,0,	249,0,	
249,0,	249,0,	249,0,	0,0,	
0,0,	249,0,	249,0,	249,0,	
249,0,	249,0,	0,0,	249,0,	
0,0,	0,0,	0,0,	0,0,	
0,0,	0,0,	0,0,	0,0,	
0,0,	0,0,	0,0,	0,0,	
0,0,	249,0,	249,0,	249,0,	
249,0,	249,0,	249,0,	249,0,	
0,0,	0,0,	0,0,	0,0,	
0,0,	0,0,	0,0,	0,0,	
0,0,	0,0,	0,0,	0,0,	
0,0,	0,0,	0,0,	0,0,	
0,0,	0,0,	0,0,	0,0,	
0,0,	0,0,	0,0,	0,0,	
0,0,	0,0,	249,0,	249,0,	
249,0,	249,0,	0,0,	249,0,	
0,0,	0,0,	0,0,	0,0,	
0,0,	0,0,	0,0,	0,0,	
0,0,	0,0,	0,0,	0,0,	
0,0,	0,0,	0,0,	0,0,	
0,0,	0,0,	0,0,	0,0,	
0,0,	0,0,	0,0,	0,0,	
0,0,	0,0,	249,0,	249,0,	
249,0,	249,0,	249,0,	253,0,	
253,0,	253,0,	253,0,	253,0,	
253,0,	253,0,	253,0,	253,0,	
253,0,	253,0,	253,0,	253,0,	
253,0,	253,0,	253,0,	253,0,	
253,0,	253,0,	253,0,	253,0,	
253,0,	253,0,	253,0,	253,0,	
253,0,	253,0,	253,0,	253,0,	
253,0,	253,0,	253,0,	253,0,	
253,0,	253,0,	0,0,	0,0,	
253,0,	253,0,	253,0,	253,0,	
253,0,	0,0,	253,0,	0,0,	
0,0,	0,0,	0,0,	0,0,	
0,0,	0,0,	0,0,	0,0,	
0,0,	0,0,	0,0,	0,0,	
253,0,	253,0,	253,0,	253,0,	
253,0,	253,0,	253,0,	0,0,	
0,0,	0,0,	0,0,	0,0,	
0,0,	0,0,	0,0,	0,0,	
0,0,	0,0,	0,0,	0,0,	
0,0,	0,0,	0,0,	0,0,	
0,0,	0,0,	0,0,	0,0,	
0,0,	0,0,	0,0,	0,0,	
0,0,	253,0,	253,0,	253,0,	
253,0,	0,0,	253,0,	0,0,	
0,0,	0,0,	0,0,	0,0,	
0,0,	0,0,	0,0,	0,0,	
0,0,	0,0,	0,0,	0,0,	
0,0,	0,0,	0,0,	0,0,	
0,0,	0,0,	0,0,	0,0,	
0,0,	0,0,	0,0,	0,0,	
0,0,	253,0,	253,0,	253,0,	
253,0,	253,0,	254,0,	254,0,	
254,0,	254,0,	254,0,	254,0,	
254,0,	254,0,	254,0,	254,0,	
254,0,	254,0,	254,0,	254,0,	
254,0,	254,0,	254,0,	254,0,	
254,0,	254,0,	254,0,	254,0,	
254,0,	254,0,	254,0,	254,0,	
254,0,	254,0,	254,0,	254,0,	
254,0,	254,0,	254,0,	254,0,	
254,0,	0,0,	0,0,	254,0,	
254,0,	254,0,	254,0,	254,0,	
0,0,	254,0,	0,0,	0,0,	
0,0,	0,0,	0,0,	0,0,	
0,0,	0,0,	0,0,	0,0,	
0,0,	0,0,	0,0,	254,0,	
254,0,	254,0,	254,0,	254,0,	
254,0,	254,0,	0,0,	0,0,	
0,0,	0,0,	0,0,	0,0,	
0,0,	0,0,	0,0,	0,0,	
0,0,	0,0,	0,0,	0,0,	
0,0,	0,0,	0,0,	0,0,	
0,0,	0,0,	0,0,	0,0,	
0,0,	0,0,	0,0,	0,0,	
254,0,	254,0,	254,0,	254,0,	
0,0,	254,0,	0,0,	0,0,	
0,0,	0,0,	0,0,	0,0,	
0,0,	0,0,	0,0,	0,0,	
0,0,	0,0,	0,0,	0,0,	
0,0,	0,0,	0,0,	0,0,	
0,0,	0,0,	0,0,	0,0,	
0,0,	0,0,	0,0,	0,0,	
254,0,	254,0,	254,0,	254,0,	
254,0,	255,0,	255,0,	255,0,	
255,0,	255,0,	255,0,	255,0,	
255,0,	255,0,	255,0,	255,0,	
255,0,	255,0,	255,0,	255,0,	
255,0,	255,0,	255,0,	255,0,	
255,0,	255,0,	255,0,	255,0,	
255,0,	255,0,	255,0,	255,0,	
255,0,	255,0,	255,0,	255,0,	
255,0,	255,0,	255,0,	255,0,	
0,0,	0,0,	255,0,	255,0,	
255,0,	255,0,	255,0,	0,0,	
255,0,	0,0,	0,0,	0,0,	
0,0,	0,0,	0,0,	0,0,	
0,0,	0,0,	0,0,	0,0,	
0,0,	0,0,	255,0,	255,0,	
255,0,	255,0,	255,0,	255,0,	
255,0,	0,0,	0,0,	0,0,	
0,0,	0,0,	0,0,	0,0,	
0,0,	0,0,	0,0,	0,0,	
0,0,	0,0,	0,0,	0,0,	
0,0,	0,0,	0,0,	0,0,	
0,0,	0,0,	0,0,	0,0,	
0,0,	0,0,	0,0,	255,0,	
255,0,	255,0,	255,0,	0,0,	
255,0,	0,0,	0,0,	0,0,	
0,0,	0,0,	0,0,	0,0,	
0,0,	0,0,	0,0,	0,0,	
0,0,	0,0,	0,0,	0,0,	
0,0,	0,0,	0,0,	0,0,	
0,0,	0,0,	0,0,	0,0,	
0,0,	0,0,	0,0,	255,0,	
255,0,	255,0,	255,0,	255,0,	
256,0,	256,0,	256,0,	256,0,	
256,0,	256,0,	256,0,	256,0,	
256,0,	256,0,	256,0,	256,0,	
256,0,	256,0,	256,0,	256,0,	
256,0,	256,0,	256,0,	256,0,	
256,0,	256,0,	256,0,	256,0,	
256,0,	256,0,	256,0,	256,0,	
256,0,	256,0,	256,0,	256,0,	
256,0,	256,0,	256,0,	0,0,	
0,0,	256,0,	256,0,	256,0,	
256,0,	256,0,	0,0,	256,0,	
0,0,	0,0,	0,0,	0,0,	
0,0,	0,0,	0,0,	0,0,	
0,0,	0,0,	0,0,	0,0,	
0,0,	256,0,	256,0,	256,0,	
256,0,	256,0,	256,0,	256,0,	
0,0,	0,0,	0,0,	0,0,	
0,0,	0,0,	0,0,	0,0,	
0,0,	0,0,	0,0,	0,0,	
0,0,	0,0,	0,0,	0,0,	
0,0,	0,0,	0,0,	0,0,	
0,0,	0,0,	0,0,	0,0,	
0,0,	0,0,	256,0,	256,0,	
256,0,	256,0,	0,0,	256,0,	
0,0,	0,0,	0,0,	0,0,	
0,0,	0,0,	0,0,	0,0,	
0,0,	0,0,	0,0,	0,0,	
0,0,	0,0,	0,0,	0,0,	
0,0,	0,0,	0,0,	0,0,	
0,0,	0,0,	0,0,	0,0,	
0,0,	0,0,	256,0,	256,0,	
256,0,	256,0,	256,0,	257,0,	
257,0,	257,0,	257,0,	257,0,	
257,0,	257,0,	257,0,	257,0,	
257,0,	257,0,	257,0,	257,0,	
257,0,	257,0,	257,0,	257,0,	
257,0,	257,0,	257,0,	257,0,	
257,0,	257,0,	257,0,	257,0,	
257,0,	257,0,	257,0,	257,0,	
257,0,	257,0,	257,0,	257,0,	
257,0,	257,0,	0,0,	0,0,	
257,0,	257,0,	257,0,	257,0,	
257,0,	0,0,	257,0,	0,0,	
0,0,	0,0,	0,0,	0,0,	
0,0,	0,0,	0,0,	0,0,	
0,0,	0,0,	0,0,	0,0,	
257,0,	257,0,	257,0,	257,0,	
257,0,	257,0,	257,0,	0,0,	
0,0,	0,0,	0,0,	0,0,	
0,0,	0,0,	0,0,	0,0,	
0,0,	0,0,	0,0,	0,0,	
0,0,	0,0,	0,0,	0,0,	
0,0,	0,0,	0,0,	0,0,	
0,0,	0,0,	0,0,	0,0,	
0,0,	257,0,	257,0,	257,0,	
257,0,	0,0,	257,0,	0,0,	
0,0,	0,0,	0,0,	0,0,	
0,0,	0,0,	0,0,	0,0,	
0,0,	0,0,	0,0,	0,0,	
0,0,	0,0,	0,0,	0,0,	
0,0,	0,0,	0,0,	0,0,	
0,0,	0,0,	0,0,	0,0,	
0,0,	257,0,	257,0,	257,0,	
257,0,	257,0,	259,0,	259,0,	
259,0,	259,0,	259,0,	259,0,	
259,0,	259,0,	259,0,	259,0,	
259,0,	259,0,	259,0,	259,0,	
259,0,	259,0,	259,0,	259,0,	
259,0,	259,0,	259,0,	259,0,	
259,0,	259,0,	259,0,	259,0,	
259,0,	259,0,	259,0,	259,0,	
259,0,	259,0,	259,0,	259,0,	
259,0,	0,0,	0,0,	259,0,	
259,0,	259,0,	259,0,	259,0,	
0,0,	259,0,	0,0,	0,0,	
0,0,	0,0,	0,0,	0,0,	
0,0,	0,0,	0,0,	0,0,	
0,0,	0,0,	0,0,	259,0,	
259,0,	259,0,	259,0,	259,0,	
259,0,	259,0,	0,0,	0,0,	
0,0,	0,0,	0,0,	0,0,	
0,0,	0,0,	0,0,	0,0,	
0,0,	0,0,	0,0,	0,0,	
0,0,	0,0,	0,0,	0,0,	
0,0,	0,0,	0,0,	0,0,	
0,0,	0,0,	0,0,	0,0,	
259,0,	259,0,	259,0,	259,0,	
0,0,	259,0,	0,0,	0,0,	
0,0,	0,0,	0,0,	0,0,	
0,0,	0,0,	0,0,	0,0,	
0,0,	0,0,	0,0,	0,0,	
0,0,	0,0,	0,0,	0,0,	
0,0,	0,0,	0,0,	0,0,	
0,0,	0,0,	0,0,	0,0,	
259,0,	259,0,	259,0,	259,0,	
259,0,	0,0,	0,0,	0,0,	
0,0};
struct yysvf yysvec[] = {
0,	0,	0,
yycrank+1,	0,		0,	
yycrank+0,	yysvec+1,	0,	
yycrank+3,	0,		0,	
yycrank+0,	yysvec+3,	0,	
yycrank+-129,	0,		0,	
yycrank+-8,	yysvec+5,	0,	
yycrank+114,	yysvec+3,	0,	
yycrank+165,	yysvec+3,	0,	
yycrank+-249,	0,		0,	
yycrank+-24,	yysvec+9,	0,	
yycrank+-25,	yysvec+9,	0,	
yycrank+-53,	yysvec+9,	0,	
yycrank+-55,	yysvec+9,	0,	
yycrank+-57,	yysvec+9,	0,	
yycrank+5,	0,		yyvstop+1,
yycrank+0,	0,		yyvstop+3,
yycrank+71,	0,		yyvstop+5,
yycrank+-337,	0,		yyvstop+7,
yycrank+400,	0,		yyvstop+10,
yycrank+96,	0,		yyvstop+13,
yycrank+0,	0,		yyvstop+15,
yycrank+0,	0,		yyvstop+17,
yycrank+74,	0,		yyvstop+19,
yycrank+75,	0,		yyvstop+21,
yycrank+0,	0,		yyvstop+23,
yycrank+76,	0,		yyvstop+25,
yycrank+-522,	yysvec+18,	yyvstop+27,
yycrank+-649,	yysvec+18,	yyvstop+31,
yycrank+-776,	yysvec+18,	yyvstop+34,
yycrank+-903,	yysvec+18,	yyvstop+39,
yycrank+0,	0,		yyvstop+43,
yycrank+0,	0,		yyvstop+45,
yycrank+80,	0,		yyvstop+47,
yycrank+81,	0,		yyvstop+49,
yycrank+82,	0,		yyvstop+51,
yycrank+522,	0,		yyvstop+53,
yycrank+77,	yysvec+36,	yyvstop+56,
yycrank+78,	yysvec+36,	yyvstop+59,
yycrank+80,	yysvec+36,	yyvstop+62,
yycrank+79,	yysvec+36,	yyvstop+65,
yycrank+127,	yysvec+36,	yyvstop+68,
yycrank+131,	yysvec+36,	yyvstop+71,
yycrank+92,	yysvec+36,	yyvstop+74,
yycrank+83,	yysvec+36,	yyvstop+77,
yycrank+137,	yysvec+36,	yyvstop+80,
yycrank+132,	yysvec+36,	yyvstop+83,
yycrank+112,	yysvec+36,	yyvstop+86,
yycrank+151,	yysvec+36,	yyvstop+89,
yycrank+187,	yysvec+36,	yyvstop+92,
yycrank+185,	yysvec+36,	yyvstop+95,
yycrank+0,	0,		yyvstop+98,
yycrank+0,	0,		yyvstop+100,
yycrank+199,	yysvec+36,	yyvstop+102,
yycrank+196,	yysvec+36,	yyvstop+105,
yycrank+155,	yysvec+36,	yyvstop+108,
yycrank+134,	yysvec+36,	yyvstop+111,
yycrank+189,	yysvec+36,	yyvstop+114,
yycrank+198,	yysvec+36,	yyvstop+117,
yycrank+0,	0,		yyvstop+120,
yycrank+25,	0,		yyvstop+122,
yycrank+0,	0,		yyvstop+124,
yycrank+0,	0,		yyvstop+126,
yycrank+0,	0,		yyvstop+128,
yycrank+0,	yysvec+15,	yyvstop+130,
yycrank+-1030,	0,		yyvstop+133,
yycrank+-1157,	yysvec+65,	yyvstop+136,
yycrank+0,	0,		yyvstop+139,
yycrank+0,	0,		yyvstop+142,
yycrank+-1284,	yysvec+18,	yyvstop+145,
yycrank+75,	yysvec+36,	yyvstop+148,
yycrank+219,	yysvec+36,	yyvstop+151,
yycrank+240,	yysvec+36,	yyvstop+154,
yycrank+202,	yysvec+36,	yyvstop+157,
yycrank+245,	yysvec+36,	yyvstop+160,
yycrank+244,	yysvec+36,	yyvstop+163,
yycrank+624,	yysvec+36,	yyvstop+166,
yycrank+315,	yysvec+36,	yyvstop+169,
yycrank+213,	yysvec+36,	yyvstop+173,
yycrank+335,	yysvec+36,	yyvstop+177,
yycrank+626,	yysvec+36,	yyvstop+180,
yycrank+0,	0,		yyvstop+184,
yycrank+0,	0,		yyvstop+187,
yycrank+0,	yysvec+15,	yyvstop+189,
yycrank+117,	0,		yyvstop+192,
yycrank+122,	0,		yyvstop+194,
yycrank+124,	0,		yyvstop+196,
yycrank+0,	0,		yyvstop+198,
yycrank+0,	yysvec+19,	yyvstop+200,
yycrank+1347,	0,		yyvstop+202,
yycrank+-1469,	yysvec+18,	yyvstop+204,
yycrank+179,	0,		0,	
yycrank+0,	0,		yyvstop+206,
yycrank+0,	0,		yyvstop+208,
yycrank+0,	0,		yyvstop+210,
yycrank+0,	0,		yyvstop+212,
yycrank+1157,	yysvec+89,	yyvstop+214,
yycrank+0,	0,		yyvstop+216,
yycrank+-1596,	yysvec+18,	yyvstop+218,
yycrank+0,	0,		yyvstop+220,
yycrank+-1723,	yysvec+18,	yyvstop+222,
yycrank+-1850,	yysvec+18,	yyvstop+227,
yycrank+0,	0,		yyvstop+230,
yycrank+0,	0,		yyvstop+232,
yycrank+0,	0,		yyvstop+234,
yycrank+0,	0,		yyvstop+236,
yycrank+0,	0,		yyvstop+238,
yycrank+243,	yysvec+36,	yyvstop+240,
yycrank+250,	yysvec+36,	yyvstop+243,
yycrank+254,	yysvec+36,	yyvstop+246,
yycrank+257,	yysvec+36,	yyvstop+249,
yycrank+337,	yysvec+36,	yyvstop+252,
yycrank+339,	yysvec+36,	yyvstop+255,
yycrank+342,	yysvec+36,	yyvstop+258,
yycrank+344,	yysvec+36,	yyvstop+261,
yycrank+351,	yysvec+36,	yyvstop+264,
yycrank+647,	yysvec+36,	yyvstop+267,
yycrank+358,	yysvec+36,	yyvstop+270,
yycrank+658,	yysvec+36,	yyvstop+273,
yycrank+627,	yysvec+36,	yyvstop+276,
yycrank+651,	yysvec+36,	yyvstop+279,
yycrank+660,	yysvec+36,	yyvstop+282,
yycrank+654,	yysvec+36,	yyvstop+285,
yycrank+680,	yysvec+36,	yyvstop+288,
yycrank+676,	yysvec+36,	yyvstop+291,
yycrank+-1977,	yysvec+18,	yyvstop+294,
yycrank+653,	yysvec+36,	yyvstop+298,
yycrank+745,	yysvec+36,	yyvstop+301,
yycrank+751,	yysvec+36,	yyvstop+304,
yycrank+754,	yysvec+36,	yyvstop+307,
yycrank+755,	yysvec+36,	yyvstop+310,
yycrank+692,	yysvec+36,	yyvstop+313,
yycrank+765,	yysvec+36,	yyvstop+316,
yycrank+775,	yysvec+36,	yyvstop+319,
yycrank+0,	0,		yyvstop+322,
yycrank+-2104,	yysvec+65,	yyvstop+324,
yycrank+-2231,	yysvec+65,	yyvstop+326,
yycrank+0,	0,		yyvstop+329,
yycrank+682,	yysvec+36,	yyvstop+331,
yycrank+683,	yysvec+36,	yyvstop+334,
yycrank+694,	yysvec+36,	yyvstop+337,
yycrank+776,	yysvec+36,	yyvstop+340,
yycrank+777,	yysvec+36,	yyvstop+343,
yycrank+779,	yysvec+36,	yyvstop+346,
yycrank+780,	yysvec+36,	yyvstop+349,
yycrank+872,	yysvec+36,	yyvstop+352,
yycrank+781,	yysvec+36,	yyvstop+355,
yycrank+795,	yysvec+36,	yyvstop+358,
yycrank+0,	0,		yyvstop+361,
yycrank+0,	0,		yyvstop+363,
yycrank+0,	0,		yyvstop+365,
yycrank+-2358,	yysvec+18,	yyvstop+367,
yycrank+0,	0,		yyvstop+369,
yycrank+0,	0,		yyvstop+372,
yycrank+0,	0,		yyvstop+374,
yycrank+-2485,	yysvec+18,	yyvstop+376,
yycrank+687,	yysvec+36,	yyvstop+380,
yycrank+805,	yysvec+36,	yyvstop+383,
yycrank+806,	yysvec+36,	yyvstop+386,
yycrank+811,	yysvec+36,	yyvstop+389,
yycrank+807,	yysvec+36,	yyvstop+392,
yycrank+809,	yysvec+36,	yyvstop+395,
yycrank+882,	yysvec+36,	yyvstop+398,
yycrank+878,	yysvec+36,	yyvstop+401,
yycrank+900,	yysvec+36,	yyvstop+404,
yycrank+820,	yysvec+36,	yyvstop+407,
yycrank+902,	yysvec+36,	yyvstop+410,
yycrank+903,	yysvec+36,	yyvstop+413,
yycrank+904,	yysvec+36,	yyvstop+416,
yycrank+922,	yysvec+36,	yyvstop+419,
yycrank+924,	yysvec+36,	yyvstop+422,
yycrank+-2612,	yysvec+18,	yyvstop+425,
yycrank+934,	yysvec+36,	yyvstop+429,
yycrank+935,	yysvec+36,	yyvstop+432,
yycrank+915,	yysvec+36,	yyvstop+435,
yycrank+1008,	yysvec+36,	yyvstop+438,
yycrank+1004,	yysvec+36,	yyvstop+441,
yycrank+1017,	yysvec+36,	yyvstop+444,
yycrank+1028,	yysvec+36,	yyvstop+447,
yycrank+1029,	yysvec+36,	yyvstop+450,
yycrank+1032,	yysvec+36,	yyvstop+453,
yycrank+1030,	yysvec+36,	yyvstop+456,
yycrank+936,	yysvec+36,	yyvstop+459,
yycrank+937,	yysvec+36,	yyvstop+462,
yycrank+946,	yysvec+36,	yyvstop+465,
yycrank+947,	yysvec+36,	yyvstop+468,
yycrank+1033,	yysvec+36,	yyvstop+471,
yycrank+1034,	yysvec+36,	yyvstop+474,
yycrank+1035,	yysvec+36,	yyvstop+477,
yycrank+-2739,	yysvec+18,	yyvstop+481,
yycrank+1044,	yysvec+36,	yyvstop+485,
yycrank+1259,	yysvec+36,	yyvstop+488,
yycrank+1076,	yysvec+36,	yyvstop+491,
yycrank+-2866,	yysvec+18,	yyvstop+494,
yycrank+1045,	yysvec+36,	yyvstop+498,
yycrank+-2993,	yysvec+18,	yyvstop+501,
yycrank+1057,	yysvec+36,	yyvstop+505,
yycrank+1061,	yysvec+36,	yyvstop+508,
yycrank+-3120,	yysvec+18,	yyvstop+511,
yycrank+1066,	yysvec+36,	yyvstop+515,
yycrank+1067,	yysvec+36,	yyvstop+518,
yycrank+1261,	yysvec+36,	yyvstop+521,
yycrank+-3247,	yysvec+18,	yyvstop+524,
yycrank+-3374,	yysvec+18,	yyvstop+528,
yycrank+1282,	yysvec+36,	yyvstop+532,
yycrank+-3501,	yysvec+18,	yyvstop+535,
yycrank+1287,	yysvec+36,	yyvstop+539,
yycrank+948,	yysvec+36,	yyvstop+542,
yycrank+1289,	yysvec+36,	yyvstop+545,
yycrank+1283,	yysvec+36,	yyvstop+548,
yycrank+1303,	yysvec+36,	yyvstop+551,
yycrank+1444,	yysvec+36,	yyvstop+554,
yycrank+1262,	yysvec+36,	yyvstop+557,
yycrank+1446,	yysvec+36,	yyvstop+560,
yycrank+1467,	yysvec+36,	yyvstop+563,
yycrank+1313,	yysvec+36,	yyvstop+566,
yycrank+1468,	yysvec+36,	yyvstop+569,
yycrank+1469,	yysvec+36,	yyvstop+572,
yycrank+1285,	yysvec+36,	yyvstop+575,
yycrank+1298,	yysvec+36,	yyvstop+578,
yycrank+1447,	yysvec+36,	yyvstop+581,
yycrank+1470,	yysvec+36,	yyvstop+584,
yycrank+1471,	yysvec+36,	yyvstop+587,
yycrank+1472,	yysvec+36,	yyvstop+590,
yycrank+1473,	yysvec+36,	yyvstop+593,
yycrank+-3628,	yysvec+18,	yyvstop+596,
yycrank+-3755,	yysvec+18,	yyvstop+600,
yycrank+1488,	yysvec+36,	yyvstop+604,
yycrank+-3882,	yysvec+18,	yyvstop+607,
yycrank+1483,	yysvec+36,	yyvstop+611,
yycrank+-4009,	yysvec+18,	yyvstop+614,
yycrank+1501,	yysvec+36,	yyvstop+618,
yycrank+1060,	yysvec+36,	yyvstop+621,
yycrank+1503,	yysvec+36,	yyvstop+624,
yycrank+1504,	yysvec+36,	yyvstop+627,
yycrank+1571,	yysvec+36,	yyvstop+630,
yycrank+1513,	yysvec+36,	yyvstop+633,
yycrank+1573,	yysvec+36,	yyvstop+636,
yycrank+1594,	yysvec+36,	yyvstop+639,
yycrank+1595,	yysvec+36,	yyvstop+642,
yycrank+1598,	yysvec+36,	yyvstop+645,
yycrank+-4136,	yysvec+18,	yyvstop+648,
yycrank+-4263,	yysvec+18,	yyvstop+652,
yycrank+1597,	yysvec+36,	yyvstop+656,
yycrank+1601,	yysvec+36,	yyvstop+659,
yycrank+1692,	yysvec+36,	yyvstop+662,
yycrank+-4390,	yysvec+18,	yyvstop+665,
yycrank+-4517,	yysvec+18,	yyvstop+669,
yycrank+-4644,	yysvec+18,	yyvstop+673,
yycrank+-4771,	yysvec+18,	yyvstop+677,
yycrank+1610,	yysvec+36,	yyvstop+681,
yycrank+1615,	yysvec+36,	yyvstop+684,
yycrank+1617,	yysvec+36,	yyvstop+687,
yycrank+-4898,	yysvec+18,	yyvstop+690,
yycrank+-5025,	yysvec+18,	yyvstop+694,
yycrank+-5152,	yysvec+18,	yyvstop+698,
yycrank+-5279,	yysvec+18,	yyvstop+702,
yycrank+-5406,	yysvec+18,	yyvstop+706,
yycrank+1626,	yysvec+36,	yyvstop+710,
yycrank+-5533,	yysvec+18,	yyvstop+713,
0,	0,	0};
struct yywork *yytop = yycrank+5660;
struct yysvf *yybgin = yysvec+1;
char yymatch[] = {
00  ,01  ,01  ,01  ,01  ,01  ,01  ,01  ,
01  ,011 ,012 ,01  ,01  ,01  ,01  ,01  ,
01  ,01  ,01  ,01  ,01  ,01  ,01  ,01  ,
01  ,01  ,01  ,01  ,01  ,01  ,01  ,01  ,
011 ,'!' ,01  ,01  ,'$' ,'%' ,01  ,01  ,
01  ,01  ,'!' ,'+' ,01  ,'-' ,'$' ,'/' ,
'0' ,'1' ,'1' ,'1' ,'1' ,'1' ,'1' ,'1' ,
'8' ,'8' ,01  ,01  ,01  ,01  ,01  ,'!' ,
01  ,'A' ,'A' ,'A' ,'A' ,'A' ,'A' ,'$' ,
'$' ,'$' ,'$' ,'$' ,'$' ,'$' ,'$' ,'$' ,
'$' ,'$' ,'$' ,'$' ,'$' ,'$' ,'$' ,'$' ,
'X' ,'$' ,'$' ,'!' ,'!' ,'!' ,01  ,'$' ,
01  ,'A' ,'A' ,'A' ,'A' ,'A' ,'A' ,'$' ,
'$' ,'$' ,'$' ,'$' ,'$' ,'$' ,'$' ,'$' ,
'$' ,'$' ,'$' ,'$' ,'$' ,'$' ,'$' ,'$' ,
'X' ,'$' ,'$' ,01  ,01  ,01  ,01  ,01  ,
0};
char yyextra[] = {
0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,
0};
/*	ATT:#ident	"libl:lib/ncform	1.3"	*/
	
#ident	"@(#)libl/lib:ncform	23.1"

int yylineno =1;
# define YYU(x) x
# define NLSTATE yyprevious=YYNEWLINE
char yytext[YYLMAX];
struct yysvf *yylstate [YYLMAX], **yylsp, **yyolsp;
char yysbuf[YYLMAX];
char *yysptr = yysbuf;
int *yyfnd;
extern struct yysvf *yyestate;
int yyprevious = YYNEWLINE;
yylook(){
	register struct yysvf *yystate, **lsp;
	register struct yywork *yyt;
	struct yysvf *yyz;
	int yych, yyfirst;
	struct yywork *yyr;
# ifdef LEXDEBUG
	int debug;
# endif
	char *yylastch;
	/* start off machines */
# ifdef LEXDEBUG
	debug = 0;
# endif
	yyfirst=1;
	if (!yymorfg)
		yylastch = yytext;
	else {
		yymorfg=0;
		yylastch = yytext+yyleng;
		}
	for(;;){
		lsp = yylstate;
		yyestate = yystate = yybgin;
		if (yyprevious==YYNEWLINE) yystate++;
		for (;;){
# ifdef LEXDEBUG
			if(debug)fprintf(yyout,"state %d\n",yystate-yysvec-1);
# endif
			yyt = yystate->yystoff;
			if(yyt == yycrank && !yyfirst){  /* may not be any transitions */
				yyz = yystate->yyother;
				if(yyz == 0)break;
				if(yyz->yystoff == yycrank)break;
				}
			*yylastch++ = yych = input();
			yyfirst=0;
		tryagain:
# ifdef LEXDEBUG
			if(debug){
				fprintf(yyout,"char ");
				allprint(yych);
				putchar('\n');
				}
# endif
			yyr = yyt;
			if ( (int)yyt > (int)yycrank){
				yyt = yyr + yych;
				if (yyt <= yytop && yyt->verify+yysvec == yystate){
					if(yyt->advance+yysvec == YYLERR)	/* error transitions */
						{unput(*--yylastch);break;}
					*lsp++ = yystate = yyt->advance+yysvec;
					goto contin;
					}
				}
# ifdef YYOPTIM
			else if((int)yyt < (int)yycrank) {		/* r < yycrank */
				yyt = yyr = yycrank+(yycrank-yyt);
# ifdef LEXDEBUG
				if(debug)fprintf(yyout,"compressed state\n");
# endif
				yyt = yyt + yych;
				if(yyt <= yytop && yyt->verify+yysvec == yystate){
					if(yyt->advance+yysvec == YYLERR)	/* error transitions */
						{unput(*--yylastch);break;}
					*lsp++ = yystate = yyt->advance+yysvec;
					goto contin;
					}
				yyt = yyr + YYU(yymatch[yych]);
# ifdef LEXDEBUG
				if(debug){
					fprintf(yyout,"try fall back character ");
					allprint(YYU(yymatch[yych]));
					putchar('\n');
					}
# endif
				if(yyt <= yytop && yyt->verify+yysvec == yystate){
					if(yyt->advance+yysvec == YYLERR)	/* error transition */
						{unput(*--yylastch);break;}
					*lsp++ = yystate = yyt->advance+yysvec;
					goto contin;
					}
				}
			if ((yystate = yystate->yyother) && (yyt= yystate->yystoff) != yycrank){
# ifdef LEXDEBUG
				if(debug)fprintf(yyout,"fall back to state %d\n",yystate-yysvec-1);
# endif
				goto tryagain;
				}
# endif
			else
				{unput(*--yylastch);break;}
		contin:
# ifdef LEXDEBUG
			if(debug){
				fprintf(yyout,"state %d char ",yystate-yysvec-1);
				allprint(yych);
				putchar('\n');
				}
# endif
			;
			}
# ifdef LEXDEBUG
		if(debug){
			fprintf(yyout,"stopped at %d with ",*(lsp-1)-yysvec-1);
			allprint(yych);
			putchar('\n');
			}
# endif
		while (lsp-- > yylstate){
			*yylastch-- = 0;
			if (*lsp != 0 && (yyfnd= (*lsp)->yystops) && *yyfnd > 0){
				yyolsp = lsp;
				if(yyextra[*yyfnd]){		/* must backup */
					while(yyback((*lsp)->yystops,-*yyfnd) != 1 && lsp > yylstate){
						lsp--;
						unput(*yylastch--);
						}
					}
				yyprevious = YYU(*yylastch);
				yylsp = lsp;
				yyleng = yylastch-yytext+1;
				yytext[yyleng] = 0;
# ifdef LEXDEBUG
				if(debug){
					fprintf(yyout,"\nmatch ");
					sprint(yytext);
					fprintf(yyout," action %d\n",*yyfnd);
					}
# endif
				return(*yyfnd++);
				}
			unput(*yylastch);
			}
		if (yytext[0] == 0  /* && feof(yyin) */)
			{
			yysptr=yysbuf;
			return(0);
			}
		yyprevious = yytext[0] = input();
		if (yyprevious>0)
			output(yyprevious);
		yylastch=yytext;
# ifdef LEXDEBUG
		if(debug)putchar('\n');
# endif
		}
	}
yyback(p, m)
	int *p;
{
if (p==0) return(0);
while (*p)
	{
	if (*p++ == m)
		return(1);
	}
return(0);
}
	/* the following are only used in the lex library */
yyinput(){
	return(input());
	}
yyoutput(c)
  int c; {
	output(c);
	}
yyunput(c)
   int c; {
	unput(c);
	}
