#ident	"@(#)tables.c	25.1	12/2/91 Copyright (c) 1991 by Arix Corp."
/*
    1.1	89/06/08 00:39:17 root
	date and time created 89/06/08 00:39:17 by root

*/
/*MOT :tables.c	6.1		*/


/* This file contains the instruction timing tables for the M68020.
   The total number of clock cycles is outside the parentheses, the
   number of read, prefetch, and write cycles are given inside the
   parentheses as (r/p/w). They are included in the total clock cycle
   number.
*/


char* fetch_EA[] =	/* The fetch effective address table indicates the
			** number of clock periods needed for the processor
			** to calculate	and fetch the specified	effective
			** address. */
{
/* Dn			*/	"0(0/0/0)	0(0/0/0)	0(0/0/0)",
/* An			*/	"0(0/0/0)	0(0/0/0)	0(0/0/0)",
/* (An)			*/	"3(1/0/0)	4(1/0/0)	4(1/0/0)",
/* (An)+		*/	"4(1/0/0)	4(1/0/0)	4(1/0/0)",
/* -(An)		*/	"3(1/0/0)	5(1/0/0)	5(1/0/0)",
/* (16,An)		*/	"3(1/0/0)	5(1/0/0)	6(1/0/0)",
/* (xxx).W		*/	"3(1/0/0)	4(1/0/0)	6(1/0/0)",
/* (xxx).L		*/	"3(1/0/0)	4(1/0/0)	7(1/0/0)",
/* #<data>.B		*/	"0(0/0/0)	2(0/0/0)	3(0/1/0)",
/* #<data>.W		*/	"0(0/0/0)	2(0/0/0)	3(0/1/0)",
/* #<data>.L		*/	"0(0/0/0)	4(0/0/0)	5(0/1/0)",
/* (8,An,Xn)		*/	"4(1/0/0)	7(1/0/0)	8(1/1/0)",
/* (16,An,Xn)		*/	"4(1/0/0)	7(1/0/0)	9(1/1/0)",
/* (B)			*/	"4(1/0/0)	7(1/0/0)	9(1/1/0)",
/* (16,B)		*/	"6(1/0/0)	9(1/0/0)	12(1/1/0)",
/* (32,B)		*/	"10(1/0/0)	13(1/0/0)	16(1/2/0)",
/* ([B],I)		*/	"9(2/0/0)	12(2/0/0)	13(2/1/0)",
/* ([B],I,16)		*/	"11(2/0/0)	14(2/0/0)	16(2/1/0)",
/* ([B],I,32)		*/	"11(2/0/0)	14(2/0/0)	17(2/2/0)",
/* ([16,B],I)		*/	"11(2/0/0)	14(2/0/0)	16(2/1/0)",
/* ([16,B],I,16)	*/	"13(2/0/0)	16(2/0/0)	19(2/2/0)",
/* ([16,B],I,32)	*/	"13(2/0/0)	16(2/0/0)	20(2/2/0)",
/* ([32,B],I)		*/	"15(2/0/0)	18(2/0/0)	20(2/2/0)",
/* ([32,B],I,16)	*/	"17(2/0/0)	20(2/0/0)	22(2/2/0)",
/* ([32,B],I,32)	*/	"17(2/0/0)	20(2/0/0)	22(2/2/0)"
};



char* calculate_EA[] =	/* The calculate effective address table indicates the
			** number of clock periods needed for the processor
			** to calculate	the specified effective	address. */
{
/* Dn			*/	"0(0/0/0)	0(0/0/0)	0(0/0/0)",
/* An			*/	"0(0/0/0)	0(0/0/0)	0(0/0/0)",
/* (An)			*/	"2(0/0/0)	2(0/0/0)	2(0/0/0)",
/* (An)+		*/	"2(0/0/0)	2(0/0/0)	2(0/0/0)",
/* -(An)		*/	"2(0/0/0)	2(0/0/0)	2(0/0/0)",
/* (16,An)		*/	"2(0/0/0)	2(0/0/0)	3(0/1/0)",
/* (xxx).W		*/	"2(0/0/0)	2(0/0/0)	3(0/1/0)",
/* (xxx).L		*/	"1(0/0/0)	4(0/0/0)	5(0/1/0)",
/* #<data>.B		*/	"not specified",
/* #<data>.W		*/	"not specified",
/* #<data>.L		*/	"not specified",
/* (8,An,Xn)		*/	"1(0/0/0)	4(0/0/0)	5(0/1/0)",
/* (16,An,Xn)		*/	"3(0/0/0)	6(0/0/0)	7(0/1/0)",
/* (B)			*/	"3(0/0/0)	6(0/0/0)	7(0/1/0)",
/* (16,B)		*/	"5(0/0/0)	8(0/0/0)	10(0/1/0)",
/* (32,B)		*/	"9(0/0/0)	12(0/0/0)	15(0/2/0)",
/* ([B],I)		*/	"8(1/0/0)	11(1/0/0)	12(1/1/0)",
/* ([B],I,16)		*/	"10(1/0/0)	13(1/0/0)	15(1/1/0)",
/* ([B],I,32)		*/	"10(1/0/0)	13(1/0/0)	16(1/2/0)",
/* ([16,B],I)		*/	"10(1/0/0)	13(1/0/0)	15(1/1/0)",
/* ([16,B],I,16)	*/	"12(1/0/0)	15(1/0/0)	18(1/2/0)",
/* ([16,B],I,32)	*/	"12(1/0/0)	15(1/0/0)	19(1/2/0)",
/* ([32,B],I)		*/	"14(1/0/0)	17(1/0/0)	19(1/2/0)",
/* ([32,B],I,16)	*/	"16(1/0/0)	19(1/0/0)	21(1/2/0)",
/* ([32,B],I,32)	*/	"16(1/0/0)	19(1/0/0)	24(1/3/0)",
};



char* jump_EA[]	=  /* The jump effective address table indicates the
		   ** number of	clock periods needed for the processor
		   ** to calculate and jump to the specified effective
		   ** address. */
{
/* Dn			*/	"not specified",
/* An			*/	"not specified",
/* (An)			*/	"0(0/0/0)	2(0/0/0)	2(0/0/0)",
/* (An)+		*/	"not specified",
/* -(An)		*/	"not specified",
/* (16,An)		*/	"not specified",
/* (xxx).W		*/	"0(0/0/0)	2(0/0/0)	2(0/0/0)",
/* (xxx).L		*/	"0(0/0/0)	2(0/0/0)	2(0/0/0)",
/* #<data>.B		*/	"not specified",
/* #<data>.W		*/	"not specified",
/* #<data>.L		*/	"not specified",
/* (8,An,Xn)		*/	"3(0/0/0)	6(0/0/0)	6(0/0/0)",
/* (16,An,Xn)		*/	"3(0/0/0)	6(0/0/0)	6(0/0/0)",
/* (B)			*/	"3(0/0/0)	6(0/0/0)	6(0/0/0)",
/* (16,B)		*/	"5(0/0/0)	8(0/0/0)	8(0/1/0)",
/* (32,B)		*/	"9(0/0/0)	12(0/0/0)	12(0/1/0)",
/* ([B],I)		*/	"8(1/0/0)	11(1/0/0)	11(1/1/0)",
/* ([B],I,16)		*/	"10(1/0/0)	13(1/0/0)	14(1/1/0)",
/* ([B],I,32)		*/	"10(1/0/0)	13(1/0/0)	14(1/1/0)",
/* ([16,B],I)		*/	"10(1/0/0)	13(1/0/0)	14(1/1/0)",
/* ([16,B],I,16)	*/	"12(1/0/0)	15(1/0/0)	17(1/1/0)",
/* ([16,B],I,32)	*/	"12(1/0/0)	15(1/0/0)	17(1/1/0)",
/* ([32,B],I)		*/	"14(1/0/0)	17(1/0/0)	19(1/2/0)",
/* ([32,B],I,16)	*/	"16(1/0/0)	19(1/0/0)	21(1/2/0)",
/* ([32,B],I,32)	*/	"16(1/0/0)	19(1/0/0)	23(1/3/0)",
};



char* move[][] =   /* The MOVE instruction timing table	indicates the
		   ** number of	clock periods needed for the processor
		   ** to fetch,	calculate, and perform the MOVE	with the
		   ** the specified source and destination effective
		   ** addresses. */

{
/* move	Dn,EA */
{
/* Dn			*/	"0(0/0/0)	2(0/0/0)	3(0/1/0)",
/* An			*/	"0(0/0/0)	2(0/0/0)	3(0/1/0)",
/* (An)			*/	"3(0/0/1)	4(0/0/0)	5(0/1/0)",
/* (An)+		*/	"4(0/0/1)	4(0/0/1)	5(0/1/1)",
/* -(An)		*/	"3(0/0/1)	5(0/0/1)	6(0/1/1)",
/* (16,An)		*/	"3(0/0/1)	5(0/0/1)	7(0/1/1)",
/* (xxx).W		*/	"3(0/0/1)	4(0/0/1)	7(0/1/1)",
/* (xxx).L		*/	"5(0/0/1)	6(0/0/1)	9(0/2/1)",
/* #<data>.B		*/	"not specified",
/* #<data>.W		*/	"not specified",
/* #<data>.L		*/	"not specified",
/* (8,An,Xn)		*/	"4(0/0/1)	7(0/0/1)	9(0/1/1)",
/* (16,An,Xn)		*/	"6(0/0/1)	9(0/0/1)	12(0/1/1)",
/* (B)			*/	"5(0/0/1)	8(0/0/1)	10(0/1/1)",
/* (16,B)		*/	"7(0/0/1)	10(0/0/1)	14(0/2/1)",
/* (32,B)		*/	"11(0/0/1)	14(0/0/1)	19(0/2/1)",
/* ([B],I)		*/	"9(1/0/1)	12(1/0/1)	14(1/1/1)",
/* ([B],I,16)		*/	"11(1/0/1)	14(1/0/1)	17(1/2/1)",
/* ([B],I,32)		*/	"12(1/0/1)	15(1/0/1)	20(1/2/1)",
/* ([16,B],I)		*/	"11(1/0/1)	14(1/0/1)	17(1/2/1)",
/* ([16,B],I,16)	*/	"13(1/0/1)	16(1/0/1)	20(1/2/1)",
/* ([16,B],I,32)	*/	"14(1/0/1)	17(1/0/1)	23(1/3/1)",
/* ([32,B],I)		*/	"15(1/0/1)	18(1/0/1)	22(1/2/1)",
/* ([32,B],I,16)	*/	"17(1/0/1)	20(1/0/1)	25(1/3/1)",
/* ([32,B],I,32)	*/	"18(1/0/1)	21(1/0/1)	27(1/3/1)",
},
/* move	An,EA */
{
/* Dn			*/	"0(0/0/0)	2(0/0/0)	3(0/1/0)",
/* An			*/	"0(0/0/0)	2(0/0/0)	3(0/1/0)",
/* (An)			*/	"3(0/0/1)	4(0/0/0)	5(0/1/0)",
/* (An)+		*/	"4(0/0/1)	4(0/0/1)	5(0/1/1)",
/* -(An)		*/	"3(0/0/1)	5(0/0/1)	6(0/1/1)",
/* (16,An)		*/	"3(0/0/1)	5(0/0/1)	7(0/1/1)",
/* (xxx).W		*/	"3(0/0/1)	4(0/0/1)	7(0/1/1)",
/* (xxx).L		*/	"5(0/0/1)	6(0/0/1)	9(0/2/1)",
/* #<data>.B		*/	"not specified",
/* #<data>.W		*/	"not specified",
/* #<data>.L		*/	"not specified",
/* (8,An,Xn)		*/	"4(0/0/1)	7(0/0/1)	9(0/1/1)",
/* (16,An,Xn)		*/	"6(0/0/1)	9(0/0/1)	12(0/1/1)",
/* (B)			*/	"5(0/0/1)	8(0/0/1)	10(0/1/1)",
/* (16,B)		*/	"7(0/0/1)	10(0/0/1)	14(0/2/1)",
/* (32,B)		*/	"11(0/0/1)	14(0/0/1)	19(0/2/1)",
/* ([B],I)		*/	"9(1/0/1)	12(1/0/1)	14(1/1/1)",
/* ([B],I,16)		*/	"11(1/0/1)	14(1/0/1)	17(1/2/1)",
/* ([B],I,32)		*/	"12(1/0/1)	15(1/0/1)	20(1/2/1)",
/* ([16,B],I)		*/	"11(1/0/1)	14(1/0/1)	17(1/2/1)",
/* ([16,B],I,16)	*/	"13(1/0/1)	16(1/0/1)	20(1/2/1)",
/* ([16,B],I,32)	*/	"14(1/0/1)	17(1/0/1)	23(1/3/1)",
/* ([32,B],I)		*/	"15(1/0/1)	18(1/0/1)	22(1/2/1)",
/* ([32,B],I,16)	*/	"17(1/0/1)	20(1/0/1)	25(1/3/1)",
/* ([32,B],I,32)	*/	"18(1/0/1)	21(1/0/1)	27(1/3/1)",
},
/* move	(An),EA	*/
{
/* Dn			*/	"3(1/0/0)	6(1/0/0)	7(1/1/0)",
/* An			*/	"3(1/0/0)	6(1/0/0)	7(1/1/0)",
/* (An)			*/	"6(1/0/1)	7(1/0/1)	9(1/1/0)",
/* (An)+		*/	"6(1/0/1)	7(1/0/1)	9(1/1/1)",
/* -(An)		*/	"6(1/0/1)	7(1/0/1)	9(1/1/1)",
/* (16,An)		*/	"6(1/0/1)	7(1/0/1)	11(1/1/1)",
/* (xxx).W		*/	"6(1/0/1)	7(1/0/1)	11(1/1/1)",
/* (xxx).L		*/	"8(1/0/1)	9(1/0/1)	13(1/2/1)",
/* #<data>.B		*/	"not specified",
/* #<data>.W		*/	"not specified",
/* #<data>.L		*/	"not specified",
/* (8,An,Xn)		*/	"8(1/0/1)	9(1/0/1)	11(1/1/1)",
/* (16,An,Xn)		*/	"10(1/0/1)	11(1/0/1)	14(1/2/1)",
/* (B)			*/	"9(1/0/1)	10(1/0/1)	12(1/1/1)",
/* (16,B)		*/	"11(1/0/1)	12(1/0/1)	16(1/2/1)",
/* (32,B)		*/	"15(1/0/1)	16(1/0/1)	21(1/2/1)",
/* ([B],I)		*/	"13(2/0/1)	14(2/0/1)	12(2/1/1)",
/* ([B],I,16)		*/	"15(2/0/1)	16(2/0/1)	19(2/2/1)",
/* ([B],I,32)		*/	"16(2/0/1)	17(2/0/1)	22(2/2/1)",
/* ([16,B],I)		*/	"15(2/0/1)	16(2/0/1)	19(2/2/1)",
/* ([16,B],I,16)	*/	"17(2/0/1)	18(2/0/1)	22(2/2/1)",
/* ([16,B],I,32)	*/	"18(2/0/1)	19(2/0/1)	25(2/3/1)",
/* ([32,B],I)		*/	"19(2/0/1)	20(2/0/1)	24(2/2/1)",
/* ([32,B],I,16)	*/	"21(2/0/1)	22(2/0/1)	27(2/3/1)",
/* ([32,B],I,32)	*/	"22(2/0/1)	23(2/0/1)	29(2/3/1)",
},
/* move	(An)+,EA */
{
/* Dn			*/	"4(1/0/0)	6(1/0/0)	7(1/1/0)",
/* An			*/	"4(1/0/0)	6(1/0/0)	7(1/1/0)",
/* (An)			*/	"7(1/0/1)	7(1/0/1)	9(1/1/0)",
/* (An)+		*/	"7(1/0/1)	7(1/0/1)	9(1/1/1)",
/* -(An)		*/	"7(1/0/1)	7(1/0/1)	9(1/1/1)",
/* (16,An)		*/	"7(1/0/1)	7(1/0/1)	11(1/1/1)",
/* (xxx).W		*/	"7(1/0/1)	7(1/0/1)	11(1/1/1)",
/* (xxx).L		*/	"9(1/0/1)	9(1/0/1)	13(1/2/1)",
/* #<data>.B		*/	"not specified",
/* #<data>.W		*/	"not specified",
/* #<data>.L		*/	"not specified",
/* (8,An,Xn)		*/	"9(1/0/1)	9(1/0/1)	11(1/1/1)",
/* (16,An,Xn)		*/	"11(1/0/1)	11(1/0/1)	14(1/2/1)",
/* (B)			*/	"10(1/0/1)	10(1/0/1)	12(1/1/1)",
/* (16,B)		*/	"12(1/0/1)	12(1/0/1)	16(1/2/1)",
/* (32,B)		*/	"16(1/0/1)	16(1/0/1)	21(1/2/1)",
/* ([B],I)		*/	"14(2/0/1)	14(2/0/1)	12(2/1/1)",
/* ([B],I,16)		*/	"16(2/0/1)	16(2/0/1)	19(2/2/1)",
/* ([B],I,32)		*/	"17(2/0/1)	17(2/0/1)	22(2/2/1)",
/* ([16,B],I)		*/	"16(2/0/1)	16(2/0/1)	19(2/2/1)",
/* ([16,B],I,16)	*/	"18(2/0/1)	18(2/0/1)	22(2/2/1)",
/* ([16,B],I,32)	*/	"19(2/0/1)	19(2/0/1)	25(2/3/1)",
/* ([32,B],I)		*/	"20(2/0/1)	20(2/0/1)	24(2/2/1)",
/* ([32,B],I,16)	*/	"22(2/0/1)	22(2/0/1)	27(2/3/1)",
/* ([32,B],I,32)	*/	"23(2/0/1)	23(2/0/1)	29(2/3/1)",
},
/* move	-(An),EA */
{
/* Dn			*/	"3(1/0/0)	7(1/0/0)	8(1/1/0)",
/* An			*/	"3(1/0/0)	7(1/0/0)	8(1/1/0)",
/* (An)			*/	"6(1/0/1)	8(1/0/1)	10(1/1/0)",
/* (An)+		*/	"6(1/0/1)	8(1/0/1)	10(1/1/1)",
/* -(An)		*/	"6(1/0/1)	8(1/0/1)	10(1/1/1)",
/* (16,An)		*/	"6(1/0/1)	8(1/0/1)	12(1/1/1)",
/* (xxx).W		*/	"6(1/0/1)	8(1/0/1)	12(1/1/1)",
/* (xxx).L		*/	"8(1/0/1)	10(1/0/1)	14(1/2/1)",
/* #<data>.B		*/	"not specified",
/* #<data>.W		*/	"not specified",
/* #<data>.L		*/	"not specified",
/* (8,An,Xn)		*/	"8(1/0/1)	10(1/0/1)	12(1/1/1)",
/* (16,An,Xn)		*/	"10(1/0/1)	12(1/0/1)	15(1/2/1)",
/* (B)			*/	"9(1/0/1)	11(1/0/1)	13(1/1/1)",
/* (16,B)		*/	"11(1/0/1)	13(1/0/1)	17(1/2/1)",
/* (32,B)		*/	"15(1/0/1)	17(1/0/1)	22(1/2/1)",
/* ([B],I)		*/	"13(2/0/1)	15(2/0/1)	13(2/1/1)",
/* ([B],I,16)		*/	"15(2/0/1)	17(2/0/1)	20(2/2/1)",
/* ([B],I,32)		*/	"16(2/0/1)	18(2/0/1)	23(2/2/1)",
/* ([16,B],I)		*/	"15(2/0/1)	17(2/0/1)	20(2/2/1)",
/* ([16,B],I,16)	*/	"17(2/0/1)	19(2/0/1)	23(2/2/1)",
/* ([16,B],I,32)	*/	"18(2/0/1)	20(2/0/1)	26(2/3/1)",
/* ([32,B],I)		*/	"19(2/0/1)	21(2/0/1)	25(2/2/1)",
/* ([32,B],I,16)	*/	"21(2/0/1)	23(2/0/1)	28(2/3/1)",
/* ([32,B],I,32)	*/	"22(2/0/1)	24(2/0/1)	30(2/3/1)",
},
/* move	(16,An),EA */
{
/* Dn			*/	"3(1/0/0)	7(1/0/0)	9(1/2/0)",
/* An			*/	"3(1/0/0)	7(1/0/0)	9(1/2/0)",
/* (An)			*/	"6(1/0/1)	8(1/0/1)	11(1/2/0)",
/* (An)+		*/	"6(1/0/1)	8(1/0/1)	11(1/2/1)",
/* -(An)		*/	"6(1/0/1)	8(1/0/1)	11(1/2/1)",
/* (16,An)		*/	"6(1/0/1)	8(1/0/1)	13(1/2/1)",
/* (xxx).W		*/	"6(1/0/1)	8(1/0/1)	13(1/2/1)",
/* (xxx).L		*/	"8(1/0/1)	10(1/0/1)	15(1/3/1)",
/* #<data>.B		*/	"not specified",
/* #<data>.W		*/	"not specified",
/* #<data>.L		*/	"not specified",
/* (8,An,Xn)		*/	"8(1/0/1)	10(1/0/1)	13(1/2/1)",
/* (16,An,Xn)		*/	"10(1/0/1)	12(1/0/1)	16(2/3/1)",
/* (B)			*/	"9(1/0/1)	11(1/0/1)	14(1/2/1)",
/* (16,B)		*/	"11(1/0/1)	13(1/0/1)	18(1/3/1)",
/* (32,B)		*/	"15(1/0/1)	17(1/0/1)	23(1/3/1)",
/* ([B],I)		*/	"13(2/0/1)	15(2/0/1)	14(2/2/1)",
/* ([B],I,16)		*/	"15(2/0/1)	17(2/0/1)	21(2/3/1)",
/* ([B],I,32)		*/	"16(2/0/1)	18(2/0/1)	24(2/3/1)",
/* ([16,B],I)		*/	"15(2/0/1)	17(2/0/1)	21(2/3/1)",
/* ([16,B],I,16)	*/	"17(2/0/1)	19(2/0/1)	24(2/3/1)",
/* ([16,B],I,32)	*/	"18(2/0/1)	20(2/0/1)	27(2/4/1)",
/* ([32,B],I)		*/	"19(2/0/1)	21(2/0/1)	26(2/3/1)",
/* ([32,B],I,16)	*/	"21(2/0/1)	23(2/0/1)	29(2/4/1)",
/* ([32,B],I,32)	*/	"22(2/0/1)	24(2/0/1)	31(2/4/1)",
},
/* move	(xxx).W,EA */
{
/* Dn			*/	"3(1/0/0)	6(1/0/0)	8(1/2/0)",
/* An			*/	"3(1/0/0)	6(1/0/0)	8(1/2/0)",
/* (An)			*/	"6(1/0/1)	7(1/0/1)	10(1/2/0)",
/* (An)+		*/	"6(1/0/1)	7(1/0/1)	10(1/2/1)",
/* -(An)		*/	"6(1/0/1)	7(1/0/1)	10(1/2/1)",
/* (16,An)		*/	"6(1/0/1)	7(1/0/1)	12(1/2/1)",
/* (xxx).W		*/	"6(1/0/1)	7(1/0/1)	12(1/2/1)",
/* (xxx).L		*/	"8(1/0/1)	9(1/0/1)	14(1/2/1)",
/* #<data>.B		*/	"not specified",
/* #<data>.W		*/	"not specified",
/* #<data>.L		*/	"not specified",
/* (8,An,Xn)		*/	"8(1/0/1)	9(1/0/1)	12(1/2/1)",
/* (16,An,Xn)		*/	"10(1/0/1)	11(1/0/1)	15(1/3/1)",
/* (B)			*/	"9(1/0/1)	10(1/0/1)	13(1/2/1)",
/* (16,B)		*/	"11(1/0/1)	12(1/0/1)	17(1/3/1)",
/* (32,B)		*/	"15(1/0/1)	16(1/0/1)	22(1/3/1)",
/* ([B],I)		*/	"13(2/0/1)	14(2/0/1)	13(2/2/1)",
/* ([B],I,16)		*/	"15(2/0/1)	16(2/0/1)	20(2/3/1)",
/* ([B],I,32)		*/	"16(2/0/1)	17(2/0/1)	23(2/3/1)",
/* ([16,B],I)		*/	"15(2/0/1)	16(2/0/1)	20(2/3/1)",
/* ([16,B],I,16)	*/	"17(2/0/1)	18(2/0/1)	23(2/3/1)",
/* ([16,B],I,32)	*/	"18(2/0/1)	19(2/0/1)	26(2/4/1)",
/* ([32,B],I)		*/	"19(2/0/1)	20(2/0/1)	25(2/3/1)",
/* ([32,B],I,16)	*/	"21(2/0/1)	22(2/0/1)	28(2/4/1)",
/* ([32,B],I,32)	*/	"22(2/0/1)	23(2/0/1)	30(2/4/1)",
},
/* move	(xxx).L,EA */
{
/* Dn			*/	"3(1/0/0)	6(1/0/0)	10(1/2/0)",
/* An			*/	"3(1/0/0)	6(1/0/0)	10(1/2/0)",
/* (An)			*/	"6(1/0/1)	7(1/0/1)	12(1/2/0)",
/* (An)+		*/	"6(1/0/1)	7(1/0/1)	12(1/2/1)",
/* -(An)		*/	"6(1/0/1)	7(1/0/1)	12(1/2/1)",
/* (16,An)		*/	"6(1/0/1)	7(1/0/1)	14(1/2/1)",
/* (xxx).W		*/	"6(1/0/1)	7(1/0/1)	14(1/2/1)",
/* (xxx).L		*/	"8(1/0/1)	9(1/0/1)	16(1/2/1)",
/* #<data>.B		*/	"not specified",
/* #<data>.W		*/	"not specified",
/* #<data>.L		*/	"not specified",
/* (8,An,Xn)		*/	"8(1/0/1)	9(1/0/1)	14(1/2/1)",
/* (16,An,Xn)		*/	"10(1/0/1)	11(1/0/1)	17(1/3/1)",
/* (B)			*/	"9(1/0/1)	10(1/0/1)	15(1/2/1)",
/* (16,B)		*/	"11(1/0/1)	12(1/0/1)	19(1/3/1)",
/* (32,B)		*/	"15(1/0/1)	16(1/0/1)	24(1/3/1)",
/* ([B],I)		*/	"13(2/0/1)	14(2/0/1)	15(2/2/1)",
/* ([B],I,16)		*/	"15(2/0/1)	16(2/0/1)	22(2/3/1)",
/* ([B],I,32)		*/	"16(2/0/1)	17(2/0/1)	25(2/3/1)",
/* ([16,B],I)		*/	"15(2/0/1)	16(2/0/1)	22(2/3/1)",
/* ([16,B],I,16)	*/	"17(2/0/1)	18(2/0/1)	25(2/3/1)",
/* ([16,B],I,32)	*/	"18(2/0/1)	19(2/0/1)	28(2/4/1)",
/* ([32,B],I)		*/	"19(2/0/1)	20(2/0/1)	27(2/3/1)",
/* ([32,B],I,16)	*/	"21(2/0/1)	22(2/0/1)	30(2/4/1)",
/* ([32,B],I,32)	*/	"22(2/0/1)	23(2/0/1)	32(2/4/1)",
},
/* move	#<data>.B,EA */
{
/* Dn			*/	"0(0/0/0)	4(0/0/0)	3(0/1/0)",
/* An			*/	"0(0/0/0)	4(0/0/0)	3(0/1/0)",
/* (An)			*/	"3(0/0/1)	6(0/0/0)	5(0/1/0)",
/* (An)+		*/	"4(0/0/1)	6(0/0/1)	5(0/1/1)",
/* -(An)		*/	"3(0/0/1)	7(0/0/1)	6(0/1/1)",
/* (16,An)		*/	"3(0/0/1)	7(0/0/1)	7(0/1/1)",
/* (xxx).W		*/	"3(0/0/1)	6(0/0/1)	7(0/1/1)",
/* (xxx).L		*/	"5(0/0/1)	8(0/0/1)	9(0/2/1)",
/* #<data>.B		*/	"not specified",
/* #<data>.W		*/	"not specified",
/* #<data>.L		*/	"not specified",
/* (8,An,Xn)		*/	"4(0/0/1)	7(0/0/1)	9(0/1/1)",
/* (16,An,Xn)		*/	"6(0/0/1)	9(0/0/1)	12(0/1/1)",
/* (B)			*/	"5(0/0/1)	8(0/0/1)	10(0/1/1)",
/* (16,B)		*/	"7(0/0/1)	10(0/0/1)	14(0/2/1)",
/* (32,B)		*/	"11(0/0/1)	14(0/0/1)	19(0/2/1)",
/* ([B],I)		*/	"9(1/0/1)	12(1/0/1)	14(1/1/1)",
/* ([B],I,16)		*/	"11(1/0/1)	14(1/0/1)	17(1/2/1)",
/* ([B],I,32)		*/	"12(1/0/1)	15(1/0/1)	20(1/2/1)",
/* ([16,B],I)		*/	"11(1/0/1)	14(1/0/1)	17(1/2/1)",
/* ([16,B],I,16)	*/	"13(1/0/1)	16(1/0/1)	20(1/2/1)",
/* ([16,B],I,32)	*/	"14(1/0/1)	17(1/0/1)	23(1/3/1)",
/* ([32,B],I)		*/	"15(1/0/1)	18(1/0/1)	22(1/2/1)",
/* ([32,B],I,16)	*/	"17(1/0/1)	20(1/0/1)	25(1/3/1)",
/* ([32,B],I,32)	*/	"18(1/0/1)	21(1/0/1)	27(1/3/1)",
},
/* move	#<data>.W,EA */
{
/* Dn			*/	"0(0/0/0)	4(0/0/0)	3(0/1/0)",
/* An			*/	"0(0/0/0)	4(0/0/0)	3(0/1/0)",
/* (An)			*/	"3(0/0/1)	6(0/0/0)	5(0/1/0)",
/* (An)+		*/	"4(0/0/1)	6(0/0/1)	5(0/1/1)",
/* -(An)		*/	"3(0/0/1)	7(0/0/1)	6(0/1/1)",
/* (16,An)		*/	"3(0/0/1)	7(0/0/1)	7(0/1/1)",
/* (xxx).W		*/	"3(0/0/1)	6(0/0/1)	7(0/1/1)",
/* (xxx).L		*/	"5(0/0/1)	8(0/0/1)	9(0/2/1)",
/* #<data>.B		*/	"not specified",
/* #<data>.W		*/	"not specified",
/* #<data>.L		*/	"not specified",
/* (8,An,Xn)		*/	"4(0/0/1)	7(0/0/1)	9(0/1/1)",
/* (16,An,Xn)		*/	"6(0/0/1)	9(0/0/1)	12(0/1/1)",
/* (B)			*/	"5(0/0/1)	8(0/0/1)	10(0/1/1)",
/* (16,B)		*/	"7(0/0/1)	10(0/0/1)	14(0/2/1)",
/* (32,B)		*/	"11(0/0/1)	14(0/0/1)	19(0/2/1)",
/* ([B],I)		*/	"9(1/0/1)	12(1/0/1)	14(1/1/1)",
/* ([B],I,16)		*/	"11(1/0/1)	14(1/0/1)	17(1/2/1)",
/* ([B],I,32)		*/	"12(1/0/1)	15(1/0/1)	20(1/2/1)",
/* ([16,B],I)		*/	"11(1/0/1)	14(1/0/1)	17(1/2/1)",
/* ([16,B],I,16)	*/	"13(1/0/1)	16(1/0/1)	20(1/2/1)",
/* ([16,B],I,32)	*/	"14(1/0/1)	17(1/0/1)	23(1/3/1)",
/* ([32,B],I)		*/	"15(1/0/1)	18(1/0/1)	22(1/2/1)",
/* ([32,B],I,16)	*/	"17(1/0/1)	20(1/0/1)	25(1/3/1)",
/* ([32,B],I,32)	*/	"18(1/0/1)	21(1/0/1)	27(1/3/1)",
},
/* move	#<data>.L,EA */
{
/* Dn			*/	"0(0/0/0)	6(0/0/0)	5(0/1/0)",
/* An			*/	"0(0/0/0)	6(0/0/0)	5(0/1/0)",
/* (An)			*/	"3(0/0/1)	8(0/0/0)	7(0/1/0)",
/* (An)+		*/	"4(0/0/1)	8(0/0/1)	7(0/1/1)",
/* -(An)		*/	"3(0/0/1)	9(0/0/1)	8(0/1/1)",
/* (16,An)		*/	"3(0/0/1)	9(0/0/1)	9(0/1/1)",
/* (xxx).W		*/	"3(0/0/1)	8(0/0/1)	9(0/1/1)",
/* (xxx).L		*/	"5(0/0/1)	10(0/0/1)	11(0/2/1)",
/* #<data>.B		*/	"not specified",
/* #<data>.W		*/	"not specified",
/* #<data>.L		*/	"not specified",
/* (8,An,Xn)		*/	"4(0/0/1)	9(0/0/1)	11(0/1/1)",
/* (16,An,Xn)		*/	"6(0/0/1)	11(0/0/1)	14(0/1/1)",
/* (B)			*/	"5(0/0/1)	10(0/0/1)	12(0/1/1)",
/* (16,B)		*/	"7(0/0/1)	12(0/0/1)	16(0/2/1)",
/* (32,B)		*/	"11(0/0/1)	16(0/0/1)	21(0/2/1)",
/* ([B],I)		*/	"9(1/0/1)	14(1/0/1)	16(1/1/1)",
/* ([B],I,16)		*/	"11(1/0/1)	16(1/0/1)	19(1/2/1)",
/* ([B],I,32)		*/	"12(1/0/1)	17(1/0/1)	22(1/2/1)",
/* ([16,B],I)		*/	"11(1/0/1)	16(1/0/1)	19(1/2/1)",
/* ([16,B],I,16)	*/	"13(1/0/1)	18(1/0/1)	22(1/2/1)",
/* ([16,B],I,32)	*/	"14(1/0/1)	19(1/0/1)	25(1/3/1)",
/* ([32,B],I)		*/	"15(1/0/1)	20(1/0/1)	24(1/2/1)",
/* ([32,B],I,16)	*/	"17(1/0/1)	22(1/0/1)	27(1/3/1)",
/* ([32,B],I,32)	*/	"18(1/0/1)	23(1/0/1)	29(1/3/1)",
},
/* move	(d8,An,Xn),EA */
{
/* Dn			*/	"4(1/0/0)	9(1/0/0)	11(1/2/0)",
/* An			*/	"4(1/0/0)	9(1/0/0)	11(1/2/0)",
/* (An)			*/	"7(1/0/1)	10(1/0/1)	13(1/2/0)",
/* (An)+		*/	"7(1/0/1)	10(1/0/1)	13(1/2/1)",
/* -(An)		*/	"7(1/0/1)	10(1/0/1)	13(1/2/1)",
/* (16,An)		*/	"7(1/0/1)	10(1/0/1)	15(1/2/1)",
/* (xxx).W		*/	"7(1/0/1)	10(1/0/1)	15(1/2/1)",
/* (xxx).L		*/	"9(1/0/1)	12(1/0/1)	17(1/3/1)",
/* #<data>.B		*/	"not specified",
/* #<data>.W		*/	"not specified",
/* #<data>.L		*/	"not specified",
/* (8,An,Xn)		*/	"9(1/0/1)	12(1/0/1)	15(1/2/1)",
/* (16,An,Xn)		*/	"10(1/0/1)	14(1/0/1)	18(1/3/1)",
/* (B)			*/	"10(1/0/1)	13(1/0/1)	16(1/2/1)",
/* (16,B)		*/	"12(1/0/1)	15(1/0/1)	20(1/3/1)",
/* (32,B)		*/	"16(1/0/1)	19(1/0/1)	25(1/3/1)",
/* ([B],I)		*/	"14(2/0/1)	17(2/0/1)	16(2/2/1)",
/* ([B],I,16)		*/	"16(2/0/1)	19(2/0/1)	23(2/3/1)",
/* ([B],I,32)		*/	"17(2/0/1)	20(2/0/1)	26(2/3/1)",
/* ([16,B],I)		*/	"16(2/0/1)	19(2/0/1)	23(2/3/1)",
/* ([16,B],I,16)	*/	"18(2/0/1)	21(2/0/1)	26(2/3/1)",
/* ([16,B],I,32)	*/	"19(2/0/1)	22(2/0/1)	29(2/4/1)",
/* ([32,B],I)		*/	"20(2/0/1)	23(2/0/1)	30(2/3/1)",
/* ([32,B],I,16)	*/	"22(2/0/1)	25(2/0/1)	31(2/4/1)",
/* ([32,B],I,32)	*/	"23(2/0/1)	26(2/0/1)	33(2/4/1)",
},
/* move	(d16,An,Xn),EA */
{
/* Dn			*/	"4(1/0/0)	9(1/0/0)	12(1/2/0)",
/* An			*/	"4(1/0/0)	9(1/0/0)	12(1/2/0)",
/* (An)			*/	"7(1/0/1)	10(1/0/1)	14(1/2/0)",
/* (An)+		*/	"7(1/0/1)	10(1/0/1)	14(1/2/1)",
/* -(An)		*/	"7(1/0/1)	10(1/0/1)	14(1/2/1)",
/* (16,An)		*/	"7(1/0/1)	10(1/0/1)	16(1/2/1)",
/* (xxx).W		*/	"7(1/0/1)	10(1/0/1)	16(1/2/1)",
/* (xxx).L		*/	"9(1/0/1)	12(1/0/1)	18(1/3/1)",
/* #<data>.B		*/	"not specified",
/* #<data>.W		*/	"not specified",
/* #<data>.L		*/	"not specified",
/* (8,An,Xn)		*/	"9(1/0/1)	12(1/0/1)	16(1/2/1)",
/* (16,An,Xn)		*/	"10(1/0/1)	14(1/0/1)	19(1/3/1)",
/* (B)			*/	"10(1/0/1)	13(1/0/1)	17(1/2/1)",
/* (16,B)		*/	"12(1/0/1)	15(1/0/1)	21(1/3/1)",
/* (32,B)		*/	"16(1/0/1)	19(1/0/1)	26(1/3/1)",
/* ([B],I)		*/	"14(2/0/1)	17(2/0/1)	17(2/2/1)",
/* ([B],I,16)		*/	"16(2/0/1)	19(2/0/1)	24(2/3/1)",
/* ([B],I,32)		*/	"17(2/0/1)	20(2/0/1)	27(2/3/1)",
/* ([16,B],I)		*/	"16(2/0/1)	19(2/0/1)	24(2/3/1)",
/* ([16,B],I,16)	*/	"18(2/0/1)	21(2/0/1)	27(2/3/1)",
/* ([16,B],I,32)	*/	"19(2/0/1)	22(2/0/1)	30(2/4/1)",
/* ([32,B],I)		*/	"20(2/0/1)	23(2/0/1)	31(2/3/1)",
/* ([32,B],I,16)	*/	"22(2/0/1)	25(2/0/1)	32(2/4/1)",
/* ([32,B],I,32)	*/	"23(2/0/1)	26(2/0/1)	34(2/4/1)",
},
/* move	(B),EA */
{
/* Dn			*/	"4(1/0/0)	9(1/0/0)	12(1/2/0)",
/* An			*/	"4(1/0/0)	9(1/0/0)	12(1/2/0)",
/* (An)			*/	"7(1/0/1)	10(1/0/1)	14(1/2/0)",
/* (An)+		*/	"7(1/0/1)	10(1/0/1)	14(1/2/1)",
/* -(An)		*/	"7(1/0/1)	10(1/0/1)	14(1/2/1)",
/* (16,An)		*/	"7(1/0/1)	10(1/0/1)	16(1/2/1)",
/* (xxx).W		*/	"7(1/0/1)	10(1/0/1)	16(1/2/1)",
/* (xxx).L		*/	"9(1/0/1)	12(1/0/1)	18(1/3/1)",
/* #<data>.B		*/	"not specified",
/* #<data>.W		*/	"not specified",
/* #<data>.L		*/	"not specified",
/* (8,An,Xn)		*/	"9(1/0/1)	12(1/0/1)	16(1/2/1)",
/* (16,An,Xn)		*/	"10(1/0/1)	14(1/0/1)	19(1/3/1)",
/* (B)			*/	"10(1/0/1)	13(1/0/1)	17(1/2/1)",
/* (16,B)		*/	"12(1/0/1)	15(1/0/1)	21(1/3/1)",
/* (32,B)		*/	"16(1/0/1)	19(1/0/1)	26(1/3/1)",
/* ([B],I)		*/	"14(2/0/1)	17(2/0/1)	17(2/2/1)",
/* ([B],I,16)		*/	"16(2/0/1)	19(2/0/1)	24(2/3/1)",
/* ([B],I,32)		*/	"17(2/0/1)	20(2/0/1)	27(2/3/1)",
/* ([16,B],I)		*/	"16(2/0/1)	19(2/0/1)	24(2/3/1)",
/* ([16,B],I,16)	*/	"18(2/0/1)	21(2/0/1)	27(2/3/1)",
/* ([16,B],I,32)	*/	"19(2/0/1)	22(2/0/1)	30(2/4/1)",
/* ([32,B],I)		*/	"20(2/0/1)	23(2/0/1)	31(2/3/1)",
/* ([32,B],I,16)	*/	"22(2/0/1)	25(2/0/1)	32(2/4/1)",
/* ([32,B],I,32)	*/	"23(2/0/1)	26(2/0/1)	34(2/4/1)",
},
/* move	(d16,B),EA */
{
/* Dn			*/	"6(1/0/0)	11(1/0/0)	15(1/2/0)",
/* An			*/	"6(1/0/0)	11(1/0/0)	15(1/2/0)",
/* (An)			*/	"9(1/0/1)	12(1/0/1)	15(1/2/0)",
/* (An)+		*/	"9(1/0/1)	12(1/0/1)	15(1/2/1)",
/* -(An)		*/	"9(1/0/1)	12(1/0/1)	15(1/2/1)",
/* (16,An)		*/	"9(1/0/1)	12(1/0/1)	19(1/2/1)",
/* (xxx).W		*/	"9(1/0/1)	12(1/0/1)	19(1/2/1)",
/* (xxx).L		*/	"11(1/0/1)	14(1/0/1)	21(1/3/1)",
/* #<data>.B		*/	"not specified",
/* #<data>.W		*/	"not specified",
/* #<data>.L		*/	"not specified",
/* (8,An,Xn)		*/	"11(1/0/1)	14(1/0/1)	19(1/2/1)",
/* (16,An,Xn)		*/	"12(1/0/1)	16(1/0/1)	22(1/3/1)",
/* (B)			*/	"12(1/0/1)	15(1/0/1)	20(1/2/1)",
/* (16,B)		*/	"14(1/0/1)	17(1/0/1)	24(1/3/1)",
/* (32,B)		*/	"18(1/0/1)	21(1/0/1)	29(1/3/1)",
/* ([B],I)		*/	"16(2/0/1)	19(2/0/1)	20(2/2/1)",
/* ([B],I,16)		*/	"18(2/0/1)	21(2/0/1)	27(2/3/1)",
/* ([B],I,32)		*/	"19(2/0/1)	22(2/0/1)	30(2/3/1)",
/* ([16,B],I)		*/	"18(2/0/1)	21(2/0/1)	27(2/3/1)",
/* ([16,B],I,16)	*/	"20(2/0/1)	23(2/0/1)	30(2/3/1)",
/* ([16,B],I,32)	*/	"21(2/0/1)	24(2/0/1)	33(2/4/1)",
/* ([32,B],I)		*/	"22(2/0/1)	25(2/0/1)	34(2/3/1)",
/* ([32,B],I,16)	*/	"24(2/0/1)	27(2/0/1)	35(2/4/1)",
/* ([32,B],I,32)	*/	"25(2/0/1)	28(2/0/1)	37(2/4/1)",
},
/* move	(d32,B),EA */
{
/* Dn			*/	"10(1/0/0)	15(1/0/0)	19(1/3/0)",
/* An			*/	"10(1/0/0)	15(1/0/0)	19(1/3/0)",
/* (An)			*/	"10(1/0/1)	16(1/0/1)	21(1/3/0)",
/* (An)+		*/	"13(1/0/1)	16(1/0/1)	21(1/3/1)",
/* -(An)		*/	"13(1/0/1)	16(1/0/1)	21(1/3/1)",
/* (16,An)		*/	"13(1/0/1)	16(1/0/1)	23(1/3/1)",
/* (xxx).W		*/	"13(1/0/1)	16(1/0/1)	23(1/3/1)",
/* (xxx).L		*/	"15(1/0/1)	18(1/0/1)	25(1/4/1)",
/* #<data>.B		*/	"not specified",
/* #<data>.W		*/	"not specified",
/* #<data>.L		*/	"not specified",
/* (8,An,Xn)		*/	"15(1/0/1)	18(1/0/1)	23(1/3/1)",
/* (16,An,Xn)		*/	"15(1/0/1)	20(1/0/1)	26(1/4/1)",
/* (B)			*/	"15(1/0/1)	19(1/0/1)	24(1/3/1)",
/* (16,B)		*/	"17(1/0/1)	21(1/0/1)	28(1/4/1)",
/* (32,B)		*/	"21(1/0/1)	25(1/0/1)	33(1/4/1)",
/* ([B],I)		*/	"20(2/0/1)	23(2/0/1)	24(2/3/1)",
/* ([B],I,16)		*/	"22(2/0/1)	25(2/0/1)	31(2/4/1)",
/* ([B],I,32)		*/	"23(2/0/1)	26(2/0/1)	34(2/4/1)",
/* ([16,B],I)		*/	"22(2/0/1)	25(2/0/1)	31(2/4/1)",
/* ([16,B],I,16)	*/	"24(2/0/1)	27(2/0/1)	34(2/4/1)",
/* ([16,B],I,32)	*/	"25(2/0/1)	28(2/0/1)	37(2/5/1)",
/* ([32,B],I)		*/	"26(2/0/1)	29(2/0/1)	38(2/4/1)",
/* ([32,B],I,16)	*/	"28(2/0/1)	31(2/0/1)	39(2/5/1)",
/* ([32,B],I,32)	*/	"29(2/0/1)	32(2/0/1)	41(2/5/1)",
},
/* move	([B],I),EA */
{
/* Dn			*/	"9(2/0/0)	14(2/0/0)	16(2/2/0)",
/* An			*/	"9(2/0/0)	14(2/0/0)	16(2/2/0)",
/* (An)			*/	"9(2/0/1)	15(2/0/1)	18(2/2/0)",
/* (An)+		*/	"12(2/0/1)	15(2/0/1)	18(2/2/1)",
/* -(An)		*/	"12(2/0/1)	15(2/0/1)	18(2/2/1)",
/* (26,An)		*/	"12(2/0/1)	15(2/0/1)	20(2/2/1)",
/* (xxx).W		*/	"12(2/0/1)	15(2/0/1)	20(2/2/1)",
/* (xxx).L		*/	"14(2/0/1)	17(2/0/1)	22(2/3/1)",
/* #<data>.B		*/	"not specified",
/* #<data>.W		*/	"not specified",
/* #<data>.L		*/	"not specified",
/* (8,An,Xn)		*/	"14(2/0/1)	17(2/0/1)	20(2/2/1)",
/* (26,An,Xn)		*/	"16(2/0/1)	19(2/0/1)	23(2/3/1)",
/* (B)			*/	"17(2/0/1)	18(2/0/1)	21(2/2/1)",
/* (26,B)		*/	"17(2/0/1)	20(2/0/1)	25(2/3/1)",
/* (32,B)		*/	"21(2/0/1)	24(2/0/1)	30(2/3/1)",
/* ([B],I)		*/	"19(3/0/1)	22(3/0/1)	21(3/2/1)",
/* ([B],I,16)		*/	"21(3/0/1)	24(3/0/1)	30(3/3/1)",
/* ([B],I,32)		*/	"22(3/0/1)	25(3/0/1)	31(3/3/1)",
/* ([16,B],I)		*/	"21(3/0/1)	24(3/0/1)	28(3/3/1)",
/* ([16,B],I,16)	*/	"23(3/0/1)	26(3/0/1)	31(3/3/1)",
/* ([16,B],I,32)	*/	"24(3/0/1)	27(3/0/1)	34(3/4/1)",
/* ([32,B],I)		*/	"25(3/0/1)	28(3/0/1)	35(3/3/1)",
/* ([32,B],I,16)	*/	"27(3/0/1)	30(3/0/1)	36(3/4/1)",
/* ([32,B],I,32)	*/	"28(3/0/1)	31(3/0/1)	38(3/4/1)",
},
/* move	([B],I,16),EA */
{
/* Dn			*/	"11(2/0/0)	16(2/0/0)	19(2/2/0)",
/* An			*/	"11(2/0/0)	16(2/0/0)	19(2/2/0)",
/* (An)			*/	"11(2/0/1)	17(2/0/1)	21(2/2/0)",
/* (An)+		*/	"14(2/0/1)	17(2/0/1)	21(2/2/1)",
/* -(An)		*/	"14(2/0/1)	17(2/0/1)	21(2/2/1)",
/* (26,An)		*/	"14(2/0/1)	17(2/0/1)	23(2/2/1)",
/* (xxx).W		*/	"14(2/0/1)	17(2/0/1)	23(2/2/1)",
/* (xxx).L		*/	"16(2/0/1)	19(2/0/1)	25(2/3/1)",
/* #<data>.B		*/	"not specified",
/* #<data>.W		*/	"not specified",
/* #<data>.L		*/	"not specified",
/* (8,An,Xn)		*/	"16(2/0/1)	19(2/0/1)	23(2/2/1)",
/* (26,An,Xn)		*/	"18(2/0/1)	21(2/0/1)	26(2/3/1)",
/* (B)			*/	"19(2/0/1)	20(2/0/1)	24(2/2/1)",
/* (26,B)		*/	"19(2/0/1)	22(2/0/1)	28(2/3/1)",
/* (32,B)		*/	"23(2/0/1)	26(2/0/1)	33(2/3/1)",
/* ([B],I)		*/	"21(3/0/1)	24(3/0/1)	24(3/2/1)",
/* ([B],I,16)		*/	"23(3/0/1)	26(3/0/1)	33(3/3/1)",
/* ([B],I,32)		*/	"24(3/0/1)	27(3/0/1)	34(3/3/1)",
/* ([16,B],I)		*/	"23(3/0/1)	26(3/0/1)	31(3/3/1)",
/* ([16,B],I,16)	*/	"25(3/0/1)	28(3/0/1)	34(3/3/1)",
/* ([16,B],I,32)	*/	"26(3/0/1)	29(3/0/1)	37(3/4/1)",
/* ([32,B],I)		*/	"27(3/0/1)	30(3/0/1)	38(3/3/1)",
/* ([32,B],I,16)	*/	"29(3/0/1)	32(3/0/1)	39(3/4/1)",
/* ([32,B],I,32)	*/	"30(3/0/1)	33(3/0/1)	41(3/4/1)",
},
/* move	([B],I,32),EA */
{
/* Dn			*/	"11(2/0/0)	16(2/0/0)	20(2/3/0)",
/* An			*/	"11(2/0/0)	16(2/0/0)	20(2/3/0)",
/* (An)			*/	"11(2/0/1)	17(2/0/1)	22(2/3/0)",
/* (An)+		*/	"14(2/0/1)	17(2/0/1)	22(2/3/1)",
/* -(An)		*/	"14(2/0/1)	17(2/0/1)	22(2/3/1)",
/* (26,An)		*/	"14(2/0/1)	17(2/0/1)	24(2/3/1)",
/* (xxx).W		*/	"14(2/0/1)	17(2/0/1)	24(2/3/1)",
/* (xxx).L		*/	"16(2/0/1)	19(2/0/1)	26(2/4/1)",
/* #<data>.B		*/	"not specified",
/* #<data>.W		*/	"not specified",
/* #<data>.L		*/	"not specified",
/* (8,An,Xn)		*/	"16(2/0/1)	19(2/0/1)	24(2/3/1)",
/* (26,An,Xn)		*/	"18(2/0/1)	21(2/0/1)	27(2/4/1)",
/* (B)			*/	"19(2/0/1)	20(2/0/1)	25(2/3/1)",
/* (26,B)		*/	"19(2/0/1)	22(2/0/1)	29(2/4/1)",
/* (32,B)		*/	"23(2/0/1)	26(2/0/1)	34(2/4/1)",
/* ([B],I)		*/	"21(3/0/1)	24(3/0/1)	25(3/3/1)",
/* ([B],I,16)		*/	"23(3/0/1)	26(3/0/1)	34(3/4/1)",
/* ([B],I,32)		*/	"24(3/0/1)	27(3/0/1)	35(3/4/1)",
/* ([16,B],I)		*/	"23(3/0/1)	26(3/0/1)	32(3/4/1)",
/* ([16,B],I,16)	*/	"25(3/0/1)	28(3/0/1)	35(3/4/1)",
/* ([16,B],I,32)	*/	"26(3/0/1)	29(3/0/1)	38(3/5/1)",
/* ([32,B],I)		*/	"27(3/0/1)	30(3/0/1)	39(3/4/1)",
/* ([32,B],I,16)	*/	"29(3/0/1)	32(3/0/1)	40(3/5/1)",
/* ([32,B],I,32)	*/	"30(3/0/1)	33(3/0/1)	42(3/5/1)",
},
/* move	([d16,B],I),EA */
{
/* Dn			*/	"11(2/0/0)	16(2/0/0)	19(2/2/0)",
/* An			*/	"11(2/0/0)	16(2/0/0)	19(2/2/0)",
/* (An)			*/	"11(2/0/1)	17(2/0/1)	21(2/2/0)",
/* (An)+		*/	"14(2/0/1)	17(2/0/1)	21(2/2/1)",
/* -(An)		*/	"14(2/0/1)	17(2/0/1)	21(2/2/1)",
/* (26,An)		*/	"14(2/0/1)	17(2/0/1)	23(2/2/1)",
/* (xxx).W		*/	"14(2/0/1)	17(2/0/1)	23(2/2/1)",
/* (xxx).L		*/	"16(2/0/1)	19(2/0/1)	25(2/3/1)",
/* #<data>.B		*/	"not specified",
/* #<data>.W		*/	"not specified",
/* #<data>.L		*/	"not specified",
/* (8,An,Xn)		*/	"16(2/0/1)	19(2/0/1)	23(2/2/1)",
/* (26,An,Xn)		*/	"18(2/0/1)	21(2/0/1)	26(2/3/1)",
/* (B)			*/	"19(2/0/1)	20(2/0/1)	24(2/2/1)",
/* (26,B)		*/	"19(2/0/1)	22(2/0/1)	28(2/3/1)",
/* (32,B)		*/	"23(2/0/1)	26(2/0/1)	33(2/3/1)",
/* ([B],I)		*/	"21(3/0/1)	24(3/0/1)	24(3/2/1)",
/* ([B],I,16)		*/	"23(3/0/1)	26(3/0/1)	33(3/3/1)",
/* ([B],I,32)		*/	"24(3/0/1)	27(3/0/1)	34(3/3/1)",
/* ([16,B],I)		*/	"23(3/0/1)	26(3/0/1)	31(3/3/1)",
/* ([16,B],I,16)	*/	"25(3/0/1)	28(3/0/1)	34(3/3/1)",
/* ([16,B],I,32)	*/	"26(3/0/1)	29(3/0/1)	37(3/4/1)",
/* ([32,B],I)		*/	"27(3/0/1)	30(3/0/1)	38(3/3/1)",
/* ([32,B],I,16)	*/	"29(3/0/1)	32(3/0/1)	39(3/4/1)",
/* ([32,B],I,32)	*/	"30(3/0/1)	33(3/0/1)	41(3/4/1)",
},
/* move	([d16,B],I,d16),EA */
{
/* Dn			*/	"13(2/0/0)	18(2/0/0)	22(2/3/0)",
/* An			*/	"13(2/0/0)	18(2/0/0)	22(2/3/0)",
/* (An)			*/	"13(2/0/1)	19(2/0/1)	24(2/3/0)",
/* (An)+		*/	"16(2/0/1)	19(2/0/1)	24(2/3/1)",
/* -(An)		*/	"16(2/0/1)	19(2/0/1)	24(2/3/1)",
/* (26,An)		*/	"16(2/0/1)	19(2/0/1)	26(2/3/1)",
/* (xxx).W		*/	"16(2/0/1)	19(2/0/1)	26(2/3/1)",
/* (xxx).L		*/	"18(2/0/1)	21(2/0/1)	28(2/4/1)",
/* #<data>.B		*/	"not specified",
/* #<data>.W		*/	"not specified",
/* #<data>.L		*/	"not specified",
/* (8,An,Xn)		*/	"18(2/0/1)	21(2/0/1)	26(2/3/1)",
/* (26,An,Xn)		*/	"20(2/0/1)	23(2/0/1)	29(2/4/1)",
/* (B)			*/	"21(2/0/1)	22(2/0/1)	27(2/3/1)",
/* (26,B)		*/	"21(2/0/1)	24(2/0/1)	31(2/4/1)",
/* (32,B)		*/	"25(2/0/1)	28(2/0/1)	36(2/4/1)",
/* ([B],I)		*/	"23(3/0/1)	26(3/0/1)	27(3/3/1)",
/* ([B],I,16)		*/	"25(3/0/1)	28(3/0/1)	36(3/4/1)",
/* ([B],I,32)		*/	"26(3/0/1)	29(3/0/1)	37(3/4/1)",
/* ([16,B],I)		*/	"25(3/0/1)	28(3/0/1)	34(3/4/1)",
/* ([16,B],I,16)	*/	"27(3/0/1)	30(3/0/1)	37(3/4/1)",
/* ([16,B],I,32)	*/	"28(3/0/1)	31(3/0/1)	40(3/5/1)",
/* ([32,B],I)		*/	"29(3/0/1)	32(3/0/1)	41(3/4/1)",
/* ([32,B],I,16)	*/	"31(3/0/1)	34(3/0/1)	42(3/5/1)",
/* ([32,B],I,32)	*/	"32(3/0/1)	35(3/0/1)	44(3/5/1)",
},
/* move	([d32,B],I),EA */
{
/* Dn			*/	"15(2/0/0)	20(2/0/0)	23(2/3/0)",
/* An			*/	"15(2/0/0)	20(2/0/0)	23(2/3/0)",
/* (An)			*/	"15(2/0/1)	21(2/0/1)	25(2/3/0)",
/* (An)+		*/	"18(2/0/1)	21(2/0/1)	25(2/3/1)",
/* -(An)		*/	"18(2/0/1)	21(2/0/1)	25(2/3/1)",
/* (26,An)		*/	"18(2/0/1)	21(2/0/1)	27(2/3/1)",
/* (xxx).W		*/	"18(2/0/1)	21(2/0/1)	27(2/3/1)",
/* (xxx).L		*/	"20(2/0/1)	23(2/0/1)	29(2/4/1)",
/* #<data>.B		*/	"not specified",
/* #<data>.W		*/	"not specified",
/* #<data>.L		*/	"not specified",
/* (8,An,Xn)		*/	"20(2/0/1)	23(2/0/1)	27(2/3/1)",
/* (26,An,Xn)		*/	"22(2/0/1)	25(2/0/1)	30(2/4/1)",
/* (B)			*/	"23(2/0/1)	24(2/0/1)	28(2/3/1)",
/* (26,B)		*/	"23(2/0/1)	26(2/0/1)	32(2/4/1)",
/* (32,B)		*/	"27(2/0/1)	30(2/0/1)	37(2/4/1)",
/* ([B],I)		*/	"25(3/0/1)	28(3/0/1)	28(3/3/1)",
/* ([B],I,16)		*/	"27(3/0/1)	30(3/0/1)	37(3/4/1)",
/* ([B],I,32)		*/	"28(3/0/1)	31(3/0/1)	38(3/4/1)",
/* ([16,B],I)		*/	"27(3/0/1)	30(3/0/1)	35(3/4/1)",
/* ([16,B],I,16)	*/	"29(3/0/1)	32(3/0/1)	38(3/4/1)",
/* ([16,B],I,32)	*/	"30(3/0/1)	33(3/0/1)	41(3/5/1)",
/* ([32,B],I)		*/	"31(3/0/1)	34(3/0/1)	42(3/4/1)",
/* ([32,B],I,16)	*/	"33(3/0/1)	36(3/0/1)	43(3/5/1)",
/* ([32,B],I,32)	*/	"34(3/0/1)	37(3/0/1)	45(3/5/1)",
},
/* move	([d32,B],I,16),EA */
{
/* Dn			*/	"17(2/0/0)	22(2/0/0)	25(2/3/0)",
/* An			*/	"17(2/0/0)	22(2/0/0)	25(2/3/0)",
/* (An)			*/	"17(2/0/1)	23(2/0/1)	27(2/3/0)",
/* (An)+		*/	"20(2/0/1)	23(2/0/1)	27(2/3/1)",
/* -(An)		*/	"20(2/0/1)	23(2/0/1)	27(2/3/1)",
/* (26,An)		*/	"20(2/0/1)	23(2/0/1)	29(2/3/1)",
/* (xxx).W		*/	"20(2/0/1)	23(2/0/1)	29(2/3/1)",
/* (xxx).L		*/	"22(2/0/1)	25(2/0/1)	31(2/4/1)",
/* #<data>.B		*/	"not specified",
/* #<data>.W		*/	"not specified",
/* #<data>.L		*/	"not specified",
/* (8,An,Xn)		*/	"22(2/0/1)	25(2/0/1)	29(2/3/1)",
/* (26,An,Xn)		*/	"24(2/0/1)	27(2/0/1)	32(2/4/1)",
/* (B)			*/	"25(2/0/1)	26(2/0/1)	30(2/3/1)",
/* (26,B)		*/	"25(2/0/1)	28(2/0/1)	34(2/4/1)",
/* (32,B)		*/	"29(2/0/1)	32(2/0/1)	39(2/4/1)",
/* ([B],I)		*/	"27(3/0/1)	30(3/0/1)	30(3/3/1)",
/* ([B],I,16)		*/	"29(3/0/1)	32(3/0/1)	37(3/4/1)",
/* ([B],I,32)		*/	"30(3/0/1)	33(3/0/1)	40(3/4/1)",
/* ([16,B],I)		*/	"29(3/0/1)	32(3/0/1)	37(3/4/1)",
/* ([16,B],I,16)	*/	"31(3/0/1)	34(3/0/1)	40(3/4/1)",
/* ([16,B],I,32)	*/	"32(3/0/1)	35(3/0/1)	43(3/5/1)",
/* ([32,B],I)		*/	"33(3/0/1)	36(3/0/1)	44(3/4/1)",
/* ([32,B],I,16)	*/	"35(3/0/1)	38(3/0/1)	45(3/5/1)",
/* ([32,B],I,32)	*/	"36(3/0/1)	39(3/0/1)	47(3/5/1)",
},
/* move	([d32,B],I,32),EA */
{
/* Dn			*/	"17(2/0/0)	22(2/0/0)	27(2/4/0)",
/* An			*/	"17(2/0/0)	22(2/0/0)	27(2/4/0)",
/* (An)			*/	"17(2/0/1)	23(2/0/1)	29(2/4/0)",
/* (An)+		*/	"20(2/0/1)	23(2/0/1)	29(2/4/1)",
/* -(An)		*/	"20(2/0/1)	23(2/0/1)	29(2/4/1)",
/* (26,An)		*/	"20(2/0/1)	23(2/0/1)	31(2/4/1)",
/* (xxx).W		*/	"20(2/0/1)	23(2/0/1)	31(2/4/1)",
/* (xxx).L		*/	"22(2/0/1)	25(2/0/1)	33(2/5/1)",
/* #<data>.B		*/	"not specified",
/* #<data>.W		*/	"not specified",
/* #<data>.L		*/	"not specified",
/* (8,An,Xn)		*/	"22(2/0/1)	25(2/0/1)	31(2/4/1)",
/* (26,An,Xn)		*/	"24(2/0/1)	27(2/0/1)	34(2/5/1)",
/* (B)			*/	"25(2/0/1)	26(2/0/1)	32(2/4/1)",
/* (26,B)		*/	"25(2/0/1)	28(2/0/1)	36(2/5/1)",
/* (32,B)		*/	"29(2/0/1)	32(2/0/1)	41(2/5/1)",
/* ([B],I)		*/	"27(3/0/1)	30(3/0/1)	32(3/4/1)",
/* ([B],I,16)		*/	"29(3/0/1)	32(3/0/1)	39(3/5/1)",
/* ([B],I,32)		*/	"30(3/0/1)	33(3/0/1)	42(3/5/1)",
/* ([16,B],I)		*/	"29(3/0/1)	32(3/0/1)	39(3/5/1)",
/* ([16,B],I,16)	*/	"31(3/0/1)	34(3/0/1)	42(3/5/1)",
/* ([16,B],I,32)	*/	"32(3/0/1)	35(3/0/1)	45(3/6/1)",
/* ([32,B],I)		*/	"33(3/0/1)	36(3/0/1)	46(3/5/1)",
/* ([32,B],I,16)	*/	"35(3/0/1)	38(3/0/1)	47(3/6/1)",



char* fetch_imm[][] =	/* The fetch immediate effective address table 
			** indicates the number of clock periods needed 
			** for the processor to fetch the immediate 
			** source operand, and calculate and fetch the 
			** specified destination operand. */
{

/* #<data>.W, EA */

{
/* Dn			*/	"0(0/0/0)	2(0/0/0)	3(0/1/0)",
/* An			*/	"not specified"
/* (An)			*/	"3(1/0/0)	4(1/0/0)	4(1/1/0)"
/* (An)+		*/	"4(1/0/0)	6(1/0/0)	7(1/1/0)"
/* -(An)		*/	"3(1/0/0)	5(1/0/0)	6(1/1/0)"
/* (16,An)		*/	"3(1/0/0)	5(1/0/0)	7(1/1/0)",
/* (xxx).W		*/	"3(1/0/0)	5(1/0/0)	7(1/1/0)",
/* (xxx).L		*/	"3(1/0/0)	6(1/0/0)	10(1/2/0)",
/* #<data>.B		*/	"0(0/0/0)	4(0/0/0)	6(0/2/0)",
/* #<data>.W		*/	"0(0/0/0)	4(0/0/0)	6(0/2/0)",
/* #<data>.L		*/	"1(0/0/0)	6(0/0/0)	8(0/2/0)",
/* (8,An,Xn)		*/	"4(1/0/0)	9(1/0/0)	11(1/2/0)",
/* (16,An,Xn)		*/	"4(1/0/0)	9(1/0/0)	12(1/2/0)",
/* (B)			*/	"4(1/0/0)	9(1/0/0)	12(1/2/0)",
/* (16,B)		*/	"6(1/0/0)	11(1/0/0)	15(1/2/0)",
/* (32,B)		*/	"10(1/0/0)	15(1/0/0)	19(1/3/0)",
/* ([B],I)		*/	"9(2/0/0)	14(2/0/0)	16(2/2/0)",
/* ([B],I,16)		*/	"11(2/0/0)	16(2/0/0)	19(2/2/0)",
/* ([B],I,32)		*/	"11(2/0/0)	16(2/0/0)	20(2/3/0)",
/* ([16,B],I)		*/	"11(2/0/0)	16(2/0/0)	19(2/2/0)",
/* ([16,B],I,16)	*/	"13(2/0/0)	18(2/0/0)	22(2/3/0)",
/* ([16,B],I,32)	*/	"not specified"
/* ([32,B],I)		*/	"15(2/0/0)	20(2/0/0)	23(2/3/0)",
/* ([32,B],I,16)	*/	"17(2/0/0)	22(2/0/0)	25(2/3/0)",
/* ([32,B],I,32)	*/	"17(2/0/0)	22(2/0/0)	27(2/4/0)"
},

/* #<data>.L,EA */

{
/* Dn			*/	"1(0/0/0)	4(0/0/0)	5(0/1/0)",
/* An			*/	"not specified"
/* (An)			*/	"3(1/0/0)	4(1/0/0)	7(1/1/0)"
/* (An)+		*/	"5(1/0/0)	8(1/0/0)	9(1/1/0)"
/* -(An)		*/	"4(1/0/0)	7(1/0/0)	8(1/1/0)"
/* (16,An)		*/	"3(1/0/0)	5(1/0/0)	7(1/1/0)",
/* (xxx).W		*/	"3(1/0/0)	5(1/0/0)	7(1/1/0)",
/* (xxx).L		*/	"3(1/0/0)	6(1/0/0)	10(1/2/0)",
/* #<data>.B		*/	"0(0/0/0)	4(0/0/0)	6(0/2/0)",
/* #<data>.W		*/	"0(0/0/0)	4(0/0/0)	6(0/2/0)",
/* #<data>.L		*/	"1(0/0/0)	6(0/0/0)	8(0/2/0)",
/* (8,An,Xn)		*/	"4(1/0/0)	9(1/0/0)	11(1/2/0)",
/* (16,An,Xn)		*/	"4(1/0/0)	9(1/0/0)	12(1/2/0)",
/* (B)			*/	"4(1/0/0)	9(1/0/0)	12(1/2/0)",
/* (16,B)		*/	"6(1/0/0)	11(1/0/0)	15(1/2/0)",
/* (32,B)		*/	"10(1/0/0)	15(1/0/0)	19(1/3/0)",
/* ([B],I)		*/	"9(2/0/0)	14(2/0/0)	16(2/2/0)",
/* ([B],I,16)		*/	"11(2/0/0)	16(2/0/0)	19(2/2/0)",
/* ([B],I,32)		*/	"11(2/0/0)	16(2/0/0)	20(2/3/0)",
/* ([16,B],I)		*/	"11(2/0/0)	16(2/0/0)	19(2/2/0)",
/* ([16,B],I,16)	*/	"13(2/0/0)	18(2/0/0)	22(2/3/0)",
/* ([16,B],I,32)	*/	"not specified"
/* ([32,B],I)		*/	"15(2/0/0)	20(2/0/0)	23(2/3/0)",
/* ([32,B],I,16)	*/	"17(2/0/0)	22(2/0/0)	25(2/3/0)",
/* ([32,B],I,32)	*/	"17(2/0/0)	22(2/0/0)	27(2/4/0)"
}


char* calculate_imm[][] = /* The calculate immediate effective address table 
			** indicates the number of clock periods needed 
			** for the processor to fetch the immediate 
			** source operand, and calculate the 
			** specified destination effective address. */
{

/* #<data>.W, EA */

{
/* Dn			*/	"0(0/0/0)	2(0/0/0)	3(0/1/0)",
/* An			*/	"not specified"
/* (An)			*/	"0(0/0/0)	2(0/0/0)	3(0/1/0)"
/* (An)+		*/	"2(0/0/0)	4(0/0/0)	5(0/1/0)"
/* -(An)		*/	"not specified"
/* (16,An)		*/	"1(0/0/0)	4(0/0/0)	5(0/1/0)",
/* (xxx).W		*/	"1(0/0/0)	4(0/0/0)	5(0/1/0)",
/* (xxx).L		*/	"2(0/0/0)	4(0/0/0)	6(0/2/0)",
/* #<data>.B		*/	"not specified",
/* #<data>.W		*/	"not specified",
/* #<data>.L		*/	"not specified",
/* (8,An,Xn)		*/	"0(0/0/0)	6(0/0/0)	8(0/2/0)",
/* (16,An,Xn)		*/	"3(0/0/0)	8(0/0/0)	10(0/2/0)",
/* (B)			*/	"3(0/0/0)	8(0/0/0)	10(0/2/0)",
/* (16,B)		*/	"5(0/0/0)	10(0/0/0)	13(0/2/0)",
/* (32,B)		*/	"9(0/0/0)	14(0/0/0)	18(0/3/0)",
/* ([B],I)		*/	"8(1/0/0)	13(1/0/0)	15(1/2/0)",
/* ([B],I,16)		*/	"10(1/0/0)	15(1/0/0)	18(1/2/0)",
/* ([B],I,32)		*/	"10(1/0/0)	15(1/0/0)	19(1/3/0)",
/* ([16,B],I)		*/	"10(1/0/0)	15(1/0/0)	18(1/2/0)",
/* ([16,B],I,16)	*/	"12(1/0/0)	17(1/0/0)	21(1/3/0)",
/* ([16,B],I,32)	*/	"12(1/0/0)	17(1/0/0)	22(1/3/0)",
/* ([32,B],I)		*/	"14(1/0/0)	19(1/0/0)	22(1/3/0)",
/* ([32,B],I,16)	*/	"16(1/0/0)	21(1/0/0)	24(1/3/0)",
/* ([32,B],I,32)	*/	"16(1/0/0)	21(1/0/0)	24(1/4/0)"
},

/* #<data>.L,EA */

{
/* Dn			*/	"1(0/0/0)	4(0/0/0)	5(0/1/0)",
/* An			*/	"not specified"
/* (An)			*/	"1(0/0/0)	4(0/0/0)	5(0/1/0)"
/* (An)+		*/	"3(0/0/0)	6(0/0/0)	7(0/1/0)"
/* -(An)		*/	"not specified"
/* (16,An)		*/	"3(0/0/0)	6(0/0/0)	8(0/2/0)",
/* (xxx).W		*/	"3(0/0/0)	6(0/0/0)	8(0/2/0)",
/* (xxx).L		*/	"3(0/0/0)	8(0/0/0)	10(0/2/0)",
/* #<data>.B		*/	"not specified",
/* #<data>.W		*/	"not specified",
/* #<data>.L		*/	"not specified",
/* (8,An,Xn)		*/	"2(0/0/0)	8(0/0/0)	10(0/2/0)",
/* (16,An,Xn)		*/	"4(0/0/0)	10(0/0/0)	12(0/2/0)",
/* (B)			*/	"4(0/0/0)	10(0/0/0)	12(0/2/0)",
/* (16,B)		*/	"6(0/0/0)	12(0/0/0)	15(0/2/0)",
/* (32,B)		*/	"10(0/0/0)	16(0/0/0)	20(0/3/0)",
/* ([B],I)		*/	"9(1/0/0)	15(1/0/0)	17(1/2/0)",
/* ([B],I,16)		*/	"11(1/0/0)	17(1/0/0)	20(1/2/0)",
/* ([B],I,32)		*/	"11(1/0/0)	17(1/0/0)	21(1/3/0)",
/* ([16,B],I)		*/	"11(1/0/0)	17(1/0/0)	20(1/2/0)",
/* ([16,B],I,16)	*/	"13(1/0/0)	19(1/0/0)	23(1/3/0)",
/* ([16,B],I,32)	*/	"13(1/0/0)	19(1/0/0)	24(1/3/0)",
/* ([32,B],I)		*/	"15(1/0/0)	21(1/0/0)	24(1/3/0)",
/* ([32,B],I,16)	*/	"17(1/0/0)	23(1/0/0)	26(1/3/0)",
/* ([32,B],I,32)	*/	"17(1/0/0)	23(1/0/0)	29(1/4/0)"
}
};
