/*	START NEW ARIX SCCS HEADER			*/
/*							*/
/*	@(#) settape.c: version 23.2 created on 4/4/91 at 16:03:27	*/
/*							*/
/*	Copyright (c) 1990 by Arix Corporation		*/
/*	All Rights Reserved				*/
/*							*/
#ident	"@(#)settape.c	23.2	4/4/91 Copyright (c) 1990 by Arix Corporation"
/*							*/
/*	END NEW ARIX SCCS HEADER			*/
/*							*/


/*
 * settape.c -- set tape modes
 */

#include <sys/types.h>
#include <sys/ioctl.h>
#include <fcntl.h>
#include <stdio.h>
#include <errno.h>

#define CX	0		/* cmd works with all tape drives	*/
#define C9	TRACK9		/* cmd is only for a 9 track tape drive */
#define CA	ARCHIVE		/* cmd is only for an Archive tape drive*/

typedef struct cmd {
	char	*word;
	int	cmd;
	int	type;
	char	*help;
} CMD;

CMD	cmds[] = {
	{ "has_cache",	T_HAS_CACHE,	CX, "tape drive has a cache" },
	{ "no_cache",	T_NO_CACHE,	CX, "tape drive has no cache" },
	{ "6250_bpi",	T_6250_DENSITY,	C9, "use 6250 bpi density mode" },
	{ "3200_bpi",   T_3200_DENSITY, C9, "use 3200 bpi density mode" },
	{ "1600_bpi",	T_1600_DENSITY,	C9, "use 1600 bpi density mode" },
	{ "800_bpi",    T_800_DENSITY, C9, "\tuse 800 bpi density mode" },
	{ "high_speed",	T_HIGH_SPEED,	C9, "use high speed mode" },
	{ "low_speed",	T_LOW_SPEED,	C9, "use low speed mode\n" },
	{ NULL }
};

/*			0	1	2	3	4	*/
char	*type[] = {  "ANY", "???", "ARCHIVE", "???", "9 TRACK" };
char	*dens[] = {  "???", "1600", "6250", "3200", "800", "???", "???" };
char	*lowhi[] = { "LOW", "HIGH"};
char	*noyes[] = { "NO", "YES" };

char	*tapepath;			/* pathname for tape device	*/
int	tapefd;				/* tape device file descriptor	*/
int	tapetype;			/* tape type: 9 track or archive*/

char	*progname;

extern int	errno;
extern char	*sys_errlist[];

extern void	exit();


main(argc, argv)
int	argc;
char	**argv;
{
	initialize(argc, argv);

	doit(argc, argv);

	return (0);
}


/*
 * err -- print out error message and exit
 */

/*VARARGS1*/
err(fmt, a1, a2, a3, a4, a5, a6)
char	*fmt;
{
	fprintf(stderr, fmt, a1, a2, a3, a4, a5, a6);
	fprintf(stderr, "\n");
	exit(1);
}


/*
 * getcmd -- return a pointer to the CMD, or NULL
 */

CMD *
getcmd(word)
register char	*word;
{
	register CMD	*cp;

	for (cp = cmds; cp->word != NULL; cp++)
		if (strcmp(cp->word, word) == 0)
			return (cp);

	return (NULL);
}


/*
 * initialize -- check arguments and drive type
 */

initialize(argc, argv)
register int	argc;
register char	**argv;
{
	register CMD	*cp;

	progname = *argv;

	if (argc < 2)
		usage();

	tapepath = argv[1];

	if ((tapefd = open(tapepath, O_RDONLY | O_NDELAY)) < 0)
		err("Can't open '%s'", tapepath);

	switch (tapetype = tapeioctl(PERGET, DRIVETYPE)) {
	case ARCHIVE:
		break;						/* ok */

	case TRACK9:
		break;						/* ok */

	default:
		err("Unknown tape type = %d", tapetype);
	}

	for (argc -= 2, argv += 2; --argc >= 0; argv++) {
		if ((cp = getcmd(*argv)) == NULL) {
			fprintf(stderr, "Unknown command '%s'\n", *argv);
			usage();
		}
		if (cp->type && cp->type != tapetype) {
			fprintf(stderr, "Command only works on %s, %s is %s\n",
			  type[cp->type], tapepath, type[tapetype]);
			usage();
		}
	}
}

/*
 * doit -- do the ioctls
 */

doit(argc, argv)
register int	argc;
register char	**argv;
{
	register CMD	*cp;

	for (argc -= 2, argv += 2; --argc >= 0; argv++) {
		if ((cp = getcmd(*argv)) == NULL) {
			err("Unknown command '%s'", *argv);
		}

		(void) tapeioctl(PERSET, cp->cmd);
	}

	if (tapetype == TRACK9)
		printf("%s: cache = %s, speed = %s, density = %s\n",
		    tapepath,
		    noyes[tapeioctl(PERGET, T_GET_CACHE)],
		    lowhi[tapeioctl(PERGET, T_GET_SPEED)],
		    dens[tapeioctl(PERGET, T_GET_DENSITY)]);
	else
		printf("%s is an archive tape drive.\n", tapepath);
}

/*
 * tapeioctl -- do a PERGET/PERSET to tapefd, returns value in arg
 */

tapeioctl(cmd, arg)
int	cmd, arg;
{
	if (ioctl(tapefd, cmd, &arg) == -1) {
		if (errno == EINVAL)
			err("%s is not a tape device.");

		err("ioctl(%d, %d, 0x%x) failed! (%s)",
		  tapefd, cmd, &arg, sys_errlist[errno]);
	}

	return (arg);
}


/*
 * usage -- print out usage and help message, and exit
 */

usage()
{
	register CMD	*cp;

	fprintf(stderr, "\nusage:  %s tape_device [command . . .]\n", progname);
	fprintf(stderr, "\nSets tape device modes\n\nWhere:\n\n");

	for (cp = cmds; cp->word != NULL; cp++)
		fprintf(stderr, "\t%s\t%s\n", cp->word, cp->help);

	exit(1);
}
