/*	START NEW ARIX SCCS HEADER			*/
/*							*/
/*	@(#) syspmask.c: version 25.1 created on 12/2/91 at 17:21:07	*/
/*							*/
/*	Copyright (c) 1990 by Arix Corporation		*/
/*	All Rights Reserved				*/
/*							*/
#ident	"@(#)syspmask.c	25.1	12/2/91 Copyright (c) 1990 by Arix Corporation"
/*							*/
/*	END NEW ARIX SCCS HEADER			*/
/*							*/
/*
 *	syspmask  set or interrogate the current system privilege 
 *		  mask. This is a SEC_ADM command only 
 *		  (C) Copyright 1989 by ARIX Corp.   
 *
 * 	Version 1: Intitial design and code by JTOF. 
 */

#ident "syspmask.c:syspmask Version 1.0"
 
#include <sys/types.h>
#include <sys/stat.h>
#include <stdio.h>
#include <signal.h>
#include <sys/mount.h>
#include <pwd.h>
#include <time.h>
#include <ctype.h> 
#include <errno.h>
#include <sys/security.h>
#include <sys/priv.h>
#include <sys/mls.h>


extern char *optarg;
extern int  optind;
extern priv_sym_t priv_pmap[], priv_cmap[];

main( argc, argv )
char **argv;
{
int c;

	while ((c = getopt( argc, argv, "dr?s:" )) != -1 ) {
		switch (c) {
			case 'd':
				listprivs();
				break;
			case 's':
				setsysmask( optarg );
				break;
			case 'r':
				showsysmask();
				break;
			case '?':
				usage();
				return;
			default:
				error( "bad or unknown option" );
		}
	}
}

/*
 *	showsysmask
 */
showsysmask()
{
uint mask;
char buf[512];

	if ( get_sys_pmask( &mask ) )
		error( "permission denied" );

	if (!cvt_priv_to_sym( mask, buf, 1, ' ' ))
		error( "bad or unknown privilege in mask" );

	printf( "%s\n", buf );
}

/*
 *
 */
setsysmask( buf )
char *buf;
{
uint mask;

	if (!cvt_sym_to_priv( buf, &mask, ',' ))
		error( "bad or unknown privilege" );

	if ( set_sys_pmask( &mask ) )
		error( "permission denied" );
}

/*
 *	listprivs
 */

listprivs()
{
int i;
char buf[512];

	/* show the primitive privilege map */
	printf( "\nPrimitive Privileges:\n" );
	for ( i = 0; *priv_pmap[i].p_name; i++ ) 
		printf( "%s\n", priv_pmap[i].p_name );

	/* show the combination privilege map */
	printf( "\nCombinational Privileges:" );
	for ( i = 0; *priv_cmap[i].p_name; i++ ) {
		if (!cvt_priv_to_sym( priv_cmap[i].p_priv, buf, 0, ' ' ))
			error( "bad or unknown privilege" );
		printf( "\n%s -> (%s)\n", priv_cmap[i].p_name, buf );
	}
}

/*
 *	usage
 *
 */
usage()
{
	fprintf( stderr, "usage: syspmask [<dsr>]\n" );
	fprintf( stderr, "       -d display list of privileges\n" );
	fprintf( stderr, "       -s set system privilege mask\n" );
	fprintf( stderr, "       -r read and display system mask\n" );
	exit(1);
}
				
/*
 *
 *
 */
error( str )
char *str;
{
	fprintf( stderr, "%s\n", str );
	exit(errno);
}
