/*	START NEW ARIX SCCS HEADER			*/
/*							*/
/*	@(#) sysconv.c: version 25.1 created on 12/2/91 at 17:20:58	*/
/*							*/
/*	Copyright (c) 1990 by Arix Corporation		*/
/*	All Rights Reserved				*/
/*							*/
#ident	"@(#)sysconv.c	25.1	12/2/91 Copyright (c) 1990 by Arix Corporation"
/*							*/
/*	END NEW ARIX SCCS HEADER			*/
/*							*/

/* sysconv - internal utility which can be run on a list of files, and
             will generate a generic syscheck list.  Files are read from
	     stdin, results to stdout.  Files which cannot be stat'ed ()
	     will be output to stderr */

#include <sys/types.h>
#include <stdio.h>
#include <sys/stat.h>
#include <fcntl.h>

#define	MAX_LINE_SIZE	512		/* Maximum data line size */

int	exit_status = 0;

main (argc, argv)
char	**argv;
int 	argc;
{
	struct	stat	file_stat;
	char	data_line [MAX_LINE_SIZE];

	while ( gets (data_line) != (char *)0 ) {

		if  ( stat ( data_line, &file_stat) == -1 ) {

			fprintf (stderr,"Unable to stat () %s\n", data_line );
			exit_status = 1;
		}

		else {

			putchar ('-');
			pmode ( file_stat.st_mode );
			fprintf (stdout, "	%d	%d	%d	PROTECTED	P_USR	%s\n",
				 file_stat.st_size, file_stat.st_uid,
				 file_stat.st_gid, data_line);
		}
	}
}

			


/* print various r,w,x permissions 
 */
pmode(mode)
unsigned int	mode;
{
        /* these arrays are declared static to allow initializations */
	static int	m0[] = { 1, S_IREAD>>0, 'r', '-' };
	static int	m1[] = { 1, S_IWRITE>>0, 'w', '-' };
	static int	m2[] = { 3, S_ISUID|S_IEXEC, 's', S_IEXEC, 'x', S_ISUID, 'S', '-' };
	static int	m3[] = { 1, S_IREAD>>3, 'r', '-' };
	static int	m4[] = { 1, S_IWRITE>>3, 'w', '-' };
	static int	m5[] = { 3, S_ISGID|(S_IEXEC>>3),'s', S_IEXEC>>3,'x', S_ISGID,'l', '-'};
	static int	m6[] = { 1, S_IREAD>>6, 'r', '-' };
	static int	m7[] = { 1, S_IWRITE>>6, 'w', '-' };
	static int	m8[] = { 3, S_ISVTX|(S_IEXEC>>6),'t', S_IEXEC>>6,'x', S_ISVTX,'T', '-'};

        static int  *m[] = { m0, m1, m2, m3, m4, m5, m6, m7, m8};

	register int **mp;

	for (mp = &m[0]; mp < &m[sizeof(m)/sizeof(m[0])];)
		select(mode, *mp++);
}

static select(mode, pairp)
register unsigned int mode;
register int *pairp;
{
	register int n;

	n = *pairp++;
	while (n-->0) {
		if((mode & *pairp) == *pairp) {

			pairp++;
			break;
		}else {
			pairp += 2;
		}
	}
	putchar(*pairp);
}
