
/*	START NEW ARIX SCCS HEADER			*/
/*							*/
/*	@(#) syscheck.h: version 1.1 created on 5/17/90 */
/*							*/
/*	Copyright (c) 1990 by Arix Corporation		*/
/*	All Rights Reserved				*/
/*							*/
#ident	"@(#)syscheck.h	1.1	5/17/90 Copyright (c) 1990 by Arix Corporation"
/*							*/
/*	END NEW ARIX SCCS HEADER			*/
/*							*/

/* syscheck.h - contains structures necessary to set and read label
   and privilege information */

#ifndef	SYSCHECK_H
#define SYSCHECK_H

#include <sys/types.h>

#define	MAX_LABEL_SIZE	256
#define MAX_PRIV_SIZE	256
#define MAX_PATH_SIZE	512

/* Flags which aid syscheck in determining what needs to be set */
#define	SET_SEC		0x0001
#define	GET_SEC		0x0002
#define	SET_DAC 	0x0004
#define	SET_LABEL	0x0008
#define	SET_PRIV	0x0010
#define	SET_OWN		0x0020
#define GENERATE	0x0040

typedef	struct	sys_check {

	mode_t	mode;
	size_t  size;
	uid_t	uid;
	gid_t	gid;
	char	label [MAX_LABEL_SIZE];
	char	privs [MAX_PRIV_SIZE];
	char	path [MAX_PATH_SIZE];
}	syscheck_t;

#endif	/* SYSCHECK_H */
