/*        START NEW ARIX SCCS HEADER                         */
/*                					                     */
/*        @(#) skulker.c: version 25.3 created on 2/13/92 at 11:50:54         */
/*                                                           */
/*        Copyright (c) 1990 by Arix Corporation             */
/*        All Rights Reserved                                */
/*                                                           */
#ident	"@(#)skulker.c	25.3	2/13/92 Copyright (c) 1990 by Arix Corporation"
/*                                                           */
/*        END NEW ARIX SCCS HEADER                           */
/*                                                           */
/*
 * skulker.c -- yet another program to monitor the access times of ttys
 *   and log out those who don't touch their keyboards.  Skulker steps
 *   through the utmp file and for every USER_PROCESS it finds, it checks 
 *   the idle time on the device with the allowed idle time in the
 *   /etc/security/dev_auth file.  If the user has been idle for to
 *   long, they are set a warning message, later killed. 
 */
/* 
 *   Skulker takes command line options of "-s sec" for the amount of 
 *   time it will sleep between passes through the utmp file, and 
 *   "-m message" to change the warning message users will recieve 
 *   before the are logged off. 
 */
/*
 *  An ARIX original written February Nineteen-Hundred-Ninty-One by
 *  Mitch "Mr Wonderful" Mikula based on a thingie written by  
 *  James "the clev" Cleverdon
 */



#include <stdio.h>
#include <sys/types.h>
#include <sys/stat.h>
#include <errno.h>
#include <utmp.h>
#include <signal.h>
#include <fcntl.h>
#include <auth.h>



#define DEF_MESSAGE      "Inactivity Warning!! <beep>Audiable Bell<beep>\n"
#define DEF_SLEEP_TIME   300
#define OPEN_DELAY       10		/* open and write delay seconds */



extern char	*optarg;
extern struct utmp	*getutent();


time_t init();
void warn();
void read_dev_auth();
void deamon_error();
time_t find_dev_auth_entry();
void usage();


struct da_entry {
	struct da_entry *next;
	char device[NAME_MAX];
	ushort timeout;
	};


struct da_entry *head;	
char *message;





/*
 *   The Skulker Deamon.
 */

main(argc, argv)
int	argc;
char	**argv;
{

	struct stat	sbuf;
	struct utmp	*up;
	time_t		idle, sleep_time, allowed_idle, now, last_da_mod = 0;

	sleep_time = init(argc, argv);

	while(1) {
		setutent();
		now = time((time_t *)0);

		if (stat(TTYAUTH, &sbuf) < 0){
			deamon_error("skulker: Can't find dev_auth file...exiting\n"); 
			exit(1);
		}

		if (sbuf.st_mtime > last_da_mod){
			last_da_mod = sbuf.st_mtime;
			read_dev_auth();
		}

		while (up = getutent()) {
			if (up->ut_type != USER_PROCESS || up->ut_pid <= 4)
				continue;

			if (stat(up->ut_line, &sbuf) < 0){
				deamon_error("un-stat-able line in utmp file\n");
				continue;
			}
			
			if ((allowed_idle = find_dev_auth_entry(up)) == -1 ){
				(void) kill(-up->ut_pid, SIGKILL);
				continue;
			}	
			if (! allowed_idle )    /*allowed_idle =0 means no timout*/
				continue;

			if ((idle = ((now - sbuf.st_atime) -allowed_idle)) < 0)
				continue;
			switch ( idle / sleep_time){
				case 0:
					warn(up->ut_line);
					break;
				case 1:
				default: 
					kill(-up->ut_pid, SIGKILL);
			}
		}
		endutent();

		sleep(sleep_time);

	}
}






/*
 * init -- set things up. Returns the sleep_time
 */

time_t
init(argc, argv)
int	argc;
char	**argv;
{
	int	c, sleep_time =DEF_SLEEP_TIME;
	int tmp;
	message = DEF_MESSAGE;

	if (! isprived("P_ADM", geteuid())) {
		fprintf(stderr,"SKULKER MUST BE RUN BY AN ADMINISTRATOR!\n");
		usage(argv);
	}

	while ((c = getopt(argc, argv, "s:m:")) > 0)
		switch (c) {
		case 's':
			if ((sleep_time = getnumarg(optarg,30, 36000)) <0)
				usage(argv);
			break;
		case 'm':
			message = optarg;
			break;
		default:
			usage(argv);
		}


	if (chdir("/dev")) {
		perror("chdir(\"/dev\")");
		exit(1);
	}

	switch (fork()) {
		case 0:	
			break;			     /* child */
		case -1:	
			perror("fork failed");
			exit(1);
		default:	
			exit(0);		          /* parent */
	}

	signal(SIGBUS,SIG_IGN);
	signal(SIGHUP,SIG_IGN);
	signal(SIGINT,SIG_IGN);
	signal(SIGCLD,SIG_IGN);
	signal(SIGQUIT,SIG_IGN);
	signal(SIGALRM,SIG_DFL);

	for (c=0; (c < 20) && (close(c) < 0) ; c++);

	setsid();  /* We are POSIX....so no setpgrp */

	return ((time_t) sleep_time);
}







/*
 * warn -- print a warning message on tty
 */

void
warn(tty)
char	*tty;
{
	int	fd;
	char msg[80];

	if (fork())
		return;				/* parent or error */

	alarm(OPEN_DELAY);

	if ((fd = open(tty, O_WRONLY)) < 0){
		sprintf(msg,"Skulker: Open failed on tty %s. errno=%d\n", tty,errno);
		deamon_error(msg);
		exit(1);
	}

	write(fd, message, strlen(message));
	exit(0);
}








/*
 *  read_dev_auth -- read the /etc/security/dev_auth file.  We just
 *                   free the linked list up, and reread it. 
 */

void
read_dev_auth()
{

	ttyauth_t *tty;
	char   *tmpstr;
	struct da_entry *prev, *ptr, *next;

	for(ptr = head; ptr; ptr = next){        /*free up the old list*/
		next=ptr->next;
		free(ptr);
	}

	prev = NULL;

	settaent();
	while (tty = gettaent()){
		if (!(tmpstr = (char *) strrchr(tty->ta_ttyn,'/')))
			continue;

		ptr = (struct da_entry *) malloc(sizeof(struct da_entry));
		strncpy(ptr->device,tmpstr+1,NAME_MAX);
		ptr->timeout = tty->ta_inactive;
		ptr->next = prev;

		prev = ptr;
	}
	head = ptr;

	endtaent();
}







/*
 *  deamon_error() -- write an error message to the console.
 */

void 
deamon_error(msg)
char *msg;
{
	int  fd;

	if ((fd = open("/dev/console", O_WRONLY )) < 0 )
		exit(1);

	write(fd,msg,strlen(msg));
	close(fd);

}







/*
 *  find_dev_auth_entry(ut)
 */

time_t
find_dev_auth_entry(ut)
struct utmp *ut;
{
	struct da_entry *ptr;

	ptr = head;

	while (ptr && (strcmp(ptr->device,ut->ut_line) != 0) ) 
		ptr = ptr->next;
	if (ptr)
		return ((time_t) ptr->timeout);
	return (-1);
}








/*
 * getnumarg -- get a numeric argument within limits low and high
 */

getnumarg(string,low, high)
char *string;
int	low, high;
{
	int	num;
	char	*p;

	p = string;
	num = strtol(string, &p, 10);
	if (p == string || num < low || num > high) 
		return(-1);
	
	return (num);
}









/*
 *  usage -- print the usage exit.
 */

void
usage(argv)
char **argv;
{
	fprintf(stderr,"\n%s: [-s sec] [-m \"message\"]\n",*argv);
	fprintf(stderr,
	"\tsec is the number of seconds to sleep between scans. sec must be\n"
		"\t\tbetween 30 and 36000. The default is 300 seconds (5 minutes)\n");

	fprintf(stderr,
	"\tmessage is the warrning message to be sent to a user sec seconds\n"
		"\t\tbefore they are killed.  An appropriate message will \n"
		"\t\tbe substituted if this argument is left off\n\n");
	exit(1);
}

